/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.tableviewer.dialog;

import edu.wpi.first.tableviewer.OutlineFrame;
import edu.wpi.first.wpilibj.networktables2.NetworkTableNode;
import edu.wpi.first.wpilibj.networktables2.client.NetworkTableClient;
import edu.wpi.first.wpilibj.networktables2.server.NetworkTableServer;
import edu.wpi.first.wpilibj.networktables2.stream.IOStreamFactory;
import edu.wpi.first.wpilibj.networktables2.stream.IOStreamProvider;
import edu.wpi.first.wpilibj.networktables2.stream.SocketStreams;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class PreferencesDialog
extends JDialog {
    private final Preferences prefs = Preferences.userNodeForPackage(this.getClass());
    private JButton cancelButton;
    private JButton clientButton;
    private JTextField hostField;
    private JLabel hostLabel;
    private JCheckBox metadataBox;
    private JButton serverButton;

    public PreferencesDialog() {
        this.setTitle("Preferences");
        this.initComponents();
        this.hostField.setText(this.prefs.get("host", "localhost"));
        this.metadataBox.setSelected(this.prefs.getBoolean("metadata", false));
        this.setResizable(false);
    }

    private void initComponents() {
        this.hostField = new JTextField();
        this.hostLabel = new JLabel();
        this.metadataBox = new JCheckBox();
        this.clientButton = new JButton();
        this.serverButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.hostLabel.setText("Host:");
        this.metadataBox.setText("Display metadata");
        this.clientButton.setText("Start Client");
        this.clientButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.startButtonPressed(evt);
            }
        });
        this.serverButton.setText("Start Server");
        this.serverButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.startButtonPressed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.hostLabel).addGap(18, 18, 18).addComponent(this.hostField)).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.clientButton).addGap(18, 18, 18).addComponent(this.serverButton).addGap(18, 18, 18).addComponent(this.cancelButton)).addComponent(this.metadataBox, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.hostField, -2, -1, -2).addComponent(this.hostLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.metadataBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 24, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.serverButton).addComponent(this.clientButton)).addContainerGap()));
        this.pack();
    }

    private void startButtonPressed(ActionEvent evt) {
        try {
            NetworkTableNode node;
            if (evt.getSource() == this.clientButton) {
                String host = this.hostField.getText();
                if (host.isEmpty()) {
                    return;
                }
                IOStreamFactory streamFactory = SocketStreams.newStreamFactory(host, 1735);
                NetworkTableClient client = new NetworkTableClient(streamFactory);
                client.reconnect();
                node = client;
                this.prefs.put("host", host);
            } else {
                IOStreamProvider streamProvider = SocketStreams.newStreamProvider(1735);
                node = new NetworkTableServer(streamProvider);
                this.prefs.put("host", "");
            }
            this.prefs.putBoolean("metadata", this.metadataBox.isSelected());
            new OutlineFrame("Network Table Viewer", node, this.metadataBox.isSelected()).setVisible(true);
            this.dispose();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getClass() + ": " + e.getMessage(), "Error creating table node", 0);
            e.printStackTrace();
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        System.exit(0);
    }
}

