/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.networktables;

import edu.wpi.first.wpilibj.networktables.NetworkTable;
import edu.wpi.first.wpilibj.networktables2.util.Set;
import edu.wpi.first.wpilibj.tables.ITable;
import edu.wpi.first.wpilibj.tables.ITableListener;

public class NetworkTableSubListenerAdapter
implements ITableListener {
    private final ITableListener targetListener;
    private final NetworkTable targetSource;
    private final String prefix;
    private final Set notifiedTables = new Set();

    public NetworkTableSubListenerAdapter(String prefix, NetworkTable targetSource, ITableListener targetListener) {
        this.prefix = prefix;
        this.targetSource = targetSource;
        this.targetListener = targetListener;
    }

    @Override
    public void valueChanged(ITable source, String key, Object value, boolean isNew) {
        if (key.startsWith(this.prefix)) {
            String subTableKey;
            String relativeKey = key.substring(this.prefix.length() + 1);
            int endSubTable = -1;
            for (int i = 0; i < relativeKey.length(); ++i) {
                if (relativeKey.charAt(i) != '/') continue;
                endSubTable = i;
                break;
            }
            if (endSubTable != -1 && !this.notifiedTables.contains(subTableKey = relativeKey.substring(0, endSubTable))) {
                this.notifiedTables.add(subTableKey);
                this.targetListener.valueChanged(this.targetSource, subTableKey, this.targetSource.getSubTable(subTableKey), true);
            }
        }
    }
}

