/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.networktables2.type;

import edu.wpi.first.wpilibj.networktables2.TableKeyExistsWithDifferentTypeException;
import edu.wpi.first.wpilibj.networktables2.type.ArrayData;
import edu.wpi.first.wpilibj.networktables2.type.ComplexEntryType;
import edu.wpi.first.wpilibj.networktables2.type.NetworkTableEntryType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ArrayEntryType
extends ComplexEntryType {
    private final NetworkTableEntryType elementType;
    private final Class externalArrayType;

    public ArrayEntryType(byte id, NetworkTableEntryType elementType, Class externalArrayType) {
        super(id, "Array of [" + elementType.name + "]");
        if (!ArrayData.class.isAssignableFrom(externalArrayType)) {
            throw new RuntimeException("External Array Data Type must extend ArrayData");
        }
        this.externalArrayType = externalArrayType;
        this.elementType = elementType;
    }

    @Override
    public void sendValue(Object value, DataOutputStream os) throws IOException {
        if (value instanceof Object[]) {
            Object[] dataArray = (Object[])value;
            if (dataArray.length > 255) {
                throw new IOException("Cannot write " + value + " as " + this.name + ". Arrays have a max length of 255 values");
            }
            os.writeByte(dataArray.length);
            for (int i = 0; i < dataArray.length; ++i) {
                this.elementType.sendValue(dataArray[i], os);
            }
        } else {
            throw new IOException("Cannot write " + value + " as " + this.name);
        }
    }

    @Override
    public Object readValue(DataInputStream is) throws IOException {
        int length = is.readUnsignedByte();
        Object[] dataArray = new Object[length];
        for (int i = 0; i < length; ++i) {
            dataArray[i] = this.elementType.readValue(is);
        }
        return dataArray;
    }

    @Override
    public Object internalizeValue(String key, Object externalRepresentation, Object currentInteralValue) {
        if (this.externalArrayType.isInstance(externalRepresentation)) {
            Object[] internalArray;
            ArrayData externalArrayData = (ArrayData)externalRepresentation;
            if (currentInteralValue instanceof Object[] && (internalArray = (Object[])currentInteralValue).length == externalArrayData.size()) {
                System.arraycopy(externalArrayData.getDataArray(), 0, internalArray, 0, internalArray.length);
                return internalArray;
            }
            internalArray = new Object[externalArrayData.size()];
            System.arraycopy(externalArrayData.getDataArray(), 0, internalArray, 0, internalArray.length);
            return internalArray;
        }
        throw new TableKeyExistsWithDifferentTypeException(key, this, externalRepresentation + " is not a " + this.externalArrayType);
    }

    @Override
    public void exportValue(String key, Object internalData, Object externalRepresentation) {
        if (!this.externalArrayType.isInstance(externalRepresentation)) {
            throw new TableKeyExistsWithDifferentTypeException(key, this, externalRepresentation + " is not a " + this.externalArrayType);
        }
        if (!(internalData instanceof Object[])) {
            throw new TableKeyExistsWithDifferentTypeException(key, this, "Internal data: " + internalData + " is not an array");
        }
        Object[] internalArray = (Object[])internalData;
        ArrayData externalArrayData = (ArrayData)externalRepresentation;
        externalArrayData.setSize(internalArray.length);
        System.arraycopy(internalArray, 0, externalArrayData.getDataArray(), 0, internalArray.length);
    }
}

