/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.networktables2.type;

import edu.wpi.first.wpilibj.networktables2.type.BooleanArray;
import edu.wpi.first.wpilibj.networktables2.type.NetworkTableEntryType;
import edu.wpi.first.wpilibj.networktables2.type.NetworkTableEntryTypeManager;
import edu.wpi.first.wpilibj.networktables2.type.NumberArray;
import edu.wpi.first.wpilibj.networktables2.type.StringArray;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class DefaultEntryTypes {
    private static final byte BOOLEAN_RAW_ID = 0;
    private static final byte DOUBLE_RAW_ID = 1;
    private static final byte STRING_RAW_ID = 2;
    public static final NetworkTableEntryType BOOLEAN = new NetworkTableEntryType(0, "Boolean"){

        @Override
        public void sendValue(Object value, DataOutputStream os) throws IOException {
            if (!(value instanceof Boolean)) {
                throw new IOException("Cannot write " + value + " as " + this.name);
            }
            os.writeBoolean((Boolean)value);
        }

        @Override
        public Object readValue(DataInputStream is) throws IOException {
            return is.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
        }
    };
    public static final NetworkTableEntryType DOUBLE = new NetworkTableEntryType(1, "Double"){

        @Override
        public void sendValue(Object value, DataOutputStream os) throws IOException {
            if (!(value instanceof Double)) {
                throw new IOException("Cannot write " + value + " as " + this.name);
            }
            os.writeDouble((Double)value);
        }

        @Override
        public Object readValue(DataInputStream is) throws IOException {
            return new Double(is.readDouble());
        }
    };
    public static final NetworkTableEntryType STRING = new NetworkTableEntryType(2, "String"){

        @Override
        public void sendValue(Object value, DataOutputStream os) throws IOException {
            if (!(value instanceof String)) {
                throw new IOException("Cannot write " + value + " as " + this.name);
            }
            os.writeUTF((String)value);
        }

        @Override
        public Object readValue(DataInputStream is) throws IOException {
            return is.readUTF();
        }
    };

    public static void registerTypes(NetworkTableEntryTypeManager manager) {
        manager.registerType(BOOLEAN);
        manager.registerType(DOUBLE);
        manager.registerType(STRING);
        manager.registerType(BooleanArray.TYPE);
        manager.registerType(NumberArray.TYPE);
        manager.registerType(StringArray.TYPE);
    }
}

