/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.networktables;

import edu.wpi.first.wpilibj.networktables.NetworkTableConnectionListenerAdapter;
import edu.wpi.first.wpilibj.networktables.NetworkTableKeyListenerAdapter;
import edu.wpi.first.wpilibj.networktables.NetworkTableListenerAdapter;
import edu.wpi.first.wpilibj.networktables.NetworkTableMode;
import edu.wpi.first.wpilibj.networktables.NetworkTableProvider;
import edu.wpi.first.wpilibj.networktables.NetworkTableSubListenerAdapter;
import edu.wpi.first.wpilibj.networktables2.NetworkTableEntry;
import edu.wpi.first.wpilibj.networktables2.NetworkTableNode;
import edu.wpi.first.wpilibj.networktables2.thread.DefaultThreadManager;
import edu.wpi.first.wpilibj.networktables2.thread.NTThreadManager;
import edu.wpi.first.wpilibj.networktables2.util.List;
import edu.wpi.first.wpilibj.networktables2.util.StringCache;
import edu.wpi.first.wpilibj.tables.IRemote;
import edu.wpi.first.wpilibj.tables.IRemoteConnectionListener;
import edu.wpi.first.wpilibj.tables.ITable;
import edu.wpi.first.wpilibj.tables.ITableListener;
import edu.wpi.first.wpilibj.tables.TableKeyNotDefinedException;
import java.io.IOException;
import java.util.Hashtable;
import java.util.NoSuchElementException;

public class NetworkTable
implements ITable,
IRemote {
    private static final NTThreadManager threadManager = new DefaultThreadManager();
    public static final char PATH_SEPARATOR = '/';
    public static final int DEFAULT_PORT = 1735;
    private static NetworkTableProvider staticProvider = null;
    private static NetworkTableMode mode = NetworkTableMode.Server;
    private static int port = 1735;
    private static String ipAddress = null;
    private final String path;
    private final EntryCache entryCache;
    private final NetworkTableKeyCache absoluteKeyCache;
    private final NetworkTableProvider provider;
    private final NetworkTableNode node;
    private final Hashtable connectionListenerMap = new Hashtable();
    private final Hashtable listenerMap = new Hashtable();

    private static synchronized void checkInit() {
        if (staticProvider != null) {
            throw new IllegalStateException("Network tables has already been initialized");
        }
    }

    public static synchronized void initialize() throws IOException {
        NetworkTable.checkInit();
        staticProvider = new NetworkTableProvider(mode.createNode(ipAddress, port, threadManager));
    }

    public static synchronized void setTableProvider(NetworkTableProvider provider) {
        NetworkTable.checkInit();
        staticProvider = provider;
    }

    public static synchronized void setServerMode() {
        NetworkTable.checkInit();
        mode = NetworkTableMode.Server;
    }

    public static synchronized void setClientMode() {
        NetworkTable.checkInit();
        mode = NetworkTableMode.Client;
    }

    public static synchronized void setTeam(int team) {
        NetworkTable.setIPAddress("10." + team / 100 + "." + team % 100 + ".2");
    }

    public static synchronized void setIPAddress(String address) {
        NetworkTable.checkInit();
        ipAddress = address;
    }

    public static synchronized NetworkTable getTable(String key) {
        if (staticProvider == null) {
            try {
                NetworkTable.initialize();
            }
            catch (IOException e) {
                throw new RuntimeException("NetworkTable could not be initialized: " + e + ": " + e.getMessage());
            }
        }
        return (NetworkTable)staticProvider.getTable('/' + key);
    }

    NetworkTable(String path, NetworkTableProvider provider) {
        this.path = path;
        this.entryCache = new EntryCache(path);
        this.absoluteKeyCache = new NetworkTableKeyCache(path);
        this.provider = provider;
        this.node = provider.getNode();
    }

    public String toString() {
        return "NetworkTable: " + this.path;
    }

    public boolean isConnected() {
        return this.node.isConnected();
    }

    public boolean isServer() {
        return this.node.isServer();
    }

    public void addConnectionListener(IRemoteConnectionListener listener, boolean immediateNotify) {
        NetworkTableConnectionListenerAdapter adapter = (NetworkTableConnectionListenerAdapter)this.connectionListenerMap.get(listener);
        if (adapter != null) {
            throw new IllegalStateException("Cannot add the same listener twice");
        }
        adapter = new NetworkTableConnectionListenerAdapter(this, listener);
        this.connectionListenerMap.put(listener, adapter);
        this.node.addConnectionListener(adapter, immediateNotify);
    }

    public void removeConnectionListener(IRemoteConnectionListener listener) {
        NetworkTableConnectionListenerAdapter adapter = (NetworkTableConnectionListenerAdapter)this.connectionListenerMap.get(listener);
        if (adapter != null) {
            this.node.removeConnectionListener(adapter);
        }
    }

    public void addTableListener(ITableListener listener) {
        this.addTableListener(listener, false);
    }

    public void addTableListener(ITableListener listener, boolean immediateNotify) {
        List adapters = (List)this.listenerMap.get(listener);
        if (adapters == null) {
            adapters = new List();
            this.listenerMap.put(listener, adapters);
        }
        NetworkTableListenerAdapter adapter = new NetworkTableListenerAdapter(this.path + '/', this, listener);
        adapters.add(adapter);
        this.node.addTableListener(adapter, immediateNotify);
    }

    public void addTableListener(String key, ITableListener listener, boolean immediateNotify) {
        List adapters = (List)this.listenerMap.get(listener);
        if (adapters == null) {
            adapters = new List();
            this.listenerMap.put(listener, adapters);
        }
        NetworkTableKeyListenerAdapter adapter = new NetworkTableKeyListenerAdapter(key, this.absoluteKeyCache.get(key), this, listener);
        adapters.add(adapter);
        this.node.addTableListener(adapter, immediateNotify);
    }

    public void addSubTableListener(ITableListener listener) {
        List adapters = (List)this.listenerMap.get(listener);
        if (adapters == null) {
            adapters = new List();
            this.listenerMap.put(listener, adapters);
        }
        NetworkTableSubListenerAdapter adapter = new NetworkTableSubListenerAdapter(this.path, this, listener);
        adapters.add(adapter);
        this.node.addTableListener(adapter, true);
    }

    public void removeTableListener(ITableListener listener) {
        List adapters = (List)this.listenerMap.get(listener);
        if (adapters != null) {
            for (int i = 0; i < adapters.size(); ++i) {
                this.node.removeTableListener((ITableListener)adapters.get(i));
            }
            adapters.clear();
        }
    }

    private synchronized NetworkTableEntry getEntry(String key) {
        return this.entryCache.get(key);
    }

    public synchronized ITable getSubTable(String key) {
        return (NetworkTable)this.provider.getTable(this.absoluteKeyCache.get(key));
    }

    public boolean containsKey(String key) {
        return this.node.containsKey(this.absoluteKeyCache.get(key));
    }

    public boolean containsSubTable(String key) {
        String subtablePrefix = this.absoluteKeyCache.get(key) + '/';
        List keys = this.node.getEntryStore().keys();
        for (int i = 0; i < keys.size(); ++i) {
            if (!((String)keys.get(i)).startsWith(subtablePrefix)) continue;
            return true;
        }
        return false;
    }

    public void putNumber(String key, double value) {
        this.putValue(key, new Double(value));
    }

    public double getNumber(String key) throws TableKeyNotDefinedException {
        return this.node.getDouble(this.absoluteKeyCache.get(key));
    }

    public double getNumber(String key, double defaultValue) {
        try {
            return this.node.getDouble(this.absoluteKeyCache.get(key));
        }
        catch (TableKeyNotDefinedException e) {
            return defaultValue;
        }
    }

    public void putString(String key, String value) {
        this.putValue(key, value);
    }

    public String getString(String key) throws TableKeyNotDefinedException {
        return this.node.getString(this.absoluteKeyCache.get(key));
    }

    public String getString(String key, String defaultValue) {
        try {
            return this.node.getString(this.absoluteKeyCache.get(key));
        }
        catch (TableKeyNotDefinedException e) {
            return defaultValue;
        }
    }

    public void putBoolean(String key, boolean value) {
        this.putValue(key, value ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean getBoolean(String key) throws TableKeyNotDefinedException {
        return this.node.getBoolean(this.absoluteKeyCache.get(key));
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        try {
            return this.node.getBoolean(this.absoluteKeyCache.get(key));
        }
        catch (TableKeyNotDefinedException e) {
            return defaultValue;
        }
    }

    public void retrieveValue(String key, Object externalValue) {
        this.node.retrieveValue(this.absoluteKeyCache.get(key), externalValue);
    }

    public void putValue(String key, Object value) {
        NetworkTableEntry entry = this.entryCache.get(key);
        if (entry != null) {
            this.node.putValue(entry, value);
        } else {
            this.node.putValue(this.absoluteKeyCache.get(key), value);
        }
    }

    public Object getValue(String key) throws TableKeyNotDefinedException {
        return this.node.getValue(this.absoluteKeyCache.get(key));
    }

    public Object getValue(String key, Object defaultValue) {
        try {
            return this.node.getValue(this.absoluteKeyCache.get(key));
        }
        catch (TableKeyNotDefinedException e) {
            return defaultValue;
        }
    }

    public void putInt(String key, int value) {
        this.putNumber(key, value);
    }

    public int getInt(String key) throws TableKeyNotDefinedException {
        return (int)this.getNumber(key);
    }

    public int getInt(String key, int defaultValue) throws TableKeyNotDefinedException {
        try {
            return (int)this.getNumber(key);
        }
        catch (NoSuchElementException ex) {
            return defaultValue;
        }
    }

    public void putDouble(String key, double value) {
        this.putNumber(key, value);
    }

    public double getDouble(String key) throws TableKeyNotDefinedException {
        return this.getNumber(key);
    }

    public double getDouble(String key, double defaultValue) {
        return this.getNumber(key, defaultValue);
    }

    class EntryCache {
        private final Hashtable cache = new Hashtable();
        private final String path;

        public EntryCache(String path) {
            this.path = path;
        }

        public NetworkTableEntry get(String key) {
            NetworkTableEntry cachedValue = (NetworkTableEntry)this.cache.get(key);
            if (cachedValue == null && (cachedValue = NetworkTable.this.node.getEntryStore().getEntry(NetworkTable.this.absoluteKeyCache.get(key))) != null) {
                this.cache.put(key, cachedValue);
            }
            return cachedValue;
        }
    }

    static class NetworkTableKeyCache
    extends StringCache {
        private final String path;

        public NetworkTableKeyCache(String path) {
            this.path = path;
        }

        public String calc(String key) {
            return this.path + '/' + key;
        }
    }
}

