/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.networktables;

import edu.wpi.first.wpilibj.networktables2.NetworkTableNode;
import edu.wpi.first.wpilibj.networktables2.client.NetworkTableClient;
import edu.wpi.first.wpilibj.networktables2.server.NetworkTableServer;
import edu.wpi.first.wpilibj.networktables2.stream.IOStreamFactory;
import edu.wpi.first.wpilibj.networktables2.stream.IOStreamProvider;
import edu.wpi.first.wpilibj.networktables2.stream.SocketStreams;
import edu.wpi.first.wpilibj.networktables2.thread.NTThreadManager;
import edu.wpi.first.wpilibj.networktables2.type.NetworkTableEntryTypeManager;
import java.io.IOException;

public abstract class NetworkTableMode {
    public static final NetworkTableMode Server = new NetworkTableMode("Server"){

        public NetworkTableNode createNode(String ipAddress, int port, NTThreadManager threadManager) throws IOException {
            IOStreamProvider streamProvider = SocketStreams.newStreamProvider(port);
            return new NetworkTableServer(streamProvider, new NetworkTableEntryTypeManager(), threadManager);
        }
    };
    public static final NetworkTableMode Client = new NetworkTableMode("Client"){

        public NetworkTableNode createNode(String ipAddress, int port, NTThreadManager threadManager) throws IOException {
            if (ipAddress == null) {
                throw new IllegalArgumentException("IP address cannot be null when in client mode");
            }
            IOStreamFactory streamFactory = SocketStreams.newStreamFactory(ipAddress, port);
            NetworkTableClient client = new NetworkTableClient(streamFactory, new NetworkTableEntryTypeManager(), threadManager);
            client.reconnect();
            return client;
        }
    };
    private String name;

    private NetworkTableMode(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    abstract NetworkTableNode createNode(String var1, int var2, NTThreadManager var3) throws IOException;
}

