/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.networktables2;

import edu.wpi.first.wpilibj.networktables2.IncomingEntryReceiver;
import edu.wpi.first.wpilibj.networktables2.NetworkTableEntry;
import edu.wpi.first.wpilibj.networktables2.OutgoingEntryReceiver;
import edu.wpi.first.wpilibj.networktables2.TableKeyExistsWithDifferentTypeException;
import edu.wpi.first.wpilibj.networktables2.type.NetworkTableEntryType;
import edu.wpi.first.wpilibj.networktables2.util.CharacterArrayMap;
import edu.wpi.first.wpilibj.networktables2.util.List;
import edu.wpi.first.wpilibj.tables.ITable;
import edu.wpi.first.wpilibj.tables.ITableListener;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class AbstractNetworkTableEntryStore
implements IncomingEntryReceiver {
    protected final CharacterArrayMap idEntries = new CharacterArrayMap();
    protected final Hashtable namedEntries = new Hashtable();
    protected final TableListenerManager listenerManager;
    protected OutgoingEntryReceiver outgoingReceiver;
    protected OutgoingEntryReceiver incomingReceiver;

    protected AbstractNetworkTableEntryStore(TableListenerManager listenerManager) {
        this.listenerManager = listenerManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetworkTableEntry getEntry(char entryId) {
        AbstractNetworkTableEntryStore abstractNetworkTableEntryStore = this;
        synchronized (abstractNetworkTableEntryStore) {
            return (NetworkTableEntry)this.idEntries.get(entryId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetworkTableEntry getEntry(String name) {
        AbstractNetworkTableEntryStore abstractNetworkTableEntryStore = this;
        synchronized (abstractNetworkTableEntryStore) {
            return (NetworkTableEntry)this.namedEntries.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List keys() {
        AbstractNetworkTableEntryStore abstractNetworkTableEntryStore = this;
        synchronized (abstractNetworkTableEntryStore) {
            List entryKeys = new List();
            Enumeration e = this.namedEntries.keys();
            while (e.hasMoreElements()) {
                entryKeys.add(e.nextElement());
            }
            return entryKeys;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearEntries() {
        AbstractNetworkTableEntryStore abstractNetworkTableEntryStore = this;
        synchronized (abstractNetworkTableEntryStore) {
            this.idEntries.clear();
            this.namedEntries.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearIds() {
        AbstractNetworkTableEntryStore abstractNetworkTableEntryStore = this;
        synchronized (abstractNetworkTableEntryStore) {
            this.idEntries.clear();
            Enumeration e = this.namedEntries.elements();
            while (e.hasMoreElements()) {
                ((NetworkTableEntry)e.nextElement()).clearId();
            }
        }
    }

    public void setOutgoingReceiver(OutgoingEntryReceiver receiver) {
        this.outgoingReceiver = receiver;
    }

    public void setIncomingReceiver(OutgoingEntryReceiver receiver) {
        this.incomingReceiver = receiver;
    }

    protected abstract boolean addEntry(NetworkTableEntry var1);

    protected abstract boolean updateEntry(NetworkTableEntry var1, char var2, Object var3);

    private static boolean valuesEqual(Object o1, Object o2) {
        if (o1 instanceof Object[]) {
            Object[] a1 = (Object[])o1;
            Object[] a2 = (Object[])o2;
            if (a1.length != a2.length) {
                return false;
            }
            for (int i = 0; i < a1.length; ++i) {
                if (AbstractNetworkTableEntryStore.valuesEqual(a1[i], a2[i])) continue;
                return false;
            }
            return true;
        }
        return o1 != null ? o1.equals(o2) : o2 == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putOutgoing(String name, NetworkTableEntryType type, Object value) throws TableKeyExistsWithDifferentTypeException {
        AbstractNetworkTableEntryStore abstractNetworkTableEntryStore = this;
        synchronized (abstractNetworkTableEntryStore) {
            NetworkTableEntry tableEntry = (NetworkTableEntry)this.namedEntries.get(name);
            if (tableEntry == null) {
                tableEntry = new NetworkTableEntry(name, type, value);
                if (this.addEntry(tableEntry)) {
                    tableEntry.fireListener(this.listenerManager);
                    this.outgoingReceiver.offerOutgoingAssignment(tableEntry);
                }
            } else {
                if (tableEntry.getType().id != type.id) {
                    throw new TableKeyExistsWithDifferentTypeException(name, tableEntry.getType());
                }
                if (!AbstractNetworkTableEntryStore.valuesEqual(value, tableEntry.getValue())) {
                    if (this.updateEntry(tableEntry, (char)(tableEntry.getSequenceNumber() + '\u0001'), value)) {
                        this.outgoingReceiver.offerOutgoingUpdate(tableEntry);
                    }
                    tableEntry.fireListener(this.listenerManager);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putOutgoing(NetworkTableEntry tableEntry, Object value) {
        AbstractNetworkTableEntryStore abstractNetworkTableEntryStore = this;
        synchronized (abstractNetworkTableEntryStore) {
            if (!AbstractNetworkTableEntryStore.valuesEqual(value, tableEntry.getValue())) {
                if (this.updateEntry(tableEntry, (char)(tableEntry.getSequenceNumber() + '\u0001'), value)) {
                    this.outgoingReceiver.offerOutgoingUpdate(tableEntry);
                }
                tableEntry.fireListener(this.listenerManager);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offerIncomingAssignment(NetworkTableEntry entry) {
        AbstractNetworkTableEntryStore abstractNetworkTableEntryStore = this;
        synchronized (abstractNetworkTableEntryStore) {
            NetworkTableEntry tableEntry = (NetworkTableEntry)this.namedEntries.get(entry.name);
            if (this.addEntry(entry)) {
                if (tableEntry == null) {
                    tableEntry = entry;
                }
                tableEntry.fireListener(this.listenerManager);
                this.incomingReceiver.offerOutgoingAssignment(tableEntry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offerIncomingUpdate(NetworkTableEntry entry, char sequenceNumber, Object value) {
        AbstractNetworkTableEntryStore abstractNetworkTableEntryStore = this;
        synchronized (abstractNetworkTableEntryStore) {
            if (this.updateEntry(entry, sequenceNumber, value)) {
                entry.fireListener(this.listenerManager);
                this.incomingReceiver.offerOutgoingUpdate(entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyEntries(ITable table, ITableListener listener) {
        AbstractNetworkTableEntryStore abstractNetworkTableEntryStore = this;
        synchronized (abstractNetworkTableEntryStore) {
            Enumeration entryIterator = this.namedEntries.elements();
            while (entryIterator.hasMoreElements()) {
                NetworkTableEntry entry = (NetworkTableEntry)entryIterator.nextElement();
                listener.valueChanged(table, entry.name, entry.getValue(), true);
            }
        }
    }

    public static interface TableListenerManager {
        public void fireTableListeners(String var1, Object var2, boolean var3);
    }
}

