/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.networktables2;

import edu.wpi.first.wpilibj.networktables2.AbstractNetworkTableEntryStore;
import edu.wpi.first.wpilibj.networktables2.FlushableOutgoingEntryReceiver;
import edu.wpi.first.wpilibj.networktables2.NetworkTableEntry;
import edu.wpi.first.wpilibj.networktables2.OutgoingEntryReceiver;
import edu.wpi.first.wpilibj.networktables2.thread.NTThread;
import edu.wpi.first.wpilibj.networktables2.thread.NTThreadManager;
import edu.wpi.first.wpilibj.networktables2.thread.PeriodicRunnable;
import edu.wpi.first.wpilibj.networktables2.util.HalfQueue;

public class WriteManager
implements OutgoingEntryReceiver,
PeriodicRunnable {
    private final int SLEEP_TIME;
    private final int queueSize;
    private Object transactionsLock = new Object();
    private NTThread thread;
    private NTThreadManager threadManager;
    private final AbstractNetworkTableEntryStore entryStore;
    private volatile HalfQueue incomingAssignmentQueue;
    private volatile HalfQueue incomingUpdateQueue;
    private volatile HalfQueue outgoingAssignmentQueue;
    private volatile HalfQueue outgoingUpdateQueue;
    private FlushableOutgoingEntryReceiver receiver;
    private long lastWrite;
    private final long keepAliveDelay;

    public WriteManager(FlushableOutgoingEntryReceiver receiver, NTThreadManager threadManager, AbstractNetworkTableEntryStore entryStore, long keepAliveDelay) {
        this.SLEEP_TIME = 100;
        this.queueSize = 500;
        this.receiver = receiver;
        this.threadManager = threadManager;
        this.entryStore = entryStore;
        this.incomingAssignmentQueue = new HalfQueue(500);
        this.incomingUpdateQueue = new HalfQueue(500);
        this.outgoingAssignmentQueue = new HalfQueue(500);
        this.outgoingUpdateQueue = new HalfQueue(500);
        this.keepAliveDelay = keepAliveDelay;
    }

    public void start() {
        if (this.thread != null) {
            this.stop();
        }
        this.lastWrite = System.currentTimeMillis();
        this.thread = this.threadManager.newBlockingPeriodicThread(this, "Write Manager Thread");
    }

    public void stop() {
        if (this.thread != null) {
            this.thread.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offerOutgoingAssignment(NetworkTableEntry entry) {
        Object object = this.transactionsLock;
        synchronized (object) {
            this.incomingAssignmentQueue.queue(entry);
            if (this.incomingAssignmentQueue.isFull()) {
                try {
                    this.run();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.err.println("assignment queue overflowed. decrease the rate at which you create new entries or increase the write buffer size");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offerOutgoingUpdate(NetworkTableEntry entry) {
        Object object = this.transactionsLock;
        synchronized (object) {
            this.incomingUpdateQueue.queue(entry);
            if (this.incomingUpdateQueue.isFull()) {
                try {
                    this.run();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.err.println("update queue overflowed. decrease the rate at which you update entries or increase the write buffer size");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws InterruptedException {
        AbstractNetworkTableEntryStore abstractNetworkTableEntryStore;
        NetworkTableEntry entry;
        int i;
        Object object = this.transactionsLock;
        synchronized (object) {
            HalfQueue tmp = this.incomingAssignmentQueue;
            this.incomingAssignmentQueue = this.outgoingAssignmentQueue;
            this.outgoingAssignmentQueue = tmp;
            tmp = this.incomingUpdateQueue;
            this.incomingUpdateQueue = this.outgoingUpdateQueue;
            this.outgoingUpdateQueue = tmp;
        }
        boolean wrote = false;
        int size = this.outgoingAssignmentQueue.size();
        Object[] array = this.outgoingAssignmentQueue.array;
        for (i = 0; i < size; ++i) {
            entry = (NetworkTableEntry)array[i];
            abstractNetworkTableEntryStore = this.entryStore;
            synchronized (abstractNetworkTableEntryStore) {
                entry.makeClean();
            }
            wrote = true;
            this.receiver.offerOutgoingAssignment(entry);
        }
        this.outgoingAssignmentQueue.clear();
        size = this.outgoingUpdateQueue.size();
        array = this.outgoingUpdateQueue.array;
        for (i = 0; i < size; ++i) {
            entry = (NetworkTableEntry)array[i];
            abstractNetworkTableEntryStore = this.entryStore;
            synchronized (abstractNetworkTableEntryStore) {
                entry.makeClean();
            }
            wrote = true;
            this.receiver.offerOutgoingUpdate(entry);
        }
        this.outgoingUpdateQueue.clear();
        if (wrote) {
            this.receiver.flush();
            this.lastWrite = System.currentTimeMillis();
        } else if (System.currentTimeMillis() - this.lastWrite > this.keepAliveDelay) {
            this.receiver.ensureAlive();
        }
        Thread.sleep(100L);
    }
}

