/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.networktables2.client;

import edu.wpi.first.wpilibj.networktables2.FlushableOutgoingEntryReceiver;
import edu.wpi.first.wpilibj.networktables2.IncomingEntryReceiver;
import edu.wpi.first.wpilibj.networktables2.NetworkTableEntry;
import edu.wpi.first.wpilibj.networktables2.client.ClientConnectionListenerManager;
import edu.wpi.first.wpilibj.networktables2.client.ClientConnectionState;
import edu.wpi.first.wpilibj.networktables2.client.ClientNetworkTableEntryStore;
import edu.wpi.first.wpilibj.networktables2.connection.BadMessageException;
import edu.wpi.first.wpilibj.networktables2.connection.ConnectionAdapter;
import edu.wpi.first.wpilibj.networktables2.connection.ConnectionMonitorThread;
import edu.wpi.first.wpilibj.networktables2.connection.NetworkTableConnection;
import edu.wpi.first.wpilibj.networktables2.stream.IOStream;
import edu.wpi.first.wpilibj.networktables2.stream.IOStreamFactory;
import edu.wpi.first.wpilibj.networktables2.thread.NTThread;
import edu.wpi.first.wpilibj.networktables2.thread.NTThreadManager;
import edu.wpi.first.wpilibj.networktables2.type.NetworkTableEntryTypeManager;
import java.io.IOException;

public class ClientConnectionAdapter
implements ConnectionAdapter,
IncomingEntryReceiver,
FlushableOutgoingEntryReceiver {
    private final ClientNetworkTableEntryStore entryStore;
    private final IOStreamFactory streamFactory;
    private final NTThreadManager threadManager;
    private NetworkTableConnection connection;
    private NTThread readThread;
    private ClientConnectionState connectionState = ClientConnectionState.DISCONNECTED_FROM_SERVER;
    private final ClientConnectionListenerManager connectionListenerManager;
    private final Object connectionLock = new Object();
    private final NetworkTableEntryTypeManager typeManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gotoState(ClientConnectionState newState) {
        Object object = this.connectionLock;
        synchronized (object) {
            if (this.connectionState != newState) {
                System.out.println(this + " entered connection state: " + newState);
                if (newState == ClientConnectionState.IN_SYNC_WITH_SERVER) {
                    this.connectionListenerManager.fireConnectedEvent();
                }
                if (this.connectionState == ClientConnectionState.IN_SYNC_WITH_SERVER) {
                    this.connectionListenerManager.fireDisconnectedEvent();
                }
                this.connectionState = newState;
            }
        }
    }

    public ClientConnectionState getConnectionState() {
        return this.connectionState;
    }

    public boolean isConnected() {
        return this.getConnectionState() == ClientConnectionState.IN_SYNC_WITH_SERVER;
    }

    public ClientConnectionAdapter(ClientNetworkTableEntryStore entryStore, NTThreadManager threadManager, IOStreamFactory streamFactory, ClientConnectionListenerManager connectionListenerManager, NetworkTableEntryTypeManager typeManager) {
        this.entryStore = entryStore;
        this.streamFactory = streamFactory;
        this.threadManager = threadManager;
        this.connectionListenerManager = connectionListenerManager;
        this.typeManager = typeManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconnect() {
        Object object = this.connectionLock;
        synchronized (object) {
            this.close();
            try {
                IOStream stream = this.streamFactory.createStream();
                if (stream == null) {
                    return;
                }
                this.connection = new NetworkTableConnection(stream, this.typeManager);
                this.readThread = this.threadManager.newBlockingPeriodicThread(new ConnectionMonitorThread(this, this.connection), "Client Connection Reader Thread");
                this.connection.sendClientHello();
                this.gotoState(ClientConnectionState.CONNECTED_TO_SERVER);
            }
            catch (Exception e) {
                this.close();
            }
        }
    }

    public void close() {
        this.close(ClientConnectionState.DISCONNECTED_FROM_SERVER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(ClientConnectionState newState) {
        Object object = this.connectionLock;
        synchronized (object) {
            this.gotoState(newState);
            if (this.readThread != null) {
                this.readThread.stop();
                this.readThread = null;
            }
            if (this.connection != null) {
                this.connection.close();
                this.connection = null;
            }
            this.entryStore.clearIds();
        }
    }

    public void badMessage(BadMessageException e) {
        this.close(new ClientConnectionState.Error(e));
    }

    public void ioException(IOException e) {
        if (this.connectionState != ClientConnectionState.DISCONNECTED_FROM_SERVER) {
            this.reconnect();
        }
    }

    public NetworkTableEntry getEntry(char id) {
        return this.entryStore.getEntry(id);
    }

    public void keepAlive() throws IOException {
    }

    public void clientHello(char protocolRevision) throws IOException {
        throw new BadMessageException("A client should not receive a client hello message");
    }

    public void protocolVersionUnsupported(char protocolRevision) {
        this.close();
        this.gotoState(new ClientConnectionState.ProtocolUnsuppotedByServer(protocolRevision));
    }

    public void serverHelloComplete() throws IOException {
        if (this.connectionState == ClientConnectionState.CONNECTED_TO_SERVER) {
            try {
                this.gotoState(ClientConnectionState.IN_SYNC_WITH_SERVER);
                this.entryStore.sendUnknownEntries(this.connection);
            }
            catch (IOException e) {
                this.ioException(e);
            }
        } else {
            throw new BadMessageException("A client should only receive a server hello complete once and only after it has connected to the server");
        }
    }

    public void offerIncomingAssignment(NetworkTableEntry entry) {
        this.entryStore.offerIncomingAssignment(entry);
    }

    public void offerIncomingUpdate(NetworkTableEntry entry, char sequenceNumber, Object value) {
        this.entryStore.offerIncomingUpdate(entry, sequenceNumber, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offerOutgoingAssignment(NetworkTableEntry entry) {
        try {
            Object object = this.connectionLock;
            synchronized (object) {
                if (this.connection != null && this.connectionState == ClientConnectionState.IN_SYNC_WITH_SERVER) {
                    this.connection.sendEntryAssignment(entry);
                }
            }
        }
        catch (IOException e) {
            this.ioException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offerOutgoingUpdate(NetworkTableEntry entry) {
        try {
            Object object = this.connectionLock;
            synchronized (object) {
                if (this.connection != null && this.connectionState == ClientConnectionState.IN_SYNC_WITH_SERVER) {
                    this.connection.sendEntryUpdate(entry);
                }
            }
        }
        catch (IOException e) {
            this.ioException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Object object = this.connectionLock;
        synchronized (object) {
            if (this.connection != null) {
                try {
                    this.connection.flush();
                }
                catch (IOException e) {
                    this.ioException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureAlive() {
        Object object = this.connectionLock;
        synchronized (object) {
            if (this.connection != null) {
                try {
                    this.connection.sendKeepAlive();
                }
                catch (IOException e) {
                    this.ioException(e);
                }
            } else {
                this.reconnect();
            }
        }
    }
}

