/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.networktables2.server;

import edu.wpi.first.wpilibj.networktables2.server.ServerAdapterManager;
import edu.wpi.first.wpilibj.networktables2.server.ServerConnectionAdapter;
import edu.wpi.first.wpilibj.networktables2.server.ServerIncomingConnectionListener;
import edu.wpi.first.wpilibj.networktables2.server.ServerNetworkTableEntryStore;
import edu.wpi.first.wpilibj.networktables2.stream.IOStream;
import edu.wpi.first.wpilibj.networktables2.stream.IOStreamProvider;
import edu.wpi.first.wpilibj.networktables2.thread.NTThread;
import edu.wpi.first.wpilibj.networktables2.thread.NTThreadManager;
import edu.wpi.first.wpilibj.networktables2.thread.PeriodicRunnable;
import edu.wpi.first.wpilibj.networktables2.type.NetworkTableEntryTypeManager;
import java.io.IOException;

public class ServerIncomingStreamMonitor
implements PeriodicRunnable {
    private final IOStreamProvider streamProvider;
    private final ServerIncomingConnectionListener incomingListener;
    private final ServerNetworkTableEntryStore entryStore;
    private final ServerAdapterManager adapterListener;
    private NTThread monitorThread;
    private NTThreadManager threadManager;
    private final NetworkTableEntryTypeManager typeManager;

    public ServerIncomingStreamMonitor(IOStreamProvider streamProvider, ServerNetworkTableEntryStore entryStore, ServerIncomingConnectionListener incomingListener, ServerAdapterManager adapterListener, NetworkTableEntryTypeManager typeManager, NTThreadManager threadManager) {
        this.streamProvider = streamProvider;
        this.entryStore = entryStore;
        this.incomingListener = incomingListener;
        this.adapterListener = adapterListener;
        this.typeManager = typeManager;
        this.threadManager = threadManager;
    }

    public void start() {
        if (this.monitorThread != null) {
            this.stop();
        }
        this.monitorThread = this.threadManager.newBlockingPeriodicThread(this, "Server Incoming Stream Monitor Thread");
    }

    public void stop() {
        if (this.monitorThread != null) {
            this.monitorThread.stop();
        }
    }

    public void run() {
        IOStream newStream = null;
        try {
            newStream = this.streamProvider.accept();
            if (newStream != null) {
                ServerConnectionAdapter connectionAdapter = new ServerConnectionAdapter(newStream, this.entryStore, this.entryStore, this.adapterListener, this.typeManager, this.threadManager);
                this.incomingListener.onNewConnection(connectionAdapter);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

