/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.InputStream;

public class BufferedInputStream
extends InputStream {
    private final InputStream source;
    private byte[] buffer;
    private int pos;
    private int maxPos;

    public BufferedInputStream(InputStream source) {
        this(source, 8192);
    }

    public BufferedInputStream(InputStream source, int size) {
        this.source = source;
        this.buffer = new byte[size];
        this.pos = 0;
        this.maxPos = 0;
    }

    private void fillBuffer() throws IOException {
        int numRemaining = this.maxPos - this.pos;
        System.arraycopy(this.buffer, this.pos, this.buffer, 0, numRemaining);
        this.pos = 0;
        this.maxPos = numRemaining;
        int numRead = this.source.read(this.buffer, numRemaining, this.buffer.length - numRemaining);
        this.maxPos += numRead;
    }

    public int read() throws IOException {
        if (this.pos < this.maxPos) {
            return this.buffer[this.pos++] & 0xFF;
        }
        this.fillBuffer();
        if (this.pos < this.maxPos) {
            return this.buffer[this.pos++] & 0xFF;
        }
        return -1;
    }

    public int available() throws IOException {
        return this.maxPos - this.pos + this.source.available();
    }

    public void close() throws IOException {
        this.source.close();
    }
}

