/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.OutputStream;

public class BufferedOutputStream
extends OutputStream {
    private final byte[] buffer;
    private int pos;
    private final OutputStream out;

    public BufferedOutputStream(OutputStream out) {
        this(out, 8192);
    }

    public BufferedOutputStream(OutputStream out, int size) {
        this.out = out;
        this.buffer = new byte[size];
        this.pos = 0;
    }

    private void flushBuffer() throws IOException {
        if (this.pos > 0) {
            this.out.write(this.buffer, 0, this.pos);
            this.pos = 0;
        }
    }

    public void write(int b) throws IOException {
        this.buffer[this.pos++] = (byte)b;
        if (this.pos >= this.buffer.length) {
            this.flushBuffer();
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (len >= this.buffer.length) {
            this.flushBuffer();
            this.out.write(b, off, len);
        } else {
            if (len >= this.buffer.length - this.pos) {
                this.flushBuffer();
            }
            System.arraycopy(b, off, this.buffer, this.pos, len);
            this.pos += len;
        }
    }

    public void flush() throws IOException {
        this.flushBuffer();
        this.out.flush();
    }

    public void close() throws IOException {
        this.flushBuffer();
        this.out.close();
    }
}

