/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.sdk.tool.frc;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public abstract class AbstractNetConsole {
    public static final String READTHREADNAME = "NetConsole.readThread";
    public static final int DATAGRAMSOCKETTIMEOUT = 1000;
    public static final char CONTROL_CHARACTER_ABORT_SHELL = 'C';
    public static final char CONTROL_CHARACTER_EOF = 'D';
    public static final char CONTROL_CHARACTER_DELETE_CHARACTER = 'H';
    public static final char CONTROL_CHARACTER_RESUME_OUTPUT = 'Q';
    public static final char CONTROL_CHARACTER_SUSPEND_OUTPUT = 'S';
    public static final char CONTROL_CHARACTER_DELETE_LINE = 'U';
    public static final char CONTROL_CHARACTER_REBOOT = 'X';
    public static final char CONTROL_CHARACTER_TOGGLE_EDIT_MODE = '[';
    protected final int readPort;
    protected final int writePort;
    protected InetAddress address;
    protected final BlockingQueue<byte[]> readQueue = new LinkedBlockingQueue<byte[]>();
    protected volatile boolean keepRunning;
    protected Thread readThread;
    protected byte[] currentReceivedBytes;
    protected int currentReceivedBytesIndex;
    protected final StringBuffer lineBuilder = new StringBuffer();
    protected final DatagramPacket writePacket;
    protected final byte[] writeBuffer;
    protected DatagramSocket datagramSocket;
    protected final Object readLock = new Object();

    public AbstractNetConsole() {
        this(null);
    }

    public AbstractNetConsole(String string) {
        this.readPort = 6666;
        this.writePort = 6668;
        if (string != null) {
            try {
                this.address = InetAddress.getByName(string);
            }
            catch (UnknownHostException unknownHostException) {
                throw new RuntimeException(unknownHostException);
            }
        }
        this.writeBuffer = new byte[1];
        this.writePacket = new DatagramPacket(this.writeBuffer, 0, this.writeBuffer.length, this.address, this.writePort);
    }

    public void doConsole() {
        if (this.address == null) {
            this.logln("Waiting to receive packets from cRIO to know which address to send to");
            int n = this.read();
            if (n == -1) {
                return;
            }
            this.log((char)n);
        }
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (AbstractNetConsole.this.keepRunning) {
                        int n = System.in.read();
                        if (n == -1) {
                            AbstractNetConsole.this.keepRunning = false;
                            break;
                        }
                        AbstractNetConsole.this.write((byte)n);
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        });
        thread.setName("readSystemInThread");
        thread.start();
        this.echo();
    }

    public void echo() {
        while (this.keepRunning) {
            int n = this.read();
            if (n == -1) {
                this.keepRunning = false;
                break;
            }
            this.log((char)n);
        }
    }

    public String echoLine() {
        String string = this.readLine();
        this.logln(string);
        return string;
    }

    public abstract void log(char var1);

    public abstract void log(String var1);

    public abstract void logln(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() {
        Object object = this.readLock;
        synchronized (object) {
            if (!this.keepRunning) {
                return -1;
            }
            ++this.currentReceivedBytesIndex;
            while (this.keepRunning && (this.currentReceivedBytes == null || this.currentReceivedBytesIndex >= this.currentReceivedBytes.length)) {
                try {
                    this.currentReceivedBytes = this.readQueue.poll(500L, TimeUnit.MILLISECONDS);
                    if (this.currentReceivedBytes == null) {
                        continue;
                    }
                }
                catch (InterruptedException interruptedException) {
                    return -1;
                }
                this.currentReceivedBytesIndex = 0;
            }
            if (this.currentReceivedBytes == null) {
                return -1;
            }
            char c = (char)this.currentReceivedBytes[this.currentReceivedBytesIndex];
            return c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readLine() {
        Object object = this.readLock;
        synchronized (object) {
            this.lineBuilder.setLength(0);
            while (this.keepRunning) {
                ++this.currentReceivedBytesIndex;
                while (this.currentReceivedBytes == null || this.currentReceivedBytesIndex >= this.currentReceivedBytes.length) {
                    try {
                        this.currentReceivedBytes = this.readQueue.poll(500L, TimeUnit.MILLISECONDS);
                        if (this.currentReceivedBytes == null) {
                            continue;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        return this.lineBuilder.toString();
                    }
                    this.currentReceivedBytesIndex = 0;
                }
                char c = (char)this.currentReceivedBytes[this.currentReceivedBytesIndex];
                if (c == '\r') {
                    return this.lineBuilder.toString();
                }
                if (c == '\n') {
                    if (this.lineBuilder.length() == 0) continue;
                    return this.lineBuilder.toString();
                }
                this.lineBuilder.append(c);
            }
            return this.lineBuilder.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte by) throws IOException {
        DatagramPacket datagramPacket = this.writePacket;
        synchronized (datagramPacket) {
            if (!this.keepRunning) {
                return;
            }
            if (this.readThread == null) {
                throw new IllegalStateException("Need to start() me before you can write");
            }
            if (this.address == null) {
                throw new IllegalArgumentException("Have not received a packet yet to set the target address or have not been given the address of the target");
            }
            this.writeBuffer[0] = by;
            this.datagramSocket.send(this.writePacket);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String string) throws IOException {
        DatagramPacket datagramPacket = this.writePacket;
        synchronized (datagramPacket) {
            char[] cArray;
            for (char c : cArray = string.toCharArray()) {
                this.write((byte)c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeln(String string) throws IOException {
        DatagramPacket datagramPacket = this.writePacket;
        synchronized (datagramPacket) {
            char[] cArray;
            for (char c : cArray = string.toCharArray()) {
                this.write((byte)c);
            }
            this.write((byte)10);
        }
    }

    public void writeControlCharacter(char c) throws IOException {
        this.write((byte)(Character.toUpperCase(c) - 64));
    }

    public void start() {
        if (this.readThread != null) {
            return;
        }
        this.keepRunning = true;
        final Semaphore semaphore = new Semaphore(0);
        final Thread thread = Thread.currentThread();
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    this.connectAndRead();
                }
                finally {
                    AbstractNetConsole.this.stop();
                    semaphore.release();
                }
            }

            public void connectAndRead() {
                byte[] byArray;
                try {
                    AbstractNetConsole.this.datagramSocket = new DatagramSocket(AbstractNetConsole.this.readPort);
                    AbstractNetConsole.this.datagramSocket.setSoTimeout(1000);
                }
                catch (SocketException socketException) {
                    socketException.printStackTrace();
                    return;
                }
                try {
                    byArray = new byte[AbstractNetConsole.this.datagramSocket.getReceiveBufferSize()];
                }
                catch (SocketException socketException) {
                    socketException.printStackTrace();
                    return;
                }
                DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
                semaphore.release();
                while (AbstractNetConsole.this.keepRunning && thread.isAlive()) {
                    try {
                        try {
                            AbstractNetConsole.this.datagramSocket.receive(datagramPacket);
                        }
                        catch (SocketTimeoutException socketTimeoutException) {
                            continue;
                        }
                        if (AbstractNetConsole.this.address == null) {
                            AbstractNetConsole.this.address = datagramPacket.getAddress();
                            AbstractNetConsole.this.writePacket.setAddress(AbstractNetConsole.this.address);
                        }
                        if (!datagramPacket.getAddress().equals(AbstractNetConsole.this.address)) continue;
                        int n = datagramPacket.getLength();
                        byte[] byArray2 = new byte[n];
                        System.arraycopy(byArray, 0, byArray2, 0, n);
                        AbstractNetConsole.this.readQueue.add(byArray2);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        };
        this.readThread = new Thread(runnable, READTHREADNAME);
        this.readThread.start();
        try {
            semaphore.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void stop() {
        if (this.readThread == null) {
            return;
        }
        if (this.datagramSocket != null) {
            this.datagramSocket.disconnect();
            this.datagramSocket.close();
            this.datagramSocket = null;
        }
        this.keepRunning = false;
        this.readThread.interrupt();
        this.readThread = null;
    }
}

