/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.sdk.tool.frc;

import com.sun.spot.sdk.tool.frc.RunTaskNetConsole;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class RunTask
extends Task {
    public static final String DEBUG_FILENAME = "/ni-rt/system/SQUAWK_DEBUG_ENABLED";
    protected String remoteaddress;
    protected int otaport = 8001;
    protected boolean debug = false;
    protected StringBuilder lineBuilder;
    protected RunTaskNetConsole netConsole;
    protected String prompt;
    protected boolean outputthreadsinfo;
    protected int syncwithprompttimeout = 10;

    public void execute() throws BuildException {
        if (this.remoteaddress != null && this.remoteaddress.trim().length() == 0) {
            this.remoteaddress = null;
        }
        if (this.remoteaddress == null) {
            throw new BuildException("Must specify remoteaddress");
        }
        if (this.prompt == null) {
            this.prompt = "-> ";
        }
        this.getProject().log((Task)this, "Executing Java program by rebooting cRIO", 3);
        this.executeWithNetConsole();
    }

    public void stopAlreadyRunningNetConsoles() {
        Vector<ThreadGroup> vector = new Vector<ThreadGroup>();
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup().getParent();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        vector.add(threadGroup);
        int n = 0;
        while (!vector.isEmpty()) {
            int n2;
            ThreadGroup[] threadGroupArray;
            int n3;
            ThreadGroup threadGroup2 = (ThreadGroup)vector.remove(0);
            int n4 = threadGroup2.activeCount();
            Thread[] threadArray = new Thread[n4 * 2];
            n4 = threadGroup2.enumerate(threadArray, false);
            for (n3 = 0; n3 < n4; ++n3) {
                threadGroupArray = threadArray[n3];
                ++n;
                if (this.outputthreadsinfo) {
                    this.getProject().log("Thread " + n + ":" + threadGroupArray.getName(), 2);
                    n2 = 0;
                    for (StackTraceElement stackTraceElement : threadGroupArray.getStackTrace()) {
                        this.getProject().log("   stack " + n2 + ":" + stackTraceElement.toString(), 2);
                        ++n2;
                    }
                }
                if (threadGroupArray.getName() == null || !threadGroupArray.getName().equals("NetConsole.readThread")) continue;
                this.getProject().log((Task)this, "Stopping previously running Java NetConsole read thread", 3);
                try {
                    Method method = threadGroupArray.getClass().getMethod("stop", new Class[0]);
                    method.invoke((Object)threadGroupArray, new Object[0]);
                    Thread.sleep(1000L);
                    this.getProject().log((Task)this, "  Stopped", 3);
                    continue;
                }
                catch (SecurityException securityException) {
                    continue;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    continue;
                }
                catch (InvocationTargetException invocationTargetException) {
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            n3 = threadGroup2.activeGroupCount();
            threadGroupArray = new ThreadGroup[n3 * 2];
            n3 = threadGroup2.enumerate(threadGroupArray, false);
            for (n2 = 0; n2 < n3; ++n2) {
                vector.add(threadGroupArray[n2]);
            }
        }
    }

    public void executeWithNetConsole() {
        this.stopAlreadyRunningNetConsoles();
        this.netConsole = new RunTaskNetConsole(this, this.remoteaddress);
        Thread thread = new Thread("netConsoleThread"){

            @Override
            public void run() {
                RunTask.this.netConsole.doConsole();
            }
        };
        this.netConsole.start();
        if (!this.netConsole.keepRunning) {
            return;
        }
        thread.start();
        this.sendRunOtaCommand();
        this.waitRemoteGone();
        this.netConsole.waitForLine(null, "   Waiting for cRIO to reboot");
        if (this.debug) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    RunTask.this.getProject().log((Task)RunTask.this, "Start debug proxy", 2);
                    RunTask.this.startDebugProxy();
                }
            }).start();
            for (int i = 1; i < 10; ++i) {
                try {
                    this.getProject().log((Task)this, "Connect debugger attempt " + i, 2);
                    this.netbeansJpdaConnect();
                    break;
                }
                catch (Throwable throwable) {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
        }
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void startDebugProxy() {
        this.getProject().executeTarget("debug-proxy");
    }

    protected void netbeansJpdaConnect() {
        this.getProject().log((Task)this, "Connecting NetBeans debugger", 2);
        Task task = this.getProject().createTask("nbjpdaconnect");
        if (task == null) {
            this.getProject().log((Task)this, "  could not find nbjpdaconnect task, so assuming not in NetBeans", 2);
            return;
        }
        task.setProject(this.getProject());
        Exception exception = null;
        try {
            Method method = task.getClass().getMethod("setName", String.class);
            method.invoke((Object)task, "NAME");
            method = task.getClass().getMethod("setAddress", String.class);
            method.invoke((Object)task, "2900");
            task.execute();
        }
        catch (SecurityException securityException) {
            exception = securityException;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            exception = noSuchMethodException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exception = illegalArgumentException;
        }
        catch (IllegalAccessException illegalAccessException) {
            exception = illegalAccessException;
        }
        catch (InvocationTargetException invocationTargetException) {
            exception = invocationTargetException;
        }
        if (exception != null) {
            throw new BuildException("Failed to jpda connect", (Throwable)exception);
        }
    }

    public static void delay(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            System.err.println("sdktoolftp RunTask got an InterruptedException");
        }
    }

    public void waitRemoteGone() {
        this.getProject().log((Task)this, "Waiting disconnect from " + this.remoteaddress, 3);
        int n = 0;
        while (true) {
            try {
                Socket socket = new Socket();
                socket.connect(new InetSocketAddress(this.remoteaddress, this.otaport), 250);
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
            catch (IOException iOException) {
                break;
            }
            RunTask.delay(1000);
            if (++n <= 10) continue;
            this.getProject().log((Task)this, "Waiting disconnect from " + this.remoteaddress + " for past " + n + "s", 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRunOtaCommand() {
        Socket socket;
        this.getProject().log((Task)this, "Waiting to connect to OTA command server of " + this.remoteaddress + ":" + this.otaport, 3);
        int n = 0;
        while (true) {
            socket = new Socket();
            try {
                socket.connect(new InetSocketAddress(this.remoteaddress, this.otaport), 1000);
            }
            catch (IOException iOException) {
                RunTask.delay(1000);
                if (++n <= 10) continue;
                this.getProject().log((Task)this, "Waiting to connect to OTA command server of " + this.remoteaddress + ":" + this.otaport + " for past " + n + "s", 2);
                continue;
            }
            break;
        }
        this.getProject().log((Task)this, "Sending " + (this.debug ? "debug" : "run") + " command", 3);
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
            DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
            if (this.debug) {
                dataOutputStream.writeUTF("!DEBUG!");
            } else {
                dataOutputStream.writeUTF("!RUN!");
            }
            dataOutputStream.flush();
            this.getProject().log((Task)this, "Waiting for confirmation", 3);
            String string = dataInputStream.readUTF();
            this.getProject().log((Task)this, "Got confirmation:" + string, 3);
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                socket.close();
            }
            catch (IOException iOException) {}
        }
        this.getProject().log((Task)this, "Sent run command", 3);
    }

    public void setOtaport(int n) {
        this.otaport = n;
    }

    public void setOutputthreadsinfo(boolean bl) {
        this.outputthreadsinfo = bl;
    }

    public void setPrompt(String string) {
        this.prompt = string;
    }

    public void setRemoteaddress(String string) {
        this.remoteaddress = string;
    }

    public void setSyncwithprompttimeout(int n) {
        this.syncwithprompttimeout = n;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }
}

