/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.sdk.tool.frc;

import com.sun.spot.sdk.tool.frc.RunTaskNetConsole;
import com.sun.spot.sdk.tool.frc.streammatching.OneShotStreamMatcher;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.tools.ant.Task;

public class TestNetConsole
extends RunTaskNetConsole {
    private int m_lastLineTimeoutMs = 15000;
    private OneShotStreamMatcher m_testsBeginDetector;
    private OneShotStreamMatcher m_failureDetector = new OneShotStreamMatcher("!!! TEST FAILED");
    private OneShotStreamMatcher m_exceptionDetector = new OneShotStreamMatcher("Exception");
    private OneShotStreamMatcher m_assertionDetector;

    public TestNetConsole(Task task, String string) {
        super(task, string);
        this.m_testsBeginDetector = new OneShotStreamMatcher("!!! TESTS BEGINNING");
        this.m_assertionDetector = new OneShotStreamMatcher("Assertion failed");
    }

    public TestNetConsole(Task task, String string, int n) {
        this(task, string);
        this.m_lastLineTimeoutMs = 1000 * n;
    }

    @Override
    public void echo() {
        long l = System.currentTimeMillis();
        final AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (TestNetConsole.this.keepRunning) {
                    int n = TestNetConsole.this.read();
                    if (n == -1) continue;
                    TestNetConsole.this.m_testsBeginDetector.search((char)n);
                    TestNetConsole.this.m_failureDetector.search((char)n);
                    TestNetConsole.this.m_exceptionDetector.search((char)n);
                    TestNetConsole.this.m_assertionDetector.search((char)n);
                    TestNetConsole.this.log((char)n);
                    atomicBoolean.set(true);
                }
            }
        });
        thread.start();
        while (this.keepRunning && System.currentTimeMillis() - l < (long)this.m_lastLineTimeoutMs) {
            if (atomicBoolean.get()) {
                l = System.currentTimeMillis();
                atomicBoolean.set(false);
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!this.keepRunning) {
            System.out.println("KeepRunning flag no longer true; quitting.");
        }
        this.keepRunning = false;
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (System.currentTimeMillis() - l > (long)this.m_lastLineTimeoutMs) {
            System.out.println("Nothing received for " + this.m_lastLineTimeoutMs / 1000 + " seconds");
        }
        System.out.println("Done.");
    }

    @Override
    public void waitForLine(String string, String string2) {
        this.loggedLineSemaphore.drainPermits();
        int n = 0;
        while (this.keepRunning) {
            try {
                boolean bl = this.loggedLineSemaphore.tryAcquire(1L, TimeUnit.SECONDS);
                if (bl && (string == null || this.lastLine.equals(string))) break;
                this.task.getProject().log(this.task, string2 + " (" + ++n + "s)", 2);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
    }

    @Override
    public void doConsole() {
        if (this.address == null) {
            this.logln("Waiting to receive packets from cRIO to know which address to send to");
            int n = this.read();
            if (n == -1) {
                return;
            }
            this.log((char)n);
        }
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (TestNetConsole.this.keepRunning) {
                        int n = System.in.read();
                        if (n == -1) continue;
                        TestNetConsole.this.write((byte)n);
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        });
        thread.setName("readSystemInThread");
        thread.start();
        this.echo();
    }

    public boolean wasFailureDetected() {
        return this.m_failureDetector.matchFound();
    }

    public boolean wasExceptionDetected() {
        return this.m_exceptionDetector.matchFound();
    }

    public boolean wereTestsRun() {
        return this.m_testsBeginDetector.matchFound();
    }

    public boolean wasAssertionFailureDetected() {
        return this.m_assertionDetector.matchFound();
    }
}

