/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.sdk.tool.frc;

import com.sun.spot.sdk.tool.frc.RunTask;
import com.sun.spot.sdk.tool.frc.TestNetConsole;
import org.apache.tools.ant.BuildException;

public class TestTask
extends RunTask {
    private int m_testNetConsoleLastLineTimeoutSeconds = 15;
    private boolean m_rebootTargetViaOTA = true;

    @Override
    public void executeWithNetConsole() throws BuildException {
        this.stopAlreadyRunningNetConsoles();
        this.netConsole = new TestNetConsole(this, this.remoteaddress, this.m_testNetConsoleLastLineTimeoutSeconds);
        TestNetConsole testNetConsole = (TestNetConsole)this.netConsole;
        Thread thread = new Thread("netConsoleThread"){

            @Override
            public void run() {
                TestTask.this.netConsole.doConsole();
            }
        };
        this.netConsole.start();
        if (!this.netConsole.keepRunning) {
            return;
        }
        thread.start();
        if (this.m_rebootTargetViaOTA) {
            this.sendRunOtaCommand();
            this.waitRemoteGone();
        }
        this.netConsole.waitForLine(null, "   Waiting for cRIO to reboot");
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!testNetConsole.wereTestsRun()) {
            throw new BuildException("Test failed: No test beginning keyword was detected; the tests may not have run. See the console for details.");
        }
        if (testNetConsole.wasFailureDetected()) {
            throw new BuildException("Test failed: A test failure keyword was detected. See the console output for details.");
        }
        if (testNetConsole.wasAssertionFailureDetected()) {
            throw new BuildException("Test failed: An assertion failure message was detected. See the console output for details.");
        }
        if (testNetConsole.wasExceptionDetected()) {
            throw new BuildException("Test failed: An exception stack trace was detected. See the console output for details.");
        }
    }

    public void setLastlinetimeoutseconds(int n) {
        this.m_testNetConsoleLastLineTimeoutSeconds = n;
    }

    public void setReboottarget(boolean bl) {
        this.m_rebootTargetViaOTA = bl;
    }
}

