/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.sdk.tool.ftp;

import com.sun.spot.sdk.tool.ftp.JakartaFtpWrapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Arrays;
import org.apache.commons.net.ftp.FTPConnectionClosedException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class DeployTask
extends Task {
    protected String remoteaddress;
    protected File localfile;
    protected String password;
    protected String remotefilepath;
    protected String userid;

    public void execute() throws BuildException {
        Throwable throwable;
        JakartaFtpWrapper jakartaFtpWrapper = new JakartaFtpWrapper();
        if (this.remoteaddress != null && this.remoteaddress.trim().length() == 0) {
            this.remoteaddress = null;
        }
        if (this.password != null && this.password.trim().length() == 0) {
            this.password = null;
        }
        if (this.remotefilepath != null && this.remotefilepath.trim().length() == 0) {
            this.remotefilepath = null;
        }
        if (this.userid != null && this.userid.trim().length() == 0) {
            this.userid = null;
        }
        if (this.remoteaddress == null) {
            throw new BuildException("Must specify remoteaddress");
        }
        if (this.localfile == null) {
            throw new BuildException("Must specify localfile");
        }
        if (this.remotefilepath == null) {
            throw new BuildException("Must specify remotefilepath");
        }
        if (this.userid == null) {
            this.userid = "";
        }
        if (this.password == null) {
            this.password = "";
        }
        this.getProject().log("FTP " + this.localfile + " to " + this.remoteaddress + ":" + this.remotefilepath, 3);
        FileInputStream fileInputStream = null;
        try {
            jakartaFtpWrapper.connectAndLogin(this.remoteaddress, this.userid, this.password);
            jakartaFtpWrapper.binary();
            byte[] byArray = new byte[(int)this.localfile.length()];
            this.getProject().log((Task)this, "Reading in local file", 3);
            fileInputStream = new FileInputStream(this.localfile);
            for (int i = 0; i < byArray.length; i += fileInputStream.read(byArray, i, byArray.length)) {
            }
            fileInputStream.close();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            this.getProject().log((Task)this, "Sending local file " + this.localfile.getName(), 2);
            boolean bl = jakartaFtpWrapper.storeFile(this.remotefilepath, byteArrayInputStream);
            if (!bl) {
                throw new BuildException("failed to storeFile, ReplyCode: " + jakartaFtpWrapper.getReplyCode());
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
            this.getProject().log((Task)this, "Retrieving remote file to verify sent properly", 3);
            bl = jakartaFtpWrapper.retrieveFile(this.remotefilepath, byteArrayOutputStream);
            if (!bl) {
                throw new BuildException("failed to retrieveFile for verification, ReplyCode: " + jakartaFtpWrapper.getReplyCode());
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            this.getProject().log((Task)this, "Verifying", 3);
            jakartaFtpWrapper.quit();
            boolean bl2 = Arrays.equals(byArray, byArray2);
            if (!bl2) {
                this.getProject().log((Task)this, "Failed verification of " + this.localfile.getName(), 3);
                throw new BuildException("Failed verification of sent file");
            }
            this.getProject().log((Task)this, "Verified", 3);
            return;
        }
        catch (UnknownHostException unknownHostException) {
            throwable = unknownHostException;
        }
        catch (FTPConnectionClosedException fTPConnectionClosedException) {
            throwable = fTPConnectionClosedException;
        }
        catch (IOException iOException) {
            throwable = iOException;
        }
        throw new BuildException(throwable);
    }

    public void setLocalfile(File file) {
        this.localfile = file;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setRemoteaddress(String string) {
        this.remoteaddress = string;
    }

    public void setRemotefilepath(String string) {
        this.remotefilepath = string;
    }

    public void setUserid(String string) {
        this.userid = string;
    }
}

