/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.sdk.tool.ftp;

import com.sun.spot.sdk.tool.ftp.JakartaFtpWrapper;
import com.sun.spot.sdk.tool.ftp.UpgradeVersionInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.apache.commons.net.ftp.FTPConnectionClosedException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class UpgradeTask
extends Task {
    protected String remoteaddress;
    protected File localsuitefile;
    protected File localvmfile;
    protected File localotaserverfile;
    protected String password;
    protected String remotesuitefilepath;
    protected String remoteversionfilepath;
    protected String remotevmfilepath;
    protected String remoteotaserverfilepath;
    protected String userid;
    protected boolean force;
    protected JakartaFtpWrapper ftpClient;
    protected ArrayList<UpgradeVersionInfo> versionInfos = new ArrayList();
    protected String versionfailuremessage;

    public void addConfiguredVersion(UpgradeVersionInfo upgradeVersionInfo) {
        this.versionInfos.add(upgradeVersionInfo);
    }

    protected void checkVersion(String string, String string2) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        this.getProject().log((Task)this, "Checking version info from " + string, 3);
        try {
            boolean bl = this.ftpClient.retrieveFile(string, byteArrayOutputStream);
            if (bl) {
                byte[] byArray = byteArrayOutputStream.toByteArray();
                Properties properties = new Properties();
                properties.load(new ByteArrayInputStream(byArray));
                for (UpgradeVersionInfo upgradeVersionInfo : this.versionInfos) {
                    String string3 = properties.getProperty(upgradeVersionInfo.getName());
                    if (string3 == null) {
                        throw new BuildException("Version info retrieved did not specify " + upgradeVersionInfo.getName() + ". " + (this.versionfailuremessage == null ? "" : this.versionfailuremessage));
                    }
                    if (!string3.equals(upgradeVersionInfo.getValue())) {
                        throw new BuildException("Expected version " + upgradeVersionInfo.getValue() + " for " + upgradeVersionInfo.getName() + " but got " + string3 + ". " + (this.versionfailuremessage == null ? "" : this.versionfailuremessage));
                    }
                    this.getProject().log((Task)this, "  Checked " + upgradeVersionInfo.getName() + "=" + string3, 3);
                }
            } else {
                this.getProject().log((Task)this, "  remote " + string + " does not exist", 3);
            }
        }
        catch (IOException iOException) {
            throw new BuildException((Throwable)iOException);
        }
    }

    static int prefixToNetMask(int n) {
        return Integer.MIN_VALUE >> n - 1;
    }

    static String ipToString(int n) {
        StringBuffer stringBuffer = new StringBuffer(15);
        for (int i = 0; i < 4; ++i) {
            int n2 = n >>> 24;
            stringBuffer.append(n2);
            if (i != 3) {
                stringBuffer.append('.');
            }
            n <<= 8;
        }
        return stringBuffer.toString();
    }

    static boolean matchingSubnets(int n, int n2, int n3) {
        return (n & n3) == (n2 & n3);
    }

    static int inetAddressToInt(Inet4Address inet4Address) {
        byte[] byArray = inet4Address.getAddress();
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            n = n << 8 | byArray[i];
        }
        return n;
    }

    static boolean matchingSubnets(Inet4Address inet4Address, Inet4Address inet4Address2, int n) {
        return UpgradeTask.matchingSubnets(UpgradeTask.inetAddressToInt(inet4Address), UpgradeTask.inetAddressToInt(inet4Address2), n);
    }

    public void sanityCheckIP() {
        String string = System.getProperty("os.name") + " " + System.getProperty("os.version") + ", " + System.getProperty("os.version");
        String string2 = System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version");
        this.getProject().log("Host OS: " + string, 2);
        this.getProject().log("Host JVM: " + string2, 2);
        try {
            int n;
            InetAddress inetAddress = InetAddress.getByName(this.remoteaddress);
            if (!(inetAddress instanceof Inet4Address)) {
                System.err.println("sanityCheckIP can't handle IPv6 robot addresses. Skipping check.");
            }
            Inet4Address inet4Address = (Inet4Address)inetAddress;
            byte[] byArray = inet4Address.getAddress();
            int n2 = 0;
            for (n = 0; n < 4; ++n) {
                n2 = n2 << 8 | byArray[n];
            }
            n = 0;
            boolean bl = false;
            this.getProject().log("Target IP: " + UpgradeTask.ipToString(n2), 2);
            this.getProject().log("Network interfaces on host:", 2);
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                if (!networkInterface.isUp() || networkInterface.isLoopback()) continue;
                StringBuffer stringBuffer = new StringBuffer("    ").append(networkInterface.getDisplayName()).append(": ");
                List<InterfaceAddress> list = networkInterface.getInterfaceAddresses();
                boolean bl2 = false;
                for (InterfaceAddress interfaceAddress : list) {
                    InetAddress inetAddress2 = interfaceAddress.getAddress();
                    if (!(inetAddress2 instanceof Inet4Address)) continue;
                    if (bl2) {
                        stringBuffer.append(", ");
                    }
                    bl2 = true;
                    stringBuffer.append(" address: ").append(inetAddress2.getHostAddress());
                    if (interfaceAddress.getNetworkPrefixLength() == 128) {
                        bl = true;
                        stringBuffer.append(" netmask: 255.255.255.255 or hidden by IPv6 address (due to Java on Windows Bug:6707289)");
                        continue;
                    }
                    int n3 = UpgradeTask.prefixToNetMask(interfaceAddress.getNetworkPrefixLength());
                    stringBuffer.append(" netmask: ").append(UpgradeTask.ipToString(n3));
                    if (!UpgradeTask.matchingSubnets(inet4Address, (Inet4Address)inetAddress2, n3)) continue;
                    stringBuffer.append(" <--- on robot's subnet");
                    n = 1;
                }
                if (!bl2) continue;
                this.getProject().log(stringBuffer.toString(), 2);
            }
            if (n == 0 && !bl) {
                this.getProject().log("WARNING: Host is not on same subnet as robot. May not be able to complete all communication with robot.", 1);
            }
        }
        catch (SocketException socketException) {
            System.err.println("Error enumerating network interfaces: " + socketException);
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
        }
    }

    public void execute() throws BuildException {
        Throwable throwable;
        this.ftpClient = new JakartaFtpWrapper();
        if (this.remoteaddress != null && this.remoteaddress.trim().length() == 0) {
            this.remoteaddress = null;
        }
        if (this.password != null && this.password.trim().length() == 0) {
            this.password = null;
        }
        if (this.remoteversionfilepath != null && this.remoteversionfilepath.trim().length() == 0) {
            this.remoteversionfilepath = null;
        }
        if (this.remotevmfilepath != null && this.remotevmfilepath.trim().length() == 0) {
            this.remotevmfilepath = null;
        }
        if (this.remoteotaserverfilepath != null && this.remoteotaserverfilepath.trim().length() == 0) {
            this.remoteotaserverfilepath = null;
        }
        if (this.userid != null && this.userid.trim().length() == 0) {
            this.userid = null;
        }
        if (this.remoteaddress == null) {
            throw new BuildException("Must specify remoteaddress");
        }
        if (this.localsuitefile == null) {
            throw new BuildException("Must specify localsuitefile");
        }
        if (this.remotesuitefilepath == null) {
            throw new BuildException("Must specify remotesuitefilepath");
        }
        if (this.localvmfile == null) {
            throw new BuildException("Must specify localvmfile");
        }
        if (this.remotevmfilepath == null) {
            throw new BuildException("Must specify remotevmfilepath");
        }
        if (this.localotaserverfile == null) {
            throw new BuildException("Must specify localotaserverfile");
        }
        if (this.remoteotaserverfilepath == null) {
            throw new BuildException("Must specify remoteotaserverfilepath");
        }
        if (this.remoteversionfilepath == null) {
            throw new BuildException("Must specify remoteversionfilepath");
        }
        if (this.userid == null) {
            this.userid = "";
        }
        if (this.password == null) {
            this.password = "";
        }
        try {
            this.sanityCheckIP();
            this.getProject().log((Task)this, "Connecting FTP " + this.userid + "@" + this.remoteaddress, 2);
            this.ftpClient.connectAndLogin(this.remoteaddress, this.userid, this.password);
            this.ftpClient.binary();
            this.checkVersion(this.remoteversionfilepath, null);
            if (this.upgrade("OTA server", this.localotaserverfile, this.remoteotaserverfilepath)) {
                this.getProject().log((Task)this, "Upgraded OTA server. You may need to reboot cRIO manually", 1);
            }
            this.upgrade("VM", this.localvmfile, this.remotevmfilepath);
            this.upgrade("Java suite", this.localsuitefile, this.remotesuitefilepath);
            this.ftpClient.quit();
            return;
        }
        catch (UnknownHostException unknownHostException) {
            throwable = unknownHostException;
        }
        catch (FTPConnectionClosedException fTPConnectionClosedException) {
            throwable = fTPConnectionClosedException;
        }
        catch (IOException iOException) {
            throwable = iOException;
        }
        throw new BuildException(throwable);
    }

    public void setForce(boolean bl) {
        this.force = bl;
    }

    public void setLocalsuitefile(File file) {
        this.localsuitefile = file;
    }

    public void setLocalvmfile(File file) {
        this.localvmfile = file;
    }

    public void setLocalotaserverfile(File file) {
        this.localotaserverfile = file;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setRemoteaddress(String string) {
        this.remoteaddress = string;
    }

    public void setRemotesuitefilepath(String string) {
        this.remotesuitefilepath = string;
    }

    public void setRemoteversionfilepath(String string) {
        this.remoteversionfilepath = string;
    }

    public void setRemotevmfilepath(String string) {
        this.remotevmfilepath = string;
    }

    public void setUserid(String string) {
        this.userid = string;
    }

    public void setRemoteotaserverfilepath(String string) {
        this.remoteotaserverfilepath = string;
    }

    public void setVersionfailuremessage(String string) {
        this.versionfailuremessage = string;
    }

    public boolean upgrade(String string, File file, String string2) throws IOException {
        Object object;
        byte[] byArray = new byte[(int)file.length()];
        this.getProject().log((Task)this, "Reading in local " + string + ":" + file, 3);
        FileInputStream fileInputStream = new FileInputStream(file);
        for (int i = 0; i < byArray.length; i += fileInputStream.read(byArray, i, byArray.length)) {
        }
        fileInputStream.close();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
        this.getProject().log((Task)this, "Retrieving " + string + ":" + string2 + " to verify", 3);
        boolean bl = this.ftpClient.retrieveFile(string2, byteArrayOutputStream);
        if (bl) {
            object = byteArrayOutputStream.toByteArray();
            this.getProject().log((Task)this, "Verifying", 3);
            boolean bl2 = Arrays.equals(byArray, object);
            if (bl2) {
                this.getProject().log((Task)this, "Remote " + string + " matches local, no upgrade needed", 3);
                return false;
            }
        } else {
            this.getProject().log((Task)this, "  remote " + string + " does not exist", 3);
        }
        this.getProject().log((Task)this, "Remote " + string + " does not match, upgrading", 2);
        object = new ByteArrayInputStream(byArray);
        this.getProject().log((Task)this, "Sending local file", 3);
        bl = this.ftpClient.storeFile(string2, (InputStream)object);
        if (!bl) {
            throw new BuildException("failed to storeFile");
        }
        this.getProject().log((Task)this, "Upgraded remote " + string, 3);
        return true;
    }
}

