/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk;

import com.sun.squawk.VM;
import com.sun.squawk.vm.Mnemonics;
import com.sun.squawk.vm.OPC;

public abstract class BytecodeTracer {
    protected abstract int getCurrentPosition();

    protected abstract void print(String var1);

    private void print(int opcode, String str) {
        this.print(Mnemonics.getMnemonic(opcode) + " " + str);
    }

    private void print(int opcode) {
        this.print(opcode, "");
    }

    protected abstract int getByte();

    protected String getObjectDetails(int index) {
        return null;
    }

    protected String getVarDetails(int index, boolean param) {
        return null;
    }

    int getUnsignedByte() {
        return this.getByte() & 0xFF;
    }

    int getChar() {
        int ch1 = this.getUnsignedByte();
        int ch2 = this.getUnsignedByte();
        if (VM.isBigEndian()) {
            return (ch1 << 8) + (ch2 << 0);
        }
        return (ch2 << 8) + (ch1 << 0);
    }

    int getShort() {
        return (short)this.getChar();
    }

    int getInt() {
        int ch1 = this.getUnsignedByte();
        int ch2 = this.getUnsignedByte();
        int ch3 = this.getUnsignedByte();
        int ch4 = this.getUnsignedByte();
        if (VM.isBigEndian()) {
            return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
        }
        return (ch4 << 24) + (ch3 << 16) + (ch2 << 8) + (ch1 << 0);
    }

    long getLong() {
        if (VM.isBigEndian()) {
            return ((long)this.getInt() << 32) + ((long)this.getInt() & 0xFFFFFFFFL);
        }
        return ((long)this.getInt() & 0xFFFFFFFFL) + (long)this.getInt() << 32;
    }

    float getFloat() {
        return Float.intBitsToFloat(this.getInt());
    }

    double getDouble() {
        return Double.longBitsToDouble(this.getLong());
    }

    protected void traceByteCode() {
        int opcode = this.getUnsignedByte();
        switch (opcode) {
            default: {
                this.do_normal(opcode);
                return;
            }
            case 77: {
                this.print(opcode);
                this.do_normal(this.getUnsignedByte() + 256);
                return;
            }
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: {
                this.print(opcode);
                this.do_wide(opcode, this.getUnsignedByte());
                return;
            }
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                this.print(opcode);
                this.do_wide(opcode, this.getUnsignedByte() + 256);
                return;
            }
            case 193: {
                this.do_switch(opcode, 4);
                return;
            }
            case 194: 
        }
        this.do_switch(opcode, 2);
    }

    private boolean do_const(int opcode) {
        switch (opcode) {
            case 85: {
                this.print(opcode);
                break;
            }
            case 86: {
                this.print(opcode, "" + this.getByte());
                break;
            }
            case 87: {
                this.print(opcode, "" + this.getShort());
                break;
            }
            case 88: {
                this.print(opcode, "" + this.getChar());
                break;
            }
            case 89: {
                this.print(opcode, "" + this.getInt());
                break;
            }
            case 90: {
                this.print(opcode, "" + this.getLong());
                break;
            }
            case 382: {
                this.print(opcode, "" + this.getFloat());
                break;
            }
            case 383: {
                this.print(opcode, "" + this.getDouble());
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private boolean do_load_store(int opcode) {
        switch (opcode) {
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                int index = opcode & 0xF;
                String var = this.getVarDetails(index, false);
                if (var == null) {
                    var = "";
                }
                this.print(opcode, var);
                break;
            }
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 100: 
            case 101: {
                int index = this.getByte();
                String var = this.getVarDetails(index, false);
                if (var == null) {
                    var = String.valueOf(index);
                }
                this.print(opcode, var);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private boolean do_load_store_parm(int opcode) {
        switch (opcode) {
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: {
                int index = opcode & 7;
                String var = this.getVarDetails(index, true);
                if (var == null) {
                    var = "";
                }
                this.print(opcode, var);
                break;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 102: 
            case 103: {
                int index = this.getByte();
                String var = this.getVarDetails(index, true);
                if (var == null) {
                    var = String.valueOf(index);
                }
                this.print(opcode, var);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private boolean do_object(int opcode) {
        switch (opcode) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                int index = opcode & 0xF;
                String obj = this.getObjectDetails(index);
                if (obj == null) {
                    obj = "";
                }
                this.print(opcode, obj);
                break;
            }
            case 91: {
                int index = this.getByte();
                String obj = this.getObjectDetails(index);
                if (obj == null) {
                    obj = "";
                }
                this.print(opcode, obj);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void do_normal(int opcode) {
        if (this.do_const(opcode) || this.do_object(opcode) || this.do_load_store(opcode) || this.do_load_store_parm(opcode)) {
            return;
        }
        if (this.isBranch(opcode)) {
            this.print(opcode, "(" + (this.getByte() + this.getCurrentPosition()) + ")");
        } else if (this.hasWide(opcode)) {
            this.print(opcode, "" + this.getUnsignedByte());
        } else {
            this.print(opcode);
        }
    }

    private void do_wide(int widecode, int opcode) {
        int val = 0;
        switch (widecode) {
            case 72: 
            case 78: {
                val = -256 + this.getUnsignedByte();
                break;
            }
            case 73: 
            case 79: {
                val = this.getUnsignedByte();
                break;
            }
            case 74: 
            case 80: {
                val = 256 + this.getUnsignedByte();
                break;
            }
            case 75: 
            case 81: {
                val = this.getShort();
                break;
            }
            case 76: 
            case 82: {
                val = this.getInt();
            }
        }
        if (this.isBranch(opcode)) {
            this.print(opcode, "(" + (val + this.getCurrentPosition()) + ")");
        } else {
            this.print(opcode, "" + val);
        }
    }

    private int getSwitchEntry(int size) {
        if (size == 2) {
            return this.getShort();
        }
        return this.getInt();
    }

    private void do_switch(int opcode, int size) {
        this.print(opcode);
        while (this.getCurrentPosition() % size != 0) {
            this.print("    pad  = " + this.getUnsignedByte());
        }
        int low = this.getSwitchEntry(size);
        this.print("    low  = " + low);
        int high = this.getSwitchEntry(size);
        this.print("    high = " + high);
        int loc = this.getSwitchEntry(size);
        int pos = this.getCurrentPosition();
        this.print("    def  = (" + (loc + pos) + ")");
        for (int i = low; i <= high; ++i) {
            loc = this.getSwitchEntry(size);
            this.print("    [" + i + "] = (" + (loc + pos) + ")");
        }
    }

    boolean hasWide(int opcode) {
        return OPC.hasWide((int)opcode);
    }

    boolean isBranch(int opcode) {
        switch (opcode) {
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: {
                return true;
            }
        }
        return false;
    }
}

