/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk;

import com.sun.squawk.Klass;
import com.sun.squawk.io.connections.ClasspathConnection;
import com.sun.squawk.util.LineReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Vector;
import javax.microedition.io.Connector;

public class ClassSourcePrinter {
    private Vector lines;

    public ClassSourcePrinter(Klass klass, String sourcePath) throws IOException {
        String filename = klass.getSourceFilePath();
        if (filename == null) {
            throw new IOException(klass + " has no record of it's source file name.");
        }
        ClasspathConnection sourcepath = (ClasspathConnection)Connector.open((String)("classpath://" + sourcePath));
        InputStream is = sourcepath.openInputStream(filename);
        InputStreamReader isr = new InputStreamReader(is);
        LineReader lr = new LineReader((Reader)isr);
        this.lines = lr.readLines(null);
        is.close();
        sourcepath.close();
    }

    public String getLine(int lineNo) {
        return (String)this.lines.elementAt(lineNo);
    }

    public int numLines() {
        return this.lines.size();
    }

    public static void main(String[] args) {
        String className = args[0];
        String sourcepath = args[1];
        int lineNo = -1;
        if (args.length > 2) {
            lineNo = Integer.parseInt(args[2]);
        }
        try {
            System.err.println("Looking for klass " + className);
            Klass klass = Klass.getClass((String)className, (boolean)false);
            System.err.println("Found " + klass + " searching for source in " + sourcepath);
            ClassSourcePrinter csp = new ClassSourcePrinter(klass, sourcepath);
            if (lineNo == -1) {
                for (int i = 0; i < csp.numLines(); ++i) {
                    System.out.print("Line " + i + ": ");
                    System.out.println(csp.getLine(i));
                }
            } else {
                System.out.print("Line " + lineNo + ": ");
                System.out.println(csp.getLine(lineNo));
            }
        }
        catch (IOException e) {
            System.err.println(e);
            e.printStackTrace();
        }
    }
}

