/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk;

import com.sun.squawk.BytecodeTracer;
import com.sun.squawk.ClassSourcePrinter;
import com.sun.squawk.ExceptionHandler;
import com.sun.squawk.Klass;
import com.sun.squawk.Method;
import com.sun.squawk.MethodBody;
import com.sun.squawk.ScopedLocalVariable;
import com.sun.squawk.translator.ci.CodeParser;
import com.sun.squawk.util.Tracer;
import java.io.PrintStream;

public class MethodBodyTracer
extends BytecodeTracer {
    private PrintStream ps = Tracer.getPrintStream();
    private StringBuffer out;
    private MethodBody body;
    private byte[] code;
    private int[] emptyOffsets;
    private int[] lnt;
    private ScopedLocalVariable[] lvt;
    private String srcFile;
    private String srcPath;
    private ClassSourcePrinter printer;
    private int lastPosition = 0;
    private int currentPosition = 0;

    private final void init() {
        this.code = this.body.getCode();
        this.emptyOffsets = CodeParser.getEmptyStackOffsets(this.code);
        Method method = this.body.getDefiningMethod();
        if (method != null) {
            this.lnt = method.getLineNumberTable();
            this.lvt = method.getLocalVariableTable();
            this.srcFile = method.getDefiningClass().getSourceFileName();
            this.srcPath = method.getDefiningClass().getSourceFilePath();
        }
    }

    public MethodBodyTracer(MethodBody body, ClassSourcePrinter printer) {
        this.body = body;
        this.printer = printer;
        this.init();
    }

    public MethodBodyTracer(MethodBody body) {
        this.body = body;
        this.printer = null;
        this.init();
    }

    public void traceAll() {
        this.traceHeader();
        this.traceBody();
    }

    private void traceTypes(Klass[] types, int from, int to) {
        for (int i = from; i <= to; ++i) {
            this.ps.print(" " + types[i].getName());
        }
    }

    private void traceOops(Klass[] types, int from, int to) {
        for (int i = from; i <= to; ++i) {
            this.ps.print(" " + (types[i].isReferenceType() ? "1" : "0"));
        }
    }

    public void traceHeader() {
        ExceptionHandler[] exceptionTable;
        Klass[] types = this.body.getTypes();
        int parameterCount = this.body.getParametersCount();
        int localCount = types.length - parameterCount;
        this.ps.println("Stack    = " + this.body.getMaxStack());
        if (parameterCount > 0) {
            this.ps.print("Parms    = {");
            this.traceTypes(types, 0, parameterCount - 1);
            this.ps.println(" }");
        }
        if (localCount > 0) {
            this.ps.print("Locals   = {");
            this.traceTypes(types, parameterCount, types.length - 1);
            this.ps.println(" }");
        }
        if (localCount > 0) {
            this.ps.print("Oops     = {");
            this.traceOops(types, parameterCount, types.length - 1);
            this.ps.println(" }");
        }
        if ((exceptionTable = this.body.getExceptionTable()) != null && exceptionTable.length > 0) {
            this.ps.print("Handlers = { ");
            for (int i = 0; i < exceptionTable.length; ++i) {
                if (i > 0) {
                    this.ps.print("\n             ");
                }
                ExceptionHandler handler = exceptionTable[i];
                this.ps.print("" + handler.getStart() + "," + handler.getEnd() + "->" + handler.getHandler() + " " + handler.getKlass().getName());
            }
            this.ps.println(" }");
        }
        if (this.body.getDefiningMethod().isInterpreterInvoked()) {
            this.ps.println("Interpreter Invoked = TRUE");
        }
        if (this.printer != null) {
            this.ps.print("File     = ");
            this.ps.println(this.srcPath);
        }
    }

    private void traceBody() {
        this.out = new StringBuffer(1024);
        while (this.currentPosition < this.code.length) {
            int lineNo;
            if (this.printer != null && (lineNo = MethodBodyTracer.getLineNumber(this.lnt, this.currentPosition)) > 0) {
                this.out.append("  Line ");
                this.out.append(lineNo + ": ");
                this.out.append(this.printer.getLine(lineNo - 1));
                this.out.append('\n');
            }
            this.traceByteCode();
        }
        this.ps.println(this.out);
    }

    public String traceUntil(int pos) {
        this.out = new StringBuffer(32);
        if (pos == -1) {
            pos = this.code.length;
        }
        while (this.currentPosition < pos) {
            this.traceByteCode();
        }
        if (this.out.length() > 0) {
            this.out.deleteCharAt(this.out.length() - 1);
        }
        return this.out.toString();
    }

    @Override
    protected void print(String str) {
        String s = "" + this.lastPosition + ":";
        while (s.length() < 5) {
            s = s + " ";
        }
        s = s + " " + str;
        while (s.length() < 30) {
            s = s + " ";
        }
        this.out.append(s);
        this.printCommentary(this.lastPosition);
        this.out.append('\n');
        this.lastPosition = this.currentPosition;
    }

    static int getLineNumber(int[] lnt, int bci) {
        if (lnt != null) {
            for (int i = 0; i < lnt.length; ++i) {
                int entry = lnt[i];
                int addr = entry >>> 16;
                if (addr != bci) continue;
                return entry & 0xFFFF;
            }
        }
        return -1;
    }

    void printCommentary(int bci) {
        int lineNo;
        boolean didLineNo = false;
        if (this.printer == null && (lineNo = MethodBodyTracer.getLineNumber(this.lnt, bci)) != -1) {
            this.out.append("// " + this.srcFile + ":" + lineNo);
            didLineNo = true;
        }
        boolean isStackEmpty = false;
        for (int i = 0; i < this.emptyOffsets.length; ++i) {
            if (bci != this.emptyOffsets[i]) continue;
            isStackEmpty = true;
            break;
        }
        if (isStackEmpty) {
            if (didLineNo) {
                this.out.append(", [_|_]");
            } else {
                this.out.append("// [_|_]");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected String getObjectDetails(int index) {
        Klass klass = this.body.getDefiningMethod().getDefiningClass();
        if (klass == null) return null;
        if (klass == Klass.OBJECT) return null;
        if (klass.getState() != 4) return null;
        Object object = klass.getObject(index);
        Object obj = object;
        if (obj != null) return obj.toString();
        return null;
    }

    static ScopedLocalVariable findLocalVariable(ScopedLocalVariable[] lvt, int bci, int index) {
        if (lvt != null) {
            for (int i = 0; i < lvt.length; ++i) {
                ScopedLocalVariable slv = lvt[i];
                if (index != slv.slot || bci < slv.start || bci >= slv.start + slv.length) continue;
                return slv;
            }
        }
        return null;
    }

    @Override
    protected String getVarDetails(int index, boolean param) {
        ScopedLocalVariable slv = MethodBodyTracer.findLocalVariable(this.lvt, this.currentPosition, param ? index : index + this.body.getParametersCount());
        if (slv != null) {
            return slv.name;
        }
        return super.getVarDetails(index, param);
    }

    @Override
    protected int getByte() {
        return this.code[this.currentPosition++];
    }

    @Override
    protected int getCurrentPosition() {
        return this.currentPosition;
    }
}

