/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.io.j2me.classpath;

import com.sun.squawk.VM;
import com.sun.squawk.io.ConnectionBase;
import com.sun.squawk.io.connections.ClasspathConnection;
import com.sun.squawk.util.Assert;
import com.sun.squawk.util.StringTokenizer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.io.Connection;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.Connector;

public class Protocol
extends ConnectionBase
implements ClasspathConnection {
    public static final String sepch;
    private static final boolean MULTIPLEINSTANCESCHECK = false;
    private Vector classPathArray = new Vector();

    public Connection open(String protocol, String name, int mode, boolean timeouts) throws IOException {
        if (name.charAt(0) != '/' || name.charAt(1) != '/') {
            throw new IllegalArgumentException("Protocol must start with \"//\" " + name);
        }
        String path = name.substring(2);
        StringTokenizer st = new StringTokenizer(path, sepch);
        while (st.hasMoreTokens()) {
            String dirName = st.nextToken();
            if (dirName.endsWith("\\") || dirName.endsWith("/")) {
                dirName = dirName.substring(0, dirName.length() - 1);
            }
            this.classPathArray.addElement(dirName);
        }
        return this;
    }

    public InputStream openInputStream(String fileName) throws IOException {
        if (fileName.endsWith("/")) {
            return this.lookupRequest(fileName);
        }
        InputStream is = null;
        for (int i = this.classPathArray.size() - 1; i >= 0; --i) {
            DataInputStream _is;
            String classPathEntry = (String)this.classPathArray.elementAt(i);
            if (classPathEntry.endsWith(".zip") || classPathEntry.endsWith(".jar")) {
                try {
                    _is = Connector.openDataInputStream((String)("zip://" + classPathEntry + "@" + fileName));
                    if (is == null) {
                        return _is;
                    }
                    ((InputStream)_is).close();
                    if (!fileName.endsWith(".class")) continue;
                    System.err.println("Warning: multiple instances of " + fileName + " in class path may cause linkage errors");
                }
                catch (ConnectionNotFoundException e) {}
                continue;
            }
            try {
                _is = Connector.openDataInputStream((String)("file://" + classPathEntry + "/" + fileName));
                if (is == null) {
                    return _is;
                }
                ((InputStream)_is).close();
                if (!fileName.endsWith(".class")) continue;
                System.err.println("Warning: multiple instances of " + fileName + " on class path may cause linkage errors");
                continue;
            }
            catch (ConnectionNotFoundException e) {
                // empty catch block
            }
        }
        if (is == null) {
            throw new ConnectionNotFoundException(fileName);
        }
        return is;
    }

    public InputStream lookupRequest(String fileName) throws IOException {
        Hashtable<String, String> table = new Hashtable<String, String>();
        for (int i = 0; i < this.classPathArray.size(); ++i) {
            String prefix;
            DataInputStream is = null;
            String classPathEntry = (String)this.classPathArray.elementAt(i);
            if (classPathEntry.endsWith(".zip") || classPathEntry.endsWith(".jar")) {
                prefix = null;
                try {
                    is = Connector.openDataInputStream((String)("zip://" + classPathEntry + "@" + fileName));
                }
                catch (ConnectionNotFoundException ex) {}
            } else {
                prefix = classPathEntry.replace('\\', '/') + '/';
                try {
                    is = Connector.openDataInputStream((String)("file://" + classPathEntry + "/" + fileName));
                }
                catch (ConnectionNotFoundException ex) {
                    // empty catch block
                }
            }
            if (is == null) continue;
            try {
                while (true) {
                    String str = is.readUTF();
                    if (prefix != null && str.startsWith(prefix)) {
                        str = str.substring(prefix.length());
                    }
                    if (table.get(str) != null) continue;
                    table.put(str, str);
                }
            }
            catch (EOFException ex) {
                is.close();
            }
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        Enumeration e = table.keys();
        while (e.hasMoreElements()) {
            String str = (String)e.nextElement();
            dos.writeUTF(str);
        }
        dos.close();
        return new ByteArrayInputStream(baos.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(String name) throws IOException {
        DataInputStream input = null;
        try {
            input = new DataInputStream(this.openInputStream(name));
            int available = input.available();
            byte[] bytes = new byte[available];
            input.readFully(bytes);
            Assert.that((input.available() == 0 ? 1 : 0) != 0);
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e1) {}
            }
        }
    }

    static {
        String sep = System.getProperty("path.separator");
        sepch = sep != null ? sep : "" + VM.getPathSeparatorChar();
    }
}

