/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.translator;

import com.sun.squawk.VM;
import com.sun.squawk.util.Assert;
import com.sun.squawk.util.Tracer;
import java.io.PrintStream;

public final class Arg {
    private static final char BOOLEAN = 'B';
    private static final char INT = 'I';
    private String name;
    private char type;
    private String defaultValue;
    private String usageMsg;
    private int intValue;
    private boolean boolValue;
    public static final int HELP = 0;
    public static final int OPTIMIZE_CONSTANT_OBJECTS = 1;
    public static final int DEAD_METHOD_ELIMINATION = 2;
    public static final int DELETE_UNUSED_PRIVATE_CONSTRUCTORS = 3;
    public static final int PRINT_STATS = 4;
    public static final int VERBOSE = 5;
    public static final int DEAD_STRING_ELIMINATION = 6;
    public static final int DEAD_CLASS_ELIMINATION = 7;
    public static final int LAST_ARG = 7;
    static final Arg[] translatorArgs = new Arg[8];

    Arg(String name, char type, String defaultValue, String usageMsg) {
        this.name = name;
        this.type = type;
        this.defaultValue = defaultValue;
        this.usageMsg = usageMsg;
    }

    public void setValue() {
        String result = System.getProperty(this.getPropertyName());
        if (this.type == 'I') {
            this.intValue = this.parseInt(result);
        } else {
            this.boolValue = this.parseBool(result);
        }
    }

    public int getInt() {
        Assert.that((this.type == 'I' ? 1 : 0) != 0);
        return this.intValue;
    }

    public boolean getBool() {
        Assert.that((this.type == 'B' ? 1 : 0) != 0);
        return this.boolValue;
    }

    void setBoolValue(boolean val) {
        this.boolValue = val;
    }

    public String getPropertyName() {
        return "translator." + this.name;
    }

    public String getOptionName() {
        return "-" + this.name + ":";
    }

    private int parseInt(String result) {
        if (result != null) {
            try {
                return Integer.parseInt(result);
            }
            catch (NumberFormatException e) {
                System.err.println("Illformed integer value " + result + " for translator property " + this.name + ". Using default value " + this.defaultValue);
            }
        }
        try {
            return Integer.parseInt(this.defaultValue);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(e.toString());
        }
    }

    private boolean parseBool(String result) {
        if (result != null) {
            if ((result = result.toLowerCase()).equals("true")) {
                return true;
            }
            if (result.equals("false")) {
                return false;
            }
            System.err.println("Illformed boolean value " + result + " for translator property " + this.name + ". Using default value " + this.defaultValue);
        }
        return this.parseBool(this.defaultValue);
    }

    public char getType() {
        return this.type;
    }

    public void printOne(PrintStream out, boolean asParameters) {
        out.print("    -");
        if (!asParameters) {
            out.print("Dtranslator.");
        }
        out.print(this.name);
        if (asParameters) {
            out.print(":");
        } else {
            out.print("=");
        }
        out.print(this.usageMsg);
        if (this.type == 'I') {
            out.println(" Default value is " + this.defaultValue + ".");
        } else {
            out.println("\n                          <bool> must be true or false. Default value is " + this.defaultValue + ".");
        }
    }

    public static Arg get(int index) {
        return translatorArgs[index];
    }

    private static void initArg(int index, String name, char type, String defaultValue, String usageMsg) {
        Arg.translatorArgs[index] = new Arg(name, type, defaultValue, usageMsg);
    }

    static void defineOptions() {
        Arg.initArg(0, "help", 'B', "false", "Display the final state of the translator options.");
        Arg.initArg(1, "optimizeConstantObjects", 'B', "true", "<bool> Reorder class objects to allow small indexes for common objects.");
        Arg.initArg(2, "deadMethodElimination", 'B', "true", "<bool> Remove uncalled (and uncallable) methods.");
        Arg.initArg(3, "deleteUnusedPrivateConstructors", 'B', "true", "<bool> Remove uncalled private constructors. This will disable Class.newInstance() if deleted.");
        Arg.initArg(4, "stats", 'B', "false", "<bool> Print translator statistics.");
        Arg.initArg(5, "verbose", 'B', "false", "<bool> Print translator actions.");
        Arg.initArg(6, "deadStringElimination", 'B', "true", "<bool> Remove unused string constants.");
        Arg.initArg(7, "deadClassElimination", 'B', "false", "<bool> Remove unused classes.");
    }

    static void setOptions() {
        for (int i = 0; i < translatorArgs.length; ++i) {
            translatorArgs[i].setValue();
        }
        Arg verbose = Arg.get(5);
        verbose.setBoolValue(verbose.getBool() | VM.isVerbose() | VM.isVeryVerbose() | Tracer.isTracing((String)"converting"));
        if (Arg.get(0).getBool() || verbose.getBool()) {
            System.out.println("Translator properties and current values:");
            for (int i = 0; i < translatorArgs.length; ++i) {
                Arg arg = translatorArgs[i];
                System.out.print("    ");
                System.out.print(arg.getPropertyName());
                System.out.print("=");
                if (arg.getType() == 'I') {
                    System.out.println(arg.getInt());
                    continue;
                }
                System.out.println(arg.getBool());
            }
        }
    }
}

