/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.translator;

import com.sun.squawk.Klass;
import com.sun.squawk.Method;
import com.sun.squawk.translator.Arg;
import com.sun.squawk.translator.Code;
import com.sun.squawk.translator.ObjectCounter;
import com.sun.squawk.translator.Translator;
import com.sun.squawk.translator.ci.ConstantPool;
import com.sun.squawk.util.ArrayHashtable;
import com.sun.squawk.util.Arrays;
import com.sun.squawk.util.Assert;
import com.sun.squawk.util.Comparer;
import com.sun.squawk.util.Tracer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;

public final class ClassFile {
    public static final Code[] NO_METHODS = new Code[0];
    public static final Object[] NO_OBJECTS = new Object[0];
    public static final byte[][] NO_SUITE_METHODS = new byte[0][];
    private final Klass definedClass;
    private Code[] virtualMethods;
    private Code[] staticMethods;
    private ConstantPool constantPool;
    private boolean safeToDoDeadStringElim;
    private static final String DEAD_STRING_ELIMINATION_MSG = "DEAD STRING ELIMINATION";
    private boolean safeToDoDeadClassElim;
    private static final String DEAD_CLASS_ELIMINATION_MSG = "DEAD CLASS ELIMINATION";
    private static Hashtable vm2cClasses = new Hashtable();
    private ArrayHashtable objectTable = new ArrayHashtable();
    private int nextIndex;
    private static int[] INT_ARRAY_DUMMY;

    public ClassFile(Klass klass) {
        this.definedClass = klass;
        this.staticMethods = NO_METHODS;
        this.virtualMethods = NO_METHODS;
        if (vm2cClasses.get(klass.getInternalName()) == null) {
            this.safeToDoDeadStringElim = Arg.get(6).getBool();
        }
        this.safeToDoDeadClassElim = Arg.get(7).getBool();
    }

    public void setConstantPool(ConstantPool constantPool) {
        Assert.that((this.constantPool == null || this.constantPool == constantPool ? 1 : 0) != 0, (String)"cannot reset the constant pool");
        this.constantPool = constantPool;
    }

    public void setVirtualMethods(Code[] methods) {
        Assert.that((this.virtualMethods == NO_METHODS ? 1 : 0) != 0, (String)"cannot reset the virtual methods");
        this.virtualMethods = methods;
    }

    public void setStaticMethods(Code[] methods) {
        Assert.that((this.staticMethods == NO_METHODS ? 1 : 0) != 0, (String)"cannot reset the static methods");
        this.staticMethods = methods;
    }

    public Klass getDefinedClass() {
        return this.definedClass;
    }

    public ConstantPool getConstantPool() {
        return this.constantPool;
    }

    int getStaticMethodCount() {
        return this.staticMethods.length;
    }

    Code getStaticMethod(int i) {
        if (i >= this.staticMethods.length || i < 0) {
            throw new RuntimeException("bad index: " + i + " max is: " + this.staticMethods.length);
        }
        if (this.staticMethods.length == 0) {
            throw new RuntimeException("bad index: " + i + " max is: " + this.staticMethods.length);
        }
        return this.staticMethods[i];
    }

    int getVirtualMethodCount() {
        return this.virtualMethods.length;
    }

    Code getVirtualMethod(int i) {
        return this.virtualMethods[i];
    }

    public void addConstantObject(Object object) {
        ObjectCounter counter = (ObjectCounter)this.objectTable.get(object);
        if (counter == null) {
            counter = new ObjectCounter(object, this.nextIndex++);
            this.objectTable.put(object, (Object)counter);
        } else {
            counter.inc();
        }
    }

    private void sortObjectTable() {
        int i;
        Object[] list = new ObjectCounter[this.objectTable.size()];
        Enumeration e = this.objectTable.elements();
        for (i = 0; i < list.length; ++i) {
            list[i] = (ObjectCounter)e.nextElement();
        }
        Arrays.sort((Object[])list, (Comparer)new Comparer(){

            public int compare(Object o1, Object o2) {
                Class<?> class2;
                if (o1 == o2) {
                    return 0;
                }
                ObjectCounter t1 = (ObjectCounter)o1;
                ObjectCounter t2 = (ObjectCounter)o2;
                if (t1.getCounter() < t2.getCounter()) {
                    return 1;
                }
                if (t1.getCounter() > t2.getCounter()) {
                    return -1;
                }
                o1 = t1.getObject();
                o2 = t2.getObject();
                Class<?> class1 = o1.getClass();
                if (class1 != (class2 = o2.getClass())) {
                    return class1.getName().compareTo(class2.getName());
                }
                if (class1 == Klass.class) {
                    return ((Klass)o1).getName().compareTo(((Klass)o2).getName());
                }
                if (class1 == String.class) {
                    return ((String)o1).compareTo((String)o2);
                }
                if (class1 == INT_ARRAY_DUMMY.getClass()) {
                    int[] arr1 = (int[])o1;
                    int[] arr2 = (int[])o2;
                    int i = 0;
                    while (true) {
                        if (i == arr1.length) {
                            Assert.that((arr2.length != i ? 1 : 0) != 0);
                            return -1;
                        }
                        if (i == arr2.length) {
                            return 1;
                        }
                        int diff = arr1[i] - arr2[i];
                        if (diff != 0) {
                            return diff;
                        }
                        ++i;
                    }
                }
                throw Assert.shouldNotReachHere((String)("unknown object table type: " + class1));
            }
        });
        for (i = 0; i < list.length; ++i) {
            Object oc = list[i];
            ((ObjectCounter)oc).setIndex(i);
        }
    }

    public int getConstantObjectIndex(Object object, boolean recordUse) {
        ObjectCounter counter = (ObjectCounter)this.objectTable.get(object);
        if (counter == null) {
            throw new NoSuchElementException();
        }
        if (recordUse) {
            counter.incEmittedCounter();
        }
        return counter.getIndex();
    }

    public void referenceConstantObject(Object object) {
        ObjectCounter counter = (ObjectCounter)this.objectTable.get(object);
        if (counter == null) {
            throw new NoSuchElementException();
        }
        counter.incEmittedCounter();
    }

    public void reportActualUsage() {
        boolean firstTime = true;
        Enumeration e = this.objectTable.elements();
        while (e.hasMoreElements()) {
            ObjectCounter counter = (ObjectCounter)e.nextElement();
            if (counter.getEmittedCounter() != 0 || counter.getObject() instanceof Klass) continue;
            if (firstTime) {
                System.out.println("====== Object usage in class " + this.definedClass);
                firstTime = false;
            }
            System.out.println("Actual object usage different for " + counter.getObject());
            System.out.println("    expected use: " + counter.getCounter() + ", actual use: " + counter.getEmittedCounter());
        }
    }

    private Object[] getConstantObjectArray() {
        Object[] list = new Object[this.objectTable.size()];
        Enumeration e = this.objectTable.elements();
        for (int i = 0; i < list.length; ++i) {
            list[i] = e.nextElement();
        }
        Arrays.sort((Object[])list, (Comparer)new Comparer(){

            public int compare(Object o1, Object o2) {
                if (o1 == o2) {
                    return 0;
                }
                ObjectCounter t1 = (ObjectCounter)o1;
                ObjectCounter t2 = (ObjectCounter)o2;
                if (t1.getIndex() < t2.getIndex()) {
                    return -1;
                }
                if (t1.getIndex() > t2.getIndex()) {
                    return 1;
                }
                return 0;
            }
        });
        boolean firstTime = true;
        for (int i = 0; i < list.length; ++i) {
            ObjectCounter oc = (ObjectCounter)list[i];
            if (oc.getEmittedCounter() > 0) {
                list[i] = oc.getObject();
                continue;
            }
            if (oc.getObject() instanceof String && this.safeToDoDeadStringElim) {
                list[i] = DEAD_STRING_ELIMINATION_MSG;
                if (!Tracer.isTracing((String)"DSE", (String)this.definedClass.getName())) continue;
                if (firstTime) {
                    Tracer.traceln((String)("Stripping objects from " + this.definedClass));
                    firstTime = false;
                }
                Tracer.traceln((String)("    " + oc.getObject()));
                continue;
            }
            if (oc.getObject() instanceof Klass && this.safeToDoDeadClassElim && this.safeToDoDeadStringElim) {
                list[i] = DEAD_CLASS_ELIMINATION_MSG;
                if (!Tracer.isTracing((String)"DSE", (String)this.definedClass.getName())) continue;
                if (firstTime) {
                    Tracer.traceln((String)("Stripping class from " + this.definedClass));
                    firstTime = false;
                }
                Tracer.traceln((String)("    " + oc.getObject()));
                continue;
            }
            list[i] = oc.getObject();
        }
        return list;
    }

    private void convertMethods(Translator translator, boolean isStatic, int phase, Vector bodies) {
        Code[] methodsCode = isStatic ? this.staticMethods : this.virtualMethods;
        for (int i = 0; i < methodsCode.length; ++i) {
            Method method = this.definedClass.getMethod(i, isStatic);
            Code code = methodsCode[i];
            if (method.isAbstract() && (phase == 0 || phase == 1)) {
                translator.methodDB.recordMethod(method, 0);
            }
            if (method.isHosted() || method.isAbstract() || method.isNative()) continue;
            Assert.that((code != null ? 1 : 0) != 0);
            if (phase == 0 || phase == 1) {
                code.convert(translator, method, method.getOffset(), 1, null);
                int size = 0;
                size = code.getIR().size();
                translator.methodDB.recordMethod(method, size);
            }
            if (phase != 0 && phase != 2) continue;
            code.convert(translator, method, method.getOffset(), 2, bodies);
            methodsCode[i] = null;
        }
    }

    void convertPhase1(Translator translator, boolean generateIR) {
        int state = this.definedClass.getState();
        Assert.that((state == 2 ? 1 : 0) != 0, (String)"class must be loaded before conversion");
        Assert.that((!this.definedClass.isSynthetic() ? 1 : 0) != 0, (String)"synthetic classes should not require conversion");
        Assert.that((!this.definedClass.isPrimitive() ? 1 : 0) != 0, (String)"primitive types should not require conversion");
        Klass superClass = this.definedClass.getSuperclass();
        if (superClass != null) {
            translator.convert(superClass);
        }
        if (Tracer.isTracing((String)"converting", (String)this.definedClass.getName())) {
            Tracer.traceln((String)("[converting " + this.definedClass + "]"));
        }
        if (generateIR) {
            this.convertMethods(translator, true, 1, null);
            this.convertMethods(translator, false, 1, null);
        }
        this.definedClass.changeState((byte)3);
    }

    void convertPhase2(Translator translator, boolean doInOnePass) {
        int state = this.definedClass.getState();
        Assert.that((state == 3 ? 1 : 0) != 0, (String)"class must be loaded before conversion");
        Assert.that((!this.definedClass.isSynthetic() ? 1 : 0) != 0, (String)"synthetic classes should not require conversion");
        Assert.that((!this.definedClass.isPrimitive() ? 1 : 0) != 0, (String)"primitive types should not require conversion");
        Klass superClass = this.definedClass.getSuperclass();
        if (superClass != null) {
            translator.convertPhase2(superClass);
        }
        Vector bodies = null;
        try {
            if (doInOnePass) {
                this.convertMethods(translator, true, 0, bodies);
                this.convertMethods(translator, false, 0, bodies);
            } else {
                if (Arg.get(1).getBool()) {
                    this.sortObjectTable();
                }
                this.convertMethods(translator, true, 2, bodies);
                this.convertMethods(translator, false, 2, bodies);
            }
        }
        catch (NoClassDefFoundError e) {
            this.definedClass.changeState((byte)5);
            throw e;
        }
        Object[] objectTable = this.getConstantObjectArray();
        this.definedClass.setObjectTable(objectTable);
        this.definedClass.changeState((byte)4);
        if (Tracer.isTracing((String)"converting", (String)this.definedClass.getName())) {
            Tracer.traceln((String)("[converted " + this.definedClass + "]"));
        }
    }

    static {
        vm2cClasses.put("com.sun.squawk.VM", "VM2C Class");
        vm2cClasses.put("com.sun.squawk.GarbageCollector", "VM2C Class");
        vm2cClasses.put("com.sun.squawk.Lisp2GenerationalCollector", "VM2C Class");
        vm2cClasses.put("com.sun.squawk.Lisp2GenerationalCollector$MarkingStack", "VM2C Class");
        INT_ARRAY_DUMMY = new int[0];
    }
}

