/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.translator;

import com.sun.squawk.Klass;
import com.sun.squawk.Method;
import com.sun.squawk.MethodBody;
import com.sun.squawk.translator.Arg;
import com.sun.squawk.translator.ClassFile;
import com.sun.squawk.translator.Translator;
import com.sun.squawk.translator.ci.ClassFileLoader;
import com.sun.squawk.translator.ci.ClassFileReader;
import com.sun.squawk.translator.ci.CodeParser;
import com.sun.squawk.translator.ci.ConstantPool;
import com.sun.squawk.translator.ir.Frame;
import com.sun.squawk.translator.ir.IR;
import com.sun.squawk.translator.ir.IRBuilder;
import com.sun.squawk.translator.ir.IRTransformer;
import com.sun.squawk.translator.ir.Instruction;
import com.sun.squawk.translator.ir.InstructionTracer;
import com.sun.squawk.translator.ir.SlotAllocator;
import com.sun.squawk.util.Assert;
import com.sun.squawk.util.ComputationTimer;
import com.sun.squawk.util.Tracer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;

public final class Code {
    public static final Code[] NO_CODE = new Code[0];
    public static final byte[] SYNTHESIZED_DEFAULT_CONSTRUCTOR_CODE = new byte[0];
    private byte[] code;
    private CodeParser codeParser;
    private IRBuilder irBuilder;

    public Code(byte[] code) {
        this.code = code;
    }

    private ConstantPool getConstantPoolForSynthesizedConstructor(Translator translator, Klass declaringClass) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeShort(7);
            dos.writeByte(1);
            dos.writeUTF("<init>");
            dos.writeByte(1);
            dos.writeUTF("()V");
            Assert.that((!declaringClass.isArray() && !declaringClass.isPrimitive() ? 1 : 0) != 0);
            String superName = declaringClass.getSuperclass().getName().replace('.', '/');
            dos.writeByte(1);
            dos.writeUTF(superName);
            dos.writeByte(12);
            dos.writeShort(1);
            dos.writeShort(2);
            dos.writeByte(7);
            dos.writeShort(3);
            dos.writeByte(10);
            dos.writeShort(5);
            dos.writeShort(4);
            dos.close();
            byte[] data = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            ClassFileReader cfr = new ClassFileReader(bais, ClassFileLoader.getClassFilePath(declaringClass));
            return new ConstantPool(translator, cfr, declaringClass);
        }
        catch (IOException e) {
            Assert.shouldNotReachHere();
            return null;
        }
    }

    private byte[] getCodeForSynthesizedConstructor() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeShort(1);
            dos.writeShort(1);
            dos.writeInt(5);
            dos.writeByte(42);
            dos.writeByte(183);
            dos.writeShort(6);
            dos.writeByte(177);
            dos.writeShort(0);
            dos.writeShort(0);
            dos.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            Assert.shouldNotReachHere();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertPhase1(Translator translator, Method method, int index) {
        try {
            ConstantPool constantPool;
            Assert.that((this.code != null ? 1 : 0) != 0, (String)("code is null for " + method));
            Klass declaringClass = method.getDefiningClass();
            ClassFile cf = translator.getClassFile(declaringClass);
            if (Tracer.isTracing((String)"converting", (String)method.toString())) {
                Tracer.traceln((String)("[converting method " + method + "]"));
            }
            if (this.code == SYNTHESIZED_DEFAULT_CONSTRUCTOR_CODE) {
                constantPool = this.getConstantPoolForSynthesizedConstructor(translator, method.getDefiningClass());
                this.code = this.getCodeForSynthesizedConstructor();
            } else {
                constantPool = cf.getConstantPool();
            }
            translator.load(method.getReturnType());
            Klass[] parameterTypes = method.getParameterTypes();
            for (int i = 0; i < parameterTypes.length; ++i) {
                translator.load(parameterTypes[i]);
            }
            this.codeParser = new CodeParser(translator, method, this.code, constantPool);
            this.irBuilder = new IRBuilder(translator, this.codeParser);
            IR ir = this.irBuilder.getIR();
            for (Instruction instruction = ir.getHead(); instruction != null; instruction = instruction.getNext()) {
                Object object = instruction.getConstantObject();
                if (object == null) continue;
                cf.addConstantObject(object);
            }
            IRTransformer transformer = new IRTransformer(ir, method, this.getFrame());
            transformer.transform(translator);
        }
        finally {
            this.code = null;
        }
    }

    IR getIR() {
        return this.irBuilder.getIR();
    }

    Frame getFrame() {
        return this.irBuilder.getFrame();
    }

    public CodeParser getCodeParser() {
        return this.codeParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MethodBody convertPhase2(Translator translator, Method method, int index) {
        try {
            Klass definingClass = method.getDefiningClass();
            ClassFile cf = translator.getClassFile(definingClass);
            IR ir = this.irBuilder.getIR();
            Frame frame = this.irBuilder.getFrame();
            if (Arg.get(2).getBool() && !translator.dme.isMarkedUsed(method)) {
                if (Tracer.isTracing((String)"converting", (String)method.toString())) {
                    Tracer.traceln((String)("Deleting code for uncalled method " + method));
                }
                MethodBody methodBody = null;
                return methodBody;
            }
            if (Tracer.isTracing((String)"ir0", (String)method.toString())) {
                Tracer.traceln((String)"");
                Tracer.traceln((String)("++++ IR0 for " + method + " ++++"));
                new InstructionTracer(ir).traceAll();
                Tracer.traceln((String)("---- IR0 for " + method + " ----"));
            }
            SlotAllocator allocator = new SlotAllocator(ir, method);
            Klass[] localTypes = allocator.transform();
            if (Tracer.isTracing((String)"ir1", (String)method.toString())) {
                Tracer.traceln((String)"");
                Tracer.traceln((String)("++++ IR1 for " + method + " ++++"));
                new InstructionTracer(ir).traceAll();
                Tracer.traceln((String)("---- IR1 for " + method + " ----"));
            }
            MethodBody body = ir.getMethodBody(method, index, this.codeParser, localTypes, allocator.getClearedSlotCount(), frame.getMaxStack(), cf);
            definingClass.installMethodBody(body, method.isStatic());
            if (Tracer.isTracing((String)"ir2", (String)method.toString())) {
                Tracer.traceln((String)"");
                Tracer.traceln((String)("++++ IR2 for " + method + " ++++"));
                new InstructionTracer(ir).traceAll();
                Tracer.traceln((String)("---- IR2 for " + method + " ----"));
            }
            if (Tracer.isTracing((String)"methods", (String)method.toString())) {
                Tracer.traceln((String)"");
                Translator.trace(body);
            }
            if (Tracer.isTracing((String)"converting", (String)method.toString())) {
                Tracer.traceln((String)("[converted method " + method + "]"));
            }
            MethodBody methodBody = body;
            return methodBody;
        }
        finally {
            this.irBuilder = null;
            this.codeParser = null;
        }
    }

    private void convert0(Translator translator, Method method, int index, int phase, Vector bodies) {
        try {
            if (phase == 1) {
                this.convertPhase1(translator, method, index);
            } else {
                MethodBody b = this.convertPhase2(translator, method, index);
                if (bodies != null) {
                    bodies.addElement(b);
                }
            }
        }
        catch (NoClassDefFoundError e) {
            if (Tracer.isTracing((String)"converting", (String)method.toString())) {
                Tracer.traceln((String)("[error converting method " + method + ": " + e + "]"));
            }
            this.code = null;
            this.irBuilder = null;
            this.codeParser = null;
            throw e;
        }
    }

    void convert(final Translator translator, final Method method, final int index, final int phase, final Vector bodies) {
        ComputationTimer.time((String)("converting phase " + phase), (ComputationTimer.Computation)new ComputationTimer.Computation(){

            public Object run() {
                Code.this.convert0(translator, method, index, phase, bodies);
                return null;
            }
        });
    }
}

