/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.translator;

import com.sun.squawk.ExceptionHandler;
import com.sun.squawk.Klass;
import com.sun.squawk.Method;
import com.sun.squawk.Modifier;
import com.sun.squawk.Suite;
import com.sun.squawk.VM;
import com.sun.squawk.translator.Arg;
import com.sun.squawk.translator.ClassFile;
import com.sun.squawk.translator.ClassReferenceRecordingVisitor;
import com.sun.squawk.translator.Code;
import com.sun.squawk.translator.Translator;
import com.sun.squawk.translator.ir.IR;
import com.sun.squawk.translator.ir.Instruction;
import com.sun.squawk.util.Arrays;
import com.sun.squawk.util.Assert;
import com.sun.squawk.util.Comparer;
import com.sun.squawk.util.SquawkVector;
import com.sun.squawk.util.Tracer;
import java.util.Hashtable;

public class DeadClassEliminator {
    private Translator translator;
    private Hashtable referencedClasses = new Hashtable();
    private static Hashtable systemRoots = new Hashtable();
    private static String[] systemRootsArray = new String[]{"com.sun.squawk.VM", "com.sun.squawk.ResourceFile", "com.sun.squawk.ManifestProperty", "com.sun.squawk.Suite", "com.sun.squawk.KlassMetadata", "com.sun.squawk.KlassMetadata$Full", "com.sun.squawk.MethodMetadata", "com.sun.squawk.FullMethodMetadata", "com.sun.squawk.vm.FieldOffsets", "com.sun.squawk.vm.MethodOffsets", "com.sun.squawk.Klass", "com.sun.squawk.StringOfBytes"};
    SquawkVector markStack;

    public boolean isMarked(Klass klass) {
        return this.referencedClasses.get(klass) != null;
    }

    public boolean markClass(Klass klass) {
        if (klass != null && !this.isMarked(klass)) {
            this.referencedClasses.put(klass, klass);
            return true;
        }
        return false;
    }

    public DeadClassEliminator(Translator translator) {
        this.translator = translator;
    }

    private static boolean isBasicRoot(Klass klass) {
        if (klass.getSystemID() >= 0) {
            return true;
        }
        if (klass.isSynthetic()) {
            return true;
        }
        if (klass.hasMain()) {
            return true;
        }
        return systemRoots.get(klass.getInternalName()) != null;
    }

    private String[] sortStringVector(SquawkVector v) {
        Object[] tmp = new String[v.size()];
        v.copyInto(tmp);
        Arrays.sort((Object[])tmp, (Comparer)new Comparer(){

            public int compare(Object a, Object b) {
                String astr = (String)a;
                String bstr = (String)b;
                return astr.compareTo(bstr);
            }
        });
        return tmp;
    }

    private void printVectorSorted(SquawkVector v, String prefix) {
        String[] results = this.sortStringVector(v);
        for (int i = 0; i < results.length; ++i) {
            Tracer.trace((String)prefix);
            Tracer.traceln((String)results[i]);
        }
    }

    public boolean isExternallyVisible(Klass klass) {
        int modifiers = klass.getModifiers();
        int suiteType = this.translator.getSuiteType();
        if (VM.stripSymbols((Klass)klass) && !VM.isInternal((Klass)klass)) {
            return false;
        }
        Assert.that((Modifier.isPackagePrivate((int)modifiers) || Modifier.isProtected((int)modifiers) || Modifier.isPublic((int)modifiers) ? 1 : 0) != 0);
        switch (suiteType) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        return true;
    }

    void shallowMark(Klass klass) {
        if (klass != null && !this.isMarked(klass)) {
            this.markStack.addElement((Object)klass);
        }
    }

    private void scanMethod(ClassFile classFile, Code code, Method m) {
        boolean dontExpectCode = m.isHosted() || m.isAbstract() || m.isNative();
        Assert.always((dontExpectCode || code != null ? 1 : 0) != 0, (String)("code for method " + m));
        Assert.always((m != null ? 1 : 0) != 0, (String)("method for code " + code));
        if (code != null && m != null && (!Arg.get(2).getBool() || this.translator.dme.isMarkedUsed(m))) {
            this.shallowMark(m.getReturnType());
            Klass[] parameters = m.getParameterTypes();
            for (int j = 0; j < parameters.length; ++j) {
                this.shallowMark(parameters[j]);
            }
            ClassReferenceRecordingVisitor visitor = new ClassReferenceRecordingVisitor(this);
            IR ir = code.getIR();
            for (Instruction instruction = ir.getHead(); instruction != null; instruction = instruction.getNext()) {
                instruction.visit(visitor);
            }
            ExceptionHandler[] exceptionHandlers = code.getCodeParser().getExceptionHandlers();
            for (int i = 0; i < exceptionHandlers.length; ++i) {
                Klass handlerklass = exceptionHandlers[i].getKlass();
                this.shallowMark(handlerklass);
            }
        }
    }

    public void scanClassMethods(Klass klass) {
        int i;
        ClassFile classFile = this.translator.lookupClassFile(klass);
        if (classFile == null) {
            return;
        }
        for (i = 0; i < classFile.getStaticMethodCount(); ++i) {
            this.scanMethod(classFile, classFile.getStaticMethod(i), klass.getMethod(i, true));
        }
        for (i = 0; i < classFile.getVirtualMethodCount(); ++i) {
            this.scanMethod(classFile, classFile.getVirtualMethod(i), klass.getMethod(i, false));
        }
    }

    public void scanClassFields(Klass klass) {
        int i;
        for (i = 0; i < klass.getFieldCount(true); ++i) {
            this.shallowMark(klass.getField(i, true).getType());
        }
        for (i = 0; i < klass.getFieldCount(false); ++i) {
            this.shallowMark(klass.getField(i, false).getType());
        }
    }

    public void scanClassDeep(Klass klass) {
        if (this.markClass(klass)) {
            this.shallowMark(klass.getSuperclass());
            this.shallowMark(klass.getComponentType());
            Klass[] interfaces = klass.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                this.shallowMark(interfaces[i]);
            }
            if (!klass.isSynthetic()) {
                this.scanClassMethods(klass);
            }
            this.scanClassFields(klass);
        }
    }

    public void computeClassesUsed() {
        int len;
        Klass klass;
        int cno;
        boolean trace = Tracer.isTracing((String)"DCE") || VM.isVeryVerbose();
        SquawkVector foundClasses = new SquawkVector();
        SquawkVector unusedClasses = new SquawkVector();
        this.markStack = new SquawkVector();
        Suite suite = this.translator.getSuite();
        foundClasses.removeAllElements();
        for (cno = 0; cno < suite.getClassCount(); ++cno) {
            klass = suite.getKlass(cno);
            if (klass == null || !DeadClassEliminator.isBasicRoot(klass)) continue;
            if (trace) {
                foundClasses.addElement((Object)klass.toString());
            }
            this.scanClassDeep(klass);
        }
        if (trace && foundClasses.size() != 0) {
            Tracer.traceln((String)("[translator DCE: ==== System roots:  " + foundClasses.size() + " ====="));
            this.printVectorSorted(foundClasses, "System root: ");
        }
        foundClasses.removeAllElements();
        for (cno = 0; cno < suite.getClassCount(); ++cno) {
            klass = suite.getKlass(cno);
            if (klass == null || !this.isExternallyVisible(klass) || this.isMarked(klass)) continue;
            if (trace) {
                foundClasses.addElement((Object)klass.toString());
            }
            this.scanClassDeep(klass);
        }
        if (trace && foundClasses.size() != 0) {
            Tracer.traceln((String)("[translator DCE: ==== Visible roots:  " + foundClasses.size() + " ====="));
            this.printVectorSorted(foundClasses, "Visible root: ");
        }
        while ((len = this.markStack.size()) > 0) {
            klass = (Klass)this.markStack.lastElement();
            this.markStack.removeElementAt(len - 1);
            this.scanClassDeep(klass);
        }
        foundClasses.removeAllElements();
        for (int cno2 = 0; cno2 < suite.getClassCount(); ++cno2) {
            Klass klass2 = suite.getKlass(cno2);
            if (klass2 == null || this.isMarked(klass2)) continue;
            if (trace) {
                foundClasses.addElement((Object)klass2.toString());
                if (VM.isInternal((Klass)klass2)) {
                    System.out.println(klass2 + " is internal, why are we deleting???");
                }
            }
            unusedClasses.addElement((Object)klass2);
        }
        if ((trace || VM.isVeryVerbose()) && foundClasses.size() != 0) {
            Tracer.traceln((String)("[translator DCE: ==== Unused classes:  " + foundClasses.size() + " (used classes: " + this.referencedClasses.size() + ") ====="));
            this.printVectorSorted(foundClasses, "    ");
        }
        Object[] unusedKlasses = new Klass[unusedClasses.size()];
        unusedClasses.copyInto(unusedKlasses);
        suite.setUnusedClasses((Klass[])unusedKlasses);
    }

    static {
        for (int i = 0; i < systemRootsArray.length; ++i) {
            String name = systemRootsArray[i];
            systemRoots.put(name, name);
        }
    }
}

