/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.translator;

import com.sun.squawk.Klass;
import com.sun.squawk.Method;
import com.sun.squawk.Suite;
import com.sun.squawk.VM;
import com.sun.squawk.translator.Arg;
import com.sun.squawk.translator.MethodDB;
import com.sun.squawk.translator.Translator;
import com.sun.squawk.util.Arrays;
import com.sun.squawk.util.Comparer;
import com.sun.squawk.util.SquawkVector;
import com.sun.squawk.util.Tracer;
import java.util.Enumeration;
import java.util.Hashtable;

public class DeadMethodEliminator {
    private Translator translator;
    private MethodDB methodDB;
    private Hashtable usedMethods = null;

    public DeadMethodEliminator(Translator translator) {
        this.translator = translator;
        this.methodDB = translator.methodDB;
    }

    private static boolean isBasicRoot(MethodDB.Entry mw) {
        Klass[] parameterTypes;
        Method m = mw.m;
        if (m.isInterpreterInvoked()) {
            return true;
        }
        if (m.getDefiningClass() == Klass.OBJECT) {
            return true;
        }
        return m.isStatic() && m.getName().equals("main") && m.getReturnType() == Klass.VOID && (parameterTypes = m.getParameterTypes()).length == 1 && parameterTypes[0] == Klass.STRING_ARRAY;
    }

    private static boolean isClassMandatedRoot(MethodDB.Entry mw) {
        Method m = mw.m;
        if (m.isStatic()) {
            if (m.isClassInitializer() || m.isReplacementConstructor()) {
                return true;
            }
            if (m.isDefaultConstructor()) {
                return !Arg.get(3).getBool() || !m.isPrivate();
            }
        }
        return false;
    }

    private String[] sortStringVector(SquawkVector v) {
        Object[] tmp = new String[v.size()];
        v.copyInto(tmp);
        Arrays.sort((Object[])tmp, (Comparer)new Comparer(){

            public int compare(Object a, Object b) {
                String astr = (String)a;
                String bstr = (String)b;
                return astr.compareTo(bstr);
            }
        });
        return tmp;
    }

    private void printVectorSorted(SquawkVector v, String prefix) {
        String[] results = this.sortStringVector(v);
        for (int i = 0; i < results.length; ++i) {
            Tracer.trace((String)prefix);
            Tracer.traceln((String)results[i]);
        }
    }

    private void printMethodVector(SquawkVector vector, String prefix) {
        if (vector != null) {
            int len = vector.size();
            Tracer.traceln((String)prefix);
            for (int i = 0; i < len; ++i) {
                MethodDB.Entry cw = (MethodDB.Entry)vector.elementAt(i);
                Tracer.traceln((String)("        " + cw));
            }
        }
    }

    private void printMethodTable() {
        Enumeration e = this.methodDB.getAllMethods();
        while (e.hasMoreElements()) {
            MethodDB.Entry mw = (MethodDB.Entry)e.nextElement();
            Tracer.traceln((String)("Method: " + mw));
            this.printMethodVector(mw.getCalls(), "    calls:");
            this.printMethodVector(mw.getOverrides(), "    overrides:");
            this.printMethodVector(mw.getSuperMethods(), "    supermethods:");
        }
    }

    private boolean hasUsedConstructor(Klass klass) {
        for (int j = klass.getMethodCount(true) - 1; j >= 0; --j) {
            Method m = klass.getMethod(j, true);
            if (!m.isConstructor() || !this.isMarkedUsed(m)) continue;
            return true;
        }
        return false;
    }

    public void computeMethodsUsed() {
        boolean trace = Tracer.isTracing((String)"DME") || VM.isVeryVerbose();
        this.usedMethods = new Hashtable();
        SquawkVector foundMethods = new SquawkVector();
        Suite suite = this.translator.getSuite();
        for (int cno = 0; cno < suite.getClassCount(); ++cno) {
            this.methodDB.computeInheritedImplementorsInfo(suite.getKlass(cno));
        }
        Enumeration e = this.methodDB.getAllMethods();
        foundMethods.removeAllElements();
        while (e.hasMoreElements()) {
            MethodDB.Entry mw = (MethodDB.Entry)e.nextElement();
            if (!DeadMethodEliminator.isBasicRoot(mw)) continue;
            if (trace) {
                foundMethods.addElement((Object)(mw.toString() + " size: " + mw.getSize()));
            }
            this.markMethodUsed(mw);
        }
        if (trace && foundMethods.size() != 0) {
            Tracer.traceln((String)("[translator DME: ==== System roots:  " + foundMethods.size() + " ====="));
            this.printVectorSorted(foundMethods, "System root: ");
        }
        e = this.methodDB.getAllMethods();
        foundMethods.removeAllElements();
        while (e.hasMoreElements()) {
            MethodDB.Entry mw = (MethodDB.Entry)e.nextElement();
            if (!this.methodDB.isExternallyVisible(mw) || this.isMarkedUsed(mw)) continue;
            if (trace) {
                foundMethods.addElement((Object)(mw.toString() + " size: " + mw.getSize()));
            }
            this.markMethodUsed(mw);
        }
        if (trace && foundMethods.size() != 0) {
            Tracer.traceln((String)("[translator DME: ==== Callable roots:  " + foundMethods.size() + " ====="));
            this.printVectorSorted(foundMethods, "Callable root: ");
        }
        e = this.methodDB.getAllMethods();
        foundMethods.removeAllElements();
        while (e.hasMoreElements()) {
            MethodDB.Entry mw = (MethodDB.Entry)e.nextElement();
            if (!DeadMethodEliminator.isClassMandatedRoot(mw) || this.isMarkedUsed(mw)) continue;
            if (trace) {
                foundMethods.addElement((Object)(mw.toString() + " size: " + mw.getSize()));
            }
            this.markMethodUsed(mw);
        }
        if (trace && foundMethods.size() != 0) {
            Tracer.traceln((String)("[translator DME: ==== Class Mandated roots:  " + foundMethods.size() + " ====="));
            this.printVectorSorted(foundMethods, "Class root: ");
        }
        if (trace || VM.isVeryVerbose()) {
            e = this.methodDB.getAllMethods();
            foundMethods.removeAllElements();
            while (e.hasMoreElements()) {
                MethodDB.Entry mw = (MethodDB.Entry)e.nextElement();
                if (this.isMarkedUsed(mw) || mw.m.isAbstract()) continue;
                foundMethods.addElement((Object)(mw.toString() + " size: " + mw.getSize()));
            }
            if (foundMethods.size() != 0) {
                Tracer.traceln((String)("[translator DME: ==== Uncalled methods:  " + foundMethods.size() + " (called methods: " + this.usedMethods.size() + ") ====="));
                this.printVectorSorted(foundMethods, "    ");
            }
        }
    }

    private void markMethodVectorUsed(SquawkVector vector) {
        if (vector != null) {
            int len = vector.size();
            for (int i = 0; i < len; ++i) {
                MethodDB.Entry cw = (MethodDB.Entry)vector.elementAt(i);
                this.markMethodUsed(cw);
            }
        }
    }

    private boolean isMarkedUsed(MethodDB.Entry mw) {
        return this.usedMethods.get(mw) != null;
    }

    public boolean isMarkedUsed(Method m) {
        return this.isMarkedUsed(this.methodDB.lookupMethodEntry(m));
    }

    private void markMethodUsed(MethodDB.Entry mw) {
        if (!this.isMarkedUsed(mw)) {
            this.usedMethods.put(mw, mw);
            this.markMethodVectorUsed(mw.getCalls());
            if (!mw.m.isStatic()) {
                this.markMethodVectorUsed(mw.getOverrides());
                this.markMethodVectorUsed(mw.getSuperMethods());
            }
        }
    }
}

