/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.translator;

import com.sun.squawk.Klass;
import com.sun.squawk.Member;
import com.sun.squawk.Method;
import com.sun.squawk.Modifier;
import com.sun.squawk.VM;
import com.sun.squawk.translator.Translator;
import com.sun.squawk.util.Assert;
import com.sun.squawk.util.SquawkVector;
import java.util.Enumeration;
import java.util.Hashtable;

public class MethodDB {
    private Translator translator;
    private static final int DEFAULT_TABLE_SIZE = 800;
    private Hashtable canonicalMethodEntryTable;
    private Hashtable allMethods;

    public MethodDB(Translator translator) {
        this.translator = translator;
        if (translator.getTranslationStrategy() >= 3) {
            this.canonicalMethodEntryTable = new Hashtable(800);
            this.allMethods = new Hashtable(800);
        }
    }

    public Entry lookupMethodEntry(Method m) {
        if (this.canonicalMethodEntryTable == null) {
            throw new IllegalStateException("MethodDB not used with this translation strategy");
        }
        String key = Klass.toString((Member)m, (boolean)false);
        Entry value = (Entry)this.canonicalMethodEntryTable.get(key);
        if (value == null) {
            value = new Entry(m, key);
            this.canonicalMethodEntryTable.put(key, value);
        }
        return value;
    }

    public void recordMethod(Method m, int estSize) {
        if (this.canonicalMethodEntryTable != null) {
            Entry mw = this.lookupMethodEntry(m);
            this.allMethods.put(mw, mw);
            mw.setSize(estSize);
            if (m.isStatic()) {
                return;
            }
            this.calcSuperMethods(mw, m);
        }
    }

    public void recordMethodCall(Entry caller, Method callee) {
        if (!callee.isHosted() && !callee.isNative()) {
            Entry cw = this.lookupMethodEntry(callee);
            caller.addCall(cw);
        }
    }

    private void calcImplementsMerge(Entry mw, Method m, Klass[] interfaces) {
        for (int i = 0; i < interfaces.length; ++i) {
            Method superMethod = interfaces[i].lookupMethod(m.getName(), m.getParameterTypes(), m.getReturnType(), null, false);
            if (superMethod == null) continue;
            mw.addSuperMethod(this.lookupMethodEntry(superMethod));
        }
    }

    private void calcSuperMethods(Entry mw, Method m) {
        Assert.that((!m.isStatic() ? 1 : 0) != 0);
        Klass defClass = m.getDefiningClass();
        Klass superType = defClass.getSuperclass();
        if (superType == null) {
            return;
        }
        Method superMethod = superType.lookupMethod(m.getName(), m.getParameterTypes(), m.getReturnType(), null, false);
        if (superMethod != null && (superMethod.getDefiningClass().isInterface() || superMethod.isAccessibleFrom(defClass))) {
            mw.addSuperMethod(this.lookupMethodEntry(superMethod));
        }
        this.calcImplementsMerge(mw, m, defClass.getInterfaces());
    }

    public void computeInheritedImplementorsInfo(Klass klass) {
        if (klass == Klass.OBJECT || klass.isArray() || klass.isInterface() || klass.isSynthetic()) {
            return;
        }
        for (Klass superKlass = klass.getSuperclass(); superKlass != Klass.OBJECT; superKlass = superKlass.getSuperclass()) {
            int count = superKlass.getMethodCount(false);
            for (int i = 0; i < count; ++i) {
                Method m = superKlass.getMethod(i, false);
                Entry mw = this.lookupMethodEntry(m);
                this.calcImplementsMerge(mw, m, klass.getInterfaces());
            }
        }
    }

    public Enumeration getAllMethods() {
        return this.allMethods.elements();
    }

    private boolean isSuperMethodDefinedOustideOfSuite(Entry mw) {
        SquawkVector superMethods = mw.getSuperMethods();
        if (superMethods == null) {
            return false;
        }
        for (int i = 0; i < superMethods.size(); ++i) {
            Entry superMethod = (Entry)superMethods.elementAt(i);
            if (!this.translator.getSuite().contains(superMethod.m.getDefiningClass())) {
                return true;
            }
            if (!this.isSuperMethodDefinedOustideOfSuite(superMethod)) continue;
            return true;
        }
        return false;
    }

    public boolean isExternallyVisible(Entry mw) {
        boolean sealedPackages;
        Method m = mw.m;
        int modifiers = m.getModifiers();
        int suiteType = this.translator.getSuiteType();
        boolean bl = sealedPackages = suiteType == 1 || suiteType == 0;
        if (Modifier.isPrivate((int)modifiers)) {
            return false;
        }
        if (this.translator.getSuite().isBootstrap() && VM.stripSymbols((Member)m) && !VM.isInternal((Member)m)) {
            return false;
        }
        Assert.that((Modifier.isPackagePrivate((int)modifiers) || Modifier.isProtected((int)modifiers) || Modifier.isPublic((int)modifiers) ? 1 : 0) != 0);
        if (!m.isStatic() && this.isSuperMethodDefinedOustideOfSuite(mw)) {
            return true;
        }
        switch (suiteType) {
            case 0: {
                return false;
            }
            case 1: {
                if (Modifier.isPackagePrivate((int)modifiers)) {
                    return false;
                }
                if (Modifier.isProtected((int)modifiers)) {
                    return !m.getDefiningClass().isFinal() && m.getDefiningClass().isPublic();
                }
                Assert.that((boolean)Modifier.isPublic((int)modifiers));
                return m.getDefiningClass().isPublic();
            }
        }
        return true;
    }

    public boolean isNeverOverriden(Method m) {
        SquawkVector overrides;
        Assert.that((!m.isStatic() ? 1 : 0) != 0);
        Assert.that((!m.isFinal() ? 1 : 0) != 0);
        Assert.that((!m.isPrivate() ? 1 : 0) != 0);
        Assert.that((!m.getDefiningClass().isFinal() ? 1 : 0) != 0);
        Entry mw = this.lookupMethodEntry(m);
        return !this.isExternallyVisible(mw) && ((overrides = mw.getOverrides()) == null || overrides.size() == 0);
    }

    public static boolean methodsEqual(Method m1, Method m2) {
        Klass[] types2;
        Klass[] types1;
        if (m1 == m2) {
            return true;
        }
        if (m1.isStatic() == m2.isStatic() && m1.getDefiningClass() == m2.getDefiningClass() && m1.getName().equals(m2.getName()) && m1.getReturnType() == m2.getReturnType() && (types1 = m1.getParameterTypes()).length == (types2 = m2.getParameterTypes()).length) {
            for (int j = 0; j < types1.length; ++j) {
                if (types1[j] == types2[j]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static final class Entry {
        public final Method m;
        private SquawkVector calls;
        private SquawkVector overrides;
        private SquawkVector superMethods;
        private String fullName;
        private int estSize;

        private Entry(Method m, String fullName) {
            this.m = m;
            this.fullName = fullName;
        }

        public void addCall(Entry calledMethod) {
            if (this.calls == null) {
                this.calls = new SquawkVector();
            }
            this.calls.addElement((Object)calledMethod);
        }

        public SquawkVector getCalls() {
            return this.calls;
        }

        private void addOverride(Entry overridingMethod) {
            if (this.overrides == null) {
                this.overrides = new SquawkVector();
            }
            this.overrides.addElement((Object)overridingMethod);
        }

        public void addSuperMethod(Entry superMethod) {
            if (this.superMethods == null) {
                this.superMethods = new SquawkVector();
            }
            if (!this.superMethods.contains((Object)superMethod)) {
                this.superMethods.addElement((Object)superMethod);
                superMethod.addOverride(this);
            }
        }

        public SquawkVector getSuperMethods() {
            return this.superMethods;
        }

        public SquawkVector getOverrides() {
            return this.overrides;
        }

        void setSize(int estSize) {
            this.estSize = estSize;
        }

        public int getSize() {
            return this.estSize;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Entry) {
                Entry w = (Entry)obj;
                return MethodDB.methodsEqual(this.m, w.m);
            }
            return false;
        }

        public int hashCode() {
            return this.fullName.hashCode();
        }

        public String toString() {
            return this.fullName;
        }
    }
}

