/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.translator;

import com.sun.squawk.Klass;
import com.sun.squawk.Method;
import com.sun.squawk.MethodBody;
import com.sun.squawk.MethodBodyTracer;
import com.sun.squawk.ResourceFile;
import com.sun.squawk.Suite;
import com.sun.squawk.TranslatorInterface;
import com.sun.squawk.VM;
import com.sun.squawk.io.connections.ClasspathConnection;
import com.sun.squawk.translator.Arg;
import com.sun.squawk.translator.ClassFile;
import com.sun.squawk.translator.DeadClassEliminator;
import com.sun.squawk.translator.DeadMethodEliminator;
import com.sun.squawk.translator.LinkageError;
import com.sun.squawk.translator.MethodDB;
import com.sun.squawk.translator.ci.ClassFileLoader;
import com.sun.squawk.translator.ci.ConstantPool;
import com.sun.squawk.util.Assert;
import com.sun.squawk.util.ComputationTimer;
import com.sun.squawk.util.Tracer;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Stack;
import javax.microedition.io.Connector;

public final class Translator
implements TranslatorInterface {
    public static final boolean TRACING_ENABLED = true;
    protected final Stack lastClassNameStack = new Stack();
    public static final boolean FORCE_DME_ERRORS = false;
    private boolean optimizeSuite;
    private int progressCounter = 0;
    public static final int BY_METHOD = 1;
    public static final int BY_CLASS = 2;
    public static final int BY_SUITE = 3;
    public static final int BY_TRANSLATION = 4;
    private int translationStrategy = 0;
    private Suite suite;
    private int suiteType;
    private ClasspathConnection classPath;
    public MethodDB methodDB;
    DeadMethodEliminator dme;
    private Hashtable classFiles;
    public static final boolean REVERSE_PARAMETERS = true;

    public static boolean shouldDoInlining() {
        return false;
    }

    public static boolean verbose() {
        return Arg.get(5).getBool();
    }

    public Translator() {
        Arg.defineOptions();
    }

    public boolean shouldOptimizeSuite() {
        return this.optimizeSuite;
    }

    private void setOptions() {
        Arg.setOptions();
        this.translationStrategy = Arg.get(7).getBool() || Arg.get(2).getBool() ? 3 : (Arg.get(1).getBool() ? 2 : 1);
        if (this.translationStrategy >= 3 && Translator.shouldDoInlining()) {
            this.optimizeSuite = true;
        }
    }

    public void traceProgress() {
        if (Translator.verbose()) {
            ++this.progressCounter;
            Tracer.trace((String)".");
            if (this.progressCounter % 40 == 0) {
                Tracer.trace((String)"\n");
            }
        }
    }

    public void open(Suite suite, String classPath) {
        this.suiteType = -9999;
        this.suite = suite;
        this.classFiles = new Hashtable();
        this.setOptions();
        try {
            String url = "classpath://" + classPath;
            this.classPath = (ClasspathConnection)Connector.open((String)url);
        }
        catch (IOException ioe) {
            throw new LinkageError("Error while setting class path from '" + classPath + "': " + ioe);
        }
        this.methodDB = new MethodDB(this);
    }

    public boolean isValidClassName(String name) {
        return name.indexOf(47) == -1 && ConstantPool.isLegalName(name.replace('.', '/'), ConstantPool.ValidNameFormat.CLASS);
    }

    public void load(Klass klass) {
        Assert.that((VM.isHosted() || VM.getCurrentIsolate().getLeafSuite() == this.suite ? 1 : 0) != 0);
        int state = klass.getState();
        if (state < 2) {
            if (klass.isArray()) {
                this.load(klass.getComponentType());
            } else {
                this.lastClassNameStack.push(klass.getName());
                ClassFile classFile = this.getClassFile(klass);
                this.load(classFile);
                this.lastClassNameStack.pop();
            }
        }
    }

    public void convert(Klass klass) {
        this.lastClassNameStack.push(klass.getName());
        int state = klass.getState();
        if (state < 3) {
            if (klass.isArray()) {
                this.convert(Klass.OBJECT);
                klass.changeState((byte)4);
            } else {
                this.traceProgress();
                ClassFile classFile = this.getClassFile(klass);
                classFile.convertPhase1(this, this.translationStrategy != 1);
                if (klass.hasGlobalStatics()) {
                    this.recordGlobalStatics(klass);
                }
                if (this.translationStrategy == 1 || this.translationStrategy == 2) {
                    classFile.convertPhase2(this, this.translationStrategy == 1);
                    this.classFiles.remove(klass.getName());
                }
            }
        }
        this.lastClassNameStack.pop();
    }

    private void recordGlobalStatics(Klass klass) {
    }

    void convertPhase2(Klass klass) {
        Assert.that((this.translationStrategy != 1 ? 1 : 0) != 0);
        this.convert(klass);
        if (klass.getState() < 4) {
            if (!VM.isVerbose()) {
                this.traceProgress();
            }
            this.lastClassNameStack.push(klass.getName());
            ClassFile classFile = this.getClassFile(klass);
            classFile.convertPhase2(this, false);
            this.classFiles.remove(klass.getName());
            this.lastClassNameStack.pop();
        }
    }

    public void close(int suiteType) throws NoClassDefFoundError {
        long time = 0L;
        this.suiteType = suiteType;
        if (Translator.verbose()) {
            Tracer.trace((String)"[Translator: computing closure...");
            time = System.currentTimeMillis();
        }
        this.computeClosure();
        if (this.translationStrategy == 3 || this.translationStrategy == 4) {
            if (Translator.verbose()) {
                time = System.currentTimeMillis() - time;
                Tracer.traceln((String)(time + "ms.]"));
                Tracer.trace((String)"[Translator: whole-suite optimizing and inlining...");
                time = System.currentTimeMillis();
            }
            if (Arg.get(2).getBool()) {
                this.dme = new DeadMethodEliminator(this);
                this.dme.computeMethodsUsed();
            }
            if (Arg.get(7).getBool()) {
                DeadClassEliminator dce = new DeadClassEliminator(this);
                dce.computeClassesUsed();
            }
            if (Translator.verbose()) {
                time = System.currentTimeMillis() - time;
                Tracer.traceln((String)(time + "ms.]"));
                Tracer.trace((String)"[Translator: phase2...");
                time = System.currentTimeMillis();
            }
            for (int cno = 0; cno < this.suite.getClassCount(); ++cno) {
                Klass klass = this.suite.getKlass(cno);
                Assert.always((Arg.get(7).getBool() || klass != null ? 1 : 0) != 0);
                if (klass == null) continue;
                this.convertPhase2(this.suite.getKlass(cno));
            }
        }
        this.classFiles.clear();
        if (Translator.verbose()) {
            time = System.currentTimeMillis() - time;
            Tracer.traceln((String)(time + "ms.]"));
        }
        Assert.always((boolean)this.lastClassNameStack.empty());
    }

    public void printTraceFlags(PrintStream out) {
        out.println("    -traceloading         trace class loading");
        out.println("    -traceconverting      trace method conversion (includes -traceloading)");
        out.println("    -tracejvmverifier     trace verification of JVM/CLDC bytecodes");
        out.println("    -traceemitter         trace Squawk bytecode emitter");
        out.println("    -tracesquawkverifier  trace verification of Squawk bytecodes");
        out.println("    -traceclassinfo       trace loading of class meta-info (i.e. implemented");
        out.println("                          interfaces, field meta-info & method meta-info)");
        out.println("    -traceclassfile       trace low-level class file elements");
        out.println("    -traceir0             trace the IR built from the JVM bytecodes");
        out.println("    -traceir1             trace optimized IR with JVM bytcode offsets");
        out.println("    -traceir2             trace optimized IR with Squawk bytcode offsets");
        out.println("    -tracemethods         trace emitted Squawk bytecode methods");
        out.println("    -tracemaps            trace stackmaps read from class files");
        out.println("    -traceDME             trace Dead Method Elimination");
        out.println("    -traceDCE             trace Dead Class Elimination");
        out.println("    -tracecallgraph       print table of methods and callees (only when doing DME)");
        out.println("    -tracefilter:<string> filter trace with simple string filter");
    }

    public void printOptionProperties(PrintStream out, boolean asParameters) {
        for (int i = 0; i < Arg.translatorArgs.length; ++i) {
            Arg.translatorArgs[i].printOne(out, asParameters);
        }
    }

    public boolean processOption(String arg) {
        if (arg.startsWith("-")) {
            for (int i = 0; i < Arg.translatorArgs.length; ++i) {
                Arg translatorArg = Arg.translatorArgs[i];
                String optionStr = translatorArg.getOptionName();
                if (!arg.startsWith(optionStr)) continue;
                String val = arg.substring(optionStr.length()).toUpperCase();
                VM.setProperty((String)translatorArg.getPropertyName(), (String)val);
                return true;
            }
        }
        return false;
    }

    public boolean isOption(String arg) {
        if (arg.startsWith("-")) {
            for (int i = 0; i < Arg.translatorArgs.length; ++i) {
                if (!arg.startsWith(Arg.translatorArgs[i].getOptionName())) continue;
                return true;
            }
        }
        return false;
    }

    public Suite getSuite() {
        return this.suite;
    }

    public int getSuiteType() {
        return this.suiteType;
    }

    public int getTranslationStrategy() {
        return this.translationStrategy;
    }

    public static int countArrayDimensions(String name) {
        int dimensions = 0;
        while (name.charAt(dimensions) == '[') {
            ++dimensions;
        }
        return dimensions;
    }

    ClassFile getClassFile(Klass klass) {
        Assert.that((!klass.isSynthetic() ? 1 : 0) != 0, (String)"synthethic class has no classfile");
        String name = klass.getName();
        ClassFile classFile = (ClassFile)this.classFiles.get(name);
        if (classFile == null) {
            classFile = new ClassFile(klass);
            this.classFiles.put(name, classFile);
        }
        return classFile;
    }

    ClassFile lookupClassFile(Klass klass) {
        Assert.that((!klass.isSynthetic() ? 1 : 0) != 0, (String)"synthethic class has no classfile");
        ClassFile classFile = (ClassFile)this.classFiles.get(klass.getInternalName());
        return classFile;
    }

    public String getLastClassName() {
        if (this.lastClassNameStack.empty()) {
            return null;
        }
        return (String)this.lastClassNameStack.peek();
    }

    public ClasspathConnection getClassPath() {
        return this.classPath;
    }

    private void load(final ClassFile classFile) {
        final ClassFileLoader loader = new ClassFileLoader(this);
        ComputationTimer.time((String)"loading", (ComputationTimer.Computation)new ComputationTimer.Computation(){

            public Object run() {
                loader.load(classFile);
                return null;
            }
        });
    }

    public void computeClosure() {
        boolean changed = true;
        while (changed) {
            changed = false;
            for (int cno = 0; cno < this.suite.getClassCount(); ++cno) {
                Klass klass = this.suite.getKlass(cno);
                Assert.always((klass != null ? 1 : 0) != 0);
                if (klass.getState() < 2) {
                    this.load(klass);
                    changed = true;
                }
                if (klass.getState() >= 3) continue;
                this.convert(klass);
                changed = true;
            }
        }
    }

    public byte[] getResourceData(String name) {
        Assert.that((VM.isHosted() || VM.getCurrentIsolate().getLeafSuite() == this.suite ? 1 : 0) != 0);
        try {
            byte[] bytes = this.classPath.getBytes(name);
            ResourceFile resourceFile = new ResourceFile(name, bytes);
            this.suite.installResource(resourceFile);
            return bytes;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static void trace(MethodBody mb) {
        Method method = mb.getDefiningMethod();
        Tracer.traceln((String)("++++ Method for " + method + " ++++"));
        new MethodBodyTracer(mb).traceAll();
        Tracer.traceln((String)("---- Method for " + method + " ----"));
    }
}

