/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.translator.ci;

import com.sun.squawk.ClassFileConstantField;
import com.sun.squawk.ClassFileField;
import com.sun.squawk.ClassFileMethod;
import com.sun.squawk.Isolate;
import com.sun.squawk.Klass;
import com.sun.squawk.Modifier;
import com.sun.squawk.VM;
import com.sun.squawk.io.connections.ClasspathConnection;
import com.sun.squawk.pragma.PragmaException;
import com.sun.squawk.translator.ClassCircularityError;
import com.sun.squawk.translator.ClassFile;
import com.sun.squawk.translator.Code;
import com.sun.squawk.translator.IncompatibleClassChangeError;
import com.sun.squawk.translator.LinkageError;
import com.sun.squawk.translator.Translator;
import com.sun.squawk.translator.VerifyError;
import com.sun.squawk.translator.ci.ClassFileReader;
import com.sun.squawk.translator.ci.ConstantPool;
import com.sun.squawk.translator.ci.Context;
import com.sun.squawk.translator.ci.MethodSignature;
import com.sun.squawk.util.Arrays;
import com.sun.squawk.util.Assert;
import com.sun.squawk.util.Comparer;
import com.sun.squawk.util.SquawkVector;
import com.sun.squawk.util.Tracer;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;

public final class ClassFileLoader
implements Context {
    private final Translator translator;
    private ClassFile cf;
    private Klass klass;
    private ClassFileReader cfr;
    private ConstantPool pool;
    private boolean traceClassInfo;

    public ClassFileLoader(Translator translator) {
        this.translator = translator;
    }

    public static String getClassFilePath(String name) {
        return name.replace('.', '/') + ".class";
    }

    public static String getClassFilePath(Klass klass) {
        return ClassFileLoader.getClassFilePath(klass.getInternalName());
    }

    public void load(ClassFile cf) {
        this.cf = cf;
        this.klass = cf.getDefinedClass();
        this.traceClassInfo = Tracer.isTracing((String)"classinfo", (String)this.klass.getName());
        Assert.that((this.klass.getState() < 2 ? 1 : 0) != 0);
        String classFilePath = ClassFileLoader.getClassFilePath(this.klass);
        InputStream is = null;
        try {
            ClasspathConnection classPath = this.translator.getClassPath();
            if (classPath == null) {
                throw new IOException("null class path");
            }
            is = classPath.openInputStream(classFilePath);
            this.load(classFilePath, is);
        }
        catch (IOException ioe) {
            if (VM.isHosted() || VM.isVeryVerbose()) {
                System.err.println("IO error while loading: " + this.klass);
                ioe.printStackTrace();
            }
            throw new NoClassDefFoundError(this.prefix(ioe.toString()));
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    Assert.shouldNotReachHere();
                }
            }
        }
    }

    private void load(String fileName, InputStream is) {
        if (Tracer.isTracing((String)"loading", (String)this.klass.getName())) {
            Tracer.traceln((String)("[loading " + this.klass + "]"));
        }
        this.cfr = new ClassFileReader(is, fileName);
        if (this.klass.getState() == 1) {
            throw new ClassCircularityError(this.klass.toString());
        }
        Assert.that((this.klass.getState() == 0 ? 1 : 0) != 0);
        this.klass.changeState((byte)1);
        this.loadMagicValues();
        this.loadConstantPool();
        this.cf.setConstantPool(this.pool);
        Klass superClass = this.loadClassInfo();
        Klass[] interfaces = this.loadInterfaces();
        Assert.that((interfaces != null ? 1 : 0) != 0);
        this.setGlobalStaticModifier(superClass, interfaces);
        if (this.traceClassInfo) {
            Tracer.traceln((String)("class: " + this.klass.getInternalName()));
            if (superClass != null) {
                Tracer.traceln((String)("  extends: " + superClass.getInternalName()));
            }
            for (int i = 0; i < interfaces.length; ++i) {
                Tracer.traceln((String)("  implements: " + interfaces[i].getInternalName()));
            }
        }
        ClassFileField[][] fieldTables = new ClassFileField[][]{ClassFileField.NO_FIELDS, ClassFileField.NO_FIELDS};
        this.loadFields(fieldTables);
        ClassFileMethod[][] methodTables = new ClassFileMethod[][]{ClassFileMethod.NO_METHODS, ClassFileMethod.NO_METHODS};
        this.loadMethods(methodTables);
        String sourceFile = this.loadExtraAttributes();
        this.cfr.readEOF();
        this.cfr.close();
        this.cfr = null;
        Assert.that((this.klass.getState() == 1 ? 1 : 0) != 0);
        if (this.klass.isSquawkPrimitive() || this.klass.isSquawkArray()) {
            fieldTables[0] = ClassFileField.NO_FIELDS;
            fieldTables[1] = ClassFileField.NO_FIELDS;
        }
        this.klass.setClassFileDefinition(superClass, interfaces, methodTables[0], methodTables[1], fieldTables[0], fieldTables[1], sourceFile);
        this.klass.changeState((byte)2);
        if (Tracer.isTracing((String)"loading", (String)this.klass.getName())) {
            Tracer.traceln((String)("[loaded " + this.klass + "]"));
        }
    }

    private void loadMagicValues() {
        int magic = this.cfr.readInt("magic");
        int minor = this.cfr.readUnsignedShort("minor");
        int major = this.cfr.readUnsignedShort("major");
        if (magic != -889275714) {
            throw this.cfr.formatError("Bad magic value = " + Integer.toHexString(magic));
        }
        if (major < 45 || major > 48) {
            throw this.cfr.formatError("Unsupported class file version: " + major + ":" + minor);
        }
    }

    private void loadConstantPool() {
        this.pool = new ConstantPool(this.translator, this.cfr, this.cf.getDefinedClass());
    }

    private Klass loadClassInfo() {
        int modifiers = this.cfr.readUnsignedShort("cls-flags");
        int classIndex = this.cfr.readUnsignedShort("cls-index");
        int superIndex = this.cfr.readUnsignedShort("cls-super index");
        modifiers = this.pool.verifyClassModifiers(modifiers);
        Klass thisClass = this.pool.getKlass(classIndex);
        if (thisClass != this.klass) {
            throw new NoClassDefFoundError(this.prefix("'this_class' indicates wrong type"));
        }
        if (this.klass == null) {
            throw this.cfr.formatError("invalid 'this_class' item");
        }
        modifiers &= Modifier.getJVMClassModifiers();
        this.klass.updateModifiers(modifiers |= this.klass.getModifiers());
        if (superIndex != 0) {
            Klass superClass = this.pool.getKlass(superIndex);
            Assert.that((superClass != null ? 1 : 0) != 0);
            if (this.klass.isInterface() && superClass != Klass.OBJECT) {
                throw this.cfr.formatError("interface class must inherit from java.lang.Object");
            }
            superClass = this.pool.getResolvedClass(superIndex, this);
            if (superClass.isArray()) {
                throw this.cfr.formatError("cannot inherit from array class");
            }
            if (superClass.isInterface()) {
                throw this.cfr.formatError("cannot extend an interface class");
            }
            if (superClass.isFinal()) {
                throw new VerifyError(this.prefix("cannot extend a final class"));
            }
            if (Modifier.isSuitePrivate((int)superClass.getModifiers()) && !Isolate.currentIsolate().getLeafSuite().contains(superClass)) {
                throw new LinkageError(this.prefix(" has a superclass " + superClass + " which is a suite-private class from another suite."));
            }
            return superClass;
        }
        if (this.klass != Klass.OBJECT) {
            throw this.cfr.formatError("class must have super-type");
        }
        return null;
    }

    private static boolean isPragmaGlobalStaticFields(Klass klass) {
        return klass.getInternalName().equals("com.sun.squawk.pragma.GlobalStaticFields");
    }

    private static boolean isPragmaGlobalStaticFieldsInherited(Klass klass) {
        return klass.getInternalName().equals("com.sun.squawk.pragma.GlobalStaticFieldsInherited");
    }

    private static boolean implementsGlobalStaticFieldPragma(Klass[] interfaces, boolean inheritedOnly) {
        for (int i = 0; i < interfaces.length; ++i) {
            Klass iface = interfaces[i];
            if ((inheritedOnly || !ClassFileLoader.isPragmaGlobalStaticFields(iface)) && !ClassFileLoader.isPragmaGlobalStaticFieldsInherited(iface)) continue;
            return true;
        }
        return false;
    }

    private void setGlobalStaticModifier(Klass superclass, Klass[] interfaces) {
        if (ClassFileLoader.implementsGlobalStaticFieldPragma(interfaces, false)) {
            this.klass.updateModifiers(0x2000000);
            return;
        }
        while (superclass != null) {
            interfaces = superclass.getInterfaces();
            if (ClassFileLoader.implementsGlobalStaticFieldPragma(interfaces, true)) {
                this.klass.updateModifiers(0x2000000);
                return;
            }
            superclass = superclass.getSuperclass();
        }
    }

    private Klass[] loadInterfaces() {
        int count = this.cfr.readUnsignedShort("i/f-count");
        if (count == 0) {
            return Klass.NO_CLASSES;
        }
        Klass[] interfaces = new Klass[count];
        for (int i = 0; i < count; ++i) {
            Klass iface = this.pool.getResolvedClass(this.cfr.readUnsignedShort("i/f-index"), this);
            if (!iface.isInterface()) {
                throw new IncompatibleClassChangeError(this.prefix("cannot implement non-interface class"));
            }
            interfaces[i] = iface;
            if (!Modifier.isSuitePrivate((int)iface.getModifiers()) || Isolate.currentIsolate().getLeafSuite().contains(iface)) continue;
            throw new LinkageError(this.prefix("implements " + iface + " which is a suite-private interface from another suite."));
        }
        return interfaces;
    }

    private void loadFields(ClassFileField[][] fieldTables) {
        int count = this.cfr.readUnsignedShort("fld-count");
        if (count == 0) {
            return;
        }
        SquawkVector instanceFields = new SquawkVector(count);
        SquawkVector staticFields = new SquawkVector(count);
        for (int i = 0; i < count; ++i) {
            ClassFileField field = this.loadField();
            this.verifyFieldIsUnique(instanceFields, field);
            this.verifyFieldIsUnique(staticFields, field);
            if (field.isStatic()) {
                staticFields.addElement((Object)field);
                continue;
            }
            instanceFields.addElement((Object)field);
        }
        fieldTables[0] = this.getFieldTable(instanceFields);
        fieldTables[1] = this.getFieldTable(staticFields);
        if (fieldTables[0].length > 1) {
            this.sortFields(fieldTables[0]);
        }
    }

    private ClassFileField[] getFieldTable(SquawkVector fields) {
        if (fields.isEmpty()) {
            return ClassFileField.NO_FIELDS;
        }
        Object[] table = new ClassFileField[fields.size()];
        fields.copyInto(table);
        return table;
    }

    private void verifyFieldIsUnique(SquawkVector fields, ClassFileField field) {
        Enumeration e = fields.elements();
        while (e.hasMoreElements()) {
            ClassFileField f = (ClassFileField)e.nextElement();
            if (!f.getName().equals(field.getName()) || f.getType() != field.getType()) continue;
            throw this.cfr.formatError("duplicate field found");
        }
    }

    private void sortFields(ClassFileField[] fields) {
        Arrays.sort((Object[])fields, (Comparer)new Comparer(){

            public int compare(Object o1, Object o2) {
                if (o1 == o2) {
                    return 0;
                }
                Klass t1 = ((ClassFileField)o1).getType();
                Klass t2 = ((ClassFileField)o2).getType();
                if (t1.getDataSize() < t2.getDataSize()) {
                    return 1;
                }
                if (t1.getDataSize() > t2.getDataSize()) {
                    return -1;
                }
                return 0;
            }
        });
    }

    private ClassFileField loadField() {
        ClassFileField field;
        int modifiers = this.cfr.readUnsignedShort("fld-flags");
        int nameIndex = this.cfr.readUnsignedShort("fld-nameIndex");
        int descriptorIndex = this.cfr.readUnsignedShort("fld-descIndex");
        int attributesCount = this.cfr.readUnsignedShort("fld-AttbCount");
        int constantValueIndex = 0;
        String fieldName = this.pool.getUtf8(nameIndex);
        String fieldSig = this.pool.getUtf8(descriptorIndex);
        this.pool.verifyFieldModifiers(modifiers, this.klass.getModifiers());
        this.pool.verifyName(fieldName, ConstantPool.ValidNameFormat.FIELD);
        Klass fieldType = this.pool.verifyFieldType(fieldSig);
        modifiers &= Modifier.getJVMFieldModifiers();
        for (int j = 0; j < attributesCount; ++j) {
            ClassFileReader.Attribute attribute = this.cfr.openAttribute(this.pool);
            if (attribute.name.equals("ConstantValue")) {
                if (attribute.length != 2) {
                    throw this.cfr.formatError("ConstantValue attribute length is not 2");
                }
                if (constantValueIndex != 0) {
                    throw this.cfr.formatError("duplicate ConstantValue attribute");
                }
                constantValueIndex = this.cfr.readUnsignedShort("fld-ConstantValue");
                if (constantValueIndex == 0) {
                    throw this.cfr.formatError("bad ConstantValue index");
                }
                if ((modifiers & 8) == 0) {
                    constantValueIndex = 0;
                }
            } else if (attribute.name.equals("Synthetic")) {
                modifiers |= 0x8000;
            } else {
                attribute.skip();
            }
            attribute.close();
        }
        Object constantValue = this.getFieldConstantValue(fieldType, constantValueIndex);
        if (constantValue != null) {
            modifiers |= 0x4000;
            if (constantValue instanceof String) {
                field = new ClassFileConstantField(fieldName, modifiers, fieldType, (String)constantValue);
            } else {
                long value = 0L;
                if (constantValue instanceof Integer) {
                    value = ((Integer)constantValue).intValue();
                } else if (constantValue instanceof Long) {
                    value = (Long)constantValue;
                } else if (constantValue instanceof Double) {
                    value = Double.doubleToLongBits((Double)constantValue);
                } else if (constantValue instanceof Float) {
                    value = Float.floatToIntBits(((Float)constantValue).floatValue());
                } else {
                    Assert.shouldNotReachHere((String)("Unknown constant value type: " + constantValue));
                }
                field = new ClassFileConstantField(fieldName, modifiers, fieldType, value);
            }
        } else {
            field = new ClassFileField(fieldName, modifiers, fieldType);
        }
        if (this.traceClassInfo && Tracer.isTracing((String)"classinfo", (String)(this.klass.getName() + "." + fieldName))) {
            String constantStr = constantValue == null ? "" : "  (constantValue=" + constantValue + ")";
            String staticStr = field.isStatic() ? "static " : "";
            Tracer.traceln((String)("  field: " + staticStr + fieldType.getName() + " " + fieldName + constantStr));
        }
        return field;
    }

    private Object getFieldConstantValue(Klass fieldType, int constantValueIndex) {
        if (constantValueIndex != 0) {
            switch (fieldType.getSystemID()) {
                case 11: {
                    return this.pool.getEntry(constantValueIndex, 5);
                }
                case 13: {
                    return this.pool.getEntry(constantValueIndex, 4);
                }
                case 14: {
                    return this.pool.getEntry(constantValueIndex, 6);
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    return this.pool.getEntry(constantValueIndex, 3);
                }
                case 2: {
                    return this.pool.getEntry(constantValueIndex, 8);
                }
            }
            throw this.cfr.formatError("invalid ConstantValue attribute value");
        }
        return null;
    }

    private void loadMethods(ClassFileMethod[][] methodTables) {
        int count = this.cfr.readUnsignedShort("mth-count");
        if (count == 0 && (this.klass.isInterface() || this.klass.isAbstract())) {
            return;
        }
        SquawkVector virtualMethods = new SquawkVector(count);
        SquawkVector staticMethods = new SquawkVector(count);
        SquawkVector replacementConstructors = null;
        boolean hasConstructor = false;
        for (int i = 0; i < count; ++i) {
            ClassFileMethod method = this.loadMethod();
            if (!hasConstructor && Modifier.isConstructor((int)method.getModifiers())) {
                hasConstructor = true;
            }
            this.verifyMethodIsUnique(virtualMethods, method);
            this.verifyMethodIsUnique(staticMethods, method);
            if (PragmaException.isReplacementConstructor((int)method.getPragmas())) {
                if (replacementConstructors == null) {
                    replacementConstructors = new SquawkVector();
                }
                replacementConstructors.addElement((Object)method);
                continue;
            }
            if (method.isStatic()) {
                staticMethods.addElement((Object)method);
                continue;
            }
            virtualMethods.addElement((Object)method);
        }
        this.replaceConstructors(staticMethods, replacementConstructors);
        if (!(hasConstructor || this.klass.isAbstract() || this.klass.isInterface())) {
            ClassFileMethod method = new ClassFileMethod("<init>", 4105, this.klass, Klass.NO_CLASSES, 0);
            method.setCode(Code.SYNTHESIZED_DEFAULT_CONSTRUCTOR_CODE);
            staticMethods.addElement((Object)method);
        }
        methodTables[0] = this.getMethodTable(virtualMethods);
        methodTables[1] = this.getMethodTable(staticMethods);
        this.cf.setVirtualMethods(this.getCodeTable(virtualMethods));
        this.cf.setStaticMethods(this.getCodeTable(staticMethods));
    }

    private void replaceConstructors(SquawkVector methods, SquawkVector replacements) {
        boolean constructorsNeedReplacing;
        boolean bl = constructorsNeedReplacing = this.klass.isSquawkArray() && !this.klass.isArray();
        if (constructorsNeedReplacing) {
            for (int m = 0; m != methods.size(); ++m) {
                ClassFileMethod method = (ClassFileMethod)methods.elementAt(m);
                if (!Modifier.isConstructor((int)method.getModifiers())) continue;
                methods.setElementAt((Object)this.replaceConstructor(method, replacements), m);
            }
        }
    }

    private ClassFileMethod replaceConstructor(ClassFileMethod ctor, SquawkVector replacements) {
        if (replacements != null) {
            Klass[] types = ctor.getParameterTypes();
            Object[] matchTypes = new Klass[types.length + 1];
            System.arraycopy(types, 0, matchTypes, 1, types.length);
            matchTypes[0] = this.klass;
            Enumeration e = replacements.elements();
            while (e.hasMoreElements()) {
                ClassFileMethod method = (ClassFileMethod)e.nextElement();
                if (!Arrays.equals((Object[])matchTypes, (Object[])method.getParameterTypes())) continue;
                ctor = new ClassFileMethod("<init>", ctor.getModifiers() | 0x2000, ctor.getReturnType(), ctor.getParameterTypes(), ctor.getPragmas() | 2);
                ctor.setCode(method.getCode());
                return ctor;
            }
        }
        throw new VerifyError(this.prefix("could not match original constructor with a replacement constructor"));
    }

    private void verifyMethodIsUnique(SquawkVector methods, ClassFileMethod method) {
        Enumeration e = methods.elements();
        while (e.hasMoreElements()) {
            ClassFileMethod m = (ClassFileMethod)e.nextElement();
            if (!m.getName().equals(method.getName()) || !Arrays.equals((Object[])m.getParameterTypes(), (Object[])method.getParameterTypes()) || m.getReturnType() != method.getReturnType()) continue;
            throw this.cfr.formatError("duplicate method found");
        }
    }

    private ClassFileMethod[] getMethodTable(SquawkVector methods) {
        if (methods.isEmpty()) {
            return ClassFileMethod.NO_METHODS;
        }
        Object[] table = new ClassFileMethod[methods.size()];
        methods.copyInto(table);
        return table;
    }

    private Code[] getCodeTable(SquawkVector methods) {
        if (methods.isEmpty()) {
            return Code.NO_CODE;
        }
        Code[] table = new Code[methods.size()];
        int index = 0;
        Enumeration e = methods.elements();
        while (e.hasMoreElements()) {
            ClassFileMethod method = (ClassFileMethod)e.nextElement();
            if (!(PragmaException.isHosted((int)method.getPragmas()) || method.isAbstract() || method.isNative())) {
                byte[] code = method.getCode();
                Assert.that((code != null ? 1 : 0) != 0);
                table[index] = new Code(code);
            }
            ++index;
        }
        return table;
    }

    private ClassFileMethod loadMethod() {
        int modifiers = this.cfr.readUnsignedShort("mth-flags");
        int nameIndex = this.cfr.readUnsignedShort("mth-nameIndex");
        int descriptorIndex = this.cfr.readUnsignedShort("mth-descIndex");
        int attributesCount = this.cfr.readUnsignedShort("mth-AttbCount");
        String methodName = this.pool.getUtf8(nameIndex);
        String methodSig = this.pool.getUtf8(descriptorIndex);
        if (methodName.equals("<clinit>")) {
            modifiers = modifiers & 0x800 | 8;
        } else {
            this.pool.verifyMethodModifiers(modifiers, this.klass.getModifiers(), methodName.equals("<init>"));
            modifiers &= Modifier.getJVMMethodModifiers();
        }
        this.pool.verifyName(methodName, ConstantPool.ValidNameFormat.METHOD);
        MethodSignature methodSignature = this.pool.verifyMethodType(methodSig, methodName.endsWith("init>"), Modifier.isStatic((int)modifiers));
        if (methodName.equals("<init>")) {
            Assert.that((methodSignature.returnType == Klass.VOID ? 1 : 0) != 0);
            methodSignature = methodSignature.modifyReturnType(this.klass);
            modifiers |= 0x1008;
        }
        boolean hasCodeAttribute = false;
        boolean hasExceptionTable = false;
        int pragmas = 0;
        byte[] code = null;
        for (int j = 0; j < attributesCount; ++j) {
            ClassFileReader.Attribute attribute = this.cfr.openAttribute(this.pool);
            if (attribute.name.equals("Code")) {
                if (hasCodeAttribute) {
                    throw this.cfr.formatError("duplicate Code attribute in method");
                }
                hasCodeAttribute = true;
                if (!Modifier.isAbstract((int)modifiers) && !Modifier.isNative((int)modifiers)) {
                    code = new byte[attribute.length];
                    this.cfr.readFully(code, "code");
                } else {
                    attribute.skip();
                }
            } else if (attribute.name.equals("Exceptions")) {
                if (hasExceptionTable) {
                    throw this.cfr.formatError("duplicate Exceptions attribute in method");
                }
                hasExceptionTable = true;
                int numExceptions = this.cfr.readUnsignedShort("mth-att-num-exceptions");
                for (int i = 0; i < numExceptions; ++i) {
                    Klass exceptionClass = this.pool.getKlass(this.cfr.readUnsignedShort("mth-att-exception"));
                    pragmas |= PragmaException.toModifier((String)exceptionClass.getName());
                }
            } else if (attribute.name.equals("Synthetic")) {
                modifiers |= 0x8000;
            } else {
                attribute.skip();
            }
            attribute.close();
        }
        if ((Modifier.isAbstract((int)modifiers) || Modifier.isNative((int)modifiers)) == hasCodeAttribute) {
            if (hasCodeAttribute) {
                throw this.cfr.formatError("code attribute supplied for native or abstract method");
            }
            throw this.cfr.formatError("missing Code attribute for method");
        }
        if (pragmas != 0) {
            if (!(Modifier.isStatic((int)modifiers) || Modifier.isPrivate((int)modifiers) || Modifier.isFinal((int)modifiers) || this.klass.isFinal())) {
                throw this.cfr.formatError("method with pragma is not non-virtual: " + methodName);
            }
            modifiers |= 0x2000;
            if (PragmaException.isNative((int)pragmas)) {
                modifiers |= 0x100;
            }
        }
        ClassFileMethod method = new ClassFileMethod(methodName, modifiers, methodSignature.returnType, methodSignature.parameterTypes, pragmas);
        if (!Modifier.isNative((int)modifiers) && !PragmaException.isHosted((int)pragmas) && code != null) {
            method.setCode(code);
        }
        if (this.traceClassInfo && Tracer.isTracing((String)"classinfo", (String)(this.klass.getName() + "." + methodName))) {
            String staticStr = method.isStatic() ? "static " : "";
            Tracer.traceln((String)("  method: " + staticStr + this.klass.getName() + "." + methodName));
        }
        return method;
    }

    private String loadExtraAttributes() {
        int attributesCount = this.cfr.readUnsignedShort("ex-count");
        String sourceFile = null;
        boolean hasInnerClassesAttribute = false;
        for (int i = 0; i < attributesCount; ++i) {
            ClassFileReader.Attribute attribute = this.cfr.openAttribute(this.pool);
            if (attribute.name.equals("SourceFile")) {
                int index = this.cfr.readUnsignedShort("sourcefile-index");
                sourceFile = this.pool.getUtf8(index);
            } else if (attribute.name.equals("InnerClasses")) {
                if (hasInnerClassesAttribute) {
                    this.cfr.formatError("duplicate InnerClasses attribute in class");
                }
                hasInnerClassesAttribute = true;
                int count = this.cfr.readUnsignedShort("inc-number_of_classes");
                while (count-- != 0) {
                    this.cfr.readUnsignedShort("inc-inner_class_info_index");
                    this.cfr.readUnsignedShort("inc-outer_class_info_index");
                    this.cfr.readUnsignedShort("inc-inner_name_index");
                    this.cfr.readUnsignedShort("inc-inner_class_access_flags");
                }
            } else if (attribute.name.equals("Synthetic")) {
                this.klass.updateModifiers(32768);
            } else {
                attribute.skip();
            }
            attribute.close();
        }
        return sourceFile;
    }

    @Override
    public String prefix(String msg) {
        return this.klass.getName() + ": " + msg;
    }
}

