/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.translator.ci;

import com.sun.squawk.translator.ClassFormatError;
import com.sun.squawk.translator.ci.ConstantPool;
import com.sun.squawk.util.StructuredFileInputStream;
import java.io.InputStream;

public final class ClassFileReader
extends StructuredFileInputStream {
    public ClassFileReader(InputStream in, String filePath) {
        super(in, filePath, "classfile");
    }

    public Error formatError(String msg) {
        if (msg == null) {
            throw new ClassFormatError(this.getFileName());
        }
        throw new ClassFormatError(this.getFileName() + ": " + msg);
    }

    public Attribute openAttribute(ConstantPool pool) {
        int nameIndex = this.readUnsignedShort("attribute_name_index");
        int length = this.readInt("attribute_length");
        String name = pool.getUtf8(nameIndex);
        return new Attribute(length, this.getBytesRead(), name);
    }

    public final class Attribute {
        public final int length;
        public final String name;
        private final int start;

        Attribute(int length, int start, String name) {
            this.length = length;
            this.start = start;
            this.name = name;
        }

        public void skip() {
            ClassFileReader.this.skip(this.length, this.name);
        }

        public void close() {
            if (ClassFileReader.this.getBytesRead() - this.start != this.length) {
                ClassFileReader.this.formatError("invalid attribute_length for " + this.name + " attribute");
            }
        }
    }
}

