/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.translator.ci;

import com.sun.squawk.ExceptionHandler;
import com.sun.squawk.Field;
import com.sun.squawk.Klass;
import com.sun.squawk.Method;
import com.sun.squawk.ScopedLocalVariable;
import com.sun.squawk.VM;
import com.sun.squawk.translator.IllegalAccessError;
import com.sun.squawk.translator.InstantiationError;
import com.sun.squawk.translator.Translator;
import com.sun.squawk.translator.VerifyError;
import com.sun.squawk.translator.ci.ClassFileLoader;
import com.sun.squawk.translator.ci.ClassFileReader;
import com.sun.squawk.translator.ci.ConstantPool;
import com.sun.squawk.translator.ci.Context;
import com.sun.squawk.translator.ci.IndexedInputStream;
import com.sun.squawk.translator.ci.LocalVariableTableEntry;
import com.sun.squawk.translator.ci.Opcode;
import com.sun.squawk.translator.ci.StackMap;
import com.sun.squawk.translator.ci.UninitializedObjectClass;
import com.sun.squawk.translator.ir.Local;
import com.sun.squawk.translator.ir.Target;
import com.sun.squawk.translator.ir.instr.Catch;
import com.sun.squawk.translator.ir.instr.Position;
import com.sun.squawk.util.Arrays;
import com.sun.squawk.util.Assert;
import com.sun.squawk.util.Comparer;
import com.sun.squawk.util.IntHashtable;
import com.sun.squawk.util.SquawkHashtable;
import com.sun.squawk.util.SquawkVector;
import com.sun.squawk.util.Tracer;
import com.sun.squawk.vm.OPC;
import com.sun.squawk.vm.OperandStackEffect;
import java.io.ByteArrayInputStream;
import java.util.Enumeration;

public final class CodeParser
implements Context {
    private static final ExceptionHandler[] NO_EXCEPTIONHANDLERS = new ExceptionHandler[0];
    private final Method method;
    private final ConstantPool constantPool;
    private final int maxStack;
    private final int maxLocals;
    private final ExceptionHandler[] exceptionHandlers;
    private final byte[] exceptionHandlerInstructionAddressesSeen;
    private ClassFileReader cfr;
    private final IndexedInputStream bcin;
    private SquawkVector pseudoOpcodes = new SquawkVector();
    private int stackmaps;
    private final boolean trace;
    private SquawkHashtable UninitializedObjectClasses;
    private IntHashtable positions;
    private final SquawkVector localVariableTable;
    private final SquawkVector lineNumberTable;
    private final IntHashtable targets;
    public static final int T_BOOLEAN = 4;
    public static final int T_CHAR = 5;
    public static final int T_FLOAT = 6;
    public static final int T_DOUBLE = 7;
    public static final int T_BYTE = 8;
    public static final int T_SHORT = 9;
    public static final int T_INT = 10;
    public static final int T_LONG = 11;
    private int lastOpcodeAddress = -1;

    public CodeParser(Translator translator, Method method, byte[] code, ConstantPool constantPool) {
        this.method = method;
        this.constantPool = constantPool;
        this.trace = Tracer.isTracing((String)"classfile", (String)method.toString());
        Klass klass = method.getDefiningClass();
        String filePath = ClassFileLoader.getClassFilePath(klass);
        this.cfr = new ClassFileReader(new ByteArrayInputStream(code), filePath);
        this.maxStack = this.cfr.readUnsignedShort("cod-maxStack");
        this.maxLocals = this.cfr.readUnsignedShort("cod-maxLocals");
        if (this.maxLocals < method.getRuntimeParameterTypes(false).length) {
            throw this.cfr.formatError("the max_locals attribute must be at least as large as the size of the parameters.");
        }
        int codeLength = this.cfr.readInt("cod-length");
        if (codeLength <= 0) {
            throw this.cfr.formatError("the value of code_length must be greater than 0");
        }
        if (codeLength >= 65535) {
            throw this.cfr.formatError("method code longer than 64 KB");
        }
        this.bcin = new IndexedInputStream(code, 8, codeLength);
        this.cfr.skip(codeLength, null);
        int ehCount = this.cfr.readUnsignedShort("hnd-handlers");
        if (ehCount != 0) {
            this.exceptionHandlers = new ExceptionHandler[ehCount];
            this.exceptionHandlerInstructionAddressesSeen = new byte[ehCount];
            for (int i = 0; i < ehCount; ++i) {
                int startPC = this.cfr.readUnsignedShort("hnd-startPC");
                int endPC = this.cfr.readUnsignedShort("hnd-endPC");
                int handlerPC = this.cfr.readUnsignedShort("hnd-handlerPC");
                int catchIndex = this.cfr.readUnsignedShort("hnd-catchIndex");
                if (startPC >= codeLength || endPC > codeLength || startPC >= endPC || handlerPC >= codeLength) {
                    throw this.cfr.formatError("invalid exception handler code range");
                }
                Klass catchType = null;
                if (catchIndex != 0 && !Klass.THROWABLE.isAssignableFrom(catchType = constantPool.getResolvedClass(catchIndex, this))) {
                    throw this.verifyError("invalid exception handler type");
                }
                this.exceptionHandlers[i] = new ExceptionHandler(startPC, endPC, handlerPC, catchType);
            }
        } else {
            this.exceptionHandlers = NO_EXCEPTIONHANDLERS;
            this.exceptionHandlerInstructionAddressesSeen = null;
        }
        SquawkVector lvt = null;
        SquawkVector lnt = null;
        IntHashtable sm = null;
        int attributesCount = this.cfr.readUnsignedShort("cod-attributesCount");
        for (int i = 0; i < attributesCount; ++i) {
            ClassFileReader.Attribute attribute = this.cfr.openAttribute(constantPool);
            if (attribute.name.equals("StackMap")) {
                if (this.stackmaps != 0) {
                    this.cfr.formatError("multiple stackmap attributes specified for same method");
                }
                ++this.stackmaps;
                sm = StackMap.loadStackMap(this, this.cfr, constantPool, codeLength);
            } else if (attribute.name.equals("LineNumberTable")) {
                lnt = this.loadLineNumberTable(codeLength);
            } else if (attribute.name.equals("LocalVariableTable")) {
                lvt = this.loadLocalVariableTable(translator, codeLength);
            } else {
                attribute.skip();
            }
            attribute.close();
        }
        this.localVariableTable = lvt;
        this.lineNumberTable = lnt;
        this.targets = sm;
        this.cfr = new ClassFileReader(this.bcin, filePath);
    }

    public CodeParser reset(Translator translator) {
        return new CodeParser(translator, this.method, this.bcin.getBuffer(), this.constantPool);
    }

    public UninitializedObjectClass getUninitializedObjectClass(int address, Klass uninitializedType) {
        String name;
        UninitializedObjectClass klass;
        if (this.UninitializedObjectClasses == null) {
            this.UninitializedObjectClasses = new SquawkHashtable();
        }
        if ((klass = (UninitializedObjectClass)((Object)this.UninitializedObjectClasses.get((Object)(name = "-new@" + address + "-")))) == null) {
            klass = new UninitializedObjectClass(name, uninitializedType);
            this.UninitializedObjectClasses.put((Object)name, (Object)klass);
        } else if (!klass.hasInitializedTypeBeenSet()) {
            klass.setInitializedType(uninitializedType);
        }
        return klass;
    }

    public void verifyUninitializedObjectClassAddresses() {
        if (this.UninitializedObjectClasses != null) {
            Enumeration e = this.UninitializedObjectClasses.elements();
            while (e.hasMoreElements()) {
                if (((UninitializedObjectClass)((Object)e.nextElement())).hasInitializedTypeBeenSet()) continue;
                throw this.verifyError("invalid 'new' instruction address in stackmap entry");
            }
        }
    }

    private Position getPosition(int address) {
        Position position;
        if (this.positions == null) {
            this.positions = new IntHashtable();
        }
        if ((position = (Position)this.positions.get(address)) == null) {
            position = new Position(address);
            this.positions.put(address, (Object)position);
        }
        return position;
    }

    private Position[] sortPositions() {
        Assert.that((this.positions != null ? 1 : 0) != 0);
        Object[] sorted = new Position[this.positions.size()];
        Enumeration e = this.positions.elements();
        for (int i = 0; i != sorted.length; ++i) {
            sorted[i] = (Position)e.nextElement();
        }
        Arrays.sort((Object[])sorted, (Comparer)new Comparer(){

            public int compare(Object o1, Object o2) {
                return ((Position)o1).getBytecodeOffset() - ((Position)o2).getBytecodeOffset();
            }
        });
        return sorted;
    }

    private SquawkVector loadLocalVariableTable(Translator translator, int codeLength) {
        int count = this.cfr.readUnsignedShort("lvt-localVariableTableLength");
        SquawkVector table = new SquawkVector(count);
        for (int i = 0; i != count; ++i) {
            int start_pc = this.cfr.readUnsignedShort("lvt-startPC");
            if (start_pc >= codeLength) {
                throw this.cfr.formatError("start_pc of LocalVariableTable is out of range");
            }
            int length = this.cfr.readUnsignedShort("lvt-length");
            if (start_pc + length > codeLength) {
                throw this.cfr.formatError("start_pc+length of LocalVariableTable is out of range");
            }
            String name = this.constantPool.getUtf8(this.cfr.readUnsignedShort("lvt-nameIndex"));
            String desc = this.constantPool.getUtf8(this.cfr.readUnsignedShort("lvt-descriptorIndex"));
            Klass type = Klass.getClass((String)desc, (boolean)true);
            int index = this.cfr.readUnsignedShort("lvt-index");
            Position start = this.getPosition(start_pc);
            Position end = this.getPosition(start_pc + length);
            table.addElement((Object)new LocalVariableTableEntry(start, end, name, type, index));
        }
        return table;
    }

    public void localVariableAllocated(int address, Local local) {
        if (this.localVariableTable != null) {
            SquawkVector table = this.localVariableTable;
            Enumeration e = table.elements();
            while (e.hasMoreElements()) {
                LocalVariableTableEntry lve = (LocalVariableTableEntry)e.nextElement();
                if (!lve.matches(local.getJavacIndex(), address)) continue;
                lve.setLocal(local);
            }
        }
    }

    public ScopedLocalVariable[] getLocalVariableTable() {
        ScopedLocalVariable[] table = null;
        if (this.localVariableTable != null) {
            int paramSlotCount = this.method.getRuntimeParameterTypes(true).length;
            int length = 0;
            Enumeration e = this.localVariableTable.elements();
            while (e.hasMoreElements()) {
                LocalVariableTableEntry entry = (LocalVariableTableEntry)e.nextElement();
                if (entry.getSlot(paramSlotCount) == -1) continue;
                ++length;
            }
            table = new ScopedLocalVariable[length];
            int i = 0;
            Enumeration e2 = this.localVariableTable.elements();
            while (e2.hasMoreElements()) {
                LocalVariableTableEntry entry = (LocalVariableTableEntry)e2.nextElement();
                int start = entry.getStart().getBytecodeOffset();
                int lth = entry.getEnd().getBytecodeOffset() - start;
                int slot = entry.getSlot(paramSlotCount);
                if (slot == -1) continue;
                ScopedLocalVariable local = new ScopedLocalVariable(entry.getName(), entry.getType(), slot, start, lth);
                table[i++] = local;
            }
        }
        return table;
    }

    public Enumeration getLocalVariableTableEntries() {
        return this.localVariableTable == null ? null : this.localVariableTable.elements();
    }

    private SquawkVector loadLineNumberTable(int codeLength) {
        int length = this.cfr.readUnsignedShort("lin-lineNumberTableLength");
        SquawkVector table = new SquawkVector(length * 2);
        for (int i = 0; i < length; ++i) {
            int pc = this.cfr.readUnsignedShort("lnt-startPC");
            if (pc >= codeLength) {
                throw this.cfr.formatError(this.method + ": " + "start_pc of LineNumberTable is out of range");
            }
            int sourceLine = this.cfr.readUnsignedShort("lnt-lineNumber");
            Position position = this.getPosition(pc);
            table.addElement((Object)position);
            table.addElement((Object)new Integer(sourceLine));
        }
        return table;
    }

    public int getSourceLineNumber(int address) {
        int lno = -1;
        if (this.lineNumberTable != null) {
            Position position;
            Enumeration e = this.lineNumberTable.elements();
            while (e.hasMoreElements() && (position = (Position)e.nextElement()).getBytecodeOffset() <= address) {
                lno = (Integer)e.nextElement();
            }
        }
        return lno;
    }

    public int[] getLineNumberTable(byte[] code) {
        int[] table = null;
        if (this.lineNumberTable != null) {
            int[] emptyStackOffsets = CodeParser.getEmptyStackOffsets(code);
            table = new int[this.lineNumberTable.size() / 2];
            Enumeration e = this.lineNumberTable.elements();
            int i = 0;
            int j = 0;
            while (e.hasMoreElements()) {
                Position position = (Position)e.nextElement();
                int lineNo = (Integer)e.nextElement();
                int address = position.getPrevious() instanceof Catch ? position.getPrevious().getBytecodeOffset() : position.getBytecodeOffset();
                while (emptyStackOffsets[j] < address && j != emptyStackOffsets.length - 1) {
                    ++j;
                }
                if (address != emptyStackOffsets[j]) {
                    address = emptyStackOffsets[j];
                }
                Assert.that(((address & 0xFFFF) == address ? 1 : 0) != 0, (String)"address overflow");
                Assert.that(((lineNo & 0xFFFF) == lineNo ? 1 : 0) != 0, (String)"line number overflow");
                Assert.that((address != 0 ? 1 : 0) != 0, (String)"cannot set a breakpoint at an extend instruction");
                table[i++] = address << 16 | lineNo;
            }
            Assert.that((i == table.length ? 1 : 0) != 0);
        }
        return table;
    }

    public static int applyOperandStackEffect(int opcode, int stack) {
        String ose = OperandStackEffect.getEffect(opcode);
        boolean popping = true;
        int slotsPerLong = 2;
        block6: for (int i = 0; i != ose.length(); ++i) {
            char ch = ose.charAt(i);
            switch (ch) {
                case ':': {
                    popping = false;
                    continue block6;
                }
                case 'F': 
                case 'I': 
                case 'O': 
                case 'W': {
                    if (popping) {
                        --stack;
                        continue block6;
                    }
                    ++stack;
                    continue block6;
                }
                case 'D': 
                case 'L': {
                    if (popping) {
                        stack -= slotsPerLong;
                        continue block6;
                    }
                    stack += slotsPerLong;
                    continue block6;
                }
                case '*': {
                    Assert.that((boolean)popping);
                    stack = 0;
                    while (i + 1 != ose.length() && ose.charAt(i + 1) != ':') {
                        ++i;
                    }
                    continue block6;
                }
                default: {
                    Assert.shouldNotReachHere();
                }
            }
        }
        return stack;
    }

    public static int[] getEmptyStackOffsets(byte[] code) {
        int extra;
        int length;
        Assert.always((code.length < 65535 ? 1 : 0) != 0);
        StringBuffer buf = new StringBuffer(code.length / 2);
        int stack = 0;
        for (int ip = 0; ip < code.length; ip += length + extra) {
            if (stack == 0) {
                buf.append((char)ip);
            }
            int opcode = CodeParser.fetchUByte(code, ip);
            extra = 0;
            switch (opcode) {
                case 72: 
                case 73: 
                case 74: {
                    extra = 1;
                    opcode = CodeParser.fetchUByte(code, ip + 1) + 165;
                    break;
                }
                case 75: {
                    extra = 2;
                    opcode = 165 + CodeParser.fetchUByte(code, ip + 1);
                    break;
                }
                case 76: {
                    extra = 4;
                    opcode = 165 + CodeParser.fetchUByte(code, ip + 1);
                    break;
                }
                case 77: {
                    extra = 1;
                    opcode = CodeParser.fetchUByte(code, ip + 1) + 256;
                    break;
                }
                case 78: 
                case 79: 
                case 80: {
                    extra = 1;
                    opcode = CodeParser.fetchUByte(code, ip + 1) + 256 + 56;
                    break;
                }
                case 81: {
                    extra = 2;
                    opcode = 56 + CodeParser.fetchUByte(code, ip + 1);
                    break;
                }
                case 82: {
                    extra = 4;
                    opcode = 56 + CodeParser.fetchUByte(code, ip + 1);
                }
            }
            length = opcode == 193 ? CodeParser.calculateSwitchInstructionLength(code, ip, 4) : (opcode == 194 ? CodeParser.calculateSwitchInstructionLength(code, ip, 2) : OPC.getSize((int)opcode));
            Assert.always((length > 0 ? 1 : 0) != 0);
            stack = CodeParser.applyOperandStackEffect(opcode, stack);
        }
        int[] table = new int[buf.length()];
        for (int i = 0; i != table.length; ++i) {
            table[i] = buf.charAt(i);
        }
        return table;
    }

    private static int fetchUByte(byte[] code, int ip) {
        return code[ip] & 0xFF;
    }

    private static int fetchShort(byte[] code, int ip) {
        int b1 = code[ip++] & 0xFF;
        int b2 = code[ip++] & 0xFF;
        if (!VM.isBigEndian()) {
            return (short)(b2 << 8 | b1);
        }
        return (short)(b1 << 8 | b2);
    }

    private static int fetchInt(byte[] code, int ip) {
        int b1 = code[ip++] & 0xFF;
        int b2 = code[ip++] & 0xFF;
        int b3 = code[ip++] & 0xFF;
        int b4 = code[ip++] & 0xFF;
        if (!VM.isBigEndian()) {
            return b4 << 24 | b3 << 16 | b2 << 8 | b1;
        }
        return b1 << 24 | b2 << 16 | b3 << 8 | b4;
    }

    private static int calculateSwitchInstructionLength(byte[] code, int ip, int dataSize) {
        int high;
        int low;
        int padding = (dataSize - (ip + 1) % dataSize) % dataSize;
        ip += 1 + padding;
        if (dataSize == 2) {
            low = CodeParser.fetchShort(code, ip);
            high = CodeParser.fetchShort(code, ip + 2);
        } else {
            Assert.that((dataSize == 4 ? 1 : 0) != 0);
            low = CodeParser.fetchInt(code, ip);
            high = CodeParser.fetchInt(code, ip + 4);
        }
        int entries = high - low + 1;
        return 1 + padding + 3 * dataSize + entries * dataSize;
    }

    public Target getTarget(int address) {
        Target target;
        if (this.targets != null && (target = (Target)this.targets.get(address)) != null) {
            return target;
        }
        if (this.stackmaps == 0) {
            throw this.verifyError("missing stack map entry for address. Check that class file has been preverified for Java ME: " + this.cfr.getFileName());
        }
        throw this.verifyError("missing stack map entry for address");
    }

    public int getTargetCount() {
        return this.targets == null ? 0 : this.targets.size();
    }

    public Enumeration getTargets() {
        return this.targets == null ? null : this.targets.elements();
    }

    public PseudoOpcode[] getLastPseudoOpcodes() {
        Position position;
        PseudoOpcode pseudoOpcode;
        Target target;
        if (this.exceptionHandlers.length == 0 && this.targets == null && this.positions == null) {
            return null;
        }
        int address = this.lastOpcodeAddress;
        boolean isCatchAddress = false;
        if (this.exceptionHandlers.length != 0) {
            for (int i = 0; i != this.exceptionHandlers.length; ++i) {
                PseudoOpcode pseudoOpcode2;
                ExceptionHandler exceptionHandler = this.exceptionHandlers[i];
                if (exceptionHandler.getEnd() == address) {
                    pseudoOpcode2 = new PseudoOpcode(0, exceptionHandler, i);
                    this.pseudoOpcodes.addElement((Object)pseudoOpcode2);
                    int n = i;
                    this.exceptionHandlerInstructionAddressesSeen[n] = (byte)(this.exceptionHandlerInstructionAddressesSeen[n] + 1);
                }
                if (exceptionHandler.getStart() == address) {
                    pseudoOpcode2 = new PseudoOpcode(1, exceptionHandler, i);
                    this.pseudoOpcodes.addElement((Object)pseudoOpcode2);
                    int n = i;
                    this.exceptionHandlerInstructionAddressesSeen[n] = (byte)(this.exceptionHandlerInstructionAddressesSeen[n] + 1);
                }
                if (exceptionHandler.getHandler() != address) continue;
                if (!isCatchAddress) {
                    isCatchAddress = true;
                    pseudoOpcode2 = new PseudoOpcode(2, this.getTarget(address), -1);
                    this.pseudoOpcodes.addElement((Object)pseudoOpcode2);
                }
                int n = i;
                this.exceptionHandlerInstructionAddressesSeen[n] = (byte)(this.exceptionHandlerInstructionAddressesSeen[n] + 1);
            }
        }
        if (!isCatchAddress && this.targets != null && (target = (Target)this.targets.get(address)) != null) {
            pseudoOpcode = new PseudoOpcode(3, target, -1);
            this.pseudoOpcodes.addElement((Object)pseudoOpcode);
        }
        if (this.positions != null && (position = (Position)this.positions.get(address)) != null) {
            pseudoOpcode = new PseudoOpcode(4, position, -1);
            this.pseudoOpcodes.addElement((Object)pseudoOpcode);
        }
        switch (this.pseudoOpcodes.size()) {
            case 0: {
                return null;
            }
            case 1: {
                PseudoOpcode res = (PseudoOpcode)this.pseudoOpcodes.elementAt(0);
                this.pseudoOpcodes.removeAllElements();
                return new PseudoOpcode[]{res};
            }
        }
        Object[] opcodes = new PseudoOpcode[this.pseudoOpcodes.size()];
        this.pseudoOpcodes.copyInto(opcodes);
        if (opcodes.length > 1) {
            Arrays.sort((Object[])opcodes, (Comparer)PseudoOpcode.COMPARER);
        }
        this.pseudoOpcodes.removeAllElements();
        return opcodes;
    }

    public void verifyExceptionHandlerInstructionAddresses() {
        if (this.exceptionHandlerInstructionAddressesSeen != null) {
            for (int i = 0; i != this.exceptionHandlerInstructionAddressesSeen.length; ++i) {
                if (this.exceptionHandlerInstructionAddressesSeen[i] == 3) continue;
                throw this.verifyError("invalid start_pc, end_pc or handler_pc in exception handler");
            }
        }
    }

    public ExceptionHandler[] getExceptionHandlers() {
        return this.exceptionHandlers;
    }

    public int getMaxLocals() {
        return this.maxLocals;
    }

    public int getMaxStack() {
        return this.maxStack;
    }

    public Method getMethod() {
        return this.method;
    }

    @Override
    public String prefix(String msg) {
        if (this.lastOpcodeAddress != -1) {
            int lno = this.getSourceLineNumber(this.lastOpcodeAddress);
            if (lno != -1) {
                String sourceFile = this.method.getDefiningClass().getSourceFileName();
                msg = "@" + this.lastOpcodeAddress + " (" + sourceFile + ":" + lno + "):\n " + msg;
            } else {
                msg = "@" + this.lastOpcodeAddress + ":\n " + msg;
            }
        } else {
            msg = " -> " + msg;
        }
        return "while translating " + this.method + msg;
    }

    public NoClassDefFoundError verifyError(String msg) {
        throw new VerifyError(this.prefix(msg));
    }

    public int getLastOpcodeAddress() {
        return this.lastOpcodeAddress;
    }

    public int getCurrentIP() {
        return this.bcin.getCurrentIndex();
    }

    public boolean atEof() {
        if (this.bcin.available() == 0) {
            this.lastOpcodeAddress = this.bcin.getCurrentIndex();
            return true;
        }
        return false;
    }

    public int parseOpcode() {
        this.lastOpcodeAddress = this.bcin.getCurrentIndex();
        int opcode = this.cfr.readUnsignedByte(null);
        if (this.trace) {
            Tracer.traceln((String)("[" + this.lastOpcodeAddress + "]:opcode:" + Opcode.mnemonics[opcode]));
        }
        return opcode;
    }

    public int parseUnsignedByteOperand() {
        return this.cfr.readUnsignedByte("operand");
    }

    public int parseByteOperand() {
        return this.cfr.readByte("operand");
    }

    public int parseShortOperand() {
        return this.cfr.readShort("operand");
    }

    public int parseIntOperand() {
        return this.cfr.readInt("operand");
    }

    public Object parseConstantPoolOperand(boolean wide, boolean longOrDouble) {
        int index = wide ? this.cfr.readUnsignedShort("operand") : this.cfr.readUnsignedByte("operand");
        int tag = this.constantPool.getTag(index);
        if (longOrDouble) {
            if (tag != 5 && tag != 6) {
                throw this.verifyError("expected long or double constant");
            }
        } else if (tag != 3 && tag != 4 && tag != 8) {
            throw this.verifyError("expected int, float or string constant");
        }
        return this.constantPool.getEntry(index, tag);
    }

    public Field parseFieldOperand(boolean isStatic, int opcode) {
        int index = this.cfr.readUnsignedShort("operand");
        int tag = this.constantPool.getTag(index);
        if (tag != 9) {
            throw this.verifyError("invalid field reference");
        }
        Field field = this.constantPool.getResolvedField(index, isStatic, this);
        if (field.isFinal() && (opcode == 179 || opcode == 181) && field.getDefiningClass() != this.method.getDefiningClass()) {
            throw new IllegalAccessError(this.prefix("invalid assignment to final field"));
        }
        return field;
    }

    public Method parseMethodOperand(boolean isStatic, boolean invokeinterface) {
        int index = this.cfr.readUnsignedShort("operand");
        int tag = this.constantPool.getTag(index);
        if (tag != 10 && tag != 11) {
            throw this.verifyError("invalid method reference");
        }
        return this.constantPool.getResolvedMethod(index, isStatic, invokeinterface, this);
    }

    public Klass parseNewArrayOperand() {
        int tag = this.cfr.readUnsignedByte("operand");
        switch (tag) {
            case 4: {
                return Klass.BOOLEAN_ARRAY;
            }
            case 8: {
                return Klass.BYTE_ARRAY;
            }
            case 5: {
                return Klass.CHAR_ARRAY;
            }
            case 9: {
                return Klass.SHORT_ARRAY;
            }
            case 10: {
                return Klass.INT_ARRAY;
            }
            case 11: {
                return Klass.LONG_ARRAY;
            }
            case 6: {
                return Klass.FLOAT_ARRAY;
            }
            case 7: {
                return Klass.DOUBLE_ARRAY;
            }
        }
        throw this.verifyError("invalid array type");
    }

    public UninitializedObjectClass parseNewOperand() {
        int index = this.cfr.readUnsignedShort("operand");
        Klass type = this.constantPool.getResolvedClass(index, this);
        if (type.isArray()) {
            throw this.verifyError("can't create array with new");
        }
        if (type.isInterface() || type.isAbstract()) {
            throw new InstantiationError(this.prefix("can't instantiate " + type));
        }
        return this.getUninitializedObjectClass(this.lastOpcodeAddress, type);
    }

    public Klass parseClassOperand() {
        int index = this.cfr.readUnsignedShort("operand");
        return this.constantPool.getResolvedClass(index, this);
    }

    public int parseLocalVariableOperand(boolean wide, boolean longOrDouble) {
        int adjust;
        int index = wide ? this.cfr.readUnsignedShort("operand") : this.cfr.readUnsignedByte("operand");
        int n = adjust = longOrDouble ? 1 : 0;
        if (index + adjust >= this.maxLocals) {
            throw this.verifyError("invalid local variable index");
        }
        return index;
    }

    public Target parseBranchOperand(boolean wide) {
        int offset = wide ? this.cfr.readInt("operand") : this.cfr.readShort("operand");
        int address = this.lastOpcodeAddress + offset;
        return this.getTarget(address);
    }

    public void parseSwitchPadding() {
        while (this.bcin.getCurrentIndex() % 4 != 0) {
            int ch = this.cfr.readUnsignedByte("operand");
            if (ch == 0) continue;
            throw this.verifyError("tableswitch/lookupswitch instruction not padded with 0's");
        }
    }

    public static final class PseudoOpcode {
        public static final int TRYEND = 0;
        public static final int TRY = 1;
        public static final int CATCH = 2;
        public static final int TARGET = 3;
        public static final int POSITION = 4;
        private final int tag;
        private final int index;
        private final Object context;
        static Comparer COMPARER = new Comparer(){

            public int compare(Object o1, Object o2) {
                int tag2;
                if (o1 == o2) {
                    return 0;
                }
                PseudoOpcode po1 = (PseudoOpcode)o1;
                PseudoOpcode po2 = (PseudoOpcode)o2;
                int tag1 = po1.tag;
                if (tag1 < (tag2 = po2.tag)) {
                    return -1;
                }
                if (tag1 > tag2) {
                    return 1;
                }
                Assert.that((tag1 == 1 || tag1 == 0 ? 1 : 0) != 0, (String)"multiple incompatible pseudo opcodes at address");
                if (tag1 == 1) {
                    return po2.index - po1.index;
                }
                return po1.index - po2.index;
            }
        };

        PseudoOpcode(int tag, Object context, int index) {
            this.tag = tag;
            this.context = context;
            this.index = index;
        }

        public int getTag() {
            return this.tag;
        }

        public String toString() {
            return super.toString();
        }

        public Object getContext() {
            return this.context;
        }
    }
}

