/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.translator.ci;

import com.sun.squawk.Field;
import com.sun.squawk.Isolate;
import com.sun.squawk.Klass;
import com.sun.squawk.Method;
import com.sun.squawk.VM;
import com.sun.squawk.translator.ClassFormatError;
import com.sun.squawk.translator.IllegalAccessError;
import com.sun.squawk.translator.IncompatibleClassChangeError;
import com.sun.squawk.translator.NoSuchFieldError;
import com.sun.squawk.translator.NoSuchMethodError;
import com.sun.squawk.translator.Translator;
import com.sun.squawk.translator.ci.ClassFileReader;
import com.sun.squawk.translator.ci.Context;
import com.sun.squawk.translator.ci.MethodSignature;
import com.sun.squawk.util.Assert;
import com.sun.squawk.util.SquawkHashtable;
import com.sun.squawk.util.SquawkVector;

public class ConstantPool {
    public static final int CONSTANT_Utf8 = 1;
    public static final int CONSTANT_Unicode = 2;
    public static final int CONSTANT_Integer = 3;
    public static final int CONSTANT_Float = 4;
    public static final int CONSTANT_Long = 5;
    public static final int CONSTANT_Double = 6;
    public static final int CONSTANT_Class = 7;
    public static final int CONSTANT_String = 8;
    public static final int CONSTANT_Fieldref = 9;
    public static final int CONSTANT_Methodref = 10;
    public static final int CONSTANT_InterfaceMethodref = 11;
    public static final int CONSTANT_NameAndType = 12;
    public static final int CONSTANT_Object = 14;
    private final Translator translator;
    private final ClassFileReader cfr;
    private final Klass definedClass;
    private final byte[] tags;
    private final Object[] entries;
    private final SquawkHashtable methodSigCache;

    public Klass getDefinedClass() {
        return this.definedClass;
    }

    private void verifyEntry(int index, int tag) {
        if (index < 1 || index >= this.entries.length) {
            throw this.cfr.formatError("constant pool index out of range");
        }
        if (this.tags[index] != tag) {
            throw this.cfr.formatError("invalid constant pool entry type");
        }
    }

    private static int skipOverFieldName(String s, int offset, boolean slashOkay) {
        int i;
        char lastCh = '\u0000';
        for (i = offset; i != s.length(); ++i) {
            char ch;
            block8: {
                block7: {
                    block6: {
                        ch = s.charAt(i);
                        if (ch >= '\u0080') break block6;
                        if (!(ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z') && (lastCh == '\u0000' || ch < '0' || ch > '9')) break block7;
                        break block8;
                    }
                    if (lastCh == '\u0000') {
                        return -1;
                    }
                    break block8;
                }
                if (slashOkay && ch == '/' && lastCh != '\u0000') {
                    if (lastCh == '/') {
                        return -1;
                    }
                } else if (ch != '_' && ch != '$') {
                    return lastCh != '\u0000' ? i : -1;
                }
            }
            lastCh = ch;
        }
        return lastCh != '\u0000' ? i : -1;
    }

    private static int skipOverFieldType(String s, int offset, boolean voidOkay) {
        int length = s.length();
        int depth = 0;
        block6: for (int i = offset; i != length; ++i) {
            switch (s.charAt(i)) {
                case 'V': {
                    if (!voidOkay) {
                        return -1;
                    }
                }
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'Z': {
                    return i + 1;
                }
                case 'L': {
                    int end = ConstantPool.skipOverFieldName(s, i + 1, true);
                    if (end != -1 && end < length && s.charAt(end) == ';') {
                        return end + 1;
                    }
                    return -1;
                }
                case '[': {
                    if (depth++ == 255) {
                        return -1;
                    }
                    voidOkay = false;
                    continue block6;
                }
                default: {
                    return -1;
                }
            }
        }
        return -1;
    }

    public static boolean isLegalName(String name, ValidNameFormat format) {
        Assert.that((format != null ? 1 : 0) != 0);
        boolean result = false;
        int length = name.length();
        if (length > 0) {
            if (name.charAt(0) == '<') {
                result = format == ValidNameFormat.METHOD && (name.equals("<init>") || name.equals("<clinit>"));
            } else {
                int end = format == ValidNameFormat.CLASS && name.charAt(0) == '[' ? ConstantPool.skipOverFieldType(name, 0, false) : ConstantPool.skipOverFieldName(name, 0, format == ValidNameFormat.CLASS);
                result = end != -1 && end == name.length();
            }
        }
        return result;
    }

    public String verifyName(String name, ValidNameFormat format) {
        if (!ConstantPool.isLegalName(name, format)) {
            throw this.cfr.formatError("invalid " + format + " name");
        }
        return name;
    }

    public Klass verifyFieldType(String sig) {
        if (ConstantPool.skipOverFieldType(sig, 0, false) != sig.length()) {
            throw this.cfr.formatError("invalid field signature");
        }
        return Klass.getClass((String)sig, (boolean)true);
    }

    public MethodSignature verifyMethodType(String sig, boolean specialMethod, boolean isStatic) {
        MethodSignature signature = (MethodSignature)this.methodSigCache.get((Object)sig);
        if (signature == null) {
            Klass returnType = null;
            SquawkVector parameterTypes = new SquawkVector();
            int length = sig.length();
            if (length > 0 && sig.charAt(0) == '(') {
                int nextOffset;
                int offset = 1;
                while (offset < length && (nextOffset = ConstantPool.skipOverFieldType(sig, offset, false)) != -1) {
                    Klass parameterType = Klass.getClass((String)sig.substring(offset, nextOffset), (boolean)true);
                    parameterTypes.addElement((Object)parameterType);
                    offset = nextOffset;
                }
                if (offset < length && sig.charAt(offset) == ')') {
                    ++offset;
                    if (specialMethod) {
                        if (offset == length - 1 && sig.charAt(offset) == 'V') {
                            returnType = Klass.VOID;
                        }
                    } else if (ConstantPool.skipOverFieldType(sig, offset, true) == length) {
                        returnType = Klass.getClass((String)sig.substring(offset, length), (boolean)true);
                    }
                }
            }
            if (returnType == null) {
                signature = MethodSignature.INVALID;
            } else {
                Object[] classes = new Klass[parameterTypes.size()];
                parameterTypes.copyInto(classes);
                signature = new MethodSignature(returnType, (Klass[])classes);
            }
            this.methodSigCache.put((Object)sig, (Object)signature);
        }
        if (signature == MethodSignature.INVALID || signature.getParametersLength(isStatic) > 255) {
            throw this.cfr.formatError("invalid method signature");
        }
        return signature;
    }

    public int verifyClassModifiers(int modifiers) {
        boolean valid;
        int finalAndAbstract = 1040;
        if ((modifiers & 0x200) != 0) {
            valid = (modifiers & finalAndAbstract) == 1024;
        } else {
            boolean bl = valid = (modifiers & finalAndAbstract) != finalAndAbstract;
        }
        if (valid) {
            return modifiers;
        }
        throw this.cfr.formatError("invalid class modifiers " + modifiers);
    }

    public void verifyFieldModifiers(int modifiers, int classModifiers) {
        boolean valid;
        if ((classModifiers & 0x200) == 0) {
            int flags = modifiers & 7;
            valid = flags == 0 || (flags & ~(flags - 1)) == flags;
            int finalAndVolatile = 80;
            valid = valid && (modifiers & finalAndVolatile) != finalAndVolatile;
        } else {
            boolean bl = valid = modifiers == 25;
        }
        if (!valid) {
            throw this.cfr.formatError("invalid field modifiers");
        }
    }

    public void verifyMethodModifiers(int modifiers, int classModifiers, boolean isInit) {
        boolean valid;
        int flags = modifiers & 7;
        boolean bl = valid = flags == 0 || (flags & ~(flags - 1)) == flags;
        if (valid) {
            if ((classModifiers & 0x200) == 0) {
                if ((modifiers & 0x400) != 0 && (modifiers & 0x93A) != 0) {
                    valid = false;
                }
            } else {
                int abstractAndPublic = 1025;
                boolean bl2 = valid = (modifiers & 0x409) == 1025;
            }
            if (valid && isInit) {
                boolean bl3 = valid = (modifiers & 0xFFFFF7F8) == 0;
            }
        }
        if (!valid) {
            throw this.cfr.formatError("invalid method modifiers");
        }
    }

    public int getSize() {
        return this.entries.length;
    }

    public int getTag(int index) {
        if (index < 0 || index >= this.entries.length) {
            throw this.cfr.formatError("invalid constant index");
        }
        return this.tags[index];
    }

    public int getInt(int index) {
        this.verifyEntry(index, 3);
        return (Integer)this.entries[index];
    }

    public long getLong(int index) {
        this.verifyEntry(index, 5);
        return (Long)this.entries[index];
    }

    public float getFloat(int index) {
        this.verifyEntry(index, 4);
        return ((Float)this.entries[index]).floatValue();
    }

    public double getDouble(int index) {
        this.verifyEntry(index, 6);
        return (Double)this.entries[index];
    }

    public String getString(int index) {
        this.verifyEntry(index, 8);
        return (String)this.entries[index];
    }

    public String getUtf8(int index) {
        this.verifyEntry(index, 1);
        return (String)this.entries[index];
    }

    public Klass getKlass(int index) {
        this.verifyEntry(index, 7);
        if (this.entries[index] instanceof String) {
            Klass klass;
            String name = this.verifyName((String)this.entries[index], ValidNameFormat.CLASS);
            if (name.charAt(0) == '[') {
                klass = Klass.getClass((String)name, (boolean)true);
            } else {
                name = name.replace('/', '.');
                klass = Klass.getClass((String)name, (boolean)false);
            }
            this.entries[index] = klass;
        }
        return (Klass)this.entries[index];
    }

    public Object getEntry(int index, int tag) {
        this.verifyEntry(index, tag);
        return this.entries[index];
    }

    private NameAndType getNameAndType(int index) {
        return (NameAndType)this.entries[index];
    }

    public Klass getResolvedClass(int index, Context context) {
        Klass klass = this.getKlass(index);
        if (klass.getState() == 5) {
            throw new NoClassDefFoundError(context.prefix(klass.getName()));
        }
        this.translator.load(klass);
        Klass base = klass;
        while (base.isArray()) {
            base = base.getComponentType();
        }
        if (!base.isAccessibleFrom(this.definedClass)) {
            System.out.println("+++++++ DEREK HELP !!!");
            System.out.print(base);
            System.out.print(".isAccessible");
            System.out.println(this.definedClass);
            System.out.println("+++++++ DEREK HELP !!!");
        }
        return klass;
    }

    public Field getResolvedField(int index, boolean isStatic, Context context) {
        Field field;
        this.verifyEntry(index, 9);
        if (this.entries[index] instanceof FieldOrMethod) {
            FieldOrMethod entry = (FieldOrMethod)this.entries[index];
            Klass declaringClass = entry.getDefiningClass(this, context);
            NameAndType nt = this.getNameAndType(entry.nameAndTypeIndex);
            this.verifyName(nt.name, ValidNameFormat.FIELD);
            Klass type = this.verifyFieldType(nt.sig);
            field = declaringClass.lookupField(nt.name, type, isStatic);
            if (field == null) {
                field = declaringClass.lookupField(nt.name, type, !isStatic);
                if (field != null) {
                    throw new IncompatibleClassChangeError(context.prefix(field.toString()));
                }
                String message = nt.sig + ' ' + declaringClass.getName() + '.' + nt.name;
                throw new NoSuchFieldError(context.prefix(message));
            }
            this.translator.load(type);
            this.entries[index] = field;
            if (!field.isAccessibleFrom(this.definedClass)) {
                throw new IllegalAccessError(context.prefix(field.toString()));
            }
        } else {
            field = (Field)this.entries[index];
        }
        return field;
    }

    public Method getResolvedMethod(int index, boolean isStatic, boolean invokeinterface, Context context) {
        Method method;
        this.verifyEntry(index, invokeinterface ? 11 : 10);
        if (this.entries[index] instanceof FieldOrMethod) {
            FieldOrMethod entry = (FieldOrMethod)this.entries[index];
            Klass declaringClass = entry.getDefiningClass(this, context);
            NameAndType nt = this.getNameAndType(entry.nameAndTypeIndex);
            String name = nt.name;
            this.verifyName(name, ValidNameFormat.METHOD);
            boolean isSpecialMethod = !invokeinterface && name.endsWith("init>");
            MethodSignature sig = this.verifyMethodType(nt.sig, isSpecialMethod, isStatic);
            Klass returnType = sig.returnType;
            if (!invokeinterface && name.equals("<init>")) {
                sig = sig.modifyReturnType(declaringClass);
                isStatic = true;
            }
            if ((method = declaringClass.lookupMethod(name, sig.parameterTypes, returnType, this.definedClass, isStatic)) == null) {
                method = declaringClass.lookupMethod(name, sig.parameterTypes, returnType, this.definedClass, !isStatic);
                if (method != null) {
                    throw new IncompatibleClassChangeError(context.prefix(method.toString()));
                }
                String message = declaringClass.getName() + '.' + nt.name + nt.sig;
                throw new NoSuchMethodError(context.prefix(message));
            }
            if (invokeinterface != method.getDefiningClass().isInterface() && method.getDefiningClass() != Klass.OBJECT && (invokeinterface || !declaringClass.isAbstract() || declaringClass == method.getDefiningClass())) {
                String message = invokeinterface ? "invokeinterface cannot be applied to method '" + name + "' declared in " + declaringClass : "invokevirtual cannot be applied to method '" + name + "' declared in " + declaringClass;
                throw new IncompatibleClassChangeError(context.prefix(message));
            }
            this.translator.load(returnType);
            for (int i = 0; i != sig.parameterTypes.length; ++i) {
                this.translator.load(sig.parameterTypes[i]);
            }
            this.entries[index] = method;
            if (!method.isAccessibleFrom(this.definedClass)) {
                throw new IllegalAccessError(context.prefix(method.toString()));
            }
        } else {
            method = (Method)this.entries[index];
        }
        return method;
    }

    public ConstantPool(Translator translator, ClassFileReader cfr, Klass definedClass) {
        int i;
        this.translator = translator;
        this.methodSigCache = new SquawkHashtable();
        this.cfr = cfr;
        this.definedClass = definedClass;
        int count = cfr.readUnsignedShort("cp-count");
        this.tags = new byte[count];
        this.entries = new Object[count];
        int[] raw = new int[count];
        Isolate isolate = VM.getCurrentIsolate();
        block16: for (i = 1; i < count; ++i) {
            int tag = cfr.readUnsignedByte("cp-tag");
            this.tags[i] = (byte)tag;
            switch (tag) {
                case 1: {
                    this.entries[i] = cfr.readUTF("CONSTANT_Utf8");
                    continue block16;
                }
                case 3: {
                    this.entries[i] = new Integer(cfr.readInt("CONSTANT_Integer"));
                    continue block16;
                }
                case 4: {
                    this.entries[i] = new Float(cfr.readFloat("CONSTANT_Float"));
                    continue block16;
                }
                case 6: {
                    this.entries[i] = new Double(cfr.readDouble("CONSTANT_Double"));
                    if (++i != count) continue block16;
                    throw cfr.formatError("invalid 64 bit constant in constant pool");
                }
                case 5: {
                    this.entries[i] = new Long(cfr.readLong("CONSTANT_Long"));
                    if (++i != count) continue block16;
                    throw cfr.formatError("invalid 64 bit constant in constant pool");
                }
                case 7: 
                case 8: {
                    raw[i] = cfr.readUnsignedShort("CONSTANT_String/Class");
                    continue block16;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    raw[i] = cfr.readUnsignedShort("CONSTANT_F/M/I/N-1") << 16 | cfr.readUnsignedShort("CONSTANT_F/M/I/N-2") & 0xFFFF;
                    continue block16;
                }
                default: {
                    throw cfr.formatError("invalid constant pool entry");
                }
            }
        }
        for (i = 1; i < count; ++i) {
            try {
                switch (this.tags[i]) {
                    case 7: 
                    case 8: {
                        this.verifyEntry(raw[i], 1);
                        this.entries[i] = this.tags[i] == 8 ? Isolate.intern((String)((String)this.entries[raw[i]])) : this.entries[raw[i]];
                        raw[i] = 0;
                        break;
                    }
                    case 12: {
                        this.fixupNameAndType(i, raw, null);
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 11: {
                        int classNameAndType = raw[i];
                        int classIndex = classNameAndType >> 16;
                        int nameAndTypeIndex = classNameAndType & 0xFFFF;
                        this.verifyEntry(classIndex, 7);
                        this.verifyEntry(nameAndTypeIndex, 12);
                        ValidNameFormat format = this.tags[i] == 9 ? ValidNameFormat.FIELD : ValidNameFormat.METHOD;
                        NameAndType nt = this.fixupNameAndType(nameAndTypeIndex, raw, format);
                        if (this.tags[i] == 9) {
                            this.verifyFieldType(nt.sig);
                        } else {
                            this.verifyMethodType(nt.sig, nt.name.endsWith("init>"), true);
                            if (nt.name.startsWith("<") && !nt.name.equals("<init>")) {
                                throw new ClassFormatError("Illegal Method reference name " + nt.name);
                            }
                        }
                        this.entries[i] = new FieldOrMethod(classIndex, nameAndTypeIndex);
                        break;
                    }
                }
                continue;
            }
            catch (ArrayIndexOutOfBoundsException obe) {
                throw cfr.formatError("invalid constant pool index");
            }
        }
    }

    private NameAndType fixupNameAndType(int index, int[] raw, ValidNameFormat format) {
        if (this.entries[index] == null) {
            int nameAndType = raw[index];
            int nameIndex = nameAndType >> 16;
            int descriptorIndex = nameAndType & 0xFFFF;
            this.verifyEntry(nameIndex, 1);
            this.verifyEntry(descriptorIndex, 1);
            this.entries[index] = new NameAndType(this.getUtf8(nameIndex), (String)this.entries[descriptorIndex]);
        }
        NameAndType entry = (NameAndType)this.entries[index];
        if (format != null) {
            this.verifyName(entry.name, format);
        }
        return entry;
    }

    private static class FieldOrMethod {
        final int classIndex;
        final int nameAndTypeIndex;

        FieldOrMethod(int classIndex, int nameAndTypeIndex) {
            this.classIndex = classIndex;
            this.nameAndTypeIndex = nameAndTypeIndex;
        }

        Klass getDefiningClass(ConstantPool pool, Context context) {
            Klass klass = pool.getResolvedClass(this.classIndex, context);
            if (klass.isArray()) {
                throw pool.cfr.formatError("expected non-array class");
            }
            return klass;
        }
    }

    private static class NameAndType {
        final String name;
        final String sig;

        NameAndType(String name, String sig) {
            this.name = name;
            this.sig = sig;
        }
    }

    public static class ValidNameFormat {
        private static int nextValue = 1;
        public final String asString;
        public final int value;
        public static final ValidNameFormat CLASS = new ValidNameFormat("class");
        public static final ValidNameFormat FIELD = new ValidNameFormat("field");
        public static final ValidNameFormat METHOD = new ValidNameFormat("method");

        private ValidNameFormat(String asString) {
            this.asString = asString;
            this.value = nextValue++;
        }

        public String toString() {
            return this.asString;
        }
    }
}

