/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.translator.ci;

import com.sun.squawk.Klass;
import com.sun.squawk.translator.ir.Local;
import com.sun.squawk.translator.ir.instr.Position;
import com.sun.squawk.util.Assert;

public class LocalVariableTableEntry {
    private final Position start;
    private final Position end;
    private final String name;
    private final Klass type;
    private final int index;
    private Local local;

    LocalVariableTableEntry(Position start, Position end, String name, Klass type, int index) {
        this.start = start;
        this.end = end;
        this.name = name;
        this.type = type;
        this.index = index;
    }

    public String getName() {
        return this.name;
    }

    public Klass getType() {
        return this.type;
    }

    public void setLocal(Local local) {
        Assert.that((this.local == null || this.local == local ? 1 : 0) != 0, (String)"cannot overwrite local");
        this.local = local;
    }

    public int getIndex() {
        return this.index;
    }

    public int getSlot(int paramSlotCount) {
        if (this.local == null) {
            return -1;
        }
        if (this.local.isParameter()) {
            return this.local.getSquawkParameterIndex();
        }
        return this.local.getSquawkLocalIndex() + paramSlotCount;
    }

    public Position getStart() {
        return this.start;
    }

    public Position getEnd() {
        return this.end;
    }

    public boolean matches(int index, int address) {
        return this.index == index && this.start.getBytecodeOffset() <= address && address < this.end.getBytecodeOffset();
    }
}

