/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.translator.ci;

import com.sun.squawk.Klass;
import com.sun.squawk.translator.ci.ClassFileReader;
import com.sun.squawk.translator.ci.CodeParser;
import com.sun.squawk.translator.ci.ConstantPool;
import com.sun.squawk.translator.ir.Target;
import com.sun.squawk.util.Assert;
import com.sun.squawk.util.IntHashtable;
import com.sun.squawk.util.Tracer;

public class StackMap {
    public static final int ITEM_Top = 0;
    public static final int ITEM_Integer = 1;
    public static final int ITEM_Float = 2;
    public static final int ITEM_Double = 3;
    public static final int ITEM_Long = 4;
    public static final int ITEM_Null = 5;
    public static final int ITEM_UninitializedThis = 6;
    public static final int ITEM_Object = 7;
    public static final int ITEM_Uninitialized = 8;

    public static IntHashtable loadStackMap(CodeParser codeParser, ClassFileReader cfr, ConstantPool constantPool, int codeLength) {
        int nmaps = cfr.readUnsignedShort("map-nmaps");
        if (nmaps == 0) {
            return null;
        }
        IntHashtable table = new IntHashtable(nmaps + nmaps / 4 + 1);
        int lastAddress = -1;
        boolean trace = Tracer.isTracing((String)"maps", (String)codeParser.getMethod().toString());
        for (int i = 0; i < nmaps; ++i) {
            int address = cfr.readUnsignedShort("map-address");
            if (address <= lastAddress) {
                throw cfr.formatError("stack map ip addresses not in order");
            }
            lastAddress = address;
            Klass[] locals = StackMap.loadStackMapList(codeParser, cfr, constantPool, codeLength);
            if (locals.length > codeParser.getMaxLocals()) {
                throw cfr.formatError("stack map locals greater than max_locals");
            }
            Klass[] stack = StackMap.loadStackMapList(codeParser, cfr, constantPool, codeLength);
            if (stack.length > codeParser.getMaxStack()) {
                throw cfr.formatError("stack map stack greater than max_stack");
            }
            Target target = new Target(address, stack, locals);
            table.put(address, (Object)target);
            if (!trace) continue;
            Tracer.traceln((String)("Stackmap @" + target));
        }
        return table;
    }

    private static Klass[] loadStackMapList(CodeParser codeParser, ClassFileReader cfr, ConstantPool constantPool, int codeLength) {
        int items = cfr.readUnsignedShort("map-items");
        if (items == 0) {
            return Klass.NO_CLASSES;
        }
        Klass[] list = new Klass[items];
        int size = items;
        block11: for (int item = 0; item < items; ++item) {
            int tag = cfr.readByte("map-tag");
            switch (tag) {
                case 0: {
                    list[item] = Klass.TOP;
                    continue block11;
                }
                case 1: {
                    list[item] = Klass.INT;
                    continue block11;
                }
                case 4: {
                    list[item] = Klass.LONG;
                    ++size;
                    continue block11;
                }
                case 2: {
                    list[item] = Klass.FLOAT;
                    continue block11;
                }
                case 3: {
                    list[item] = Klass.DOUBLE;
                    ++size;
                    continue block11;
                }
                case 5: {
                    list[item] = Klass.NULL;
                    continue block11;
                }
                case 6: {
                    list[item] = Klass.UNINITIALIZED_THIS;
                    continue block11;
                }
                case 7: {
                    int classIndex = cfr.readUnsignedShort("map-ITEM_Object");
                    list[item] = constantPool.getResolvedClass(classIndex, codeParser);
                    continue block11;
                }
                case 8: {
                    int address = cfr.readUnsignedShort("map-ITEM_Uninitialized");
                    if (address >= codeLength) {
                        throw cfr.formatError("start_pc of LineNumberTable is out of range");
                    }
                    list[item] = codeParser.getUninitializedObjectClass(address, null);
                    continue block11;
                }
                default: {
                    throw cfr.formatError("Bad stack map item tag: " + tag);
                }
            }
        }
        if (size != items) {
            Klass[] newList = new Klass[size];
            int javacIndex = 0;
            for (int j = 0; j < items; ++j) {
                Klass type = list[j];
                newList[javacIndex++] = type;
                if (!type.isDoubleWord()) continue;
                newList[javacIndex++] = Klass.getSecondWordType((Klass)type);
            }
            Assert.that((javacIndex == size ? 1 : 0) != 0);
            list = newList;
        }
        return list;
    }
}

