/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.translator.ir;

import com.sun.squawk.Klass;
import com.sun.squawk.Method;
import com.sun.squawk.translator.ci.CodeParser;
import com.sun.squawk.translator.ci.LocalVariableTableEntry;
import com.sun.squawk.translator.ci.Opcode;
import com.sun.squawk.translator.ir.Local;
import com.sun.squawk.translator.ir.Target;
import com.sun.squawk.translator.ir.instr.StackMerge;
import com.sun.squawk.translator.ir.instr.StackProducer;
import com.sun.squawk.util.Arrays;
import com.sun.squawk.util.Assert;
import com.sun.squawk.util.IntHashtable;
import com.sun.squawk.util.Tracer;
import java.util.Enumeration;

public final class Frame {
    private final CodeParser codeParser;
    private Target finallyTargetForSynchronizedMethod;
    private IntHashtable localValues;
    private final Klass[] localTypes;
    private final int parameterLocalsCount;
    private StackProducer[] stack;
    private int sp;
    private int maxStack;
    private int nextSpillLocalId;

    public Frame(CodeParser codeParser, int extraLocals) {
        Klass parameterType;
        int i;
        this.maxStack = codeParser.getMaxStack();
        this.codeParser = codeParser;
        this.stack = new StackProducer[this.maxStack];
        this.localTypes = new Klass[codeParser.getMaxLocals() + extraLocals];
        Method method = codeParser.getMethod();
        Klass[] parameterTypes = method.getParameterTypes();
        Local[] parameterLocals = null;
        if (method.isInterpreterInvoked()) {
            parameterLocals = new Local[parameterTypes.length];
        }
        int javacIndex = 0;
        if (!method.isStatic() || method.isConstructor()) {
            Assert.that((parameterLocals == null ? 1 : 0) != 0);
            Klass thisType = method.getDefiningClass();
            if (method.isConstructor() && thisType != Klass.OBJECT) {
                thisType = Klass.UNINITIALIZED_THIS;
            }
            Local thisLocal = this.allocateParameter(thisType, javacIndex);
            this.store(javacIndex, thisType, thisLocal);
            ++javacIndex;
        }
        int parameterIndex = javacIndex;
        for (i = 0; i < parameterTypes.length; ++i) {
            parameterType = parameterTypes[i];
            Local parameterLocal = this.allocateParameter(parameterType, javacIndex);
            if (parameterLocals != null) {
                parameterLocals[i] = parameterLocal;
            }
            this.store(javacIndex, parameterType, parameterLocal);
            javacIndex += parameterType.isDoubleWord() ? 2 : 1;
        }
        this.parameterLocalsCount = javacIndex;
        if (parameterLocals != null) {
            parameterIndex = 0;
            for (i = parameterTypes.length - 1; i >= 0; --i) {
                parameterType = parameterTypes[i];
                parameterLocals[i].setParameterIndex(parameterIndex++);
                if (!parameterType.isDoubleWord()) continue;
                ++parameterIndex;
            }
        }
        while (javacIndex < this.localTypes.length) {
            this.localTypes[javacIndex++] = Klass.TOP;
        }
    }

    public boolean containsType(Klass type) {
        int i;
        for (i = 0; i < this.localTypes.length; ++i) {
            if (!type.isAssignableFrom(this.localTypes[i])) continue;
            return true;
        }
        for (i = 0; i < this.sp; ++i) {
            StackProducer producer = this.stack[i];
            if (producer == null || !type.isAssignableFrom(producer.getType())) continue;
            return true;
        }
        return false;
    }

    public void replaceTypeWithType(Klass fromType, Klass toType) {
        int i;
        for (i = 0; i < this.localTypes.length; ++i) {
            if (this.localTypes[i] != fromType) continue;
            this.localTypes[i] = toType;
        }
        for (i = 0; i < this.sp; ++i) {
            StackProducer producer = this.stack[i];
            if (producer == null || producer.getType() != fromType) continue;
            producer.updateType(toType);
        }
    }

    public Target createFinallyTargetForSynchronizedMethod() {
        Assert.that((this.finallyTargetForSynchronizedMethod == null ? 1 : 0) != 0);
        Klass[] stack = new Klass[]{Klass.THROWABLE};
        Klass[] parameterLocals = new Klass[this.parameterLocalsCount];
        for (int i = 0; i < this.parameterLocalsCount; ++i) {
            parameterLocals[i] = this.getParameterTypeFor(this.getDerivedLocalTypeAt(i));
        }
        this.finallyTargetForSynchronizedMethod = new Target(999999, stack, parameterLocals);
        return this.finallyTargetForSynchronizedMethod;
    }

    public int getParameterLocalsCount() {
        return this.parameterLocalsCount;
    }

    public int getLocalsCount() {
        return this.localTypes.length;
    }

    public static Klass getLocalTypeFor(Klass type) {
        switch (type.getSystemID()) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return Klass.INT;
            }
            case 11: 
            case 13: 
            case 14: {
                return type;
            }
            case 34: 
            case 36: 
            case 38: {
                return type;
            }
        }
        Assert.that((boolean)Klass.REFERENCE.isAssignableFrom(type));
        return Klass.REFERENCE;
    }

    private Klass getParameterTypeFor(Klass type) {
        if (type == Klass.LONG2 || type == Klass.DOUBLE2) {
            return type;
        }
        return Frame.getLocalTypeFor(type);
    }

    public Local allocateLocal(Klass type, int index) {
        return this.allocateLocalPrim(type, index, false);
    }

    private Local allocateParameter(Klass type, int index) {
        return this.allocateLocalPrim(type, index, true);
    }

    private String getBadAddressLocalVariableMessage(int index, Klass type1, Klass type2) {
        Assert.that((type1.isSquawkPrimitive() || type2.isSquawkPrimitive() ? 1 : 0) != 0);
        if (type2.isSquawkPrimitive()) {
            Klass otherType = type1;
            type1 = type2;
            type2 = otherType;
        }
        StringBuffer buf = new StringBuffer("Stack location " + index + " cannot be used for both a local variable of type " + type1.getName() + " and of type " + type2.getName() + ". Try moving the variable of type " + type1.getName() + " to the top-most scope of the method.");
        Enumeration e = this.codeParser.getLocalVariableTableEntries();
        if (e != null) {
            buf.append(" (source code usage: ");
            while (e.hasMoreElements()) {
                LocalVariableTableEntry entry = (LocalVariableTableEntry)e.nextElement();
                if (entry.getIndex() != index) continue;
                int start = this.codeParser.getSourceLineNumber(entry.getStart().getBytecodeOffset());
                int end = this.codeParser.getSourceLineNumber(entry.getEnd().getBytecodeOffset());
                buf.append(entry.getType().getName()).append(' ').append(entry.getName()).append(" from line ").append(start).append(" to line ").append(end).append(';');
            }
        }
        return buf.toString();
    }

    private Local allocateLocalPrim(Klass type, int index, boolean isParameter) {
        Local local;
        Assert.that((this.localTypes.length < 65535 ? 1 : 0) != 0);
        Assert.that((index >= 0 && index < this.localTypes.length ? 1 : 0) != 0, (String)("index=" + index + " localTypes.length=" + this.localTypes.length));
        Klass localType = Frame.getLocalTypeFor(type);
        int key = localType.getSuiteID();
        if (localType.isSquawkPrimitive()) {
            key = Klass.REFERENCE.getSuiteID();
        }
        key = key << 16 | index;
        if (this.localValues == null) {
            this.localValues = new IntHashtable();
        }
        if ((local = (Local)this.localValues.get(key)) == null) {
            local = new Local(localType, index, isParameter);
            this.localValues.put(key, (Object)local);
        }
        if ((localType.isSquawkPrimitive() || local.getType().isSquawkPrimitive()) && localType != local.getType()) {
            throw this.codeParser.verifyError(this.getBadAddressLocalVariableMessage(index, localType, local.getType()));
        }
        this.codeParser.localVariableAllocated(this.codeParser.getCurrentIP(), local);
        return local;
    }

    public boolean isLocalInitialized(int index) {
        Assert.that((index >= 0 && index < this.localTypes.length ? 1 : 0) != 0);
        return this.localTypes[index] != Klass.TOP;
    }

    public void verifyLocalVariableIndex(Klass type, int index) {
        if (index < 0) {
            throw this.codeParser.verifyError("invalid local variable index");
        }
        if (type.isDoubleWord()) {
            ++index;
        }
        if (index >= this.localTypes.length) {
            throw this.codeParser.verifyError("invalid local variable index");
        }
    }

    public void verifyUseOfSquawkPrimitive(Klass type1, Klass type2) {
        if ((type1.isSquawkPrimitive() || type2.isSquawkPrimitive()) && type1 != type2) {
            String type = type1.getName();
            throw this.codeParser.verifyError(type + " values can only be written to or compared with other " + type + " values, not with " + type2.getName());
        }
    }

    public Klass getDerivedLocalTypeAt(int index) {
        Assert.that((index >= 0 && index < this.localTypes.length ? 1 : 0) != 0);
        return this.localTypes[index];
    }

    public void store(int index, Klass type, Local local) {
        Klass localType = local.getType();
        Assert.that((localType.isAssignableFrom(type) || localType == Frame.getLocalTypeFor(type) ? 1 : 0) != 0);
        this.verifyLocalVariableIndex(localType, index);
        this.localTypes[index] = type;
        if (localType.isDoubleWord()) {
            this.localTypes[index + 1] = Klass.getSecondWordType((Klass)localType);
        } else {
            this.verifyUseOfSquawkPrimitive(localType, type);
        }
    }

    public Local load(int index, Klass localType) {
        Klass secondWordType;
        this.verifyLocalVariableIndex(localType, index);
        Klass derivedType = this.localTypes[index];
        if (!localType.isAssignableFrom(derivedType)) {
            throw this.codeParser.verifyError("incompatible type in local variable");
        }
        if (localType.isDoubleWord() && !(secondWordType = Klass.getSecondWordType((Klass)localType)).isAssignableFrom(this.localTypes[index + 1])) {
            throw this.codeParser.verifyError("incompatible type in local variable");
        }
        if (derivedType.isSquawkPrimitive()) {
            localType = derivedType;
        }
        return this.allocateLocal(localType, index);
    }

    public void mergeLocals(Target target, boolean replaceWithTarget) {
        Klass[] recordedTypes = target.getLocals();
        if (recordedTypes.length > this.localTypes.length) {
            throw this.codeParser.verifyError("size of recorded and derived local variable array differs");
        }
        for (int i = 0; i < recordedTypes.length; ++i) {
            Klass recordedType = recordedTypes[i];
            Klass derivedType = this.localTypes[i];
            if (!(recordedType.isAssignableFrom(derivedType) || recordedType.isInterface() && !derivedType.isPrimitive())) {
                throw this.codeParser.verifyError("invalid type in local variable");
            }
            if (!replaceWithTarget) continue;
            this.localTypes[i] = recordedType;
        }
    }

    public void resetLocals(Target target) {
        Klass[] types;
        int i;
        Klass[] recordedTypes = target.getLocals();
        for (i = 0; i < recordedTypes.length; ++i) {
            this.localTypes[i] = recordedTypes[i];
        }
        while (i < this.localTypes.length) {
            this.localTypes[i++] = Klass.TOP;
        }
        if (this.finallyTargetForSynchronizedMethod != null && (types = this.finallyTargetForSynchronizedMethod.getLocals()).length > recordedTypes.length) {
            for (i = recordedTypes.length; i != types.length; ++i) {
                this.localTypes[i] = types[i];
            }
        }
    }

    public void growMaxStack(int amount) {
        Assert.that((amount > 0 ? 1 : 0) != 0);
        int growth = this.sp + amount - this.maxStack;
        if (growth > 0) {
            this.maxStack += growth;
            this.ensureStack(this.maxStack);
        }
    }

    public void resetMaxStack() {
        this.maxStack = this.codeParser.getMaxStack();
    }

    private void ensureStack(int limit) {
        if (limit > this.stack.length) {
            this.stack = (StackProducer[])Arrays.copy((Object[])this.stack, (int)0, (Object[])new StackProducer[limit], (int)0, (int)this.stack.length);
        }
    }

    public int getMaxStack() {
        return this.stack.length;
    }

    public void push(StackProducer producer) {
        Klass type = producer.getType();
        Assert.that((type != Klass.VOID ? 1 : 0) != 0);
        if (this.sp == this.maxStack) {
            throw this.codeParser.verifyError("operand stack overflow");
        }
        this.stack[this.sp++] = producer;
        if (type.isDoubleWord()) {
            if (this.sp == this.maxStack) {
                throw this.codeParser.verifyError("operand stack overflow");
            }
            this.stack[this.sp++] = null;
        }
    }

    public StackProducer pop(Klass type) {
        StackProducer producer;
        if (type.isDoubleWord()) {
            if (this.sp < 2) {
                throw this.codeParser.verifyError("operand stack underflow");
            }
            if (!this.isTopDoubleWord()) {
                throw this.codeParser.verifyError("incompatible type on operand stack " + this.tosKlassName());
            }
            this.sp -= 2;
            producer = this.stack[this.sp];
        } else {
            if (this.sp < 1) {
                throw this.codeParser.verifyError("operand stack underflow");
            }
            if (this.isTopDoubleWord()) {
                throw this.codeParser.verifyError("incompatible type on operand stack " + this.tosKlassName());
            }
            producer = this.stack[--this.sp];
            if (type.isPrimitive() && type != Klass.FLOAT) {
                type = Klass.INT;
            }
        }
        Assert.that((producer != null ? 1 : 0) != 0);
        if (type.isInterface()) {
            type = Klass.OBJECT;
        }
        if (!type.isAssignableFrom(producer.getType())) {
            throw this.codeParser.verifyError("incompatible type: '" + type + "' is not assignable from '" + producer.getType() + "'");
        }
        return producer;
    }

    public int getStackSize() {
        return this.sp;
    }

    public StackProducer getStackAt(int index) {
        Assert.that((index < this.sp ? 1 : 0) != 0, (String)"index out of bounds");
        Assert.that((this.stack[index] != null ? 1 : 0) != 0, (String)"cannot index the second word of a double word value");
        return this.stack[index];
    }

    public StackProducer getTopOfStack() {
        if (this.isTopDoubleWord()) {
            Assert.that((this.stack[this.sp - 2] != null ? 1 : 0) != 0);
            return this.stack[this.sp - 2];
        }
        if (this.sp > 0) {
            Assert.that((this.stack[this.sp - 1] != null ? 1 : 0) != 0);
            return this.stack[this.sp - 1];
        }
        return null;
    }

    public Klass getStackTypeAt(int index) {
        Assert.that((index < this.sp ? 1 : 0) != 0, (String)"index out of bounds");
        if (this.stack[index] == null) {
            return Klass.getSecondWordType((Klass)this.stack[index - 1].getType());
        }
        return this.stack[index].getType();
    }

    public void mergeStack(Target target, boolean replaceWithTarget) {
        Klass[] recordedTypes = target.getStack();
        if (recordedTypes.length != this.getStackSize()) {
            throw this.codeParser.verifyError("size of recorded and derived stack differs");
        }
        int r = 0;
        int d = 0;
        while (r < recordedTypes.length) {
            Klass recordedType = recordedTypes[r];
            Klass derivedType = this.getStackTypeAt(d);
            if (!(recordedType.isAssignableFrom(derivedType) || recordedType.isInterface() && Klass.OBJECT.isAssignableFrom(derivedType))) {
                throw this.codeParser.verifyError("invalid type on operand stack @ " + d + ": expected " + recordedType + ", received " + derivedType);
            }
            ++r;
            ++d;
        }
        target.merge(this);
        if (replaceWithTarget) {
            this.resetStack(target, false);
        }
    }

    public void resetStack(Target target, boolean isForCatch) {
        Klass[] recordedTypes = target.getStack();
        if (!isForCatch) {
            this.sp = 0;
            if (recordedTypes.length != 0) {
                boolean isBackwardBranchTarget;
                StackProducer[] derivedStack = target.getDerivedStack();
                boolean bl = isBackwardBranchTarget = derivedStack[0] == null;
                if (isBackwardBranchTarget) {
                    for (int i = 0; i < recordedTypes.length; ++i) {
                        Klass recordedType = recordedTypes[i];
                        if (recordedType == Klass.LONG2 || recordedType == Klass.DOUBLE2) continue;
                        StackMerge merge = new StackMerge(recordedType);
                        Assert.that((derivedStack[0] == null || !derivedStack[0].isOnStack() ? 1 : 0) != 0);
                        derivedStack[0] = merge;
                        this.push(merge);
                    }
                } else {
                    while (this.sp != derivedStack.length) {
                        StackProducer producer = derivedStack[this.sp];
                        this.stack[this.sp++] = producer;
                    }
                }
            }
        } else {
            this.sp = 0;
        }
    }

    public Local allocateLocalForSpill(StackProducer producer) {
        Klass type = Frame.getLocalTypeFor(producer.getType());
        return new Local(type, --this.nextSpillLocalId, false);
    }

    public void spill(StackProducer producer) {
        if (!producer.isSpilt()) {
            producer.spill(this.allocateLocalForSpill(producer));
        }
    }

    public void spillStack() {
        for (int i = 0; i < this.sp; ++i) {
            StackProducer producer = this.stack[i];
            if (producer == null) continue;
            this.spill(producer);
        }
    }

    private String tosKlassName() {
        StackProducer top = this.stack[this.sp - (this.isTopDoubleWord() ? 2 : 1)];
        if (top == null) {
            return "null";
        }
        return top.getType().getInternalName();
    }

    public boolean isTopDoubleWord() {
        return this.sp > 1 && this.stack[this.sp - 1] == null;
    }

    public void doStackOp(int opcode) {
        switch (opcode) {
            case 89: {
                StackProducer x1 = this.pop(Klass.ONE_WORD);
                this.push(x1);
                this.push(x1);
                x1.setDuped(this);
                break;
            }
            case 92: {
                if (!this.isTopDoubleWord()) {
                    StackProducer x1 = this.pop(Klass.ONE_WORD);
                    StackProducer x2 = this.pop(Klass.ONE_WORD);
                    this.push(x2);
                    this.push(x1);
                    this.push(x2);
                    this.push(x1);
                    x1.setDuped(this);
                    x2.setDuped(this);
                    break;
                }
                StackProducer x1 = this.pop(Klass.TWO_WORD);
                this.push(x1);
                this.push(x1);
                x1.setDuped(this);
                break;
            }
            case 90: {
                StackProducer x1 = this.pop(Klass.ONE_WORD);
                StackProducer x2 = this.pop(Klass.ONE_WORD);
                this.push(x1);
                this.push(x2);
                this.push(x1);
                x1.setDuped(this);
                x2.setDuped(this);
                break;
            }
            case 91: {
                StackProducer x1 = this.pop(Klass.ONE_WORD);
                if (!this.isTopDoubleWord()) {
                    StackProducer x2 = this.pop(Klass.ONE_WORD);
                    StackProducer x3 = this.pop(Klass.ONE_WORD);
                    this.push(x1);
                    this.push(x3);
                    this.push(x2);
                    this.push(x1);
                    x1.setDuped(this);
                    x2.setDuped(this);
                    x3.setDuped(this);
                    break;
                }
                StackProducer x2 = this.pop(Klass.TWO_WORD);
                this.push(x1);
                this.push(x2);
                this.push(x1);
                x1.setDuped(this);
                x2.setDuped(this);
                break;
            }
            case 93: {
                if (!this.isTopDoubleWord()) {
                    StackProducer x1 = this.pop(Klass.ONE_WORD);
                    StackProducer x2 = this.pop(Klass.ONE_WORD);
                    StackProducer x3 = this.pop(Klass.ONE_WORD);
                    this.push(x2);
                    this.push(x1);
                    this.push(x3);
                    this.push(x2);
                    this.push(x1);
                    x1.setDuped(this);
                    x2.setDuped(this);
                    x3.setDuped(this);
                    break;
                }
                StackProducer x1 = this.pop(Klass.TWO_WORD);
                StackProducer x2 = this.pop(Klass.ONE_WORD);
                this.push(x1);
                this.push(x2);
                this.push(x1);
                x1.setDuped(this);
                x2.setDuped(this);
                break;
            }
            case 94: {
                if (!this.isTopDoubleWord()) {
                    StackProducer x1 = this.pop(Klass.ONE_WORD);
                    StackProducer x2 = this.pop(Klass.ONE_WORD);
                    if (!this.isTopDoubleWord()) {
                        StackProducer x3 = this.pop(Klass.ONE_WORD);
                        StackProducer x4 = this.pop(Klass.ONE_WORD);
                        this.push(x2);
                        this.push(x1);
                        this.push(x4);
                        this.push(x3);
                        this.push(x2);
                        this.push(x1);
                        x1.setDuped(this);
                        x2.setDuped(this);
                        x3.setDuped(this);
                        x4.setDuped(this);
                        break;
                    }
                    StackProducer x3 = this.pop(Klass.TWO_WORD);
                    this.push(x2);
                    this.push(x1);
                    this.push(x3);
                    this.push(x2);
                    this.push(x1);
                    x1.setDuped(this);
                    x2.setDuped(this);
                    x3.setDuped(this);
                    break;
                }
                StackProducer x1 = this.pop(Klass.TWO_WORD);
                if (!this.isTopDoubleWord()) {
                    StackProducer x2 = this.pop(Klass.ONE_WORD);
                    StackProducer x3 = this.pop(Klass.ONE_WORD);
                    this.push(x1);
                    this.push(x3);
                    this.push(x2);
                    this.push(x1);
                    x1.setDuped(this);
                    x2.setDuped(this);
                    x3.setDuped(this);
                    break;
                }
                StackProducer x2 = this.pop(Klass.TWO_WORD);
                this.push(x1);
                this.push(x2);
                this.push(x1);
                x1.setDuped(this);
                x2.setDuped(this);
                break;
            }
            case 95: {
                StackProducer x1 = this.pop(Klass.ONE_WORD);
                StackProducer x2 = this.pop(Klass.ONE_WORD);
                this.push(x1);
                this.push(x2);
                x1.setDuped(this);
                x2.setDuped(this);
                break;
            }
            default: {
                Assert.that((boolean)false, (String)("unknown dup/swap opcode: " + opcode));
            }
        }
    }

    private void traceType(Klass type, String prefix, boolean isDerived) {
        String name;
        if (!isDerived) {
            char[] spaces = new char[prefix.length()];
            Arrays.fill((char[])spaces, (char)' ');
            Tracer.trace((String)new String(spaces));
        } else {
            Tracer.trace((String)prefix);
        }
        String string = name = type == null ? "-T-" : type.getInternalName();
        if (isDerived) {
            Tracer.traceln((String)(" " + name));
        } else {
            Tracer.traceln((String)("{" + name + "}"));
        }
    }

    private void traceStack(Target target) {
        Klass[] map = target == null ? Klass.NO_CLASSES : target.getStack();
        int r = 0;
        for (int d = 0; r < map.length || d < this.sp; ++r, ++d) {
            Klass derived = d < this.sp ? this.getStackTypeAt(d) : null;
            Klass recorded = r < map.length ? map[r] : null;
            String prefix = "  stack[" + r + "]: ";
            this.traceType(derived, prefix, true);
            if (recorded == null) continue;
            this.traceType(recorded, prefix, false);
        }
    }

    private void traceLocals(Target target) {
        Klass[] map = target == null ? Klass.NO_CLASSES : target.getLocals();
        int i = 0;
        for (int l = 0; i < map.length || l < this.localTypes.length; ++i, ++l) {
            Klass derived = l < this.localTypes.length ? this.localTypes[l] : null;
            Klass recorded = i < map.length ? map[i] : null;
            String prefix = "  local[" + l + "]: ";
            this.traceType(derived, prefix, true);
            if (recorded == null) continue;
            this.traceType(recorded, prefix, false);
        }
    }

    public void traceFrameState(int opcode, int address) {
        Target target = null;
        try {
            target = this.codeParser.getTarget(address);
        }
        catch (NoClassDefFoundError e) {
            // empty catch block
        }
        Tracer.traceln((String)("Frame state @ " + address + " [ " + Opcode.mnemonics[opcode] + " ]"));
        this.traceLocals(target);
        this.traceStack(target);
    }

    public void traceTarget(Target target) {
        Tracer.traceln((String)("target " + target));
        this.traceLocals(target);
        this.traceStack(target);
    }
}

