/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.translator.ir;

import com.sun.squawk.ExceptionHandler;
import com.sun.squawk.Klass;
import com.sun.squawk.Method;
import com.sun.squawk.MethodBody;
import com.sun.squawk.translator.ClassFile;
import com.sun.squawk.translator.ci.CodeParser;
import com.sun.squawk.translator.ir.IRExceptionHandler;
import com.sun.squawk.translator.ir.Instruction;
import com.sun.squawk.translator.ir.InstructionEmitter;
import com.sun.squawk.translator.ir.Target;
import com.sun.squawk.util.Assert;
import com.sun.squawk.util.SquawkVector;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public final class IR {
    private static final Target[] NO_TARGETS = new Target[0];
    private Instruction head;
    private Instruction tail;
    private SquawkVector exceptionHandlers;
    private Target[] targets = NO_TARGETS;

    private boolean findInstruction(Instruction instruction) {
        Instruction i = this.head;
        while (i != null) {
            if (instruction == i) {
                return true;
            }
            i = i.next;
        }
        return false;
    }

    public void append(Instruction instruction) {
        if (this.head == null) {
            Assert.that((this.tail == null ? 1 : 0) != 0);
            this.head = this.tail = instruction;
        } else {
            Assert.that((this.tail != null ? 1 : 0) != 0);
            Assert.that((!this.findInstruction(instruction) ? 1 : 0) != 0, (String)"instruction cannot be in IR twice");
            this.tail.next = instruction;
            instruction.previous = this.tail;
            instruction.next = null;
            this.tail = instruction;
        }
    }

    public void prepend(Instruction instruction) {
        if (this.head == null) {
            Assert.that((this.tail == null ? 1 : 0) != 0);
            this.head = this.tail = instruction;
        } else {
            Assert.that((this.tail != null ? 1 : 0) != 0);
            Assert.that((!this.findInstruction(instruction) ? 1 : 0) != 0, (String)"instruction cannot be in IR twice");
            instruction.next = this.head;
            this.head.previous = instruction;
            this.head = instruction;
        }
        this.tail = instruction;
    }

    public void insertAfter(Instruction instruction, Instruction pos) {
        Assert.that((!this.findInstruction(instruction) ? 1 : 0) != 0);
        Assert.that((boolean)this.findInstruction(pos));
        if (pos == this.tail) {
            this.tail = instruction;
        } else {
            pos.next.previous = instruction;
        }
        instruction.next = pos.next;
        instruction.previous = pos;
        pos.next = instruction;
    }

    public void insertBefore(Instruction instruction, Instruction pos) {
        Assert.that((!this.findInstruction(instruction) ? 1 : 0) != 0);
        Assert.that((boolean)this.findInstruction(pos));
        if (pos == this.head) {
            this.head = instruction;
        } else {
            pos.previous.next = instruction;
        }
        instruction.previous = pos.previous;
        instruction.next = pos;
        pos.previous = instruction;
    }

    public void remove(Instruction instruction) {
        Assert.that((boolean)this.findInstruction(instruction));
        if (instruction == this.head) {
            this.head = instruction.next;
        }
        if (this.tail == instruction) {
            this.tail = instruction.previous;
        }
        if (instruction.previous != null) {
            instruction.previous.next = instruction.next;
        }
        if (instruction.next != null) {
            instruction.next.previous = instruction.previous;
        }
        instruction.previous = null;
        instruction.next = null;
    }

    public Instruction getHead() {
        return this.head;
    }

    public Instruction getTail() {
        return this.tail;
    }

    public int size() {
        Instruction instr = this.head;
        int n = 0;
        while (instr != null) {
            instr = instr.getNext();
            ++n;
        }
        return n;
    }

    public void setTargets(Target[] targets) {
        this.targets = targets;
    }

    public Target[] getTargets() {
        return this.targets;
    }

    void addExceptionHandler(IRExceptionHandler handler) {
        if (this.exceptionHandlers == null) {
            this.exceptionHandlers = new SquawkVector();
        }
        this.exceptionHandlers.addElement((Object)handler);
    }

    public Enumeration getExceptionHandlers() {
        if (this.exceptionHandlers == null) {
            return null;
        }
        return this.exceptionHandlers.elements();
    }

    public Enumeration getInstructions(final boolean reverse) {
        return new Enumeration(){
            Instruction instruction;
            {
                this.instruction = reverse ? IR.this.tail : IR.this.head;
            }

            @Override
            public boolean hasMoreElements() {
                return this.instruction != null;
            }

            public Object nextElement() {
                if (this.instruction == null) {
                    throw new NoSuchElementException();
                }
                Instruction result = this.instruction;
                this.instruction = reverse ? this.instruction.previous : this.instruction.next;
                return result;
            }
        };
    }

    public MethodBody getMethodBody(Method method, int index, CodeParser codeParser, Klass[] locals, int clearedSlots, int maxStack, ClassFile classFile) {
        InstructionEmitter emitter = new InstructionEmitter(this, classFile, method, clearedSlots);
        emitter.emit();
        byte[] code = emitter.getCode();
        byte[] typeMap = null;
        ExceptionHandler[] exceptionTable = null;
        if (this.exceptionHandlers != null && !this.exceptionHandlers.isEmpty()) {
            int lth = this.exceptionHandlers.size();
            exceptionTable = new ExceptionHandler[lth];
            for (int i = 0; i < lth; ++i) {
                IRExceptionHandler irHandler = (IRExceptionHandler)this.exceptionHandlers.elementAt(i);
                exceptionTable[i] = new ExceptionHandler(irHandler.getEntry().getBytecodeOffset(), irHandler.getExit().getBytecodeOffset(), irHandler.getCatch().getExceptionBytecodeOffset(), irHandler.getCatch().getType());
            }
        }
        if (maxStack == 0 && method.requiresClassClinit()) {
            ++maxStack;
        }
        MethodBody body = new MethodBody(method, maxStack, locals, exceptionTable, codeParser.getLineNumberTable(code), codeParser.getLocalVariableTable(), code, typeMap, true, false);
        return body;
    }
}

