/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.translator.ir;

import com.sun.squawk.ExceptionHandler;
import com.sun.squawk.Field;
import com.sun.squawk.Klass;
import com.sun.squawk.Method;
import com.sun.squawk.VM;
import com.sun.squawk.translator.AbstractMethodError;
import com.sun.squawk.translator.Translator;
import com.sun.squawk.translator.ci.CodeParser;
import com.sun.squawk.translator.ci.Opcode;
import com.sun.squawk.translator.ci.UninitializedObjectClass;
import com.sun.squawk.translator.ir.Frame;
import com.sun.squawk.translator.ir.IR;
import com.sun.squawk.translator.ir.IRExceptionHandler;
import com.sun.squawk.translator.ir.Instruction;
import com.sun.squawk.translator.ir.Local;
import com.sun.squawk.translator.ir.OperandVisitor;
import com.sun.squawk.translator.ir.Target;
import com.sun.squawk.translator.ir.instr.ArithmeticOp;
import com.sun.squawk.translator.ir.instr.ArrayLength;
import com.sun.squawk.translator.ir.instr.ArrayLoad;
import com.sun.squawk.translator.ir.instr.ArrayStore;
import com.sun.squawk.translator.ir.instr.Branch;
import com.sun.squawk.translator.ir.instr.Catch;
import com.sun.squawk.translator.ir.instr.CheckCast;
import com.sun.squawk.translator.ir.instr.ComparisonOp;
import com.sun.squawk.translator.ir.instr.Constant;
import com.sun.squawk.translator.ir.instr.ConstantDouble;
import com.sun.squawk.translator.ir.instr.ConstantFloat;
import com.sun.squawk.translator.ir.instr.ConstantInt;
import com.sun.squawk.translator.ir.instr.ConstantLong;
import com.sun.squawk.translator.ir.instr.ConstantObject;
import com.sun.squawk.translator.ir.instr.ConversionOp;
import com.sun.squawk.translator.ir.instr.FindSlot;
import com.sun.squawk.translator.ir.instr.GetField;
import com.sun.squawk.translator.ir.instr.GetStatic;
import com.sun.squawk.translator.ir.instr.If;
import com.sun.squawk.translator.ir.instr.IfCompare;
import com.sun.squawk.translator.ir.instr.IncDecLocal;
import com.sun.squawk.translator.ir.instr.InstanceOf;
import com.sun.squawk.translator.ir.instr.Invoke;
import com.sun.squawk.translator.ir.instr.InvokeSlot;
import com.sun.squawk.translator.ir.instr.InvokeStatic;
import com.sun.squawk.translator.ir.instr.InvokeSuper;
import com.sun.squawk.translator.ir.instr.InvokeVirtual;
import com.sun.squawk.translator.ir.instr.LoadLocal;
import com.sun.squawk.translator.ir.instr.LookupSwitch;
import com.sun.squawk.translator.ir.instr.MonitorEnter;
import com.sun.squawk.translator.ir.instr.MonitorExit;
import com.sun.squawk.translator.ir.instr.NegationOp;
import com.sun.squawk.translator.ir.instr.New;
import com.sun.squawk.translator.ir.instr.NewArray;
import com.sun.squawk.translator.ir.instr.NewDimension;
import com.sun.squawk.translator.ir.instr.Phi;
import com.sun.squawk.translator.ir.instr.Pop;
import com.sun.squawk.translator.ir.instr.Position;
import com.sun.squawk.translator.ir.instr.PutField;
import com.sun.squawk.translator.ir.instr.PutStatic;
import com.sun.squawk.translator.ir.instr.Return;
import com.sun.squawk.translator.ir.instr.StackMerge;
import com.sun.squawk.translator.ir.instr.StackOp;
import com.sun.squawk.translator.ir.instr.StackProducer;
import com.sun.squawk.translator.ir.instr.StoreLocal;
import com.sun.squawk.translator.ir.instr.TableSwitch;
import com.sun.squawk.translator.ir.instr.Throw;
import com.sun.squawk.translator.ir.instr.Try;
import com.sun.squawk.translator.ir.instr.TryEnd;
import com.sun.squawk.util.Assert;
import com.sun.squawk.util.Tracer;
import java.util.Enumeration;
import java.util.Stack;

public final class IRBuilder {
    private final Method method;
    private CodeParser codeParser;
    private IR ir;
    private Frame frame;
    private Stack handlers;
    private LoadLocal copyOfThis;

    public IRBuilder(Translator translator, CodeParser codeParser) {
        this.codeParser = codeParser;
        this.method = codeParser.getMethod();
        try {
            try {
                this.frame = new Frame(codeParser, 0);
                this.ir = new IR();
                this.parseInstructions(translator, false);
            }
            catch (OverwroteThisInConstructorError e) {
                this.codeParser = codeParser.reset(translator);
                this.frame = new Frame(codeParser, 1);
                this.ir = new IR();
                this.parseInstructions(translator, true);
            }
        }
        catch (RuntimeException e) {
            System.err.println(codeParser.prefix(""));
            throw e;
        }
    }

    public IR getIR() {
        return this.ir;
    }

    public Frame getFrame() {
        return this.frame;
    }

    private void parseInstructions(Translator translator, boolean copyThis) {
        CodeParser.PseudoOpcode[] pseudoOpcodes;
        boolean trace = Tracer.isTracing((String)"jvmverifier", (String)this.method.toString());
        if (trace) {
            Tracer.traceln((String)"");
            Tracer.traceln((String)("++++ Verifying " + this.method + "++++"));
        }
        if (copyThis && this.method.isConstructor()) {
            this.copyOfThis = this.copyThis();
        }
        boolean flowFromPredecessor = true;
        Target finallyTarget = null;
        if (this.method.isSynchronized()) {
            finallyTarget = this.frame.createFinallyTargetForSynchronizedMethod();
            this.enterSynchronizedMethod();
            this.opc_try(finallyTarget);
        }
        do {
            int opcode = this.codeParser.parseOpcode();
            pseudoOpcodes = this.codeParser.getLastPseudoOpcodes();
            if (pseudoOpcodes != null) {
                this.processPseudoInstructions(pseudoOpcodes, flowFromPredecessor);
            }
            if (!flowFromPredecessor) {
                this.codeParser.getTarget(this.codeParser.getLastOpcodeAddress());
            }
            this.verifyActiveExceptionHandlers();
            boolean fallsThrough = true;
            if (trace) {
                this.frame.traceFrameState(opcode, this.codeParser.getLastOpcodeAddress());
            }
            switch (opcode) {
                case 0: {
                    break;
                }
                case 1: {
                    this.opc_constant(new ConstantObject(Klass.NULL, null));
                    break;
                }
                case 2: {
                    this.opc_constant(new ConstantInt(new Integer(-1)));
                    break;
                }
                case 3: {
                    this.opc_constant(new ConstantInt(new Integer(0)));
                    break;
                }
                case 4: {
                    this.opc_constant(new ConstantInt(new Integer(1)));
                    break;
                }
                case 5: {
                    this.opc_constant(new ConstantInt(new Integer(2)));
                    break;
                }
                case 6: {
                    this.opc_constant(new ConstantInt(new Integer(3)));
                    break;
                }
                case 7: {
                    this.opc_constant(new ConstantInt(new Integer(4)));
                    break;
                }
                case 8: {
                    this.opc_constant(new ConstantInt(new Integer(5)));
                    break;
                }
                case 9: {
                    this.opc_constant(new ConstantLong(new Long(0L)));
                    break;
                }
                case 10: {
                    this.opc_constant(new ConstantLong(new Long(1L)));
                    break;
                }
                case 11: {
                    this.opc_constant(new ConstantFloat(new Float(0.0f)));
                    break;
                }
                case 12: {
                    this.opc_constant(new ConstantFloat(new Float(1.0f)));
                    break;
                }
                case 13: {
                    this.opc_constant(new ConstantFloat(new Float(2.0f)));
                    break;
                }
                case 14: {
                    this.opc_constant(new ConstantDouble(new Double(0.0)));
                    break;
                }
                case 15: {
                    this.opc_constant(new ConstantDouble(new Double(1.0)));
                    break;
                }
                case 16: {
                    this.opc_constant(new ConstantInt(new Integer(this.codeParser.parseByteOperand())));
                    break;
                }
                case 17: {
                    this.opc_constant(new ConstantInt(new Integer(this.codeParser.parseShortOperand())));
                    break;
                }
                case 18: {
                    this.opc_constant(Constant.create(this.codeParser.parseConstantPoolOperand(false, false)));
                    break;
                }
                case 19: {
                    this.opc_constant(Constant.create(this.codeParser.parseConstantPoolOperand(true, false)));
                    break;
                }
                case 20: {
                    this.opc_constant(Constant.create(this.codeParser.parseConstantPoolOperand(true, true)));
                    break;
                }
                case 21: {
                    this.opc_load(Klass.INT, this.codeParser.parseLocalVariableOperand(false, false));
                    break;
                }
                case 22: {
                    this.opc_load(Klass.LONG, this.codeParser.parseLocalVariableOperand(false, true));
                    break;
                }
                case 23: {
                    this.opc_load(Klass.FLOAT, this.codeParser.parseLocalVariableOperand(false, false));
                    break;
                }
                case 24: {
                    this.opc_load(Klass.DOUBLE, this.codeParser.parseLocalVariableOperand(false, true));
                    break;
                }
                case 25: {
                    this.opc_load(Klass.REFERENCE, this.codeParser.parseLocalVariableOperand(false, false));
                    break;
                }
                case 26: {
                    this.opc_load(Klass.INT, 0);
                    break;
                }
                case 27: {
                    this.opc_load(Klass.INT, 1);
                    break;
                }
                case 28: {
                    this.opc_load(Klass.INT, 2);
                    break;
                }
                case 29: {
                    this.opc_load(Klass.INT, 3);
                    break;
                }
                case 30: {
                    this.opc_load(Klass.LONG, 0);
                    break;
                }
                case 31: {
                    this.opc_load(Klass.LONG, 1);
                    break;
                }
                case 32: {
                    this.opc_load(Klass.LONG, 2);
                    break;
                }
                case 33: {
                    this.opc_load(Klass.LONG, 3);
                    break;
                }
                case 34: {
                    this.opc_load(Klass.FLOAT, 0);
                    break;
                }
                case 35: {
                    this.opc_load(Klass.FLOAT, 1);
                    break;
                }
                case 36: {
                    this.opc_load(Klass.FLOAT, 2);
                    break;
                }
                case 37: {
                    this.opc_load(Klass.FLOAT, 3);
                    break;
                }
                case 38: {
                    this.opc_load(Klass.DOUBLE, 0);
                    break;
                }
                case 39: {
                    this.opc_load(Klass.DOUBLE, 1);
                    break;
                }
                case 40: {
                    this.opc_load(Klass.DOUBLE, 2);
                    break;
                }
                case 41: {
                    this.opc_load(Klass.DOUBLE, 3);
                    break;
                }
                case 42: {
                    this.opc_load(Klass.REFERENCE, 0);
                    break;
                }
                case 43: {
                    this.opc_load(Klass.REFERENCE, 1);
                    break;
                }
                case 44: {
                    this.opc_load(Klass.REFERENCE, 2);
                    break;
                }
                case 45: {
                    this.opc_load(Klass.REFERENCE, 3);
                    break;
                }
                case 46: {
                    this.opc_arrayload(Klass.INT_ARRAY);
                    break;
                }
                case 47: {
                    this.opc_arrayload(Klass.LONG_ARRAY);
                    break;
                }
                case 48: {
                    this.opc_arrayload(Klass.FLOAT_ARRAY);
                    break;
                }
                case 49: {
                    this.opc_arrayload(Klass.DOUBLE_ARRAY);
                    break;
                }
                case 50: {
                    this.opc_arrayload(Klass.OBJECT_ARRAY);
                    break;
                }
                case 51: {
                    this.opc_arrayload(Klass.BYTE_ARRAY);
                    break;
                }
                case 52: {
                    this.opc_arrayload(Klass.CHAR_ARRAY);
                    break;
                }
                case 53: {
                    this.opc_arrayload(Klass.SHORT_ARRAY);
                    break;
                }
                case 54: {
                    this.opc_store(Klass.INT, this.codeParser.parseLocalVariableOperand(false, false));
                    break;
                }
                case 55: {
                    this.opc_store(Klass.LONG, this.codeParser.parseLocalVariableOperand(false, true));
                    break;
                }
                case 56: {
                    this.opc_store(Klass.FLOAT, this.codeParser.parseLocalVariableOperand(false, false));
                    break;
                }
                case 57: {
                    this.opc_store(Klass.DOUBLE, this.codeParser.parseLocalVariableOperand(false, true));
                    break;
                }
                case 58: {
                    this.opc_store(Klass.REFERENCE, this.codeParser.parseLocalVariableOperand(false, false));
                    break;
                }
                case 59: {
                    this.opc_store(Klass.INT, 0);
                    break;
                }
                case 60: {
                    this.opc_store(Klass.INT, 1);
                    break;
                }
                case 61: {
                    this.opc_store(Klass.INT, 2);
                    break;
                }
                case 62: {
                    this.opc_store(Klass.INT, 3);
                    break;
                }
                case 63: {
                    this.opc_store(Klass.LONG, 0);
                    break;
                }
                case 64: {
                    this.opc_store(Klass.LONG, 1);
                    break;
                }
                case 65: {
                    this.opc_store(Klass.LONG, 2);
                    break;
                }
                case 66: {
                    this.opc_store(Klass.LONG, 3);
                    break;
                }
                case 67: {
                    this.opc_store(Klass.FLOAT, 0);
                    break;
                }
                case 68: {
                    this.opc_store(Klass.FLOAT, 1);
                    break;
                }
                case 69: {
                    this.opc_store(Klass.FLOAT, 2);
                    break;
                }
                case 70: {
                    this.opc_store(Klass.FLOAT, 3);
                    break;
                }
                case 71: {
                    this.opc_store(Klass.DOUBLE, 0);
                    break;
                }
                case 72: {
                    this.opc_store(Klass.DOUBLE, 1);
                    break;
                }
                case 73: {
                    this.opc_store(Klass.DOUBLE, 2);
                    break;
                }
                case 74: {
                    this.opc_store(Klass.DOUBLE, 3);
                    break;
                }
                case 75: {
                    this.opc_store(Klass.REFERENCE, 0);
                    break;
                }
                case 76: {
                    this.opc_store(Klass.REFERENCE, 1);
                    break;
                }
                case 77: {
                    this.opc_store(Klass.REFERENCE, 2);
                    break;
                }
                case 78: {
                    this.opc_store(Klass.REFERENCE, 3);
                    break;
                }
                case 79: {
                    this.opc_arraystore(Klass.INT_ARRAY);
                    break;
                }
                case 80: {
                    this.opc_arraystore(Klass.LONG_ARRAY);
                    break;
                }
                case 81: {
                    this.opc_arraystore(Klass.FLOAT_ARRAY);
                    break;
                }
                case 82: {
                    this.opc_arraystore(Klass.DOUBLE_ARRAY);
                    break;
                }
                case 83: {
                    this.opc_arraystore(Klass.OBJECT_ARRAY);
                    break;
                }
                case 84: {
                    this.opc_arraystore(Klass.BYTE_ARRAY);
                    break;
                }
                case 85: {
                    this.opc_arraystore(Klass.CHAR_ARRAY);
                    break;
                }
                case 86: {
                    this.opc_arraystore(Klass.SHORT_ARRAY);
                    break;
                }
                case 87: {
                    this.opc_pop(false);
                    break;
                }
                case 88: {
                    this.opc_pop(true);
                    break;
                }
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: {
                    this.opc_stackop(opcode);
                    break;
                }
                case 96: {
                    this.opc_arithmetic(Klass.INT, 196);
                    break;
                }
                case 97: {
                    this.opc_arithmetic(Klass.LONG, 211);
                    break;
                }
                case 100: {
                    this.opc_arithmetic(Klass.INT, 197);
                    break;
                }
                case 101: {
                    this.opc_arithmetic(Klass.LONG, 212);
                    break;
                }
                case 104: {
                    this.opc_arithmetic(Klass.INT, 204);
                    break;
                }
                case 105: {
                    this.opc_arithmetic(Klass.LONG, 213);
                    break;
                }
                case 108: {
                    this.opc_arithmetic(Klass.INT, 205);
                    break;
                }
                case 109: {
                    this.opc_arithmetic(Klass.LONG, 214);
                    break;
                }
                case 112: {
                    this.opc_arithmetic(Klass.INT, 206);
                    break;
                }
                case 113: {
                    this.opc_arithmetic(Klass.LONG, 215);
                    break;
                }
                case 116: {
                    this.opc_negation(Klass.INT, 207);
                    break;
                }
                case 117: {
                    this.opc_negation(Klass.LONG, 219);
                    break;
                }
                case 120: {
                    this.opc_shift(Klass.INT, 201);
                    break;
                }
                case 121: {
                    this.opc_shift(Klass.LONG, 220);
                    break;
                }
                case 122: {
                    this.opc_shift(Klass.INT, 202);
                    break;
                }
                case 123: {
                    this.opc_shift(Klass.LONG, 221);
                    break;
                }
                case 124: {
                    this.opc_shift(Klass.INT, 203);
                    break;
                }
                case 125: {
                    this.opc_shift(Klass.LONG, 222);
                    break;
                }
                case 126: {
                    this.opc_arithmetic(Klass.INT, 198);
                    break;
                }
                case 127: {
                    this.opc_arithmetic(Klass.LONG, 216);
                    break;
                }
                case 128: {
                    this.opc_arithmetic(Klass.INT, 199);
                    break;
                }
                case 129: {
                    this.opc_arithmetic(Klass.LONG, 217);
                    break;
                }
                case 130: {
                    this.opc_arithmetic(Klass.INT, 200);
                    break;
                }
                case 131: {
                    this.opc_arithmetic(Klass.LONG, 218);
                    break;
                }
                case 132: {
                    this.opc_iinc(this.codeParser.parseLocalVariableOperand(false, false), this.codeParser.parseByteOperand());
                    break;
                }
                case 133: {
                    this.opc_conversion(Klass.INT, Klass.LONG, 224);
                    break;
                }
                case 136: {
                    this.opc_conversion(Klass.LONG, Klass.INT, 223);
                    break;
                }
                case 145: {
                    this.opc_conversion(Klass.INT, Klass.BYTE, 208);
                    break;
                }
                case 146: {
                    this.opc_conversion(Klass.INT, Klass.CHAR, 210);
                    break;
                }
                case 147: {
                    this.opc_conversion(Klass.INT, Klass.SHORT, 209);
                    break;
                }
                case 148: {
                    this.opc_comparison(Klass.LONG, -1);
                    break;
                }
                case 153: {
                    this.opc_if(Klass.INT, 109, this.codeParser.parseBranchOperand(false));
                    break;
                }
                case 154: {
                    this.opc_if(Klass.INT, 110, this.codeParser.parseBranchOperand(false));
                    break;
                }
                case 155: {
                    this.opc_if(Klass.INT, 111, this.codeParser.parseBranchOperand(false));
                    break;
                }
                case 156: {
                    this.opc_if(Klass.INT, 114, this.codeParser.parseBranchOperand(false));
                    break;
                }
                case 157: {
                    this.opc_if(Klass.INT, 113, this.codeParser.parseBranchOperand(false));
                    break;
                }
                case 158: {
                    this.opc_if(Klass.INT, 112, this.codeParser.parseBranchOperand(false));
                    break;
                }
                case 159: {
                    this.opc_ifcompare(Klass.INT, 115, this.codeParser.parseBranchOperand(false));
                    break;
                }
                case 160: {
                    this.opc_ifcompare(Klass.INT, 116, this.codeParser.parseBranchOperand(false));
                    break;
                }
                case 161: {
                    this.opc_ifcompare(Klass.INT, 117, this.codeParser.parseBranchOperand(false));
                    break;
                }
                case 162: {
                    this.opc_ifcompare(Klass.INT, 120, this.codeParser.parseBranchOperand(false));
                    break;
                }
                case 163: {
                    this.opc_ifcompare(Klass.INT, 119, this.codeParser.parseBranchOperand(false));
                    break;
                }
                case 164: {
                    this.opc_ifcompare(Klass.INT, 118, this.codeParser.parseBranchOperand(false));
                    break;
                }
                case 165: {
                    this.opc_ifcompare(Klass.REFERENCE, 107, this.codeParser.parseBranchOperand(false));
                    break;
                }
                case 166: {
                    this.opc_ifcompare(Klass.REFERENCE, 108, this.codeParser.parseBranchOperand(false));
                    break;
                }
                case 167: {
                    this.opc_goto(this.codeParser.parseBranchOperand(false));
                    fallsThrough = false;
                    break;
                }
                case 168: {
                    throw this.codeParser.verifyError("'jsr' is unsupported");
                }
                case 169: {
                    throw this.codeParser.verifyError("'ret' is unsupported");
                }
                case 170: {
                    this.opc_tableswitch();
                    fallsThrough = false;
                    break;
                }
                case 171: {
                    this.opc_lookupswitch();
                    fallsThrough = false;
                    break;
                }
                case 172: {
                    this.opc_return(Klass.INT);
                    fallsThrough = false;
                    break;
                }
                case 173: {
                    this.opc_return(Klass.LONG);
                    fallsThrough = false;
                    break;
                }
                case 174: {
                    this.opc_return(Klass.FLOAT);
                    fallsThrough = false;
                    break;
                }
                case 175: {
                    this.opc_return(Klass.DOUBLE);
                    fallsThrough = false;
                    break;
                }
                case 176: {
                    this.opc_return(Klass.REFERENCE);
                    fallsThrough = false;
                    break;
                }
                case 177: {
                    this.opc_return(Klass.VOID);
                    fallsThrough = false;
                    break;
                }
                case 178: {
                    this.opc_getstatic(this.codeParser.parseFieldOperand(true, opcode));
                    break;
                }
                case 179: {
                    this.opc_putstatic(this.codeParser.parseFieldOperand(true, opcode));
                    break;
                }
                case 180: {
                    this.opc_getfield(this.codeParser.parseFieldOperand(false, opcode));
                    break;
                }
                case 181: {
                    this.opc_putfield(this.codeParser.parseFieldOperand(false, opcode));
                    break;
                }
                case 182: {
                    Method callee = this.codeParser.parseMethodOperand(false, false);
                    if (callee.getDefiningClass().isInterface()) {
                        this.opc_invokeinterface(callee, 182);
                        break;
                    }
                    this.opc_invokevirtual(callee);
                    break;
                }
                case 183: {
                    this.opc_invokespecial(this.codeParser.parseMethodOperand(false, false));
                    break;
                }
                case 184: {
                    this.opc_invokestatic(this.codeParser.parseMethodOperand(true, false));
                    break;
                }
                case 185: {
                    Method callee = this.codeParser.parseMethodOperand(false, true);
                    if (callee.getDefiningClass() != Klass.OBJECT) {
                        this.opc_invokeinterface(callee, 185);
                        break;
                    }
                    this.opc_invokevirtual(callee);
                    break;
                }
                case 187: {
                    this.opc_new(this.codeParser.parseNewOperand());
                    break;
                }
                case 188: {
                    this.opc_newarray(this.codeParser.parseNewArrayOperand());
                    break;
                }
                case 189: {
                    this.opc_newarray(Klass.getClass((String)("[" + this.codeParser.parseClassOperand().getInternalName()), (boolean)false));
                    break;
                }
                case 190: {
                    this.opc_arraylength();
                    break;
                }
                case 191: {
                    this.opc_throw();
                    fallsThrough = false;
                    break;
                }
                case 192: {
                    this.opc_checkcast(this.codeParser.parseClassOperand());
                    break;
                }
                case 193: {
                    this.opc_instanceof(this.codeParser.parseClassOperand());
                    break;
                }
                case 194: {
                    this.opc_monitorenter(false);
                    break;
                }
                case 195: {
                    this.opc_monitorexit(false);
                    break;
                }
                case 196: {
                    this.opc_wide(this.codeParser.parseUnsignedByteOperand());
                    break;
                }
                case 197: {
                    this.opc_multianewarray(this.codeParser.parseClassOperand(), this.codeParser.parseUnsignedByteOperand());
                    break;
                }
                case 198: {
                    this.opc_if(Klass.REFERENCE, 105, this.codeParser.parseBranchOperand(false));
                    break;
                }
                case 199: {
                    this.opc_if(Klass.REFERENCE, 106, this.codeParser.parseBranchOperand(false));
                    break;
                }
                case 200: {
                    this.opc_goto(this.codeParser.parseBranchOperand(true));
                    fallsThrough = false;
                    break;
                }
                case 201: {
                    throw this.codeParser.verifyError("'jsr_w' is unsupported");
                }
                case 202: {
                    throw this.codeParser.verifyError("'breakpoint' is unsupported");
                }
                case 98: {
                    this.opc_arithmetic(Klass.FLOAT, 384);
                    break;
                }
                case 99: {
                    this.opc_arithmetic(Klass.DOUBLE, 390);
                    break;
                }
                case 102: {
                    this.opc_arithmetic(Klass.FLOAT, 385);
                    break;
                }
                case 103: {
                    this.opc_arithmetic(Klass.DOUBLE, 391);
                    break;
                }
                case 106: {
                    this.opc_arithmetic(Klass.FLOAT, 386);
                    break;
                }
                case 107: {
                    this.opc_arithmetic(Klass.DOUBLE, 392);
                    break;
                }
                case 110: {
                    this.opc_arithmetic(Klass.FLOAT, 387);
                    break;
                }
                case 111: {
                    this.opc_arithmetic(Klass.DOUBLE, 393);
                    break;
                }
                case 114: {
                    this.opc_arithmetic(Klass.FLOAT, 388);
                    break;
                }
                case 115: {
                    this.opc_arithmetic(Klass.DOUBLE, 394);
                    break;
                }
                case 118: {
                    this.opc_negation(Klass.FLOAT, 389);
                    break;
                }
                case 119: {
                    this.opc_negation(Klass.DOUBLE, 395);
                    break;
                }
                case 134: {
                    this.opc_conversion(Klass.INT, Klass.FLOAT, 396);
                    break;
                }
                case 135: {
                    this.opc_conversion(Klass.INT, Klass.DOUBLE, 400);
                    break;
                }
                case 137: {
                    this.opc_conversion(Klass.LONG, Klass.FLOAT, 397);
                    break;
                }
                case 138: {
                    this.opc_conversion(Klass.LONG, Klass.DOUBLE, 401);
                    break;
                }
                case 139: {
                    this.opc_conversion(Klass.FLOAT, Klass.INT, 398);
                    break;
                }
                case 140: {
                    this.opc_conversion(Klass.FLOAT, Klass.LONG, 399);
                    break;
                }
                case 141: {
                    this.opc_conversion(Klass.FLOAT, Klass.DOUBLE, 402);
                    break;
                }
                case 142: {
                    this.opc_conversion(Klass.DOUBLE, Klass.INT, 403);
                    break;
                }
                case 143: {
                    this.opc_conversion(Klass.DOUBLE, Klass.LONG, 404);
                    break;
                }
                case 144: {
                    this.opc_conversion(Klass.DOUBLE, Klass.FLOAT, 405);
                    break;
                }
                case 149: {
                    this.opc_comparison(Klass.FLOAT, 350);
                    break;
                }
                case 150: {
                    this.opc_comparison(Klass.FLOAT, 351);
                    break;
                }
                case 151: {
                    this.opc_comparison(Klass.DOUBLE, 352);
                    break;
                }
                case 152: {
                    this.opc_comparison(Klass.DOUBLE, 353);
                    break;
                }
                default: {
                    throw this.codeParser.verifyError("invalid opcode " + opcode);
                }
            }
            flowFromPredecessor = fallsThrough;
        } while (!this.codeParser.atEof());
        if (flowFromPredecessor) {
            throw this.codeParser.verifyError("execution falls off end of code");
        }
        int targetCount = this.codeParser.getTargetCount() + (finallyTarget == null ? 0 : 1);
        if (targetCount != 0) {
            Target[] targets = new Target[targetCount];
            Enumeration e = this.codeParser.getTargets();
            int index = 0;
            if (e != null) {
                while (e.hasMoreElements()) {
                    Target target = (Target)e.nextElement();
                    if (target.getTargetedInstruction() == null) {
                        throw this.codeParser.verifyError("branch into middle of instruction");
                    }
                    targets[index++] = target;
                }
            }
            if (finallyTarget != null) {
                targets[index++] = finallyTarget;
            }
            this.ir.setTargets(targets);
            this.codeParser.verifyUninitializedObjectClassAddresses();
        }
        if ((pseudoOpcodes = this.codeParser.getLastPseudoOpcodes()) != null) {
            this.processPseudoInstructions(pseudoOpcodes, flowFromPredecessor);
        }
        if (this.method.isSynchronized()) {
            Assert.that((finallyTarget != null ? 1 : 0) != 0);
            this.opc_tryend(finallyTarget);
            this.frame.growMaxStack(1);
            this.opc_catch(finallyTarget);
            this.exitSynchronizedMethod();
            this.opc_throw();
            this.frame.resetMaxStack();
        }
        this.codeParser.verifyExceptionHandlerInstructionAddresses();
        if (trace) {
            Tracer.traceln((String)"");
            Tracer.traceln((String)("---- Verifying " + this.method + "----"));
        }
    }

    private void processPseudoInstructions(CodeParser.PseudoOpcode[] pseudoOpcodes, boolean flowFromPredecessor) {
        Assert.that((pseudoOpcodes != null && pseudoOpcodes.length != 0 ? 1 : 0) != 0);
        boolean trace = Tracer.isTracing((String)"jvmverifier", (String)this.method.toString());
        block7: for (int i = 0; i < pseudoOpcodes.length; ++i) {
            CodeParser.PseudoOpcode pseudoOpcode = pseudoOpcodes[i];
            if (trace) {
                Tracer.traceln((String)("Psuedo instruction @" + this.codeParser.getLastOpcodeAddress() + " " + pseudoOpcode));
            }
            Object context = pseudoOpcode.getContext();
            switch (pseudoOpcode.getTag()) {
                case 0: {
                    ExceptionHandler ehItem = (ExceptionHandler)context;
                    this.opc_tryend(this.codeParser.getTarget(ehItem.getHandler()));
                    continue block7;
                }
                case 1: {
                    ExceptionHandler ehItem = (ExceptionHandler)context;
                    this.opc_try(this.codeParser.getTarget(ehItem.getHandler()));
                    continue block7;
                }
                case 2: {
                    this.opc_catch((Target)context);
                    continue block7;
                }
                case 3: {
                    this.opc_target((Target)context, flowFromPredecessor);
                    continue block7;
                }
                case 4: {
                    this.opc_position((Position)context);
                    continue block7;
                }
                default: {
                    Assert.shouldNotReachHere();
                }
            }
        }
    }

    private void verifyActiveExceptionHandlers() {
        if (this.handlers != null) {
            Enumeration e = this.handlers.elements();
            while (e.hasMoreElements()) {
                IRExceptionHandler handler = (IRExceptionHandler)e.nextElement();
                Target target = handler.getTarget();
                this.frame.mergeLocals(target, false);
            }
        }
    }

    private void processBasicBlockDelimiter(Instruction delimiter, Target defaultTarget, Target[] targets) {
        if (defaultTarget != null) {
            this.processBasicBlockDelimiterTarget(defaultTarget);
        }
        if (targets != null) {
            for (int i = 0; i < targets.length; ++i) {
                Target target = targets[i];
                this.processBasicBlockDelimiterTarget(target);
            }
        }
    }

    private void processBasicBlockDelimiterTarget(Target target) {
        this.verifyTarget(target);
    }

    private void verifyTarget(Target target) {
        this.frame.mergeStack(target, false);
        this.frame.mergeLocals(target, false);
        if (target.getAddress() <= this.codeParser.getLastOpcodeAddress()) {
            if (this.frame.containsType(Klass.UNINITIALIZED)) {
                this.frame.traceTarget(target);
                target.markAsFatalTarget();
            }
            target.markAsBackwardBranchTarget();
        } else {
            target.markAsForwardBranchTarget();
        }
    }

    private StackProducer getObjectForInstanceField(Field field, boolean isPutfield) {
        Klass expectedType = field.isProtected() && !this.method.getDefiningClass().isInSamePackageAs(field.getDefiningClass()) ? this.method.getDefiningClass() : field.getDefiningClass();
        if (isPutfield && this.method.isConstructor() && field.getDefiningClass() == this.method.getDefiningClass()) {
            StackProducer instruction = this.frame.pop(Klass.REFERENCE);
            if (instruction.getType() == Klass.UNINITIALIZED_THIS) {
                return instruction;
            }
            this.frame.push(instruction);
        }
        return this.frame.pop(expectedType);
    }

    private LoadLocal copyThis() {
        int indexForSavedThis = this.codeParser.getMaxLocals();
        Local thisLocal = this.frame.allocateLocal(Klass.UNINITIALIZED_THIS, indexForSavedThis);
        LoadLocal load = new LoadLocal(Klass.UNINITIALIZED_THIS, this.frame.load(0, Klass.REFERENCE));
        this.append(load);
        StoreLocal store = new StoreLocal(thisLocal, this.frame.pop(Klass.REFERENCE));
        this.append(store);
        return load;
    }

    private void append(Instruction instruction) {
        if (instruction.constrainsStack()) {
            this.frame.spillStack();
        }
        instruction.setBytecodeOffset(this.codeParser.getLastOpcodeAddress());
        this.ir.append(instruction);
        if (instruction instanceof StackProducer) {
            StackProducer producer = (StackProducer)instruction;
            if (producer.getType() != Klass.VOID) {
                this.frame.push(producer);
            } else {
                Assert.that((boolean)(producer instanceof Invoke));
            }
        }
    }

    private void enterSynchronizedMethod() {
        Assert.that((boolean)this.method.isSynchronized());
        if (!this.method.isStatic()) {
            this.frame.growMaxStack(1);
            this.opc_load(Klass.REFERENCE, 0);
            this.frame.resetMaxStack();
        }
        this.opc_monitorenter(this.method.isStatic());
    }

    private void exitSynchronizedMethod() {
        Assert.that((boolean)this.method.isSynchronized());
        if (!this.method.isStatic()) {
            this.frame.growMaxStack(1);
            this.opc_load(Klass.REFERENCE, 0);
            this.frame.resetMaxStack();
        }
        this.opc_monitorexit(this.method.isStatic());
    }

    private StackProducer[] popInvokeParameters(Method callee) {
        int extra = !callee.isStatic() || callee.isConstructor() ? 1 : 0;
        Klass[] parameterTypes = callee.getParameterTypes();
        int parameterCount = parameterTypes.length + extra;
        StackProducer[] parameters = new StackProducer[parameterCount];
        for (int i = parameterTypes.length - 1; i >= 0; --i) {
            parameters[--parameterCount] = this.frame.pop(parameterTypes[i]);
        }
        if (extra == 1) {
            parameters[0] = this.frame.pop(Klass.REFERENCE);
        }
        this.spillParameters(parameters);
        return parameters;
    }

    private void spillParameters(StackProducer[] parameters) {
        for (int i = 0; i < parameters.length; ++i) {
            this.frame.spill(parameters[i]);
        }
    }

    private StackProducer[] insertSlotParameter(StackProducer[] parameters, StackProducer slot) {
        StackProducer[] newParms = new StackProducer[parameters.length + 1];
        newParms[0] = slot;
        for (int i = 0; i < parameters.length; ++i) {
            newParms[i + 1] = parameters[i];
        }
        return newParms;
    }

    private void verifyNonSquawkPrimitive(Method callee, Klass actualType, Klass expectedType) {
        if (actualType.isSquawkPrimitive() && actualType != expectedType) {
            Klass definingClass = callee.getDefiningClass();
            if (expectedType.getSystemID() == 1 && (definingClass.getSystemID() == 39 || definingClass.getInternalName().equals("com.sun.squawk.GC"))) {
                return;
            }
            System.err.println("name: " + definingClass.getInternalName());
            String type = actualType.getName();
            throw this.codeParser.verifyError("In call to " + callee + ", " + type + " values can only be passsed as parameters of type " + type + " not as type " + expectedType.getName());
        }
    }

    private void verifyNonSquawkPrimitiveParameters(Method callee, StackProducer[] parameters) {
        Klass[] expectedTypes = callee.getParameterTypes();
        int extra = 0;
        if (!callee.isStatic() || callee.isConstructor()) {
            this.verifyNonSquawkPrimitive(callee, parameters[0].getType(), callee.getDefiningClass());
            extra = 1;
        }
        for (int i = 0; i < expectedTypes.length; ++i) {
            Klass actualType = parameters[i + extra].getType();
            this.verifyNonSquawkPrimitive(callee, actualType, expectedTypes[i]);
        }
    }

    private void verifyThisParameter(Method callee, StackProducer thisParameter) {
        Assert.that((!callee.isStatic() || callee.isConstructor() ? 1 : 0) != 0);
        Klass expectedThisType = callee.isProtected() && !this.method.getDefiningClass().isInSamePackageAs(callee.getDefiningClass()) ? this.method.getDefiningClass() : callee.getDefiningClass();
        if (expectedThisType.isInterface()) {
            expectedThisType = Klass.OBJECT;
        }
        if (!expectedThisType.isAssignableFrom(thisParameter.getType())) {
            throw this.codeParser.verifyError("invalid type for 'this' parameter in non-static method: expected '" + expectedThisType + "' received '" + thisParameter.getType() + "'");
        }
    }

    private void opc_constant(Constant instruction) {
        this.append(instruction);
    }

    private void opc_load(Klass type, int index) {
        Local local = this.frame.load(index, type);
        type = this.frame.getDerivedLocalTypeAt(index);
        LoadLocal instruction = new LoadLocal(type, local);
        this.append(instruction);
    }

    private void opc_store(Klass type, int index) {
        StackProducer value = this.frame.pop(type);
        this.frame.verifyLocalVariableIndex(type, index);
        if (value.getType().isSquawkPrimitive()) {
            type = value.getType();
        }
        Local local = this.frame.allocateLocal(type, index);
        if (index == 0) {
            if (this.frame.getDerivedLocalTypeAt(0) == Klass.UNINITIALIZED_THIS) {
                throw this.codeParser.verifyError("constructor does not initialize receiver");
            }
            if (this.copyOfThis == null && this.method.isConstructor()) {
                throw new OverwroteThisInConstructorError();
            }
        }
        this.frame.store(index, value.getType(), local);
        StoreLocal instruction = new StoreLocal(local, value);
        this.append(instruction);
    }

    private void opc_arraystore(Klass arrayType) {
        StackProducer array;
        if (!arrayType.isArray()) {
            throw this.codeParser.verifyError("expected array class");
        }
        Klass componentType = arrayType.getComponentType();
        StackProducer value = this.frame.pop(componentType);
        StackProducer index = this.frame.pop(Klass.INT);
        if (arrayType == Klass.BYTE_ARRAY) {
            array = this.frame.pop(Klass.OBJECT);
            if (array.getType() != Klass.BYTE_ARRAY && array.getType() != Klass.BOOLEAN_ARRAY && array.getType() != Klass.NULL) {
                throw this.codeParser.verifyError("invalid 'bastore'");
            }
        } else {
            array = this.frame.pop(arrayType);
            if (arrayType == Klass.OBJECT_ARRAY) {
                arrayType = array.getType();
                if (arrayType != Klass.NULL && ((componentType = arrayType.getComponentType()).isArray() || value.getType().isArray()) && !componentType.isAssignableFrom(value.getType())) {
                    throw this.codeParser.verifyError("invalid 'aastore'");
                }
                this.frame.verifyUseOfSquawkPrimitive(componentType, value.getType());
            } else {
                Assert.that((boolean)componentType.isPrimitive());
                if (array.getType() != null && array.getType() != Klass.NULL && array.getType() != arrayType) {
                    throw this.codeParser.verifyError("invalid array " + array.getType() + " for array store of type " + arrayType.getComponentType().getName());
                }
            }
        }
        ArrayStore instruction = new ArrayStore(componentType, array, index, value);
        this.append(instruction);
    }

    private void opc_arrayload(Klass arrayType) {
        StackProducer array;
        StackProducer index = this.frame.pop(Klass.INT);
        if (arrayType == Klass.BYTE_ARRAY) {
            array = this.frame.pop(Klass.OBJECT);
            if (array.getType() != Klass.BYTE_ARRAY && array.getType() != Klass.BOOLEAN_ARRAY && array.getType() != Klass.NULL) {
                throw this.codeParser.verifyError("invalid 'baload'");
            }
        } else {
            array = this.frame.pop(arrayType);
            if (arrayType.getComponentType().isPrimitive()) {
                if (array.getType() != null && array.getType() != Klass.NULL && array.getType() != arrayType) {
                    throw this.codeParser.verifyError("invalid array " + array.getType() + " for array load of type " + arrayType.getComponentType().getName());
                }
            } else {
                arrayType = array.getType();
            }
        }
        Klass componentType = arrayType != Klass.NULL ? arrayType.getComponentType() : Klass.NULL;
        ArrayLoad instruction = new ArrayLoad(componentType, array, index);
        this.append(instruction);
    }

    private void opc_pop(boolean pop2) {
        if (pop2) {
            if (!this.frame.isTopDoubleWord()) {
                this.append(new Pop(this.frame.pop(Klass.ONE_WORD)));
                this.append(new Pop(this.frame.pop(Klass.ONE_WORD)));
            } else {
                this.append(new Pop(this.frame.pop(Klass.TWO_WORD)));
            }
        } else {
            this.append(new Pop(this.frame.pop(Klass.ONE_WORD)));
        }
    }

    private void opc_stackop(int opcode) {
        Instruction last;
        if (opcode == 89 && !this.frame.isTopDoubleWord() && (last = this.ir.getTail()) instanceof Constant) {
            Constant instruction = (Constant)last;
            this.opc_constant(Constant.create(instruction.getValue()));
            return;
        }
        this.frame.doStackOp(opcode);
        StackOp instruction = new StackOp(opcode);
        this.append(instruction);
    }

    private void opc_arithmetic(Klass type, int opcode) {
        StackProducer right = this.frame.pop(type);
        StackProducer left = this.frame.pop(type);
        ArithmeticOp instruction = new ArithmeticOp(left, right, opcode);
        this.append(instruction);
    }

    private void opc_comparison(Klass type, int opcode) {
        StackProducer right = this.frame.pop(type);
        StackProducer left = this.frame.pop(type);
        ComparisonOp instruction = new ComparisonOp(left, right, opcode);
        this.append(instruction);
    }

    private void opc_conversion(Klass from, Klass to, int opcode) {
        StackProducer value = this.frame.pop(from);
        ConversionOp instruction = new ConversionOp(to, value, opcode);
        this.append(instruction);
    }

    private void opc_negation(Klass type, int opcode) {
        StackProducer value = this.frame.pop(type);
        NegationOp instruction = new NegationOp(value, opcode);
        this.append(instruction);
    }

    private void opc_shift(Klass type, int opcode) {
        StackProducer shift = this.frame.pop(Klass.INT);
        StackProducer value = this.frame.pop(type);
        ArithmeticOp instruction = new ArithmeticOp(value, shift, opcode);
        this.append(instruction);
    }

    private void opc_iinc(int index, int value) {
        if (value == 1 || value == -1) {
            Local local = this.frame.load(index, Klass.INT);
            IncDecLocal instruction = new IncDecLocal(local, value == 1);
            this.append(instruction);
        } else {
            this.frame.growMaxStack(2);
            this.opc_load(Klass.INT, index);
            if (value > 0) {
                this.opc_constant(new ConstantInt(new Integer(value)));
                this.opc_arithmetic(Klass.INT, 196);
            } else {
                this.opc_constant(new ConstantInt(new Integer(-value)));
                this.opc_arithmetic(Klass.INT, 197);
            }
            this.opc_store(Klass.INT, index);
            this.frame.resetMaxStack();
        }
    }

    private void opc_goto(Target target) {
        Branch instruction = new Branch(target);
        this.append(instruction);
        this.processBasicBlockDelimiter(instruction, target, null);
    }

    private void opc_if(Klass type, int opcode, Target target) {
        Instruction instruction;
        StackProducer value = this.frame.pop(type);
        Instruction tail = this.ir.getTail();
        if (tail instanceof ComparisonOp && ((ComparisonOp)(instruction = (ComparisonOp)tail)).isLCMP()) {
            int ifOpcode = 127;
            int offset = opcode - 109;
            Assert.that((offset >= 0 && offset < 6 ? 1 : 0) != 0);
            this.frame.push(((ComparisonOp)instruction).getLeft());
            this.frame.push(((ComparisonOp)instruction).getRight());
            this.ir.remove(instruction);
            this.opc_ifcompare(((ComparisonOp)instruction).getLeft().getType(), ifOpcode += offset, target);
            return;
        }
        if (value.getType().isSquawkPrimitive()) {
            throw this.codeParser.verifyError(value.getType().getName() + " must use EQ() and NE() for equality comparisons");
        }
        instruction = new If(value, opcode, target);
        this.append(instruction);
        this.processBasicBlockDelimiter(instruction, target, null);
    }

    private void opc_ifcompare(Klass type, int opcode, Target target) {
        StackProducer right = this.frame.pop(type);
        StackProducer left = this.frame.pop(type);
        if (left.getType().isSquawkPrimitive() || right.getType().isSquawkPrimitive()) {
            throw this.codeParser.verifyError(left.getType().getName() + " values must be compared with built in methods (eq(), ne(), lt() etc.)");
        }
        IfCompare instruction = new IfCompare(left, right, opcode, target);
        this.append(instruction);
        this.processBasicBlockDelimiter(instruction, target, null);
    }

    private void opc_position(Position position) {
        Assert.that((position.getBytecodeOffset() == this.codeParser.getLastOpcodeAddress() ? 1 : 0) != 0);
        this.append(position);
    }

    private void opc_target(Target target, boolean flowFromPredecessor) {
        if (!flowFromPredecessor) {
            this.frame.resetStack(target, false);
            this.frame.resetLocals(target);
        } else {
            this.frame.mergeStack(target, true);
            this.frame.mergeLocals(target, true);
        }
        Phi instruction = new Phi(target);
        this.append(instruction);
    }

    private void opc_catch(Target target) {
        if (target.getStack().length != 1) {
            throw this.codeParser.verifyError("invalid stack map for exception handler");
        }
        this.frame.resetLocals(target);
        this.frame.resetStack(target, true);
        Klass throwableKlass = target.getStack()[0];
        Catch instruction = new Catch(throwableKlass, target);
        this.append(instruction);
        StackProducer[] producers = instruction.getTarget().getDerivedStack();
        for (int i = 0; i < producers.length; ++i) {
            if (producers[i] == null) continue;
            this.frame.spill(producers[i]);
        }
    }

    private void opc_try(Target target) {
        IRExceptionHandler handler = new IRExceptionHandler(target);
        Try instruction = new Try();
        handler.setEntry(instruction);
        if (this.handlers == null) {
            this.handlers = new Stack();
        }
        this.handlers.push(handler);
        this.append(instruction);
    }

    private void opc_tryend(Target target) {
        if (this.handlers == null || this.handlers.isEmpty()) {
            throw this.codeParser.verifyError("invalid start_pc in exception handler");
        }
        IRExceptionHandler handler = (IRExceptionHandler)this.handlers.pop();
        TryEnd instruction = new TryEnd();
        handler.setExit(instruction);
        this.ir.addExceptionHandler(handler);
        this.append(instruction);
    }

    private void opc_wide(int opcode) {
        switch (opcode) {
            case 132: {
                this.opc_iinc(this.codeParser.parseLocalVariableOperand(true, false), this.codeParser.parseShortOperand());
                break;
            }
            case 21: {
                this.opc_load(Klass.INT, this.codeParser.parseLocalVariableOperand(true, false));
                break;
            }
            case 22: {
                this.opc_load(Klass.LONG, this.codeParser.parseLocalVariableOperand(true, true));
                break;
            }
            case 23: {
                this.opc_load(Klass.FLOAT, this.codeParser.parseLocalVariableOperand(true, false));
                break;
            }
            case 24: {
                this.opc_load(Klass.DOUBLE, this.codeParser.parseLocalVariableOperand(true, true));
                break;
            }
            case 25: {
                this.opc_load(Klass.REFERENCE, this.codeParser.parseLocalVariableOperand(true, false));
                break;
            }
            case 54: {
                this.opc_store(Klass.INT, this.codeParser.parseLocalVariableOperand(true, false));
                break;
            }
            case 55: {
                this.opc_store(Klass.LONG, this.codeParser.parseLocalVariableOperand(true, true));
                break;
            }
            case 56: {
                this.opc_store(Klass.FLOAT, this.codeParser.parseLocalVariableOperand(true, false));
                break;
            }
            case 57: {
                this.opc_store(Klass.DOUBLE, this.codeParser.parseLocalVariableOperand(true, true));
                break;
            }
            case 58: {
                this.opc_store(Klass.REFERENCE, this.codeParser.parseLocalVariableOperand(true, false));
                break;
            }
            default: {
                throw this.codeParser.verifyError("invalid wide opcode");
            }
        }
    }

    private void opc_tableswitch() {
        StackProducer key = this.frame.pop(Klass.INT);
        this.codeParser.parseSwitchPadding();
        Target defaultTarget = this.codeParser.parseBranchOperand(true);
        int low = this.codeParser.parseIntOperand();
        int high = this.codeParser.parseIntOperand();
        if (high - low < 0) {
            throw this.codeParser.verifyError("unordered tableswitch");
        }
        int cases = high - low + 1;
        TableSwitch instruction = new TableSwitch(key, low, high, defaultTarget);
        int caseValue = low;
        while (--cases >= 0) {
            Target target = this.codeParser.parseBranchOperand(true);
            instruction.addTarget(caseValue, target);
            ++caseValue;
        }
        this.append(instruction);
        this.processBasicBlockDelimiter(instruction, defaultTarget, instruction.getTargets());
    }

    private void opc_lookupswitch() {
        this.frame.growMaxStack(1);
        StackProducer key = this.frame.pop(Klass.INT);
        this.codeParser.parseSwitchPadding();
        Target defaultTarget = this.codeParser.parseBranchOperand(true);
        int npairs = this.codeParser.parseIntOperand();
        LookupSwitch instruction = new LookupSwitch(key, npairs, defaultTarget);
        int lastCaseValue = -1;
        for (int i = 0; i < npairs; ++i) {
            int caseValue = this.codeParser.parseIntOperand();
            if (i != 0 && caseValue <= lastCaseValue) {
                throw this.codeParser.verifyError("unordered lookupswitch");
            }
            Target target = this.codeParser.parseBranchOperand(true);
            instruction.addTarget(i, caseValue, target);
            lastCaseValue = caseValue;
        }
        this.append(instruction);
        this.processBasicBlockDelimiter(instruction, defaultTarget, instruction.getTargets());
        this.frame.resetMaxStack();
    }

    private void opc_return(Klass returnType) {
        StackProducer value;
        boolean isConstructor;
        boolean bl = isConstructor = this.method.isConstructor() && !this.method.isReplacementConstructor();
        if (this.method.getReturnType() == Klass.VOID || isConstructor) {
            boolean error;
            if (returnType != Klass.VOID) {
                throw this.codeParser.verifyError("invalid return for void method");
            }
            if (isConstructor && (error = this.copyOfThis != null ? this.method.getDefiningClass() != this.copyOfThis.getType() : this.frame.containsType(Klass.UNINITIALIZED_THIS))) {
                throw this.codeParser.verifyError("constructor does not initialize receiver");
            }
            value = null;
        } else {
            value = this.frame.pop(returnType);
            Klass declaredType = this.method.getReturnType();
            Klass localType = Frame.getLocalTypeFor(declaredType);
            boolean valid = localType == Klass.REFERENCE ? declaredType.isInterface() || declaredType.isAssignableFrom(value.getType()) : localType.isAssignableFrom(value.getType());
            if (!valid) {
                throw this.codeParser.verifyError("invalid return for non-void method");
            }
        }
        if (this.method.isSynchronized()) {
            if (this.method.getReturnType() != Klass.VOID) {
                this.frame.spill(value);
            }
            this.exitSynchronizedMethod();
        }
        if (isConstructor) {
            Assert.that((value == null ? 1 : 0) != 0);
            this.frame.growMaxStack(1);
            if (this.copyOfThis == null) {
                if (this.frame.getDerivedLocalTypeAt(0) == this.method.getDefiningClass()) {
                    this.opc_load(this.method.getDefiningClass(), 0);
                } else {
                    this.opc_constant(new ConstantObject(Klass.NULL, null));
                }
            } else {
                LoadLocal load = new LoadLocal(this.copyOfThis.getType(), this.copyOfThis.getLocal());
                this.append(load);
            }
            this.frame.resetMaxStack();
            value = this.frame.pop(this.method.getDefiningClass());
        }
        Return instruction = new Return(value);
        this.append(instruction);
        this.processBasicBlockDelimiter(instruction, null, null);
    }

    private void opc_monitorenter(boolean isForClass) {
        MonitorEnter instruction;
        if (!isForClass) {
            StackProducer object = this.frame.pop(Klass.REFERENCE);
            instruction = new MonitorEnter(object);
        } else {
            instruction = new MonitorEnter(null);
        }
        this.append(instruction);
    }

    private void opc_monitorexit(boolean isForClass) {
        MonitorExit instruction;
        if (!isForClass) {
            StackProducer object = this.frame.pop(Klass.REFERENCE);
            instruction = new MonitorExit(object);
        } else {
            instruction = new MonitorExit(null);
        }
        this.append(instruction);
    }

    private void opc_throw() {
        StackProducer throwable = this.frame.pop(Klass.THROWABLE);
        Throw instruction = new Throw(throwable);
        this.append(instruction);
        this.processBasicBlockDelimiter(instruction, null, null);
    }

    private void opc_getfield(Field field) {
        StackProducer object = this.getObjectForInstanceField(field, false);
        GetField instruction = new GetField(field, object);
        this.append(instruction);
    }

    private void opc_putfield(Field field) {
        StackProducer value = this.frame.pop(field.getType());
        StackProducer object = this.getObjectForInstanceField(field, true);
        PutField instruction = new PutField(field, object, value);
        this.append(instruction);
    }

    private void opc_getstatic(Field field) {
        if (field.hasConstant()) {
            if (VM.getCurrentIsolate().getLeafSuite().contains(field.getDefiningClass())) {
                field.getDefiningClass().updateModifiers(0x1000000);
            } else {
                if (field.getType().isPrimitive()) {
                    long value = field.getPrimitiveConstantValue();
                    switch (field.getType().getSystemID()) {
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: {
                            this.append(new ConstantInt(new Integer((int)value)));
                            return;
                        }
                        case 11: {
                            this.append(new ConstantLong(new Long(value)));
                            return;
                        }
                        case 13: {
                            this.append(new ConstantFloat(new Float(Float.intBitsToFloat((int)value))));
                            return;
                        }
                        case 14: {
                            this.append(new ConstantDouble(new Double(Double.longBitsToDouble(value))));
                            return;
                        }
                    }
                    throw Assert.shouldNotReachHere();
                }
                this.append(new ConstantObject(Klass.STRING, field.getStringConstantValue()));
                return;
            }
        }
        GetStatic instruction = new GetStatic(field);
        this.append(instruction);
    }

    private void opc_putstatic(Field field) {
        if (field.hasConstant() && field.getType().isPrimitive()) {
            if (VM.getCurrentIsolate().getLeafSuite().contains(field.getDefiningClass())) {
                field.getDefiningClass().updateModifiers(0x1000000);
            } else {
                throw Assert.shouldNotReachHere((String)"writing to constant field of immutable class not supported");
            }
        }
        StackProducer value = this.frame.pop(field.getType());
        PutStatic instruction = new PutStatic(field, value);
        this.append(instruction);
        if (field.getDefiningClass() != this.method.getDefiningClass()) {
            this.frame.growMaxStack(1);
        }
        this.frame.resetMaxStack();
    }

    private void opc_invokevirtual(Method callee) {
        if (!callee.isHosted()) {
            if (callee.isConstructor() || callee.isClassInitializer()) {
                throw this.codeParser.verifyError("expected invokespecial");
            }
            StackProducer[] parameters = this.popInvokeParameters(callee);
            this.verifyThisParameter(callee, parameters[0]);
            this.verifyNonSquawkPrimitiveParameters(callee, parameters);
            InvokeVirtual instruction = new InvokeVirtual(callee, parameters);
            this.append(instruction);
        } else {
            this.removeHostedMethodInvocation(callee);
        }
    }

    private void removeHostedMethodInvocation(Method callee) {
        Klass returnType;
        Klass[] params = callee.getParameterTypes();
        OperandVisitor visitor = new OperandVisitor(){

            @Override
            public StackProducer doOperand(Instruction instruction, StackProducer operand) {
                IRBuilder.this.removeOperand(operand, this);
                return operand;
            }
        };
        for (int i = params.length - 1; i >= 0; --i) {
            StackProducer operand = this.frame.pop(params[i]);
            this.removeOperand(operand, visitor);
        }
        if (!callee.isStatic() || callee.isConstructor()) {
            StackProducer operand = this.frame.pop(callee.getDefiningClass());
            this.removeOperand(operand, visitor);
        }
        if ((returnType = callee.getReturnType()) != Klass.VOID) {
            if (returnType.isPrimitive()) {
                switch (returnType.getSystemID()) {
                    default: {
                        this.opc_constant(new ConstantInt(new Integer(0)));
                        break;
                    }
                    case 11: {
                        this.opc_constant(new ConstantLong(new Long(0L)));
                        break;
                    }
                    case 13: {
                        this.opc_constant(new ConstantFloat(new Float(0.0f)));
                        break;
                    }
                    case 14: {
                        this.opc_constant(new ConstantDouble(new Double(0.0)));
                        break;
                    }
                }
            } else {
                this.opc_constant(new ConstantObject(Klass.NULL, null));
            }
        }
    }

    private void removeOperand(StackProducer operand, OperandVisitor visitor) {
        operand.visit(visitor);
        if (!(operand instanceof StackMerge)) {
            this.ir.remove(operand);
        }
    }

    private void opc_invokeinit(Method callee) {
        Klass initializedType;
        boolean chainedConstructorInvoked;
        this.frame.growMaxStack(1);
        StackProducer[] parameters = this.popInvokeParameters(callee);
        boolean trace = Tracer.isTracing((String)"jvmverifier", (String)this.method.toString());
        this.verifyNonSquawkPrimitiveParameters(callee, parameters);
        StackProducer thisParameter = parameters[0];
        boolean bl = chainedConstructorInvoked = thisParameter.getType() == Klass.UNINITIALIZED_THIS;
        if (chainedConstructorInvoked) {
            initializedType = this.method.getDefiningClass();
            thisParameter.updateType(initializedType);
            if (this.copyOfThis != null) {
                this.copyOfThis.updateType(initializedType);
            }
            for (int i = 1; i < parameters.length; ++i) {
                StackProducer parameter = parameters[i];
                if (parameter.getType() != Klass.UNINITIALIZED_THIS) continue;
                parameter.updateType(initializedType);
            }
            this.frame.replaceTypeWithType(Klass.UNINITIALIZED_THIS, initializedType);
            Klass currentKlass = this.method.getDefiningClass();
            Klass calleeKlass = callee.getDefiningClass();
            if (!this.method.isConstructor() || currentKlass != calleeKlass && currentKlass.getSuperclass() != calleeKlass) {
                throw this.codeParser.verifyError("invalid constructor call");
            }
        } else {
            UninitializedObjectClass uninitializedType;
            try {
                uninitializedType = (UninitializedObjectClass)thisParameter.getType();
            }
            catch (ClassCastException e) {
                throw this.codeParser.verifyError("expected uninitialized object");
            }
            initializedType = uninitializedType.getInitializedType();
            this.frame.replaceTypeWithType(uninitializedType, initializedType);
            thisParameter.updateType(initializedType);
        }
        int numRemovableDups = 0;
        if (thisParameter.isDuped() && !chainedConstructorInvoked) {
            StackOp stackOp = (StackOp)thisParameter.getNext();
            while (this.frame.getTopOfStack() == thisParameter) {
                Assert.always((stackOp.getOpcode() == 89 ? 1 : 0) != 0, (String)("cannot translate '" + Opcode.mnemonics[stackOp.getOpcode()] + "' of uninitialized object"));
                ++numRemovableDups;
                Instruction nextInstr = stackOp.getNext();
                this.frame.pop(thisParameter.getType());
                this.ir.remove(stackOp);
                if (!(nextInstr instanceof StackOp)) break;
                stackOp = (StackOp)nextInstr;
            }
            if (numRemovableDups > 0) {
                thisParameter.cancelDuping();
            }
        }
        this.verifyThisParameter(callee, thisParameter);
        InvokeStatic instruction = new InvokeStatic(callee, parameters);
        instruction.updateType(initializedType);
        this.append(instruction);
        if (numRemovableDups == 0) {
            this.opc_pop(false);
        } else {
            while (--numRemovableDups != 0) {
                this.opc_stackop(89);
            }
        }
        this.frame.resetMaxStack();
    }

    private void opc_invokesuper(Method callee) {
        this.frame.growMaxStack(1);
        StackProducer[] parameters = this.popInvokeParameters(callee);
        this.verifyThisParameter(callee, parameters[0]);
        this.verifyNonSquawkPrimitiveParameters(callee, parameters);
        InvokeSuper instruction = new InvokeSuper(callee, parameters);
        this.append(instruction);
        this.frame.resetMaxStack();
    }

    private void opc_invokespecial(Method callee) {
        if (!callee.isHosted()) {
            if (callee.isConstructor()) {
                this.opc_invokeinit(callee);
            } else if (callee.isFinal() || callee.isPrivate()) {
                this.opc_invokevirtual(callee);
            } else {
                Klass currentKlass = this.method.getDefiningClass();
                if (!callee.getDefiningClass().isAssignableFrom(currentKlass)) {
                    throw this.codeParser.verifyError("invalid invokespecial");
                }
                if (callee.isAbstract()) {
                    throw new AbstractMethodError(callee.toString());
                }
                this.opc_invokesuper(callee);
            }
        } else {
            this.removeHostedMethodInvocation(callee);
        }
    }

    private void opc_invokestatic(Method callee) {
        if (!callee.isHosted()) {
            if (callee.isClassInitializer()) {
                throw this.codeParser.verifyError("call to <clinit> with invokestatic is invalid");
            }
            if (callee.isConstructor()) {
                throw this.codeParser.verifyError("call to <init> with invokestatic is invalid");
            }
            this.frame.growMaxStack(1);
            StackProducer[] parameters = this.popInvokeParameters(callee);
            this.verifyNonSquawkPrimitiveParameters(callee, parameters);
            InvokeStatic instruction = new InvokeStatic(callee, parameters);
            this.append(instruction);
            this.frame.resetMaxStack();
        } else {
            this.removeHostedMethodInvocation(callee);
        }
    }

    private void opc_invokeinterface(Method callee, int opcode) {
        Assert.that((opcode == 185 || opcode == 182 ? 1 : 0) != 0);
        if (opcode == 185) {
            Klass[] types;
            int count = this.codeParser.parseByteOperand();
            if (count != (types = callee.getParameterTypes()).length + 1) {
                int expected = 1;
                for (int i = 0; i != types.length; ++i) {
                    expected += types[i].isDoubleWord() ? 2 : 1;
                }
                if (expected != count) {
                    throw this.codeParser.verifyError("invalid 'count' operand to invokeinterface");
                }
            }
            if (this.codeParser.parseByteOperand() != 0) {
                throw this.codeParser.verifyError("fourth operand to invokeinterface is not 0");
            }
        }
        this.frame.growMaxStack(1);
        int min = 3 - this.frame.getStackSize();
        if (min > 0) {
            this.frame.growMaxStack(min);
        }
        StackProducer[] parameters = this.popInvokeParameters(callee);
        StackProducer receiver = parameters[0];
        this.verifyThisParameter(callee, receiver);
        this.verifyNonSquawkPrimitiveParameters(callee, parameters);
        this.spillParameters(parameters);
        receiver.setDuped(this.frame);
        FindSlot findSlot = new FindSlot(callee, receiver);
        this.append(findSlot);
        this.frame.spill(findSlot);
        StackProducer fslot = this.frame.pop(Klass.INT);
        Assert.that((fslot == findSlot ? 1 : 0) != 0);
        parameters = this.insertSlotParameter(parameters, findSlot);
        InvokeSlot instruction = new InvokeSlot(callee, parameters);
        this.append(instruction);
        this.frame.resetMaxStack();
    }

    private void opc_new(UninitializedObjectClass uninitializedType) {
        New instruction = new New(uninitializedType);
        this.append(instruction);
    }

    private void opc_newarray(Klass type) {
        this.frame.growMaxStack(1);
        StackProducer length = this.frame.pop(Klass.INT);
        NewArray instruction = new NewArray(type, length);
        this.append(instruction);
        this.frame.resetMaxStack();
    }

    private void opc_arraylength() {
        StackProducer array = this.frame.pop(Klass.OBJECT);
        if (array.getType() != Klass.NULL && !array.getType().isArray()) {
            throw this.codeParser.verifyError("invalid arraylength");
        }
        ArrayLength instruction = new ArrayLength(array);
        this.append(instruction);
    }

    private void opc_checkcast(Klass to) {
        this.frame.growMaxStack(1);
        StackProducer object = this.frame.pop(Klass.OBJECT);
        CheckCast instruction = new CheckCast(to, object);
        this.append(instruction);
        this.frame.resetMaxStack();
    }

    private void opc_instanceof(Klass checkType) {
        this.frame.growMaxStack(1);
        StackProducer object = this.frame.pop(Klass.OBJECT);
        InstanceOf instruction = new InstanceOf(checkType, object);
        this.append(instruction);
        this.frame.resetMaxStack();
    }

    private void opc_multianewarray(Klass type, int dimensions) {
        if (!type.isArray()) {
            throw this.codeParser.verifyError("invalid type for multianewarray");
        }
        if (dimensions < 1 || dimensions > Translator.countArrayDimensions(type.getInternalName())) {
            throw this.codeParser.verifyError("invalid dimensions for multianewarray");
        }
        StackProducer[] dimensionLengths = new StackProducer[dimensions];
        if (dimensions == 1) {
            dimensionLengths[0] = this.frame.pop(Klass.INT);
        } else {
            for (int i = dimensions - 1; i >= 0; --i) {
                dimensionLengths[i] = this.frame.pop(Klass.INT);
                this.frame.spill(dimensionLengths[i]);
            }
        }
        NewArray instruction = new NewArray(type, dimensionLengths[0]);
        this.append(instruction);
        for (int i = 1; i < dimensionLengths.length; ++i) {
            NewDimension newDimension = new NewDimension(this.frame.pop(type), dimensionLengths[i]);
            this.append(newDimension);
        }
    }

    final class OverwroteThisInConstructorError
    extends NoClassDefFoundError {
        OverwroteThisInConstructorError() {
        }
    }
}

