/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.translator.ir;

import com.sun.squawk.Method;
import com.sun.squawk.translator.MethodDB;
import com.sun.squawk.translator.Translator;
import com.sun.squawk.translator.ir.Frame;
import com.sun.squawk.translator.ir.IR;
import com.sun.squawk.translator.ir.IRUseCounter;
import com.sun.squawk.translator.ir.Instruction;
import com.sun.squawk.translator.ir.Local;
import com.sun.squawk.translator.ir.OperandVisitor;
import com.sun.squawk.translator.ir.instr.Constant;
import com.sun.squawk.translator.ir.instr.Invoke;
import com.sun.squawk.translator.ir.instr.LoadLocal;
import com.sun.squawk.translator.ir.instr.LocalVariable;
import com.sun.squawk.translator.ir.instr.StackMerge;
import com.sun.squawk.translator.ir.instr.StackProducer;
import com.sun.squawk.translator.ir.instr.StoreLocal;
import com.sun.squawk.util.Assert;

public final class IRTransformer
implements OperandVisitor {
    private static final boolean DO_NOT_REVERSE_NATIVE_CALLS = true;
    private final Method method;
    private final IR ir;
    private final Frame frame;
    private boolean oneOrMoreOperandsSpilt;

    public IRTransformer(IR ir, Method method, Frame frame) {
        this.ir = ir;
        this.method = method;
        this.frame = frame;
    }

    public void transform(Translator translator) {
        Instruction instruction;
        boolean recordCalls = translator.getTranslationStrategy() >= 3;
        new IRUseCounter().count(this.ir);
        MethodDB.Entry callerEntry = null;
        if (recordCalls) {
            callerEntry = translator.methodDB.lookupMethodEntry(this.method);
        }
        for (instruction = this.ir.getHead(); instruction != null; instruction = instruction.getNext()) {
            this.oneOrMoreOperandsSpilt = false;
            instruction.visit(this);
            if (this.instructionNeedParametersReversed(instruction)) {
                Invoke invoke = (Invoke)instruction;
                StackProducer[] parameters = invoke.getParameters();
                for (int i = parameters.length - 1; i >= 0; --i) {
                    this.fillReversedParameters(invoke, parameters[i]);
                }
            }
            if (!recordCalls || !(instruction instanceof Invoke)) continue;
            Invoke inv = (Invoke)instruction;
            translator.methodDB.recordMethodCall(callerEntry, inv.getMethod());
        }
        for (instruction = this.ir.getHead(); instruction != null; instruction = instruction.getNext()) {
            LoadLocal load;
            StackProducer producer;
            if (!(instruction instanceof StackProducer) || !(producer = (StackProducer)instruction).isSpilt()) continue;
            Local local = producer.getSpillLocal();
            Assert.that((local != null ? 1 : 0) != 0);
            if (!producer.isDuped() && !(producer instanceof StackMerge) && producer.getNext() instanceof LoadLocal && (load = (LoadLocal)instruction.getNext()).getLocal() == local) {
                this.ir.remove(load);
                continue;
            }
            StoreLocal store = new StoreLocal(local, producer);
            this.ir.insertAfter(store, instruction);
            instruction = store;
        }
    }

    boolean instructionNeedParametersReversed(Instruction instruction) {
        if (instruction instanceof Invoke) {
            Invoke invoke = (Invoke)instruction;
            return !invoke.getMethod().isNative();
        }
        return false;
    }

    @Override
    public StackProducer doOperand(Instruction instruction, StackProducer operand) {
        if (this.instructionNeedParametersReversed(instruction)) {
            return operand;
        }
        Assert.that((operand != null ? 1 : 0) != 0);
        if (this.oneOrMoreOperandsSpilt || operand.isSpilt()) {
            this.oneOrMoreOperandsSpilt = true;
            if (!this.canReplaceSpillWithUse(instruction, operand)) {
                StackProducer load;
                if (!operand.isSpilt()) {
                    this.frame.spill(operand);
                }
                operand = load = this.fill(instruction, operand);
            }
        }
        Assert.that((operand != null ? 1 : 0) != 0);
        return operand;
    }

    private boolean canReplaceSpillWithUse(Instruction instruction, StackProducer operand) {
        if (!operand.isDuped() && operand.getUseCount() < 2) {
            if (operand instanceof LoadLocal) {
                LoadLocal load = (LoadLocal)operand;
                Local local = load.getLocal();
                if (this.connectsWithoutStoringTo(operand, instruction, local)) {
                    operand.cancelSpilling();
                    this.ir.remove(operand);
                    this.ir.insertBefore(operand, instruction);
                    return true;
                }
            } else if (operand instanceof Constant) {
                operand.cancelSpilling();
                this.ir.remove(operand);
                this.ir.insertBefore(operand, instruction);
                return true;
            }
        }
        return false;
    }

    private StackProducer fill(Instruction instruction, StackProducer operand) {
        Local spillLocal = operand.getSpillLocal();
        LoadLocal load = new LoadLocal(operand.getType(), spillLocal);
        this.ir.insertBefore(load, instruction);
        return load;
    }

    private void fillReversedParameters(Instruction instruction, StackProducer operand) {
        if (!this.canReplaceSpillWithUse(instruction, operand)) {
            this.fill(instruction, operand);
        }
    }

    private boolean connectsWithoutStoringTo(Instruction start, Instruction end, Local local) {
        for (Instruction instruction = start; instruction != end; instruction = instruction.getNext()) {
            LocalVariable lvi;
            if (instruction instanceof LocalVariable && (lvi = (LocalVariable)((Object)instruction)).getLocal() == local && lvi.writesValue()) {
                return false;
            }
            Assert.that((instruction.getNext() != null ? 1 : 0) != 0);
        }
        return true;
    }
}

