/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.translator.ir;

import com.sun.squawk.Field;
import com.sun.squawk.Klass;
import com.sun.squawk.Member;
import com.sun.squawk.Method;
import com.sun.squawk.VM;
import com.sun.squawk.translator.ClassFile;
import com.sun.squawk.translator.NoSuchFieldError;
import com.sun.squawk.translator.NoSuchMethodError;
import com.sun.squawk.translator.ir.IR;
import com.sun.squawk.translator.ir.Instruction;
import com.sun.squawk.translator.ir.InstructionTracer;
import com.sun.squawk.translator.ir.InstructionVisitor;
import com.sun.squawk.translator.ir.Local;
import com.sun.squawk.translator.ir.Target;
import com.sun.squawk.translator.ir.instr.ArithmeticOp;
import com.sun.squawk.translator.ir.instr.ArrayLength;
import com.sun.squawk.translator.ir.instr.ArrayLoad;
import com.sun.squawk.translator.ir.instr.ArrayStore;
import com.sun.squawk.translator.ir.instr.Branch;
import com.sun.squawk.translator.ir.instr.Catch;
import com.sun.squawk.translator.ir.instr.CheckCast;
import com.sun.squawk.translator.ir.instr.ComparisonOp;
import com.sun.squawk.translator.ir.instr.Constant;
import com.sun.squawk.translator.ir.instr.ConversionOp;
import com.sun.squawk.translator.ir.instr.FindSlot;
import com.sun.squawk.translator.ir.instr.GetField;
import com.sun.squawk.translator.ir.instr.GetStatic;
import com.sun.squawk.translator.ir.instr.If;
import com.sun.squawk.translator.ir.instr.IfCompare;
import com.sun.squawk.translator.ir.instr.IncDecLocal;
import com.sun.squawk.translator.ir.instr.InstanceOf;
import com.sun.squawk.translator.ir.instr.InvokeSlot;
import com.sun.squawk.translator.ir.instr.InvokeStatic;
import com.sun.squawk.translator.ir.instr.InvokeSuper;
import com.sun.squawk.translator.ir.instr.InvokeVirtual;
import com.sun.squawk.translator.ir.instr.LoadLocal;
import com.sun.squawk.translator.ir.instr.LookupSwitch;
import com.sun.squawk.translator.ir.instr.MonitorEnter;
import com.sun.squawk.translator.ir.instr.MonitorExit;
import com.sun.squawk.translator.ir.instr.NegationOp;
import com.sun.squawk.translator.ir.instr.New;
import com.sun.squawk.translator.ir.instr.NewArray;
import com.sun.squawk.translator.ir.instr.NewDimension;
import com.sun.squawk.translator.ir.instr.Phi;
import com.sun.squawk.translator.ir.instr.Pop;
import com.sun.squawk.translator.ir.instr.Position;
import com.sun.squawk.translator.ir.instr.PutField;
import com.sun.squawk.translator.ir.instr.PutStatic;
import com.sun.squawk.translator.ir.instr.Return;
import com.sun.squawk.translator.ir.instr.StackMerge;
import com.sun.squawk.translator.ir.instr.StackOp;
import com.sun.squawk.translator.ir.instr.StackProducer;
import com.sun.squawk.translator.ir.instr.StoreLocal;
import com.sun.squawk.translator.ir.instr.Switch;
import com.sun.squawk.translator.ir.instr.TableSwitch;
import com.sun.squawk.translator.ir.instr.Throw;
import com.sun.squawk.translator.ir.instr.Try;
import com.sun.squawk.translator.ir.instr.TryEnd;
import com.sun.squawk.util.Assert;
import com.sun.squawk.util.Tracer;
import com.sun.squawk.vm.Global;
import java.util.Hashtable;
import java.util.NoSuchElementException;

public class InstructionEmitter
implements InstructionVisitor {
    private static int trace_methods;
    private static int trace_static_methods;
    private static int trace_clearingExtends;
    private static int trace_slotsCleared;
    private static int trace_clinit;
    static final int TRACE_HIST_COUNT = 15;
    private static int[] trace_clearingHistogram;
    private boolean trace;
    private static int methodsProcessed;
    private static int passes;
    private static Hashtable intGlobals;
    private static Hashtable addrGlobals;
    private static Hashtable oopGlobals;
    private IR ir;
    private byte[] code;
    private final int clearedSlots;
    private int count;
    private final ClassFile classFile;
    private final Method method;
    private static final int NONE = 0;
    private static final int INIT = 1;
    private static final int CHECK = 2;
    private static final int EMIT = 3;
    private int state = 0;
    private boolean needAnotherPass;
    private boolean isAppClass = true;

    InstructionEmitter(IR ir, ClassFile classFile, Method method, int clearedSlots) {
        this.ir = ir;
        this.classFile = classFile;
        this.method = method;
        this.clearedSlots = clearedSlots;
        this.trace = Tracer.isTracing((String)"emitter", (String)method.toString());
        this.isAppClass = !VM.getCurrentIsolate().getLeafSuite().isBootstrap();
    }

    private int visitAll() {
        InstructionTracer tracer = null;
        if (this.trace) {
            Tracer.traceln((String)"");
            Tracer.traceln((String)("++++ InstructionEmitter trace for " + this.method + " ++++"));
            tracer = new InstructionTracer(this.ir);
        }
        this.count = 0;
        if (this.clearedSlots > 0) {
            this.emitOpcode(184);
            this.emit(this.clearedSlots);
        } else {
            this.emitOpcode(195);
        }
        ++trace_methods;
        if (this.method.isStatic()) {
            ++trace_static_methods;
        }
        if (this.clearedSlots > 0) {
            ++trace_clearingExtends;
        }
        if (this.clearedSlots >= 15) {
            trace_clearingHistogram[14] = trace_clearingHistogram[14] + 1;
        } else {
            int n = this.clearedSlots;
            trace_clearingHistogram[n] = trace_clearingHistogram[n] + 1;
        }
        trace_slotsCleared += this.clearedSlots;
        if (this.method.requiresClassClinit()) {
            this.emitOpcode(236);
            ++trace_clinit;
        }
        for (Instruction instruction = this.ir.getHead(); instruction != null; instruction = instruction.getNext()) {
            instruction.setBytecodeOffset(this.count);
            if (this.trace) {
                tracer.trace(instruction);
            }
            instruction.visit(this);
        }
        if (this.trace) {
            Tracer.traceln((String)("---- InstructionEmitter trace for " + this.method + " [state = " + this.state + " count = " + this.count + "] ----"));
        }
        ++passes;
        return this.count;
    }

    private static String percent(int a, int b) {
        int pcent = a * 100 / b;
        int units = pcent / 100;
        String res = "" + units + ".";
        if ((pcent -= units * 100) < 10) {
            res = res + "0";
        }
        return res + pcent;
    }

    public static void printStats() {
        System.out.println("-- Slot clearing stats --");
        System.out.println("Total methods:                " + trace_methods);
        System.out.println("Total static methods:         " + trace_static_methods + " " + InstructionEmitter.percent(trace_static_methods, trace_methods) + " per method");
        System.out.println("Total class_clinits:          " + trace_clinit + " " + InstructionEmitter.percent(trace_clinit, trace_methods) + " per method " + InstructionEmitter.percent(trace_clinit, trace_static_methods) + " per static method");
        System.out.println("Total slots cleared:          " + InstructionEmitter.percent(trace_slotsCleared, trace_methods) + " per method");
        System.out.println("Total clearing extends:       " + trace_clearingExtends);
        System.out.println("Clearing histogram:           ");
        for (int i = 0; i < 15; ++i) {
            System.out.println("    " + i + " = " + trace_clearingHistogram[i] + " (" + InstructionEmitter.percent(trace_clearingHistogram[i], trace_methods) + ")");
        }
        System.out.println();
        System.out.println("-- Emitting --");
        System.out.println("Total methods:                " + methodsProcessed);
        System.out.println("Total emitter passes:         " + passes);
        System.out.println("Passes/method:                " + (float)passes / (float)methodsProcessed);
    }

    void emit() {
        int last;
        this.needAnotherPass = false;
        this.state = 1;
        int size = last = this.visitAll();
        if (this.needAnotherPass) {
            this.state = 2;
            size = this.visitAll();
            while (size != last) {
                last = size;
                this.visitAll();
                size = this.visitAll();
            }
        }
        this.code = new byte[size];
        this.state = 3;
        last = this.visitAll();
        Assert.always((last == size ? 1 : 0) != 0);
        ++methodsProcessed;
        if (this.trace) {
            Tracer.traceln((String)("**** InstructionEmitter summary -- methodsProcessed = " + methodsProcessed + " passes = " + passes + " avg=" + (float)passes / (float)methodsProcessed + " ****"));
        }
    }

    public static Hashtable getGlobalIntVariables() {
        return intGlobals;
    }

    public static Hashtable getGlobalAddrVariables() {
        return addrGlobals;
    }

    public static Hashtable getGlobalOopVariables() {
        return oopGlobals;
    }

    byte[] getCode() {
        return this.code;
    }

    private void emit(int b) {
        Assert.that(((b & 0xFFFFFF00) == 0 ? 1 : 0) != 0);
        if (this.state == 3 && this.count < this.code.length) {
            this.code[this.count] = (byte)b;
        }
        ++this.count;
    }

    private void emitShort(int s) {
        if (this.state == 3) {
            if (VM.isBigEndian()) {
                this.emit(s >> 8 & 0xFF);
                this.emit(s >> 0 & 0xFF);
            } else {
                this.emit(s >> 0 & 0xFF);
                this.emit(s >> 8 & 0xFF);
            }
        } else {
            this.count += 2;
        }
    }

    private void emitInt(int i) {
        if (this.state == 3) {
            if (VM.isBigEndian()) {
                this.emit(i >> 24 & 0xFF);
                this.emit(i >> 16 & 0xFF);
                this.emit(i >> 8 & 0xFF);
                this.emit(i >> 0 & 0xFF);
            } else {
                this.emit(i >> 0 & 0xFF);
                this.emit(i >> 8 & 0xFF);
                this.emit(i >> 16 & 0xFF);
                this.emit(i >> 24 & 0xFF);
            }
        } else {
            this.count += 4;
        }
    }

    private void emitLong(long l) {
        if (this.state == 3) {
            if (VM.isBigEndian()) {
                this.emit((int)(l >> 56) & 0xFF);
                this.emit((int)(l >> 48) & 0xFF);
                this.emit((int)(l >> 40) & 0xFF);
                this.emit((int)(l >> 32) & 0xFF);
                this.emit((int)(l >> 24) & 0xFF);
                this.emit((int)(l >> 16) & 0xFF);
                this.emit((int)(l >> 8) & 0xFF);
                this.emit((int)(l >> 0) & 0xFF);
            } else {
                this.emit((int)(l >> 0) & 0xFF);
                this.emit((int)(l >> 8) & 0xFF);
                this.emit((int)(l >> 16) & 0xFF);
                this.emit((int)(l >> 24) & 0xFF);
                this.emit((int)(l >> 32) & 0xFF);
                this.emit((int)(l >> 40) & 0xFF);
                this.emit((int)(l >> 48) & 0xFF);
                this.emit((int)(l >> 56) & 0xFF);
            }
        } else {
            this.count += 8;
        }
    }

    private void emitOpcode(int opcode) {
        if (opcode > 255) {
            this.emit(77);
        }
        this.emit(opcode & 0xFF);
    }

    private void emitOpcode(int opcode, byte type) {
        this.emitOpcode(opcode);
    }

    private void emitWide0Opcode(int opcode) {
        if (opcode < 256) {
            this.emit(73);
        } else {
            this.emit(79);
        }
        this.emitOpcode(opcode & 0xFF);
    }

    private void emitWide1Opcode(int opcode) {
        if (opcode < 256) {
            this.emit(74);
        } else {
            this.emit(80);
        }
        this.emitOpcode(opcode & 0xFF);
    }

    private void emitWideM1Opcode(int opcode) {
        if (opcode < 256) {
            this.emit(72);
        } else {
            this.emit(78);
        }
        this.emitOpcode(opcode & 0xFF);
    }

    private void emitWideShortOpcode(int opcode) {
        if (opcode < 256) {
            this.emit(75);
        } else {
            this.emit(81);
        }
        this.emitOpcode(opcode & 0xFF);
    }

    private void emitWideIntOpcode(int opcode) {
        if (opcode < 256) {
            this.emit(76);
        } else {
            this.emit(82);
        }
        this.emitOpcode(opcode & 0xFF);
    }

    private void emitUnsigned(int opcode, int value) {
        if ((value & 0xFFFFFF00) == 0) {
            this.emitOpcode(opcode);
            this.emit(value);
        } else if ((value & 0xFFFFFE00) == 0) {
            this.emitWide1Opcode(opcode);
            this.emit(value & 0xFF);
        } else if (value >= 0 && value < 32768) {
            this.emitWideShortOpcode(opcode);
            this.emitShort(value);
        } else {
            this.emitWideIntOpcode(opcode);
            this.emitInt(value);
        }
    }

    private boolean emitBranch(int opcode, int targetOffset, int operandSize) {
        int savePosition = this.count;
        switch (operandSize) {
            case 1: {
                this.emitOpcode(opcode);
                int value = targetOffset - (this.count + 1);
                if (value < -128 || value >= 128) break;
                this.emit(value & 0xFF);
                return true;
            }
            case 2: {
                this.emitWideM1Opcode(opcode);
                int value = targetOffset - (this.count + 1);
                if (value < 0 && value >= -256) {
                    this.emit(value & 0xFF);
                    return true;
                }
                this.count = savePosition;
                this.emitWide0Opcode(opcode);
                value = targetOffset - (this.count + 1);
                if (value >= 0 && value < 256) {
                    this.emit(value & 0xFF);
                    return true;
                }
                this.count = savePosition;
                this.emitWide1Opcode(opcode);
                value = targetOffset - (this.count + 1);
                if (value < 0 || value >= 512) break;
                this.emit(value & 0xFF);
                return true;
            }
            case 3: {
                this.emitWideShortOpcode(opcode);
                int value = targetOffset - (this.count + 2);
                if (value < Short.MIN_VALUE || value >= 32768) break;
                this.emitShort(value);
                return true;
            }
            case 5: {
                this.emitWideIntOpcode(opcode);
                int value = targetOffset - (this.count + 4);
                this.emitInt(value);
                return true;
            }
            default: {
                Assert.shouldNotReachHere();
            }
        }
        this.count = savePosition;
        return false;
    }

    private void emitCompact(int opcode, int opcode_0, int limit, int value) {
        if (value < limit) {
            this.emitOpcode(opcode_0 + value);
        } else {
            this.emitUnsigned(opcode, value);
        }
    }

    private void emitConstantInt(int value) {
        if (value == -1) {
            this.emitOpcode(85);
        } else if (value >= 0 && value < 16) {
            this.emitOpcode(0 + value);
        } else if (value >= -128 && value < 128) {
            this.emitOpcode(86);
            this.emit(value & 0xFF);
        } else if (value >= Short.MIN_VALUE && value < Short.MAX_VALUE) {
            this.emitOpcode(87);
            this.emitShort(value);
        } else if ((value & 0xFFFF0000) == 0) {
            this.emitOpcode(88);
            this.emitShort(value);
        } else {
            this.emitOpcode(89);
            this.emitInt(value);
        }
    }

    private void emitConstantLong(long value) {
        if (value >= Integer.MIN_VALUE && value < Integer.MAX_VALUE) {
            this.emitConstantInt((int)value);
            this.emitOpcode(224);
        } else {
            this.emitOpcode(90);
            this.emitLong(value);
        }
    }

    private void emitConstantFloat(float value) {
        int ivalue;
        float fvalue;
        int fvalue_bits;
        int value_bits = Float.floatToIntBits(value);
        if (value_bits == (fvalue_bits = Float.floatToIntBits(fvalue = (float)(ivalue = (int)value))) && ivalue >= -1 && ivalue < 16) {
            this.emitConstantInt(ivalue);
            this.emitOpcode(396);
        } else {
            this.emitOpcode(382);
            this.emitInt(value_bits);
        }
    }

    private void emitConstantDouble(double value) {
        int ivalue;
        double dvalue;
        long dvalue_bits;
        long value_bits = Double.doubleToLongBits(value);
        if (value_bits == (dvalue_bits = Double.doubleToLongBits(dvalue = (double)(ivalue = (int)value)))) {
            this.emitConstantInt(ivalue);
            this.emitOpcode(400);
        } else {
            this.emitOpcode(383);
            this.emitLong(value_bits);
        }
    }

    private void emitConstantObject(Object object) {
        if (object == null) {
            this.emitOpcode(84);
        } else {
            try {
                int index = this.classFile.getConstantObjectIndex(object, this.state == 3);
                this.emitCompact(91, 16, 16, index);
            }
            catch (NoSuchElementException ex) {
                throw new NoClassDefFoundError("no copy of object in class's object table: " + object);
            }
        }
    }

    private void emitLoad(boolean isParm, boolean isLong, int index) {
        if (isLong) {
            if (isParm) {
                this.emitUnsigned(97, index);
            } else {
                this.emitUnsigned(93, index);
            }
        } else if (isParm) {
            this.emitCompact(96, 64, 8, index);
        } else {
            this.emitCompact(92, 32, 16, index);
        }
    }

    private void emitStore(boolean isParm, boolean isLong, int index) {
        Assert.that((isParm || index != 0 ? 1 : 0) != 0, (String)"slot 0 is reserved for method pointer");
        if (isLong) {
            if (isParm) {
                this.emitUnsigned(99, index);
            } else {
                this.emitUnsigned(95, index);
            }
        } else if (isParm) {
            this.emitUnsigned(98, index);
        } else {
            this.emitCompact(94, 48, 16, index);
        }
    }

    private void emitIncDec(boolean isInc, boolean isParm, int index) {
        if (isInc) {
            if (isParm) {
                this.emitUnsigned(102, index);
            } else {
                this.emitUnsigned(100, index);
            }
        } else if (isParm) {
            this.emitUnsigned(103, index);
        } else {
            this.emitUnsigned(101, index);
        }
    }

    @Override
    public void doArithmeticOp(ArithmeticOp instruction) {
        this.emitOpcode(instruction.getOpcode());
    }

    @Override
    public void doArrayLength(ArrayLength instruction) {
        this.emitOpcode(232);
    }

    @Override
    public void doArrayLoad(ArrayLoad instruction) {
        int opcode;
        switch (instruction.getType().getSystemID()) {
            case 6: 
            case 7: {
                opcode = 242;
                break;
            }
            case 8: {
                opcode = 244;
                break;
            }
            case 9: {
                opcode = 243;
                break;
            }
            case 10: {
                opcode = 241;
                break;
            }
            case 11: {
                opcode = 246;
                break;
            }
            case 13: {
                opcode = 406;
                break;
            }
            case 14: {
                opcode = 407;
                break;
            }
            case 34: 
            case 36: 
            case 38: {
                opcode = 241;
                break;
            }
            default: {
                opcode = 245;
            }
        }
        this.emitOpcode(opcode);
    }

    @Override
    public void doArrayStore(ArrayStore instruction) {
        int opcode;
        switch (instruction.getComponentType().getSystemID()) {
            case 6: 
            case 7: {
                opcode = 248;
                break;
            }
            case 8: 
            case 9: {
                opcode = 249;
                break;
            }
            case 10: {
                opcode = 247;
                break;
            }
            case 11: {
                opcode = 251;
                break;
            }
            case 13: {
                opcode = 408;
                break;
            }
            case 14: {
                opcode = 409;
                break;
            }
            case 34: 
            case 36: 
            case 38: {
                opcode = 247;
                break;
            }
            default: {
                opcode = 250;
            }
        }
        this.emitOpcode(opcode);
    }

    private void doBranch(int opcode, Branch branch, Target target) {
        int targetOffset = target.getBytecodeOffset();
        if (this.state == 1 && branch.isForward()) {
            this.count += 2;
            this.needAnotherPass = true;
        } else {
            if (this.emitBranch(opcode, targetOffset, 1)) {
                return;
            }
            if (this.emitBranch(opcode, targetOffset, 2)) {
                return;
            }
            if (this.emitBranch(opcode, targetOffset, 3)) {
                return;
            }
            if (this.emitBranch(opcode, targetOffset, 5)) {
                return;
            }
            Assert.shouldNotReachHere();
        }
    }

    @Override
    public void doBranch(Branch instruction) {
        this.doBranch(104, instruction, instruction.getTarget());
    }

    @Override
    public void doCheckCast(CheckCast instruction) {
        this.emitConstantObject(instruction.getType());
        this.emitOpcode(240);
    }

    @Override
    public void doConversionOp(ConversionOp instruction) {
        this.emitOpcode(instruction.getOpcode());
    }

    @Override
    public void doComparisonOp(ComparisonOp instruction) {
        if (instruction.isLCMP()) {
            this.invokeNative(171, Klass.INT);
        } else {
            int opcode = instruction.getOpcode();
            Assert.that((opcode >= 350 && opcode <= 353 ? 1 : 0) != 0);
            this.emitOpcode(opcode);
        }
    }

    @Override
    public void doTry(Try instruction) {
    }

    @Override
    public void doTryEnd(TryEnd instruction) {
    }

    @Override
    public void doIf(If instruction) {
        this.doBranch(instruction.getOpcode(), instruction, instruction.getTarget());
    }

    @Override
    public void doIfCompare(IfCompare instruction) {
        this.doIf(instruction);
    }

    @Override
    public void doIncDecLocal(IncDecLocal instruction) {
        Local local = instruction.getLocal();
        Assert.that((local.getType() == Klass.INT ? 1 : 0) != 0);
        boolean isInc = instruction.isIncrement();
        if (local.isParameter()) {
            this.emitIncDec(isInc, true, local.getSquawkParameterIndex());
        } else {
            this.emitIncDec(isInc, false, local.getSquawkLocalIndex());
        }
    }

    @Override
    public void doInstanceOf(InstanceOf instruction) {
        this.emitConstantObject(instruction.getCheckType());
        this.emitOpcode(239);
    }

    @Override
    public void doFindSlot(FindSlot instruction) {
        Method method = instruction.getMethod();
        Assert.that((!method.isNative() ? 1 : 0) != 0, (String)("Invalid native findslot to " + method));
        this.emitConstantObject(method.getDefiningClass());
        this.emitUnsigned(183, method.getOffset());
    }

    private void checkMethodCallable(Method callee) {
        Object m;
        int offset = callee.getOffset();
        if (offset == 65535) {
            throw new NoSuchMethodError("Call to hosted or other no longer available method: " + Klass.toString((Member)callee, (boolean)false) + " in " + Klass.toString((Member)this.method, (boolean)false));
        }
        Klass klass = callee.getDefiningClass();
        if (klass.getState() >= 4 && !callee.isAbstract() && ((m = klass.getMethodObject(callee)) == null || Klass.isMissingMethodObject((Object)m, (boolean)callee.isStatic()))) {
            throw new NoSuchMethodError("Call to deleted method: " + Klass.toString((Member)callee, (boolean)false) + " in " + Klass.toString((Member)this.method, (boolean)false));
        }
    }

    @Override
    public void doInvokeSlot(InvokeSlot instruction) {
        int opcode;
        Method method = instruction.getMethod();
        this.checkMethodCallable(method);
        switch (method.getReturnType().getSystemID()) {
            case 5: {
                opcode = 186;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                opcode = 185;
                break;
            }
            case 13: {
                opcode = 378;
                break;
            }
            case 14: {
                opcode = 379;
                break;
            }
            case 11: {
                opcode = 187;
                break;
            }
            case 34: 
            case 36: 
            case 38: {
                opcode = 185;
                break;
            }
            default: {
                opcode = 188;
            }
        }
        Assert.that((!method.isNative() ? 1 : 0) != 0, (String)("Invalid native invokeslot to " + method));
        this.emitOpcode(opcode);
    }

    private void invokeNative(String name, Klass type) {
        int identifier = VM.lookupNative((String)name);
        if (identifier == -1) {
            String msg = "Undefined native method invoked in " + this.method + ": " + name;
            throw new NoClassDefFoundError(msg);
        }
        this.invokeNative(identifier, type);
    }

    private void invokeNative(int identifier, Klass type) {
        int opcode;
        switch (type.getSystemID()) {
            case 5: {
                opcode = 180;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                opcode = 179;
                break;
            }
            case 13: {
                opcode = 376;
                break;
            }
            case 14: {
                opcode = 377;
                break;
            }
            case 11: {
                opcode = 181;
                break;
            }
            case 34: 
            case 36: 
            case 38: {
                opcode = 179;
                break;
            }
            default: {
                opcode = 182;
            }
        }
        this.emitUnsigned(opcode, identifier);
    }

    @Override
    public void doInvokeStatic(InvokeStatic instruction) {
        this.invokeStatic(instruction.getMethod());
    }

    private void invokeStatic(Method method) {
        Klass returnType = method.getReturnType();
        if (method.isNative()) {
            String name = method.getFullyQualifiedName();
            this.invokeNative(name, returnType);
        } else {
            int opcode;
            this.checkMethodCallable(method);
            switch (returnType.getSystemID()) {
                case 5: {
                    opcode = 172;
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    opcode = 171;
                    break;
                }
                case 13: {
                    opcode = 372;
                    break;
                }
                case 14: {
                    opcode = 373;
                    break;
                }
                case 11: {
                    opcode = 173;
                    break;
                }
                case 34: 
                case 36: 
                case 38: {
                    opcode = 171;
                    break;
                }
                default: {
                    opcode = 174;
                }
            }
            this.emitConstantObject(method.getDefiningClass());
            this.emitUnsigned(opcode, method.getOffset());
        }
    }

    @Override
    public void doInvokeSuper(InvokeSuper instruction) {
        Method method = instruction.getMethod();
        Klass returnType = method.getReturnType();
        if (method.isNative()) {
            Assert.that((method.isFinal() || method.getDefiningClass().isFinal() ? 1 : 0) != 0, (String)("cannot invoke non-final native method " + method));
            String name = method.getFullyQualifiedName();
            this.invokeNative(name, returnType);
        } else {
            int opcode;
            this.checkMethodCallable(method);
            switch (returnType.getSystemID()) {
                case 5: {
                    opcode = 176;
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    opcode = 175;
                    break;
                }
                case 13: {
                    opcode = 374;
                    break;
                }
                case 14: {
                    opcode = 375;
                    break;
                }
                case 11: {
                    opcode = 177;
                    break;
                }
                case 34: 
                case 36: 
                case 38: {
                    opcode = 175;
                    break;
                }
                default: {
                    opcode = 178;
                }
            }
            Assert.that((method.isPrivate() || !method.isNative() ? 1 : 0) != 0, (String)(this.method.toString() + ": invalid native invokesuper to " + method));
            this.emitConstantObject(method.getDefiningClass());
            this.emitUnsigned(opcode, method.getOffset());
        }
    }

    @Override
    public void doInvokeVirtual(InvokeVirtual instruction) {
        Method method = instruction.getMethod();
        Klass returnType = method.getReturnType();
        if (method.isNative()) {
            Assert.that((method.isFinal() || method.getDefiningClass().isFinal() ? 1 : 0) != 0, (String)("cannot invoke non-final native method " + method));
            String name = method.getFullyQualifiedName();
            this.invokeNative(name, returnType);
        } else {
            int opcode;
            this.checkMethodCallable(method);
            switch (returnType.getSystemID()) {
                case 5: {
                    opcode = 168;
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    opcode = 167;
                    break;
                }
                case 13: {
                    opcode = 370;
                    break;
                }
                case 14: {
                    opcode = 371;
                    break;
                }
                case 11: {
                    opcode = 169;
                    break;
                }
                case 34: 
                case 36: 
                case 38: {
                    opcode = 167;
                    break;
                }
                default: {
                    opcode = 170;
                }
            }
            this.emitUnsigned(opcode, method.getOffset());
        }
    }

    @Override
    public void doConstant(Constant instruction) {
        Object value = instruction.getValue();
        switch (instruction.getTag()) {
            case 6: {
                this.emitConstantDouble((Double)value);
                break;
            }
            case 4: {
                this.emitConstantFloat(((Float)value).floatValue());
                break;
            }
            case 5: {
                this.emitConstantLong((Long)value);
                break;
            }
            case 3: {
                this.emitConstantInt((Integer)value);
                break;
            }
            default: {
                this.emitConstantObject(value);
            }
        }
    }

    @Override
    public void doCatch(Catch instruction) {
        if (this.state == 3) {
            this.classFile.referenceConstantObject(instruction.getType());
        }
        this.emitOpcode(83);
    }

    @Override
    public void doGetField(GetField instruction) {
        LoadLocal load;
        Local local;
        int opcode;
        Field field = instruction.getField();
        switch (field.getType().getSystemID()) {
            case 6: 
            case 7: {
                opcode = 146;
                break;
            }
            case 9: {
                opcode = 147;
                break;
            }
            case 8: {
                opcode = 148;
                break;
            }
            case 10: {
                opcode = 145;
                break;
            }
            case 13: {
                opcode = 362;
                break;
            }
            case 14: {
                opcode = 363;
                break;
            }
            case 11: {
                opcode = 150;
                break;
            }
            case 34: 
            case 36: 
            case 38: {
                opcode = 145;
                break;
            }
            default: {
                opcode = 149;
            }
        }
        if (instruction.getObject() instanceof LoadLocal && (local = (load = (LoadLocal)instruction.getObject()).getLocal()).isParameter() && local.getSquawkParameterIndex() == 0) {
            if (load.getBytecodeOffset() != -1) {
                this.ir.remove(load);
                load.setBytecodeOffset(-1);
                this.needAnotherPass = true;
                return;
            }
            switch (opcode) {
                case 146: {
                    opcode = 152;
                    break;
                }
                case 147: {
                    opcode = 153;
                    break;
                }
                case 148: {
                    opcode = 154;
                    break;
                }
                case 145: {
                    opcode = 151;
                    break;
                }
                case 149: {
                    opcode = 155;
                    break;
                }
                case 150: {
                    opcode = 156;
                    break;
                }
                case 362: {
                    opcode = 364;
                    break;
                }
                case 363: {
                    opcode = 365;
                    break;
                }
                default: {
                    Assert.shouldNotReachHere();
                }
            }
        }
        this.emitUnsigned(opcode, field.getOffset());
    }

    @Override
    public void doGetStatic(GetStatic instruction) {
        Field field = instruction.getField();
        Klass klass = field.getDefiningClass();
        if (klass.hasGlobalStatics()) {
            this.emitGlobalVariableAccess(field, true);
        } else {
            int opcode;
            switch (field.getType().getSystemID()) {
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    opcode = 133;
                    break;
                }
                case 13: {
                    opcode = 354;
                    break;
                }
                case 14: {
                    opcode = 355;
                    break;
                }
                case 11: {
                    opcode = 135;
                    break;
                }
                case 34: 
                case 36: 
                case 38: {
                    opcode = 133;
                    break;
                }
                default: {
                    opcode = 134;
                }
            }
            if (klass == this.method.getDefiningClass()) {
                switch (opcode) {
                    case 133: {
                        opcode = 136;
                        break;
                    }
                    case 135: {
                        opcode = 138;
                        break;
                    }
                    case 134: {
                        opcode = 137;
                        break;
                    }
                    case 354: {
                        opcode = 356;
                        break;
                    }
                    case 355: {
                        opcode = 357;
                        break;
                    }
                    default: {
                        Assert.shouldNotReachHere();
                        break;
                    }
                }
            } else {
                this.emitConstantObject(klass);
            }
            this.emitUnsigned(opcode, field.getOffset() + 2);
        }
    }

    private void emitGlobalVariableAccess(Field field, boolean isRead) {
        Hashtable table;
        Klass varType;
        String nativename;
        String fieldname = field.getFullyQualifiedName();
        switch (field.getType().getSystemID()) {
            case 11: 
            case 14: {
                Assert.shouldNotReachHere((String)"Only single word global varibles are supported");
            }
            case 36: 
            case 38: {
                Assert.shouldNotReachHere((String)(field.getType().getName() + " typed global varibles are not (yet) supported"));
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: {
                nativename = "Int";
                varType = Klass.INT;
                table = intGlobals;
                Assert.always((oopGlobals.get(fieldname) == null ? 1 : 0) != 0, (String)(field + " is an oop in Globals.java"));
                Assert.always((addrGlobals.get(fieldname) == null ? 1 : 0) != 0, (String)(field + " is an address in Globals.java"));
                break;
            }
            case 34: {
                nativename = "Addr";
                varType = Klass.INT;
                table = addrGlobals;
                Assert.always((oopGlobals.get(fieldname) == null ? 1 : 0) != 0, (String)(field + " is an oop in Globals.java"));
                Assert.always((intGlobals.get(fieldname) == null ? 1 : 0) != 0, (String)(field + " is an int in Globals.java"));
                break;
            }
            default: {
                nativename = "Oop";
                varType = Klass.OBJECT;
                table = oopGlobals;
                Assert.always((addrGlobals.get(fieldname) == null ? 1 : 0) != 0, (String)(field + " is an address in Globals.java"));
                Assert.always((intGlobals.get(fieldname) == null ? 1 : 0) != 0, (String)(field + " is an int in Globals.java"));
            }
        }
        nativename = "com.sun.squawk.VM." + (isRead ? "getGlobal" : "setGlobal") + nativename;
        Integer index = (Integer)table.get(fieldname);
        if (index == null) {
            throw new NoSuchFieldError("No built-in global field " + fieldname);
        }
        Assert.that((index != null ? 1 : 0) != 0);
        this.emitConstantInt(index);
        this.invokeNative(nativename, isRead ? varType : Klass.VOID);
    }

    @Override
    public void doLoadLocal(LoadLocal instruction) {
        Local local = instruction.getLocal();
        boolean isLong = local.is64Bit();
        if (local.isParameter()) {
            this.emitLoad(true, isLong, local.getSquawkParameterIndex());
        } else {
            this.emitLoad(false, isLong, local.getSquawkLocalIndex());
        }
    }

    @Override
    public void doLookupSwitch(LookupSwitch instruction) {
        int[] caseValues = instruction.getCaseValues();
        this.emitConstantObject(caseValues);
        if (caseValues instanceof int[]) {
            this.emitOpcode(252, (byte)5);
            this.doSwitch(instruction, 0, caseValues.length - 1);
        } else if (caseValues instanceof short[]) {
            this.emitOpcode(254, (byte)5);
            this.doSwitch(instruction, 0, ((short[])caseValues).length - 1);
        } else if (caseValues instanceof byte[]) {
            this.emitOpcode(253, (byte)5);
            this.doSwitch(instruction, 0, ((byte[])caseValues).length - 1);
        } else {
            Assert.shouldNotReachHere();
        }
    }

    @Override
    public void doMonitorEnter(MonitorEnter instruction) {
        this.emitOpcode(instruction.getObject() == null ? 230 : 228);
    }

    @Override
    public void doMonitorExit(MonitorExit instruction) {
        this.emitOpcode(instruction.getObject() == null ? 231 : 229);
    }

    @Override
    public void doNegationOp(NegationOp instruction) {
        this.emitOpcode(instruction.getOpcode());
    }

    @Override
    public void doNewArray(NewArray instruction) {
        this.emitConstantObject(instruction.getType());
        this.emitOpcode(234);
    }

    @Override
    public void doNewDimension(NewDimension instruction) {
        this.emitOpcode(235);
    }

    @Override
    public void doNew(New instruction) {
        Klass klass = instruction.getRuntimeType();
        if (klass.isSquawkArray()) {
            this.emitConstantObject(null);
        } else {
            this.emitConstantObject(klass);
            this.emitOpcode(233);
        }
    }

    private void reportSquawkConstraintBroken(String msg, Instruction instr) {
        System.out.println("WARNING: Squawk constraint: " + msg + " was broken at " + instr + " in " + this.method);
        System.out.println("    This has only been seen in TCK tests, in code that is not reachable, so never executed. When dead-code elimination is checked in, we can be certain on this point.");
    }

    @Override
    public void doPhi(Phi instruction) {
        if (instruction.getTarget().isBackwardBranchTarget()) {
            if (instruction.getTarget().isFatalTarget()) {
                this.reportSquawkConstraintBroken("frame state contains uninitialized object at backward branch", instruction);
            }
            this.emitOpcode(this.isAppClass ? 238 : 237);
        }
    }

    @Override
    public void doPop(Pop instruction) {
        if (instruction.value().isOnStack()) {
            if (instruction.value().getType().isDoubleWord()) {
                this.emitOpcode(227);
            } else {
                this.emitOpcode(226);
            }
        }
    }

    @Override
    public void doPosition(Position instruction) {
    }

    @Override
    public void doReturn(Return instruction) {
        int opcode;
        StackProducer value = instruction.getValue();
        if (value == null) {
            opcode = 189;
        } else {
            switch (value.getType().getSystemID()) {
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    opcode = 190;
                    break;
                }
                case 13: {
                    opcode = 380;
                    break;
                }
                case 14: {
                    opcode = 381;
                    break;
                }
                case 11: {
                    opcode = 191;
                    break;
                }
                case 34: 
                case 36: 
                case 38: {
                    opcode = 190;
                    break;
                }
                default: {
                    opcode = 192;
                }
            }
        }
        this.emitOpcode(opcode);
    }

    @Override
    public void doPutField(PutField instruction) {
        LoadLocal load;
        Local local;
        int opcode;
        Field field = instruction.getField();
        switch (field.getType().getSystemID()) {
            case 6: 
            case 7: {
                opcode = 158;
                break;
            }
            case 8: 
            case 9: {
                opcode = 159;
                break;
            }
            case 10: {
                opcode = 157;
                break;
            }
            case 13: {
                opcode = 366;
                break;
            }
            case 14: {
                opcode = 367;
                break;
            }
            case 11: {
                opcode = 161;
                break;
            }
            case 34: 
            case 36: 
            case 38: {
                opcode = 157;
                break;
            }
            default: {
                opcode = 160;
            }
        }
        if (instruction.getObject() instanceof LoadLocal && (local = (load = (LoadLocal)instruction.getObject()).getLocal()).isParameter() && local.getSquawkParameterIndex() == 0) {
            if (load.getBytecodeOffset() != -1) {
                this.ir.remove(load);
                load.setBytecodeOffset(-1);
                this.needAnotherPass = true;
                return;
            }
            switch (opcode) {
                case 158: {
                    opcode = 163;
                    break;
                }
                case 159: {
                    opcode = 164;
                    break;
                }
                case 157: {
                    opcode = 162;
                    break;
                }
                case 160: {
                    opcode = 165;
                    break;
                }
                case 161: {
                    opcode = 166;
                    break;
                }
                case 366: {
                    opcode = 368;
                    break;
                }
                case 367: {
                    opcode = 369;
                    break;
                }
                default: {
                    Assert.shouldNotReachHere();
                }
            }
        }
        this.emitUnsigned(opcode, field.getOffset());
    }

    @Override
    public void doPutStatic(PutStatic instruction) {
        Field field = instruction.getField();
        Klass klass = field.getDefiningClass();
        if (klass.hasGlobalStatics()) {
            this.emitGlobalVariableAccess(field, false);
        } else {
            int opcode;
            switch (field.getType().getSystemID()) {
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    opcode = 139;
                    break;
                }
                case 13: {
                    opcode = 358;
                    break;
                }
                case 14: {
                    opcode = 359;
                    break;
                }
                case 11: {
                    opcode = 141;
                    break;
                }
                case 34: 
                case 36: 
                case 38: {
                    opcode = 139;
                    break;
                }
                default: {
                    opcode = 140;
                }
            }
            if (klass == this.method.getDefiningClass()) {
                switch (opcode) {
                    case 139: {
                        opcode = 142;
                        break;
                    }
                    case 141: {
                        opcode = 144;
                        break;
                    }
                    case 140: {
                        opcode = 143;
                        break;
                    }
                    case 358: {
                        opcode = 360;
                        break;
                    }
                    case 359: {
                        opcode = 361;
                        break;
                    }
                    default: {
                        Assert.shouldNotReachHere();
                        break;
                    }
                }
            } else {
                this.emitConstantObject(klass);
            }
            this.emitUnsigned(opcode, field.getOffset() + 2);
        }
    }

    @Override
    public void doStoreLocal(StoreLocal instruction) {
        Local local = instruction.getLocal();
        boolean isLong = local.is64Bit();
        if (local.isParameter()) {
            this.emitStore(true, isLong, local.getSquawkParameterIndex());
        } else {
            this.emitStore(false, isLong, local.getSquawkLocalIndex());
        }
    }

    @Override
    public void doStackMerge(StackMerge instruction) {
        Assert.shouldNotReachHere();
    }

    @Override
    public void doStackOp(StackOp instruction) {
    }

    private boolean emitTableEntry(int offset, int size) {
        if (size == 2) {
            if (offset < Short.MIN_VALUE || offset >= 32768) {
                return false;
            }
            this.emitShort(offset);
        } else {
            this.emitInt(offset);
        }
        return true;
    }

    private boolean tryTable(Switch instruction, int low, int high, int size) {
        Target def = instruction.getDefaultTarget();
        Target[] targets = instruction.getTargets();
        this.emitOpcode(size == 2 ? 194 : 193);
        while (this.count % size != 0) {
            this.emit(0);
        }
        if (!this.emitTableEntry(low, size)) {
            return false;
        }
        if (!this.emitTableEntry(high, size)) {
            return false;
        }
        int position = this.count + size;
        int offset = def.getBytecodeOffset() - position;
        if (!this.emitTableEntry(offset, size)) {
            return false;
        }
        for (int i = 0; i != targets.length; ++i) {
            offset = targets[i].getBytecodeOffset() - position;
            if (this.emitTableEntry(offset, size)) continue;
            return false;
        }
        return true;
    }

    private void doSwitch(Switch instruction, int low, int high) {
        int savePosition = this.count;
        this.needAnotherPass = true;
        if (!this.tryTable(instruction, low, high, 2)) {
            this.count = savePosition;
            this.tryTable(instruction, low, high, 4);
        }
    }

    @Override
    public void doTableSwitch(TableSwitch instruction) {
        this.doSwitch(instruction, instruction.getLow(), instruction.getHigh());
    }

    @Override
    public void doThrow(Throw instruction) {
        this.emitOpcode(225);
    }

    static {
        trace_clearingHistogram = new int[15];
        intGlobals = Global.getGlobalInts();
        addrGlobals = Global.getGlobalAddrs();
        oopGlobals = Global.getGlobalOops();
    }
}

