/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.translator.ir;

import com.sun.squawk.Field;
import com.sun.squawk.Klass;
import com.sun.squawk.Member;
import com.sun.squawk.Method;
import com.sun.squawk.MethodBodyTracer;
import com.sun.squawk.translator.ci.Opcode;
import com.sun.squawk.translator.ir.IR;
import com.sun.squawk.translator.ir.IRExceptionHandler;
import com.sun.squawk.translator.ir.Instruction;
import com.sun.squawk.translator.ir.InstructionVisitor;
import com.sun.squawk.translator.ir.Target;
import com.sun.squawk.translator.ir.instr.ArithmeticOp;
import com.sun.squawk.translator.ir.instr.ArrayLength;
import com.sun.squawk.translator.ir.instr.ArrayLoad;
import com.sun.squawk.translator.ir.instr.ArrayStore;
import com.sun.squawk.translator.ir.instr.Branch;
import com.sun.squawk.translator.ir.instr.Catch;
import com.sun.squawk.translator.ir.instr.CheckCast;
import com.sun.squawk.translator.ir.instr.ComparisonOp;
import com.sun.squawk.translator.ir.instr.Constant;
import com.sun.squawk.translator.ir.instr.ConversionOp;
import com.sun.squawk.translator.ir.instr.FindSlot;
import com.sun.squawk.translator.ir.instr.GetField;
import com.sun.squawk.translator.ir.instr.GetStatic;
import com.sun.squawk.translator.ir.instr.If;
import com.sun.squawk.translator.ir.instr.IfCompare;
import com.sun.squawk.translator.ir.instr.IncDecLocal;
import com.sun.squawk.translator.ir.instr.InstanceOf;
import com.sun.squawk.translator.ir.instr.InvokeSlot;
import com.sun.squawk.translator.ir.instr.InvokeStatic;
import com.sun.squawk.translator.ir.instr.InvokeSuper;
import com.sun.squawk.translator.ir.instr.InvokeVirtual;
import com.sun.squawk.translator.ir.instr.LoadLocal;
import com.sun.squawk.translator.ir.instr.LookupSwitch;
import com.sun.squawk.translator.ir.instr.MonitorEnter;
import com.sun.squawk.translator.ir.instr.MonitorExit;
import com.sun.squawk.translator.ir.instr.NegationOp;
import com.sun.squawk.translator.ir.instr.New;
import com.sun.squawk.translator.ir.instr.NewArray;
import com.sun.squawk.translator.ir.instr.NewDimension;
import com.sun.squawk.translator.ir.instr.Phi;
import com.sun.squawk.translator.ir.instr.Pop;
import com.sun.squawk.translator.ir.instr.Position;
import com.sun.squawk.translator.ir.instr.PutField;
import com.sun.squawk.translator.ir.instr.PutStatic;
import com.sun.squawk.translator.ir.instr.Return;
import com.sun.squawk.translator.ir.instr.StackMerge;
import com.sun.squawk.translator.ir.instr.StackOp;
import com.sun.squawk.translator.ir.instr.StackProducer;
import com.sun.squawk.translator.ir.instr.StoreLocal;
import com.sun.squawk.translator.ir.instr.TableSwitch;
import com.sun.squawk.translator.ir.instr.Throw;
import com.sun.squawk.translator.ir.instr.Try;
import com.sun.squawk.translator.ir.instr.TryEnd;
import com.sun.squawk.util.Assert;
import com.sun.squawk.util.Tracer;
import com.sun.squawk.vm.Mnemonics;
import java.io.PrintStream;
import java.util.Enumeration;

public class InstructionTracer
implements InstructionVisitor {
    private StringBuffer out;
    private PrintStream ps = Tracer.getPrintStream();
    private IR ir;
    private String indent = "        ";

    private String createSpaces(int value, int extra) {
        int length = String.valueOf(value).length() + extra;
        StringBuffer buf = new StringBuffer(length);
        for (int i = 0; i != length; ++i) {
            buf.append(' ');
        }
        return buf.toString();
    }

    public InstructionTracer(IR ir) {
        this.ir = ir;
        this.indent = this.createSpaces(this.getAddressOf(ir.getTail()), 2);
    }

    public void traceAll() {
        for (Instruction instruction = this.ir.getHead(); instruction != null; instruction = instruction.getNext()) {
            this.trace(instruction);
        }
    }

    public void traceWithBody(MethodBodyTracer mbt) {
        for (Instruction instruction = this.ir.getHead(); instruction != null; instruction = instruction.getNext()) {
            if (instruction instanceof Position || instruction instanceof Try || instruction instanceof TryEnd || instruction instanceof Catch || instruction instanceof Phi || instruction instanceof StackMerge || instruction instanceof StackOp) continue;
            this.out = new StringBuffer();
            instruction.visit(this);
            Instruction next = instruction.getNext();
            int nextoffset = -1;
            if (next != null) {
                nextoffset = next.getBytecodeOffset();
            }
            this.ps.print(mbt.traceUntil(nextoffset));
            this.ps.println(this.out.toString());
        }
    }

    public void trace(Instruction instruction) {
        if (instruction instanceof Position) {
            return;
        }
        if (instruction instanceof TryEnd) {
            this.indent = this.indent.substring(4);
        }
        String address = String.valueOf(this.getAddressOf(instruction));
        String prefix = address + ':' + this.indent.substring(address.length());
        String line = this.traceToString(instruction, prefix);
        this.ps.println(line);
        if (instruction instanceof Try) {
            this.indent = this.indent + "    ";
        }
    }

    private String traceToString(Instruction instruction, String prefix) {
        this.out = new StringBuffer();
        this.out.append(prefix);
        instruction.visit(this);
        return this.out.toString();
    }

    private int getAddressOf(Object object) {
        Instruction instruction;
        if (object instanceof Instruction) {
            instruction = (Instruction)object;
        } else {
            Assert.that((boolean)(object instanceof Target));
            instruction = (Instruction)((Object)((Target)object).getTargetedInstruction());
        }
        int address = instruction.getBytecodeOffset();
        boolean isFill = instruction instanceof LoadLocal;
        while (address == -99999) {
            instruction = isFill ? instruction.getNext() : instruction.getPrevious();
            address = instruction.getBytecodeOffset();
        }
        return address;
    }

    @Override
    public void doArithmeticOp(ArithmeticOp instruction) {
        this.out.append(Mnemonics.getMnemonic(instruction.getOpcode()));
    }

    @Override
    public void doArrayLength(ArrayLength instruction) {
        this.out.append(Mnemonics.getMnemonic(232));
    }

    @Override
    public void doArrayLoad(ArrayLoad instruction) {
        int opcode;
        switch (instruction.getType().getSystemID()) {
            case 6: 
            case 7: {
                opcode = 242;
                break;
            }
            case 8: {
                opcode = 244;
                break;
            }
            case 9: {
                opcode = 243;
                break;
            }
            case 10: {
                opcode = 241;
                break;
            }
            case 11: {
                opcode = 246;
                break;
            }
            case 13: {
                opcode = 406;
                break;
            }
            case 14: {
                opcode = 407;
                break;
            }
            default: {
                opcode = 245;
            }
        }
        this.out.append(Mnemonics.getMnemonic(opcode));
    }

    @Override
    public void doArrayStore(ArrayStore instruction) {
        int opcode;
        switch (instruction.getComponentType().getSystemID()) {
            case 6: 
            case 7: {
                opcode = 248;
                break;
            }
            case 8: 
            case 9: {
                opcode = 249;
                break;
            }
            case 10: {
                opcode = 247;
                break;
            }
            case 11: {
                opcode = 251;
                break;
            }
            case 13: {
                opcode = 408;
                break;
            }
            case 14: {
                opcode = 409;
                break;
            }
            default: {
                opcode = 250;
            }
        }
        this.out.append(Mnemonics.getMnemonic(opcode));
    }

    private void doBranch(int opcode, Target target) {
        this.out.append(Mnemonics.getMnemonic(opcode) + " " + this.getAddressOf(target));
    }

    @Override
    public void doBranch(Branch instruction) {
        this.doBranch(104, instruction.getTarget());
    }

    @Override
    public void doCheckCast(CheckCast instruction) {
        this.out.append(Mnemonics.getMnemonic(240) + " " + instruction.getType());
    }

    @Override
    public void doConversionOp(ConversionOp instruction) {
        this.out.append(Mnemonics.getMnemonic(instruction.getOpcode()));
    }

    @Override
    public void doComparisonOp(ComparisonOp instruction) {
        if (instruction.isLCMP()) {
            this.out.append("call com.sun.squawk.VM.lcmp");
        } else {
            this.out.append(Mnemonics.getMnemonic(instruction.getOpcode()));
        }
    }

    @Override
    public void doTry(Try instruction) {
        this.out.append("try {");
    }

    @Override
    public void doTryEnd(TryEnd instruction) {
        this.out.append("} // tryend");
    }

    @Override
    public void doIf(If instruction) {
        this.doBranch(instruction.getOpcode(), instruction.getTarget());
    }

    @Override
    public void doIfCompare(IfCompare instruction) {
        this.doIf(instruction);
    }

    @Override
    public void doIncDecLocal(IncDecLocal instruction) {
        this.out.append(Mnemonics.getMnemonic(instruction.isIncrement() ? 100 : 101) + " " + instruction.getLocal());
    }

    @Override
    public void doInstanceOf(InstanceOf instruction) {
        this.out.append(Mnemonics.getMnemonic(239) + " " + instruction.getCheckType());
    }

    private String member(Member member) {
        return " " + member + " [" + member.getOffset() + "]";
    }

    @Override
    public void doFindSlot(FindSlot instruction) {
        Method method = instruction.getMethod();
        this.out.append(Mnemonics.getMnemonic(183) + this.member((Member)method));
    }

    @Override
    public void doInvokeSlot(InvokeSlot instruction) {
        int opcode;
        Method method = instruction.getMethod();
        switch (method.getReturnType().getSystemID()) {
            case 5: {
                opcode = 186;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                opcode = 185;
                break;
            }
            case 11: {
                opcode = 187;
                break;
            }
            case 13: {
                opcode = 378;
                break;
            }
            case 14: {
                opcode = 379;
                break;
            }
            default: {
                opcode = 188;
            }
        }
        this.out.append(Mnemonics.getMnemonic(opcode));
    }

    @Override
    public void doInvokeStatic(InvokeStatic instruction) {
        int opcode;
        Method method = instruction.getMethod();
        switch (method.getReturnType().getSystemID()) {
            case 5: {
                opcode = 172;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                opcode = 171;
                break;
            }
            case 11: {
                opcode = 173;
                break;
            }
            case 13: {
                opcode = 372;
                break;
            }
            case 14: {
                opcode = 373;
                break;
            }
            default: {
                opcode = 174;
            }
        }
        this.out.append(Mnemonics.getMnemonic(opcode) + this.member((Member)method));
    }

    @Override
    public void doInvokeSuper(InvokeSuper instruction) {
        int opcode;
        Method method = instruction.getMethod();
        switch (method.getReturnType().getSystemID()) {
            case 5: {
                opcode = 176;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                opcode = 175;
                break;
            }
            case 11: {
                opcode = 177;
                break;
            }
            case 13: {
                opcode = 374;
                break;
            }
            case 14: {
                opcode = 375;
                break;
            }
            default: {
                opcode = 178;
            }
        }
        this.out.append(Mnemonics.getMnemonic(opcode) + this.member((Member)method));
    }

    @Override
    public void doInvokeVirtual(InvokeVirtual instruction) {
        int opcode;
        Method method = instruction.getMethod();
        switch (method.getReturnType().getSystemID()) {
            case 5: {
                opcode = 168;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                opcode = 167;
                break;
            }
            case 11: {
                opcode = 169;
                break;
            }
            case 13: {
                opcode = 370;
                break;
            }
            case 14: {
                opcode = 371;
                break;
            }
            default: {
                opcode = 170;
            }
        }
        this.out.append(Mnemonics.getMnemonic(opcode) + this.member((Member)method));
    }

    @Override
    public void doConstant(Constant instruction) {
        int opcode;
        int tag = instruction.getTag();
        Object value = instruction.getValue();
        switch (tag) {
            case 6: {
                opcode = 383;
                break;
            }
            case 4: {
                opcode = 382;
                break;
            }
            case 5: {
                opcode = 90;
                break;
            }
            case 3: {
                opcode = 89;
                break;
            }
            default: {
                if (value == null) {
                    opcode = 84;
                    value = "";
                    break;
                }
                opcode = 91;
                value = "\"" + value + "\"";
            }
        }
        this.out.append(Mnemonics.getMnemonic(opcode) + " " + value);
    }

    @Override
    public void doCatch(Catch instruction) {
        if (instruction.isControlFlowTarget()) {
            this.out.append(Mnemonics.getMnemonic(84));
            this.out.append("\n    ");
        }
        this.out.append("catch");
        this.out.append(" " + instruction.getType().getName() + " [ ");
        Enumeration tryBlocks = this.ir.getExceptionHandlers();
        if (tryBlocks != null) {
            while (tryBlocks.hasMoreElements()) {
                IRExceptionHandler handler = (IRExceptionHandler)tryBlocks.nextElement();
                if (handler.getCatch() != instruction) continue;
                Target target = handler.getCatch().getTarget();
                if (target.isBackwardBranchTarget()) {
                    this.out.append("(b)");
                }
                if (target.isForwardBranchTarget()) {
                    this.out.append("(f)");
                }
                this.out.append(this.getAddressOf(handler.getEntry()) + "-" + this.getAddressOf(handler.getExit()) + " ");
            }
        }
        this.out.append("]");
    }

    @Override
    public void doGetField(GetField instruction) {
        int opcode;
        Field field = instruction.getField();
        switch (field.getType().getSystemID()) {
            case 6: 
            case 7: {
                opcode = 146;
                break;
            }
            case 9: {
                opcode = 147;
                break;
            }
            case 8: {
                opcode = 148;
                break;
            }
            case 10: {
                opcode = 145;
                break;
            }
            case 11: {
                opcode = 150;
                break;
            }
            case 13: {
                opcode = 362;
                break;
            }
            case 14: {
                opcode = 363;
                break;
            }
            default: {
                opcode = 149;
            }
        }
        this.out.append(Mnemonics.getMnemonic(opcode) + this.member((Member)field));
    }

    @Override
    public void doGetStatic(GetStatic instruction) {
        int opcode;
        Field field = instruction.getField();
        switch (field.getType().getSystemID()) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                opcode = 133;
                break;
            }
            case 11: {
                opcode = 135;
                break;
            }
            case 13: {
                opcode = 354;
                break;
            }
            case 14: {
                opcode = 355;
                break;
            }
            default: {
                opcode = 134;
            }
        }
        this.out.append(Mnemonics.getMnemonic(opcode) + this.member((Member)field));
    }

    @Override
    public void doLoadLocal(LoadLocal instruction) {
        this.out.append(Mnemonics.getMnemonic(92) + " " + instruction.getLocal());
    }

    @Override
    public void doLookupSwitch(LookupSwitch instruction) {
        this.out.append("lookupswitch default=" + this.getAddressOf(instruction.getDefaultTarget()));
        Target[] targets = instruction.getTargets();
        int[] caseValues = instruction.getCaseValues();
        this.out.append(" npairs=" + targets.length + " (");
        for (int i = 0; i != targets.length; ++i) {
            this.out.append(caseValues[i] + " -> " + this.getAddressOf(targets[i]));
            if (i == targets.length - 1) continue;
            this.out.append(", ");
        }
        this.out.append(")");
    }

    @Override
    public void doMonitorEnter(MonitorEnter instruction) {
        this.out.append(Mnemonics.getMnemonic(instruction.getObject() == null ? 230 : 228));
    }

    @Override
    public void doMonitorExit(MonitorExit instruction) {
        this.out.append(Mnemonics.getMnemonic(instruction.getObject() == null ? 231 : 229));
    }

    @Override
    public void doNegationOp(NegationOp instruction) {
        this.out.append(Mnemonics.getMnemonic(instruction.getOpcode()));
    }

    @Override
    public void doNewArray(NewArray instruction) {
        this.out.append(Mnemonics.getMnemonic(234) + " " + instruction.getType().getName());
    }

    @Override
    public void doNewDimension(NewDimension instruction) {
        this.out.append(Mnemonics.getMnemonic(235));
    }

    @Override
    public void doNew(New instruction) {
        this.out.append(Mnemonics.getMnemonic(233) + " " + instruction.getRuntimeType().getName());
    }

    @Override
    public void doPhi(Phi instruction) {
        Target target = instruction.getTarget();
        this.out.append("phi");
        if (target.isBackwardBranchTarget()) {
            this.out.append("(b)");
        }
        if (target.isForwardBranchTarget()) {
            this.out.append("(f)");
        }
        this.out.append(" stack={" + Klass.getNames((Klass[])target.getStack()) + "} locals={" + Klass.getNames((Klass[])target.getLocals()) + "}");
    }

    @Override
    public void doPop(Pop instruction) {
        if (instruction.value().isOnStack()) {
            if (instruction.value().getType().isDoubleWord()) {
                this.out.append(Mnemonics.getMnemonic(227));
            } else {
                this.out.append(Mnemonics.getMnemonic(226)).append(' ').append(instruction.value());
            }
        } else {
            this.out.append("/* pop */");
        }
    }

    @Override
    public void doPosition(Position instruction) {
        this.out.append("// position");
    }

    @Override
    public void doReturn(Return instruction) {
        int opcode;
        StackProducer value = instruction.getValue();
        if (value == null) {
            opcode = 189;
        } else {
            switch (value.getType().getSystemID()) {
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    opcode = 190;
                    break;
                }
                case 11: {
                    opcode = 191;
                    break;
                }
                case 13: {
                    opcode = 380;
                    break;
                }
                case 14: {
                    opcode = 381;
                    break;
                }
                default: {
                    opcode = 192;
                }
            }
        }
        this.out.append(Mnemonics.getMnemonic(opcode));
    }

    @Override
    public void doPutField(PutField instruction) {
        int opcode;
        Field field = instruction.getField();
        switch (field.getType().getSystemID()) {
            case 6: 
            case 7: {
                opcode = 158;
                break;
            }
            case 8: 
            case 9: {
                opcode = 159;
                break;
            }
            case 10: {
                opcode = 157;
                break;
            }
            case 11: {
                opcode = 161;
                break;
            }
            case 13: {
                opcode = 366;
                break;
            }
            case 14: {
                opcode = 367;
                break;
            }
            default: {
                opcode = 160;
            }
        }
        this.out.append(Mnemonics.getMnemonic(opcode) + this.member((Member)field));
    }

    @Override
    public void doPutStatic(PutStatic instruction) {
        int opcode;
        Field field = instruction.getField();
        switch (field.getType().getSystemID()) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                opcode = 139;
                break;
            }
            case 11: {
                opcode = 141;
                break;
            }
            case 13: {
                opcode = 358;
                break;
            }
            case 14: {
                opcode = 359;
                break;
            }
            default: {
                opcode = 140;
            }
        }
        this.out.append(Mnemonics.getMnemonic(opcode) + this.member((Member)field));
    }

    @Override
    public void doStoreLocal(StoreLocal instruction) {
        this.out.append(Mnemonics.getMnemonic(94) + " " + instruction.getLocal());
    }

    @Override
    public void doStackMerge(StackMerge instruction) {
        Assert.shouldNotReachHere();
    }

    @Override
    public void doStackOp(StackOp instruction) {
        this.out.append("/* " + Opcode.mnemonics[instruction.getOpcode()] + " */");
    }

    @Override
    public void doTableSwitch(TableSwitch instruction) {
        this.out.append("tableswitch default=" + this.getAddressOf(instruction.getDefaultTarget()));
        Target[] targets = instruction.getTargets();
        int low = instruction.getLow();
        int high = instruction.getHigh();
        this.out.append(" low=" + low + " high=" + high + " (");
        for (int i = 0; i != targets.length; ++i) {
            this.out.append(low + i + " -> " + this.getAddressOf(targets[i]));
            if (i == targets.length - 1) continue;
            this.out.append(", ");
        }
        this.out.append(")");
    }

    @Override
    public void doThrow(Throw instruction) {
        this.out.append(Mnemonics.getMnemonic(225) + " " + instruction.getThrowable().getType().getName());
    }
}

