/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.translator.ir;

import com.sun.squawk.Klass;
import com.sun.squawk.translator.ir.Frame;
import com.sun.squawk.translator.ir.Instruction;
import com.sun.squawk.translator.ir.Slot;
import com.sun.squawk.translator.ir.SlotAllocator;
import com.sun.squawk.util.Assert;

public final class Local {
    private final Klass type;
    private final int javacIndex;
    private int parameterIndex;
    private Slot slot;
    private Instruction lastUse;
    private boolean isDead;

    public Local(Klass type, int javacIndex, boolean isParameter) {
        Assert.that((Frame.getLocalTypeFor(type) == type ? 1 : 0) != 0);
        this.type = type;
        this.javacIndex = javacIndex;
        this.parameterIndex = isParameter ? javacIndex : -1;
        Assert.that((isParameter == this.isParameter() ? 1 : 0) != 0);
    }

    public Klass getType() {
        return this.type;
    }

    public boolean is64Bit() {
        return this.type == Klass.LONG | this.type == Klass.DOUBLE | false;
    }

    public int getJavacIndex() {
        return this.javacIndex;
    }

    public boolean isParameter() {
        return this.parameterIndex >= 0;
    }

    public void setParameterIndex(int index) {
        Assert.that((boolean)this.isParameter());
        this.parameterIndex = index;
        Assert.that((boolean)this.isParameter());
    }

    public void setLastLoad(Instruction inst) {
        this.lastUse = inst;
    }

    public void setSlotForStore(SlotAllocator allocator) {
        if (!this.isParameter()) {
            if (this.isDead) {
                throw new RuntimeException("Using dead variable " + this.javacIndex);
            }
            if (this.slot == null) {
                this.slot = allocator.allocate(this.type, this.javacIndex < 0);
            }
        }
    }

    public void setSlotForLoad(SlotAllocator allocator, Instruction inst) {
        if (!this.isParameter()) {
            this.setSlotForStore(allocator);
            if (this.javacIndex < 0 && this.lastUse == inst) {
                allocator.free(this.slot);
                this.isDead = true;
            }
        }
    }

    public void setSlotForIncDec(SlotAllocator allocator) {
        Assert.that((this.javacIndex >= 0 ? 1 : 0) != 0);
        if (!this.isParameter()) {
            this.setSlotForStore(allocator);
        }
    }

    public boolean hasSameSlotAs(Local aLocal) {
        return aLocal.slot == this.slot;
    }

    public int getSquawkLocalIndex() {
        Assert.that((this.slot != null ? 1 : 0) != 0);
        Assert.that((!this.isParameter() ? 1 : 0) != 0);
        return this.slot.getSquawkIndex();
    }

    public int getSquawkParameterIndex() {
        Assert.that((boolean)this.isParameter());
        Assert.that((this.slot == null ? 1 : 0) != 0);
        return this.parameterIndex;
    }

    public boolean setUninitializedAtGC() {
        Assert.that((!this.isParameter() && this.type == Klass.REFERENCE && this.slot != null ? 1 : 0) != 0);
        return this.slot.setNeedsClearing();
    }

    public String toString() {
        int ndx;
        String suffix;
        switch (this.type.getSystemID()) {
            case 10: {
                suffix = "_i";
                break;
            }
            case 13: {
                suffix = "_f";
                break;
            }
            case 11: {
                suffix = "_l";
                break;
            }
            case 14: {
                suffix = "_d";
                break;
            }
            default: {
                suffix = "_o";
            }
        }
        if (this.isParameter()) {
            return "parm" + this.getSquawkParameterIndex() + suffix;
        }
        if (this.slot != null && (ndx = this.getSquawkLocalIndex()) >= 0) {
            suffix = suffix + " (slot " + ndx + ")";
        }
        if (this.javacIndex < 0) {
            return "tmp" + (0 - this.javacIndex) + suffix;
        }
        return "loc" + this.javacIndex + suffix;
    }
}

