/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.translator.ir;

import com.sun.squawk.Klass;
import com.sun.squawk.Method;
import com.sun.squawk.translator.ir.Frame;
import com.sun.squawk.translator.ir.IR;
import com.sun.squawk.translator.ir.Instruction;
import com.sun.squawk.translator.ir.Local;
import com.sun.squawk.translator.ir.Slot;
import com.sun.squawk.translator.ir.instr.IncDecLocal;
import com.sun.squawk.translator.ir.instr.LoadLocal;
import com.sun.squawk.translator.ir.instr.LocalVariable;
import com.sun.squawk.translator.ir.instr.StoreLocal;
import com.sun.squawk.util.Assert;
import com.sun.squawk.util.SquawkVector;
import com.sun.squawk.util.Tracer;
import java.util.Enumeration;

public final class SlotAllocator {
    public static final boolean RESERVE_SLOT_ZERO = true;
    private final Method method;
    private final IR ir;
    private SquawkVector slots;
    private int clearedSlotCounter = 0;

    public SlotAllocator(IR ir, Method method) {
        this.ir = ir;
        this.method = method;
    }

    private int doSlotClearingAnalysis(SquawkVector localRefs) {
        boolean trace = Tracer.isTracing((String)"slotclearingdetail", (String)this.method.toString());
        int cleared = 0;
        if (trace) {
            Tracer.traceln((String)"");
            Tracer.traceln((String)("++++ Slot clearing analysis for " + this.method + " ++++"));
        }
        boolean requiresClassClinit = this.method.requiresClassClinit();
        Enumeration e = localRefs.elements();
        while (e.hasMoreElements()) {
            Local local = (Local)e.nextElement();
            Assert.that((!local.isParameter() && local.getType() == Klass.REFERENCE ? 1 : 0) != 0);
            boolean mustClear = true;
            if (trace) {
                Tracer.traceln((String)(" local = " + local + " mustClear = " + mustClear));
            }
            if (!mustClear || !local.setUninitializedAtGC()) continue;
            ++cleared;
        }
        if (trace) {
            Tracer.traceln((String)("---- Slot clearing analysis for " + this.method + " cleared = " + cleared + " not cleared = " + (localRefs.size() - cleared) + " ----"));
        }
        return cleared;
    }

    public Klass[] transform() {
        Slot slot;
        Enumeration e;
        Instruction instruction;
        this.slots = new SquawkVector();
        SquawkVector localRefs = new SquawkVector();
        for (instruction = this.ir.getHead(); instruction != null; instruction = instruction.getNext()) {
            if (!(instruction instanceof LocalVariable)) continue;
            Local local = ((LocalVariable)((Object)instruction)).getLocal();
            if (instruction instanceof LoadLocal) {
                local.setLastLoad(instruction);
            }
            if (local.isParameter() || local.getType() != Klass.REFERENCE || localRefs.contains((Object)local)) continue;
            localRefs.addElement((Object)local);
        }
        for (instruction = this.ir.getHead(); instruction != null; instruction = instruction.getNext()) {
            if (instruction instanceof LoadLocal) {
                ((LoadLocal)instruction).getLocal().setSlotForLoad(this, instruction);
                continue;
            }
            if (instruction instanceof IncDecLocal) {
                ((IncDecLocal)instruction).getLocal().setSlotForIncDec(this);
                continue;
            }
            if (!(instruction instanceof StoreLocal)) continue;
            ((StoreLocal)instruction).getLocal().setSlotForStore(this);
        }
        this.clearedSlotCounter = this.doSlotClearingAnalysis(localRefs);
        int index = 1;
        SquawkVector sortedSlots = null;
        if (this.clearedSlotCounter > 0) {
            sortedSlots = new SquawkVector(this.clearedSlotCounter);
            e = this.slots.elements();
            while (e.hasMoreElements()) {
                slot = (Slot)e.nextElement();
                if (!slot.needsClearing()) continue;
                sortedSlots.addElement((Object)slot);
                index = this.setSlotIndex(slot, index);
            }
        }
        Assert.that((index == this.clearedSlotCounter + 1 ? 1 : 0) != 0);
        e = this.slots.elements();
        while (e.hasMoreElements()) {
            slot = (Slot)e.nextElement();
            if (slot.needsClearing()) continue;
            index = this.setSlotIndex(slot, index);
            if (this.clearedSlotCounter <= 0) continue;
            sortedSlots.addElement((Object)slot);
        }
        if (this.clearedSlotCounter > 0) {
            this.slots = sortedSlots;
        }
        Klass[] localTypes = new Klass[index];
        localTypes[0] = Klass.REFERENCE;
        index = 1;
        Enumeration e2 = this.slots.elements();
        while (e2.hasMoreElements()) {
            Slot slot2 = (Slot)e2.nextElement();
            Klass k = slot2.getType();
            if (k.isDoubleWord()) {
                if (k.getSystemID() == 11) {
                    localTypes[index++] = Klass.LONG2;
                } else {
                    Assert.that((k.getSystemID() == 14 ? 1 : 0) != 0);
                    localTypes[index++] = Klass.DOUBLE2;
                }
            }
            localTypes[index++] = k;
        }
        Assert.that((index == localTypes.length ? 1 : 0) != 0);
        return localTypes;
    }

    private int setSlotIndex(Slot slot, int index) {
        if (slot.getType().isDoubleWord()) {
            slot.setSquawkIndex(index + 1);
            index += 2;
        } else {
            slot.setSquawkIndex(index++);
        }
        return index;
    }

    public int getClearedSlotCount() {
        return this.clearedSlotCounter;
    }

    Slot allocate(Klass type, boolean isForStack) {
        Assert.that((Frame.getLocalTypeFor(type) == type ? 1 : 0) != 0);
        if (isForStack) {
            Enumeration e = this.slots.elements();
            while (e.hasMoreElements()) {
                Slot slot = (Slot)e.nextElement();
                if (!slot.isFree() || slot.getType() != type) continue;
                slot.setFree(false);
                return slot;
            }
        }
        Slot slot = new Slot(type, isForStack);
        this.slots.addElement((Object)slot);
        return slot;
    }

    void free(Slot slot) {
        slot.setFree(true);
    }
}

