/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.translator.ir;

import com.sun.squawk.Klass;
import com.sun.squawk.translator.ir.Frame;
import com.sun.squawk.translator.ir.Instruction;
import com.sun.squawk.translator.ir.instr.Catch;
import com.sun.squawk.translator.ir.instr.StackMerge;
import com.sun.squawk.translator.ir.instr.StackProducer;
import com.sun.squawk.translator.ir.instr.TargetedInstruction;
import com.sun.squawk.util.Assert;

public final class Target {
    private static final StackProducer[] EMPTY_DERIVED_STACK = new StackProducer[0];
    private final int address;
    private final Klass[] stack;
    private final StackProducer[] derivedStack;
    public final Klass[] locals;
    private TargetedInstruction instruction;
    private boolean isCatchTarget;
    private boolean fatalTarget;
    private boolean isForwardBranchTarget;
    private boolean isBackwardBranchTarget;

    public Target(int address, Klass[] stack, Klass[] locals) {
        this.address = address;
        this.stack = stack;
        this.locals = locals;
        this.derivedStack = stack.length == 0 ? EMPTY_DERIVED_STACK : new StackProducer[stack.length];
    }

    public int getAddress() {
        return this.address;
    }

    public int getBytecodeOffset() {
        return ((Instruction)((Object)this.instruction)).getBytecodeOffset();
    }

    public Klass[] getStack() {
        return this.stack;
    }

    public Klass[] getLocals() {
        return this.locals;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(20);
        return buf.append(this.getAddress()).append(": stack={").append(Klass.getNames((Klass[])this.stack)).append("} locals={").append(Klass.getNames((Klass[])this.locals)).append("}").toString();
    }

    public void merge(Frame frame) {
        int sp = frame.getStackSize();
        int i = 0;
        int mapIndex = 0;
        while (i < sp) {
            StackProducer derived = this.derivedStack[i];
            StackProducer producer = frame.getStackAt(i);
            if (derived != producer) {
                if (derived == null) {
                    this.derivedStack[i] = producer;
                } else {
                    StackMerge merge;
                    if (derived instanceof StackMerge) {
                        merge = (StackMerge)derived;
                    } else {
                        merge = new StackMerge(this.stack[mapIndex]);
                        merge.addProducer(derived);
                        this.derivedStack[i] = merge;
                    }
                    merge.addProducer(producer);
                }
            }
            if (producer.getType().isDoubleWord()) {
                ++i;
                ++mapIndex;
            }
            ++i;
            ++mapIndex;
        }
    }

    StackProducer[] getDerivedStack() {
        return this.derivedStack;
    }

    public void setTargetedInstruction(TargetedInstruction instruction) {
        Assert.that((this.instruction == null ? 1 : 0) != 0, (String)"cannot reset targeted instruction");
        this.instruction = instruction;
    }

    public void setTargetedCatchInstruction(Catch instruction) {
        this.setTargetedInstruction(instruction);
        this.isCatchTarget = true;
    }

    public TargetedInstruction getTargetedInstruction() {
        return this.instruction;
    }

    public void markAsForwardBranchTarget() {
        this.isForwardBranchTarget = true;
        Assert.that((!this.isBackwardBranchTarget ? 1 : 0) != 0);
    }

    public void markAsBackwardBranchTarget() {
        this.isBackwardBranchTarget = true;
    }

    public boolean isBackwardBranchTarget() {
        return this.isBackwardBranchTarget;
    }

    public boolean isForwardBranchTarget() {
        return this.isForwardBranchTarget;
    }

    public Catch getCatch() {
        Assert.that((boolean)this.isCatchTarget);
        return (Catch)this.instruction;
    }

    public boolean isFatalTarget() {
        return this.fatalTarget;
    }

    void markAsFatalTarget() {
        this.fatalTarget = true;
    }
}

