/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.translator.ir.instr;

import com.sun.squawk.Klass;
import com.sun.squawk.translator.ir.Instruction;
import com.sun.squawk.translator.ir.InstructionVisitor;
import com.sun.squawk.translator.ir.OperandVisitor;
import com.sun.squawk.translator.ir.instr.Mutator;
import com.sun.squawk.translator.ir.instr.StackProducer;

public final class ArrayStore
extends Instruction
implements Mutator {
    private Klass componentType;
    private StackProducer array;
    private StackProducer index;
    private StackProducer value;

    public ArrayStore(Klass componentType, StackProducer array, StackProducer index, StackProducer value) {
        this.componentType = componentType;
        this.array = array;
        this.index = index;
        this.value = value;
    }

    public Klass getComponentType() {
        return this.componentType;
    }

    @Override
    public Klass getMutationType() {
        return this.getComponentType();
    }

    public StackProducer getArray() {
        return this.array;
    }

    public StackProducer getIndex() {
        return this.index;
    }

    public StackProducer getValue() {
        return this.value;
    }

    @Override
    public boolean mayCauseGC(boolean isStatic) {
        return true;
    }

    @Override
    public boolean constrainsStack() {
        return !this.value.getType().isPrimitive();
    }

    @Override
    public void visit(InstructionVisitor visitor) {
        visitor.doArrayStore(this);
    }

    @Override
    public void visit(OperandVisitor visitor) {
        this.array = visitor.doOperand(this, this.array);
        this.index = visitor.doOperand(this, this.index);
        this.value = visitor.doOperand(this, this.value);
    }
}

