/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.translator.ir.instr;

import com.sun.squawk.Klass;
import com.sun.squawk.translator.ir.InstructionVisitor;
import com.sun.squawk.translator.ir.OperandVisitor;
import com.sun.squawk.translator.ir.instr.StackProducer;
import com.sun.squawk.util.Assert;

public final class ComparisonOp
extends StackProducer {
    public static final int LCMP = -1;
    private StackProducer left;
    private StackProducer right;
    private final int opcode;

    public ComparisonOp(StackProducer left, StackProducer right, int opcode) {
        super(Klass.INT);
        this.left = left;
        this.right = right;
        this.opcode = opcode;
    }

    public StackProducer getLeft() {
        return this.left;
    }

    public StackProducer getRight() {
        return this.right;
    }

    public int getOpcode() {
        Assert.that((this.opcode >= 0 ? 1 : 0) != 0);
        return this.opcode;
    }

    public boolean isLCMP() {
        return this.opcode == -1;
    }

    @Override
    public boolean constrainsStack() {
        return this.isLCMP();
    }

    @Override
    public void visit(InstructionVisitor visitor) {
        visitor.doComparisonOp(this);
    }

    @Override
    public void visit(OperandVisitor visitor) {
        this.left = visitor.doOperand(this, this.left);
        this.right = visitor.doOperand(this, this.right);
    }
}

