/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.translator.ir.instr;

import com.sun.squawk.Klass;
import com.sun.squawk.translator.ir.InstructionVisitor;
import com.sun.squawk.translator.ir.instr.ConstantDouble;
import com.sun.squawk.translator.ir.instr.ConstantFloat;
import com.sun.squawk.translator.ir.instr.ConstantInt;
import com.sun.squawk.translator.ir.instr.ConstantLong;
import com.sun.squawk.translator.ir.instr.ConstantObject;
import com.sun.squawk.translator.ir.instr.StackProducer;
import com.sun.squawk.util.Assert;

public abstract class Constant
extends StackProducer {
    private final int tag;
    protected final Object value;

    public static Constant create(Object value) {
        if (value == null) {
            return new ConstantObject(Klass.NULL, null);
        }
        if (value instanceof String) {
            return new ConstantObject(Klass.STRING, value);
        }
        if (value instanceof Integer) {
            return new ConstantInt((Integer)value);
        }
        if (value instanceof Long) {
            return new ConstantLong((Long)value);
        }
        if (value instanceof Double) {
            return new ConstantDouble((Double)value);
        }
        if (value instanceof Float) {
            return new ConstantFloat((Float)value);
        }
        throw Assert.shouldNotReachHere();
    }

    Constant(Klass type, int tag, Object value) {
        super(type);
        this.tag = tag;
        this.value = value;
    }

    public int getTag() {
        return this.tag;
    }

    public Object getValue() {
        return this.value;
    }

    public abstract boolean isDefaultValue();

    @Override
    public final void visit(InstructionVisitor visitor) {
        visitor.doConstant(this);
    }
}

