/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.translator.ir.instr;

import com.sun.squawk.Method;
import com.sun.squawk.translator.ir.OperandVisitor;
import com.sun.squawk.translator.ir.instr.StackProducer;
import com.sun.squawk.util.Assert;

public abstract class Invoke
extends StackProducer {
    private final Method method;
    private final StackProducer[] parameters;

    public Invoke(Method method, StackProducer[] parameters) {
        super(method.getReturnType());
        this.method = method;
        this.parameters = parameters;
        Assert.always((!method.isInterpreterInvoked() ? 1 : 0) != 0, (String)"the symbols for this method should have been stripped");
    }

    public Method getMethod() {
        return this.method;
    }

    public StackProducer[] getParameters() {
        return this.parameters;
    }

    @Override
    public final Object getConstantObject() {
        if (this.pushesClassOfMethod()) {
            return this.method.getDefiningClass();
        }
        return null;
    }

    abstract boolean pushesClassOfMethod();

    @Override
    public boolean constrainsStack() {
        return true;
    }

    @Override
    public void visit(OperandVisitor visitor) {
        for (int i = 0; i != this.parameters.length; ++i) {
            StackProducer parameter = this.parameters[i];
            this.parameters[i] = parameter = visitor.doOperand(this, parameter);
        }
    }
}

