/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.translator.ir.instr;

import com.sun.squawk.Klass;
import com.sun.squawk.translator.ir.Frame;
import com.sun.squawk.translator.ir.InstructionVisitor;
import com.sun.squawk.translator.ir.Local;
import com.sun.squawk.translator.ir.instr.StackProducer;
import com.sun.squawk.util.Assert;

public final class StackMerge
extends StackProducer {
    private static final StackProducer[] NO_PRODUCERS = new StackProducer[0];
    private StackProducer[] producers = NO_PRODUCERS;
    private boolean spillRecursionGuard;

    public StackMerge(Klass type) {
        super(type);
    }

    private static boolean contains(StackProducer[] producers, StackProducer producer) {
        for (int i = 0; i != producers.length; ++i) {
            if (producers[i] != producer) continue;
            return true;
        }
        return false;
    }

    public void addProducer(StackProducer producer) {
        Assert.that((producer != this ? 1 : 0) != 0);
        if (this.producers.length == 0) {
            this.producers = new StackProducer[]{producer};
            if (producer.isSpilt()) {
                super.spill(producer.getSpillLocal());
            }
            return;
        }
        if (StackMerge.contains(this.producers, producer)) {
            return;
        }
        if (producer.isSpilt()) {
            this.spill(producer.getSpillLocal());
        } else if (this.isSpilt()) {
            producer.spill(this.getSpillLocal());
        }
        StackProducer[] old = this.producers;
        this.producers = new StackProducer[old.length + 1];
        System.arraycopy(old, 0, this.producers, 1, old.length);
        this.producers[0] = producer;
    }

    @Override
    public synchronized void spill(Local local) {
        if (!this.spillRecursionGuard) {
            this.spillRecursionGuard = true;
            super.spill(local);
            for (int i = 0; i != this.producers.length; ++i) {
                this.producers[i].spill(local);
            }
            this.spillRecursionGuard = false;
        }
    }

    @Override
    public boolean isOnStack() {
        if (this.producers == NO_PRODUCERS) {
            return false;
        }
        return this.producers[0].isOnStack();
    }

    @Override
    public void setDuped(Frame frame) {
        super.setDuped(frame);
        for (int i = 0; i != this.producers.length; ++i) {
            this.producers[i].setDuped(frame);
        }
    }

    @Override
    public void cancelDuping() {
        super.cancelDuping();
        for (int i = 0; i != this.producers.length; ++i) {
            this.producers[i].cancelDuping();
        }
    }

    public boolean visitProducers(ProducerVisitor visitor) {
        for (int i = 0; i != this.producers.length; ++i) {
            StackProducer producer = this.producers[i];
            if (!(producer instanceof StackMerge ? !((StackMerge)producer).visitProducers(visitor) : !visitor.visit(producer))) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        String spr = super.toString();
        spr = spr + " num producers: " + this.producers.length;
        for (int i = 0; i < this.producers.length; ++i) {
            spr = spr + "\n    " + this.producers[i];
        }
        return spr;
    }

    @Override
    public void visit(InstructionVisitor visitor) {
        visitor.doStackMerge(this);
    }

    public static interface ProducerVisitor {
        public boolean visit(StackProducer var1);
    }
}

