/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.translator.ir.instr;

import com.sun.squawk.Klass;
import com.sun.squawk.translator.ir.Frame;
import com.sun.squawk.translator.ir.Instruction;
import com.sun.squawk.translator.ir.Local;
import com.sun.squawk.translator.ir.instr.Mutator;
import com.sun.squawk.util.Assert;

public abstract class StackProducer
extends Instruction
implements Mutator {
    private Klass type;
    private int useCount;
    private boolean isDuped;
    private Local spillLocal;

    public StackProducer(Klass type) {
        Assert.that((type != null ? 1 : 0) != 0);
        Assert.that((type != Klass.LONG2 ? 1 : 0) != 0);
        Assert.that((type != Klass.DOUBLE2 ? 1 : 0) != 0);
        this.type = type;
    }

    public final Klass getType() {
        return this.type;
    }

    @Override
    public final Klass getMutationType() {
        return this.getType();
    }

    public final void updateType(Klass newType) {
        this.type = newType;
    }

    public void setDuped(Frame frame) {
        this.isDuped = true;
        if (!this.isSpilt()) {
            this.spill(frame.allocateLocalForSpill(this));
        }
    }

    public void cancelDuping() {
        Assert.that((this.isDuped ? 1 : 0) != 0);
        this.isDuped = false;
    }

    public boolean isDuped() {
        return this.isDuped;
    }

    public boolean isSpilt() {
        return this.spillLocal != null;
    }

    public boolean isOnStack() {
        return !this.isSpilt();
    }

    public void spill(Local spillLocal) {
        this.spillLocal = spillLocal;
    }

    public Local getSpillLocal() {
        Assert.that((this.spillLocal != null ? 1 : 0) != 0, (String)"producer doesn't spill");
        return this.spillLocal;
    }

    public void cancelSpilling() {
        this.spillLocal = null;
    }

    public void incUseCount() {
        ++this.useCount;
    }

    public int getUseCount() {
        return this.useCount;
    }
}

